/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.commons.collections4.CollectionUtils;
import org.cyclos.entities.access.Token;
import org.cyclos.entities.access.TokenPrincipalType;
import org.cyclos.entities.system.ImportedLine;
import org.cyclos.entities.system.TokenImportedFile;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.impl.access.TokenServiceLocal;
import org.cyclos.impl.system.BaseImportHandlerImpl;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.principaltypes.PrincipalTypeVO;
import org.cyclos.model.access.tokens.TokenDTO;
import org.cyclos.model.access.tokens.TokenData;
import org.cyclos.model.access.tokens.TokenDataParams;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.system.imports.ImportField;
import org.cyclos.model.system.imports.ImportType;
import org.cyclos.model.system.imports.ImportedFileDTO;
import org.cyclos.model.system.imports.TokenImportField;
import org.cyclos.model.system.imports.TokenImportedFileDTO;
import org.cyclos.model.system.imports.TokenImportedFileData;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TokenImportHandlerImpl
extends BaseImportHandlerImpl<TokenImportedFileDTO, TokenImportedFileData, TokenImportedFile, Token> {
    protected static final Set<String> REQUIRED_HEADERS = Collections.unmodifiableSet(CollectionHelper.asSet((Object[])new String[]{TokenImportField.TYPE.getName(), TokenImportField.VALUE.getName()}));
    @Autowired
    private TokenServiceLocal tokenService;

    public TokenImportHandlerImpl() {
        super((ImportField[])TokenImportField.values());
    }

    public Predicate<String> getAllowedImportFieldsPredicate(TokenImportedFile tokenImportedFile) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (TokenImportField tokenImportField : TokenImportField.values()) {
            arrayList.add(tokenImportField.getName());
        }
        return string -> arrayList.contains(string);
    }

    public TokenImportedFileData getData(TokenImportedFile tokenImportedFile) {
        TokenImportedFileData tokenImportedFileData = new TokenImportedFileData();
        tokenImportedFileData.setDto((EntityDTO)((ImportedFileDTO)this.conversionHandler.convert(TokenImportedFileDTO.class, (Object)tokenImportedFile)));
        return tokenImportedFileData;
    }

    public Class<Token> getEntityClass() {
        return Token.class;
    }

    public Class<TokenImportedFile> getImportedFileClass() {
        return TokenImportedFile.class;
    }

    public ImportType getImportType() {
        return ImportType.TOKENS_IMPORT;
    }

    public Set<String> getMissingRequiredFields(TokenImportedFile tokenImportedFile, List<String> list) {
        return Set.copyOf(CollectionUtils.subtract(REQUIRED_HEADERS, list));
    }

    public Object instantiateContext() {
        return null;
    }

    public TokenImportedFile newImportedFile(TokenImportedFileDTO tokenImportedFileDTO) {
        return new TokenImportedFile();
    }

    public Token processImportedLine(ImportedLine importedLine, Object object) {
        TokenDTO tokenDTO = this.convertToDTO(importedLine);
        Long l = this.tokenService.save((EntityDTO)tokenDTO);
        return (Token)this.find(l);
    }

    public Validator resolveValidator(TokenImportedFileDTO tokenImportedFileDTO) {
        return new Validator();
    }

    public void validateImportedLine(ImportedLine importedLine, Object object) {
        TokenDTO tokenDTO = this.convertToDTO(importedLine);
        if (tokenDTO.getType().getTokenType().isNFC()) {
            throw new ValidationException(this.message(SystemKeys.Imports.ERROR_CANNOT_IMPORT_NFC, new Object[0]));
        }
        this.tokenService.validate((EntityDTO)tokenDTO);
    }

    @Override
    protected List<ImportField> doGetFieldsInList(TokenImportedFile tokenImportedFile) {
        return Arrays.asList(TokenImportField.USER, TokenImportField.TYPE, TokenImportField.VALUE);
    }

    private TokenDTO convertToDTO(ImportedLine importedLine) {
        TokenPrincipalType tokenPrincipalType = this.parseTokenType(importedLine.getValue((ImportField)TokenImportField.TYPE));
        BasicUser basicUser = this.locateUser(importedLine.getValue((ImportField)TokenImportField.USER));
        TokenDataParams tokenDataParams = new TokenDataParams();
        tokenDataParams.setType(new PrincipalTypeVO(tokenPrincipalType.getId()));
        if (basicUser != null) {
            tokenDataParams.setUser(new UserLocatorVO(basicUser.getId()));
        }
        TokenData tokenData = (TokenData)this.tokenService.getDataForNew((Object)tokenDataParams);
        TokenDTO tokenDTO = (TokenDTO)tokenData.getDto();
        tokenDTO.setValue(importedLine.getValue((ImportField)TokenImportField.VALUE));
        Boolean bl = this.parseBoolean(importedLine.getValue((ImportField)TokenImportField.ACTIVATE_NOW));
        if (bl != null) {
            tokenDTO.setActivateNow(bl.booleanValue());
        }
        DateTime dateTime = this.parseDateTime(importedLine.getValue((ImportField)TokenImportField.EXPIRY));
        tokenDTO.setExpiryDate(dateTime);
        DateTime dateTime2 = this.parseDateTime(importedLine.getValue((ImportField)TokenImportField.ACTIVATION_DEADLINE));
        tokenDTO.setActivationDeadline(dateTime2);
        return tokenDTO;
    }

    private TokenPrincipalType parseTokenType(String string) {
        try {
            return (TokenPrincipalType)this.entityManagerHandler.find(TokenPrincipalType.class, string);
        }
        catch (EntityNotFoundException entityNotFoundException) {
            String string2 = this.message(SystemKeys.Imports.TOKENS_INVALID_TOKEN_TYPE, new Object[0]);
            throw new ValidationException(string2);
        }
    }
}

