/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.cyclos.entities.banking.Payment;
import org.cyclos.entities.banking.PaymentTransferType;
import org.cyclos.entities.banking.TransactionCustomField;
import org.cyclos.entities.system.ImportedLine;
import org.cyclos.entities.system.ImportedLineValue;
import org.cyclos.entities.system.UserPaymentImportedFile;
import org.cyclos.entities.users.User;
import org.cyclos.impl.banking.PaymentServiceLocal;
import org.cyclos.impl.banking.TransactionCustomFieldServiceLocal;
import org.cyclos.impl.banking.TransactionServiceLocal;
import org.cyclos.impl.system.BaseWithFieldsImportHandlerImpl;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.Property;
import org.cyclos.model.ValidationException;
import org.cyclos.model.banking.BankingKeys;
import org.cyclos.model.banking.accounts.AccountOwner;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.banking.accounttypes.AccountTypeNature;
import org.cyclos.model.banking.transactions.PerformPaymentDTO;
import org.cyclos.model.banking.transactions.PerformPaymentData;
import org.cyclos.model.banking.transfertypes.TransferTypeVO;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.system.fields.CustomFieldValueDTO;
import org.cyclos.model.system.imports.ImportField;
import org.cyclos.model.system.imports.ImportType;
import org.cyclos.model.system.imports.ImportedFileDTO;
import org.cyclos.model.system.imports.UserPaymentImportField;
import org.cyclos.model.system.imports.UserPaymentImportedFileDTO;
import org.cyclos.model.system.imports.UserPaymentImportedFileData;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.utils.CurrencyAmountDTO;
import org.cyclos.utils.CollectionHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserPaymentsImportHandlerImpl
extends BaseWithFieldsImportHandlerImpl<TransactionCustomField, CustomFieldValueDTO, UserPaymentImportedFileDTO, UserPaymentImportedFileData, UserPaymentImportedFile, Payment> {
    protected static final Set<String> REQUIRED_HEADERS = Collections.unmodifiableSet(CollectionHelper.asSet((Object[])new String[]{UserPaymentImportField.USER.getName(), UserPaymentImportField.AMOUNT.getName()}));
    @Autowired
    private PaymentServiceLocal paymentService;
    @Autowired
    private TransactionServiceLocal transactionService;
    @Autowired
    private TransactionCustomFieldServiceLocal transactionCustomFieldService;

    UserPaymentsImportHandlerImpl() {
        super(TransactionCustomField.class, CustomFieldValueDTO.class, (ImportField[])UserPaymentImportField.values());
    }

    public Predicate<String> getAllowedImportFieldsPredicate(UserPaymentImportedFile userPaymentImportedFile) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (UserPaymentImportField userPaymentImportField : UserPaymentImportField.values()) {
            arrayList.add(userPaymentImportField.getName());
        }
        PaymentTransferType paymentTransferType = userPaymentImportedFile.getPaymentType();
        List list = this.transactionCustomFieldService.listVisible((AccountOwner)userPaymentImportedFile.getUser());
        list.retainAll(paymentTransferType.getCustomFields());
        arrayList.addAll(this.getImportFieldNames(list));
        return string -> arrayList.contains(string);
    }

    public UserPaymentImportedFileData getData(UserPaymentImportedFile userPaymentImportedFile) {
        UserPaymentImportedFileData userPaymentImportedFileData = new UserPaymentImportedFileData();
        userPaymentImportedFileData.setDto((EntityDTO)((ImportedFileDTO)this.conversionHandler.convert(UserPaymentImportedFileDTO.class, (Object)userPaymentImportedFile)));
        if (userPaymentImportedFile.isTransient()) {
            PerformPaymentData performPaymentData = this.transactionService.getPaymentData((InternalAccountOwner)userPaymentImportedFile.getUser(), null, null);
            List list = CollectionHelper.orEmpty((List)performPaymentData.getPaymentTypes()).stream().filter(transferTypeWithCurrencyVO -> transferTypeWithCurrencyVO.getTo().getNature() == AccountTypeNature.USER).collect(Collectors.toList());
            Set set = list.stream().map(TransferTypeVO::getFrom).collect(Collectors.toSet());
            List list2 = performPaymentData.getAccounts();
            list2.removeIf(accountWithStatusVO -> !set.contains(accountWithStatusVO.getType()));
            if (CollectionHelper.isEmpty(list) || CollectionHelper.isEmpty((Iterable)list2)) {
                throw new ValidationException(this.message(BankingKeys.Transactions.PAYMENT_NO_PAYMENT_TYPES, new Object[0]));
            }
            userPaymentImportedFileData.setAccounts(list2);
            userPaymentImportedFileData.setPaymentTypes(list);
        }
        return userPaymentImportedFileData;
    }

    public Class<Payment> getEntityClass() {
        return Payment.class;
    }

    public Class<UserPaymentImportedFile> getImportedFileClass() {
        return UserPaymentImportedFile.class;
    }

    public ImportType getImportType() {
        return ImportType.USER_PAYMENTS_IMPORT;
    }

    public Set<String> getMissingRequiredFields(UserPaymentImportedFile userPaymentImportedFile, List<String> list) {
        return Set.copyOf(CollectionUtils.subtract(REQUIRED_HEADERS, list));
    }

    public Object instantiateContext() {
        return null;
    }

    public UserPaymentImportedFile newImportedFile(UserPaymentImportedFileDTO userPaymentImportedFileDTO) {
        UserPaymentImportedFile userPaymentImportedFile = new UserPaymentImportedFile();
        userPaymentImportedFile.setUser((User)this.conversionHandler.convert(User.class, (Object)userPaymentImportedFileDTO.getUser()));
        userPaymentImportedFile.setPaymentType((PaymentTransferType)this.conversionHandler.convert(PaymentTransferType.class, (Object)userPaymentImportedFileDTO.getPaymentType()));
        return userPaymentImportedFile;
    }

    public Payment processImportedLine(ImportedLine importedLine, Object object) {
        PerformPaymentDTO performPaymentDTO = this.toPerformDTO(importedLine);
        return this.paymentService.importPayment(performPaymentDTO, true);
    }

    public Validator resolveValidator(UserPaymentImportedFileDTO userPaymentImportedFileDTO) {
        Validator validator = new Validator();
        if (userPaymentImportedFileDTO.isTransient()) {
            validator.property((Property)UserPaymentImportedFileDTO.PAYMENT_TYPE, BankingKeys.Transactions.TYPE).required();
        }
        return validator;
    }

    public void validateImportedLine(ImportedLine importedLine, Object object) {
        try {
            PerformPaymentDTO performPaymentDTO = this.toPerformDTO(importedLine);
            this.paymentService.validate(performPaymentDTO);
        }
        catch (EntityNotFoundException entityNotFoundException) {
            if (User.class.getSimpleName().equals(entityNotFoundException.getEntityType())) {
                String string = importedLine.getValue((ImportField)UserPaymentImportField.USER);
                throw new ValidationException(this.message(SystemKeys.Imports.INVALID_USER, string));
            }
            throw entityNotFoundException;
        }
    }

    @Override
    protected List<ImportField> doGetFieldsInList(UserPaymentImportedFile userPaymentImportedFile) {
        return Arrays.asList(UserPaymentImportField.USER, UserPaymentImportField.AMOUNT, UserPaymentImportField.DESCRIPTION);
    }

    @Override
    protected Collection<TransactionCustomField> getCustomFields(ImportedLine importedLine, List<ImportedLineValue> list) {
        UserPaymentImportedFile userPaymentImportedFile = (UserPaymentImportedFile)importedLine.getImportedFile();
        Set set2 = userPaymentImportedFile.getPaymentType().getCustomFields();
        BiFunction<String, Set, TransactionCustomField> biFunction = (string, set) -> set.stream().filter(transactionCustomField -> transactionCustomField.getInternalName().equals(string)).findFirst().orElseGet(null);
        return this.getCustomFieldValues(importedLine).keySet().stream().map(string -> (TransactionCustomField)biFunction.apply((String)string, set2)).filter(transactionCustomField -> transactionCustomField != null).collect(Collectors.toSet());
    }

    private PerformPaymentDTO toPerformDTO(ImportedLine importedLine) {
        UserPaymentImportedFile userPaymentImportedFile = (UserPaymentImportedFile)importedLine.getImportedFile();
        PaymentTransferType paymentTransferType = userPaymentImportedFile.getPaymentType();
        UserLocatorVO userLocatorVO = new UserLocatorVO();
        userLocatorVO.setPrincipalType("*");
        userLocatorVO.setPrincipal(importedLine.getValue((ImportField)UserPaymentImportField.USER));
        PerformPaymentDTO performPaymentDTO = new PerformPaymentDTO();
        performPaymentDTO.setType(new TransferTypeVO(paymentTransferType.getId()));
        performPaymentDTO.setOwner((InternalAccountOwner)userPaymentImportedFile.getUser());
        performPaymentDTO.setSubject((InternalAccountOwner)userLocatorVO);
        CurrencyAmountDTO currencyAmountDTO = this.parseAmount(importedLine.getValue((ImportField)UserPaymentImportField.AMOUNT), paymentTransferType.getCurrency());
        performPaymentDTO.setAmount(currencyAmountDTO == null ? null : currencyAmountDTO.getAmount());
        performPaymentDTO.setDescription(importedLine.getValue((ImportField)UserPaymentImportField.DESCRIPTION));
        this.setCustomFieldValues(importedLine, performPaymentDTO);
        return performPaymentDTO;
    }
}

