/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.cyclos.entities.banking.Voucher;
import org.cyclos.entities.banking.VoucherCustomField;
import org.cyclos.entities.banking.VoucherType;
import org.cyclos.entities.system.ImportedLine;
import org.cyclos.entities.system.ImportedLineValue;
import org.cyclos.entities.system.UserSendVouchersImportedFile;
import org.cyclos.entities.users.User;
import org.cyclos.impl.banking.VoucherCustomFieldServiceLocal;
import org.cyclos.impl.banking.VoucherServiceLocal;
import org.cyclos.impl.system.BaseWithFieldsImportHandlerImpl;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.Property;
import org.cyclos.model.banking.BankingKeys;
import org.cyclos.model.banking.currencies.ICurrency;
import org.cyclos.model.banking.vouchers.BuyingMaxAmountReachedForPeriodException;
import org.cyclos.model.banking.vouchers.BuyingMaxOpenAmountException;
import org.cyclos.model.banking.vouchers.BuyingNotAllowedForUserException;
import org.cyclos.model.banking.vouchers.CreateVoucherDataParams;
import org.cyclos.model.banking.vouchers.MaxTotalOpenAmountException;
import org.cyclos.model.banking.vouchers.SendVoucherDTO;
import org.cyclos.model.banking.vouchertypes.VoucherTypeVO;
import org.cyclos.model.system.fields.CustomFieldValueDTO;
import org.cyclos.model.system.imports.ImportField;
import org.cyclos.model.system.imports.ImportType;
import org.cyclos.model.system.imports.ImportedFileDTO;
import org.cyclos.model.system.imports.ImportedFileDataParams;
import org.cyclos.model.system.imports.UserSendVouchersImportField;
import org.cyclos.model.system.imports.UserSendVouchersImportedFileDTO;
import org.cyclos.model.system.imports.UserSendVouchersImportedFileData;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserSendVouchersImportHandlerImpl
extends BaseWithFieldsImportHandlerImpl<VoucherCustomField, CustomFieldValueDTO, UserSendVouchersImportedFileDTO, UserSendVouchersImportedFileData, UserSendVouchersImportedFile, Voucher> {
    protected static final Set<String> REQUIRED_HEADERS = Collections.unmodifiableSet(CollectionHelper.asSet((Object[])new String[]{UserSendVouchersImportField.NAME.getName(), UserSendVouchersImportField.EMAIL.getName()}));
    @Autowired
    private VoucherServiceLocal voucherService;
    @Autowired
    private VoucherCustomFieldServiceLocal voucherCustomFieldService;

    UserSendVouchersImportHandlerImpl() {
        super(VoucherCustomField.class, CustomFieldValueDTO.class, (ImportField[])UserSendVouchersImportField.values());
    }

    public Predicate<String> getAllowedImportFieldsPredicate(UserSendVouchersImportedFile userSendVouchersImportedFile) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (UserSendVouchersImportField userSendVouchersImportField : UserSendVouchersImportField.values()) {
            if (userSendVouchersImportField == UserSendVouchersImportField.AMOUNT) {
                if (!userSendVouchersImportedFile.isUseAmountFromFile()) continue;
                arrayList.add(userSendVouchersImportField.getName());
                continue;
            }
            arrayList.add(userSendVouchersImportField.getName());
        }
        VoucherType voucherType = userSendVouchersImportedFile.getVoucherType();
        List list = this.voucherCustomFieldService.listVisible(userSendVouchersImportedFile.getUser());
        list.retainAll(voucherType.getCustomFields());
        arrayList.addAll(this.getImportFieldNames(list));
        return string -> arrayList.contains(string);
    }

    public UserSendVouchersImportedFileData getData(UserSendVouchersImportedFile userSendVouchersImportedFile) {
        UserSendVouchersImportedFileData userSendVouchersImportedFileData = new UserSendVouchersImportedFileData();
        userSendVouchersImportedFileData.setDto((EntityDTO)((ImportedFileDTO)this.conversionHandler.convert(UserSendVouchersImportedFileDTO.class, (Object)userSendVouchersImportedFile)));
        if (userSendVouchersImportedFile.isTransient()) {
            CreateVoucherDataParams createVoucherDataParams = new CreateVoucherDataParams();
            createVoucherDataParams.setUser(new UserLocatorVO(userSendVouchersImportedFile.getUser().getId()));
            if (userSendVouchersImportedFile.getVoucherType() != null) {
                createVoucherDataParams.setType(new VoucherTypeVO(userSendVouchersImportedFile.getVoucherType().getId()));
            }
            userSendVouchersImportedFileData.setSendData(this.voucherService.getSendData(createVoucherDataParams));
        }
        return userSendVouchersImportedFileData;
    }

    public Class<Voucher> getEntityClass() {
        return Voucher.class;
    }

    public Class<UserSendVouchersImportedFile> getImportedFileClass() {
        return UserSendVouchersImportedFile.class;
    }

    public ImportType getImportType() {
        return ImportType.USER_SEND_VOUCHERS_IMPORT;
    }

    public Set<String> getMissingRequiredFields(UserSendVouchersImportedFile userSendVouchersImportedFile, List<String> list) {
        Set<String> set = REQUIRED_HEADERS;
        if (userSendVouchersImportedFile.getAmount() == null) {
            set = new HashSet<String>(set);
            set.add(UserSendVouchersImportField.AMOUNT.getName());
        }
        return Set.copyOf(CollectionUtils.subtract(set, list));
    }

    public Object instantiateContext() {
        return null;
    }

    @Override
    public UserSendVouchersImportedFile newEntity(ImportedFileDataParams importedFileDataParams) {
        UserSendVouchersImportedFile userSendVouchersImportedFile = (UserSendVouchersImportedFile)super.newEntity(importedFileDataParams);
        userSendVouchersImportedFile.setVoucherType((VoucherType)this.conversionHandler.convert(VoucherType.class, (Object)importedFileDataParams.getVoucherType()));
        return userSendVouchersImportedFile;
    }

    public UserSendVouchersImportedFile newImportedFile(UserSendVouchersImportedFileDTO userSendVouchersImportedFileDTO) {
        UserSendVouchersImportedFile userSendVouchersImportedFile = new UserSendVouchersImportedFile();
        userSendVouchersImportedFile.setUser((User)this.conversionHandler.convert(User.class, (Object)userSendVouchersImportedFileDTO.getUser()));
        userSendVouchersImportedFile.setVoucherType((VoucherType)this.conversionHandler.convert(VoucherType.class, (Object)userSendVouchersImportedFileDTO.getVoucherType()));
        userSendVouchersImportedFile.setUseAmountFromFile(userSendVouchersImportedFileDTO.isUseAmountFromFile());
        userSendVouchersImportedFile.setAmount(userSendVouchersImportedFileDTO.getAmount());
        userSendVouchersImportedFile.setSendMessage(userSendVouchersImportedFileDTO.getSendMessage());
        return userSendVouchersImportedFile;
    }

    public Voucher processImportedLine(ImportedLine importedLine, Object object) {
        SendVoucherDTO sendVoucherDTO = this.toSendDTO(importedLine);
        return this.voucherService.sendByImport(sendVoucherDTO);
    }

    public Validator resolveValidator(UserSendVouchersImportedFileDTO userSendVouchersImportedFileDTO) {
        Validator validator = new Validator();
        if (userSendVouchersImportedFileDTO.isTransient()) {
            VoucherType voucherType;
            validator.property((Property)UserSendVouchersImportedFileDTO.VOUCHER_TYPE, BankingKeys.Vouchers.TYPE).required();
            org.cyclos.impl.utils.validation.Property property = validator.property((Property)UserSendVouchersImportedFileDTO.AMOUNT, BankingKeys.Vouchers.AMOUNT);
            if (!userSendVouchersImportedFileDTO.isUseAmountFromFile()) {
                property.required();
            }
            if ((voucherType = (VoucherType)this.conversionHandler.convert(VoucherType.class, (Object)userSendVouchersImportedFileDTO.getVoucherType())) != null) {
                if (voucherType.getMinBuyAmount() != null) {
                    property.greaterEquals((Comparable)voucherType.getMinBuyAmount());
                }
                if (voucherType.getMaxBuyAmount() != null) {
                    property.lessEquals((Comparable)voucherType.getMaxBuyAmount());
                }
            }
        }
        return validator;
    }

    public void validateImportedLine(ImportedLine importedLine, Object object) {
        SendVoucherDTO sendVoucherDTO = this.toSendDTO(importedLine);
        this.voucherService.validate(sendVoucherDTO);
    }

    @Override
    protected List<ImportField> doGetFieldsInList(UserSendVouchersImportedFile userSendVouchersImportedFile) {
        return Arrays.asList(UserSendVouchersImportField.NAME, UserSendVouchersImportField.EMAIL);
    }

    @Override
    protected Collection<VoucherCustomField> getCustomFields(ImportedLine importedLine, List<ImportedLineValue> list) {
        UserSendVouchersImportedFile userSendVouchersImportedFile = (UserSendVouchersImportedFile)importedLine.getImportedFile();
        Set set2 = userSendVouchersImportedFile.getVoucherType().getCustomFields();
        BiFunction<String, Set, VoucherCustomField> biFunction = (string, set) -> set.stream().filter(voucherCustomField -> voucherCustomField.getInternalName().equals(string)).findFirst().orElseGet(null);
        return this.getCustomFieldValues(importedLine).keySet().stream().map(string -> (VoucherCustomField)biFunction.apply((String)string, set2)).filter(voucherCustomField -> voucherCustomField != null).collect(Collectors.toSet());
    }

    @Override
    protected String getImportErrorMessage(Throwable throwable) {
        try {
            throw throwable;
        }
        catch (BuyingNotAllowedForUserException buyingNotAllowedForUserException) {
            return this.message(BankingKeys.Vouchers.BUY_ERROR_USER, new Object[0]);
        }
        catch (BuyingMaxOpenAmountException buyingMaxOpenAmountException) {
            return this.message(BankingKeys.Vouchers.BUY_ERROR_MAX_OPEN_AMOUNT_FOR_USER, buyingMaxOpenAmountException.getMaxOpenAmount(), buyingMaxOpenAmountException.getCurrentOpenAmount());
        }
        catch (BuyingMaxAmountReachedForPeriodException buyingMaxAmountReachedForPeriodException) {
            return this.message(BankingKeys.Vouchers.BUY_ERROR_MAX_AMOUNT_PER_PERIOD, buyingMaxAmountReachedForPeriodException.getDateAllowedAgain(), buyingMaxAmountReachedForPeriodException.getAmountLeftForBuying());
        }
        catch (MaxTotalOpenAmountException maxTotalOpenAmountException) {
            return this.message(BankingKeys.Vouchers.ERROR_MAX_TOTAL_OPEN_AMOUNT, maxTotalOpenAmountException.getMaxOpenAmount(), maxTotalOpenAmountException.getCurrentOpenAmount());
        }
        catch (Throwable throwable2) {
            return super.getImportErrorMessage(throwable);
        }
    }

    private SendVoucherDTO toSendDTO(ImportedLine importedLine) {
        UserSendVouchersImportedFile userSendVouchersImportedFile = (UserSendVouchersImportedFile)importedLine.getImportedFile();
        VoucherType voucherType = userSendVouchersImportedFile.getVoucherType();
        String string = importedLine.getValue((ImportField)UserSendVouchersImportField.NAME);
        String string2 = importedLine.getValue((ImportField)UserSendVouchersImportField.EMAIL);
        int n = voucherType.getCurrency().getPrecision();
        BigDecimal bigDecimal = userSendVouchersImportedFile.isUseAmountFromFile() ? (BigDecimal)ObjectHelper.defaultValue((Object)this.parseDecimal(importedLine.getValue((ImportField)UserSendVouchersImportField.AMOUNT), n), (Object)userSendVouchersImportedFile.getAmount()) : userSendVouchersImportedFile.getAmount();
        SendVoucherDTO sendVoucherDTO = new SendVoucherDTO();
        sendVoucherDTO.setType(new VoucherTypeVO(voucherType.getId()));
        sendVoucherDTO.setUser(new UserLocatorVO(userSendVouchersImportedFile.getUser().getId()));
        sendVoucherDTO.setCount(Integer.valueOf(1));
        sendVoucherDTO.setEmail(string2);
        sendVoucherDTO.setMessage(StringHelper.replaceVariables((String)userSendVouchersImportedFile.getSendMessage(), string3 -> {
            switch (string3) {
                case "name": {
                    return string;
                }
                case "email": {
                    return string2;
                }
                case "amount": {
                    return this.getFormatter().format((ICurrency)voucherType.getCurrency(), bigDecimal);
                }
            }
            return "";
        }));
        sendVoucherDTO.setAmount(bigDecimal);
        this.setCustomFieldValues(importedLine, sendVoucherDTO);
        return sendVoucherDTO;
    }
}

