/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import com.querydsl.core.types.dsl.BooleanPath;
import com.querydsl.core.types.dsl.NumberPath;
import java.util.Date;
import org.cyclos.entities.banking.BasePayment;
import org.cyclos.entities.banking.PaymentTransferType;
import org.cyclos.impl.users.AbstractTransactionFeedbackRecurringTask;
import org.cyclos.model.utils.TimeField;
import org.cyclos.server.utils.DateHelper;
import org.cyclos.utils.ObjectHelper;

public abstract class AbstractTransactionFeedbackNotificationRecurringTask
extends AbstractTransactionFeedbackRecurringTask {
    public AbstractTransactionFeedbackNotificationRecurringTask(NumberPath<Integer> numberPath, BooleanPath booleanPath) {
        super(numberPath, booleanPath, true);
    }

    protected abstract void notifyTransactionProcessed(BasePayment var1, Date var2);

    @Override
    protected final void process(BasePayment basePayment) throws Throwable {
        PaymentTransferType paymentTransferType = (PaymentTransferType)ObjectHelper.ifType((Object)basePayment.getType(), PaymentTransferType.class);
        if (paymentTransferType != null && paymentTransferType.getFeedbackExpirationDays() != null) {
            Date date = basePayment.getProcessDate();
            Date date2 = DateHelper.add((Date)date, (TimeField)TimeField.DAYS, (int)paymentTransferType.getFeedbackExpirationDays());
            this.notifyTransactionProcessed(basePayment, date2);
        }
    }
}

