/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import com.querydsl.core.types.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.cyclos.entities.banking.AccountType;
import org.cyclos.entities.banking.AuthorizationRole;
import org.cyclos.entities.banking.PaymentTransferType;
import org.cyclos.entities.banking.SystemAccountType;
import org.cyclos.entities.banking.VoucherConfiguration;
import org.cyclos.entities.users.AdminGroup;
import org.cyclos.entities.users.AdminProduct;
import org.cyclos.entities.users.AdminProductAuthorizationRole;
import org.cyclos.entities.users.Product;
import org.cyclos.entities.users.ProductAdminVoucher;
import org.cyclos.entities.users.ProductSystemRecordType;
import org.cyclos.entities.users.QAdminProduct;
import org.cyclos.impl.banking.AuthorizationRoleServiceLocal;
import org.cyclos.impl.users.BooleanPermissionHandlerImpl;
import org.cyclos.impl.users.CollectionPermissionHandlerImpl;
import org.cyclos.impl.users.OperationPermissionHandlerImpl;
import org.cyclos.impl.users.PermissionHandler;
import org.cyclos.impl.users.UserManagementProductConversionHandlerImpl;
import org.cyclos.impl.users.ViewManagePermissionHandlerImpl;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.Property;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.Role;
import org.cyclos.model.banking.authorizationroles.AuthorizationRoleVO;
import org.cyclos.model.banking.transfertypes.TransferTypeDirection;
import org.cyclos.model.banking.voucherconfigurations.VoucherConfigurationVO;
import org.cyclos.model.banking.voucherconfigurations.VoucherGenerationStatus;
import org.cyclos.model.users.UsersKeys;
import org.cyclos.model.users.groups.AdminGroupType;
import org.cyclos.model.users.products.ActiveAdminProductsData;
import org.cyclos.model.users.products.AdminProductAuthorizationRoleDTO;
import org.cyclos.model.users.products.AdminProductDTO;
import org.cyclos.model.users.products.ExternalPaymentOperation;
import org.cyclos.model.users.products.ImportOperation;
import org.cyclos.model.users.products.PaymentRequestOperation;
import org.cyclos.model.users.products.ProductAdminVoucherDTO;
import org.cyclos.model.users.products.ProductManagementDTO;
import org.cyclos.model.users.products.ProductNature;
import org.cyclos.model.users.products.ProductVO;
import org.cyclos.model.users.products.ScheduledPaymentsOperation;
import org.cyclos.model.users.products.ViewManageOperation;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.MessageKey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AdminProductConversionHandlerImpl
extends UserManagementProductConversionHandlerImpl<AdminProduct, AdminProductDTO, ActiveAdminProductsData> {
    @Autowired
    private AuthorizationRoleServiceLocal authorizationRoleService;

    public AdminProductConversionHandlerImpl() {
        super(AdminProduct.class, AdminProductDTO.class, ActiveAdminProductsData.class);
    }

    public ProductNature getProductNature() {
        return ProductNature.ADMIN;
    }

    public Role getRole() {
        return Role.ADMIN;
    }

    @Override
    public void registerHandlers() {
        super.registerHandlers();
        QAdminProduct qAdminProduct = QAdminProduct.adminProduct;
        this.registerPropertyMapping((Property<?, ?>)AdminProductDTO.SYSTEM_TO_SYSTEM_PAYMENTS, (Path<?>)qAdminProduct.systemPayments);
        this.registerPropertyMapping((Property<?, ?>)AdminProductDTO.SYSTEM_TO_USER_PAYMENTS, (Path<?>)qAdminProduct.systemPayments);
        this.registerPropertyMapping((Property<?, ?>)AdminProductDTO.SYSTEM_TO_USER_EXTERNAL_PAYMENTS, (Path<?>)qAdminProduct.systemToUserExternalPayments);
        this.registerAdditionalCollectionMapping(Permission.VOUCHER_TYPES_VIEW, (Path<?>)qAdminProduct.accessibleVoucherConfigurations);
        this.registerAdditionalCollectionMapping(Permission.VOUCHER_TYPES_MANAGE, (Path<?>)qAdminProduct.accessibleVoucherConfigurations);
        this.register(new ViewManagePermissionHandlerImpl(Permission.GLOBAL_CONFIGURATION_VIEW, Permission.GLOBAL_CONFIGURATION_MANAGE, AdminProductDTO.GLOBAL_CONFIGURATION, ActiveAdminProductsData.GLOBAL_CONFIGURATION, null));
        this.register(new ViewManagePermissionHandlerImpl(Permission.SYSTEM_CONFIGURATION_VIEW, Permission.SYSTEM_CONFIGURATION_MANAGE, AdminProductDTO.SYSTEM_CONFIGURATION, ActiveAdminProductsData.SYSTEM_CONFIGURATION, UsersKeys.Products.SYSTEM_CONFIGURATION));
        this.register(new CollectionPermissionHandlerImpl(Permission.SPECIFIC_CONFIGURATION_MANAGE, AdminProductDTO.MANAGE_SPECIFIC_CONFIGURATIONS, UsersKeys.Products.MANAGE_SPECIFIC_CONFIGURATIONS));
        this.register(new CollectionPermissionHandlerImpl(Permission.SPECIFIC_CONFIGURATION_MANAGE_CONTENT, AdminProductDTO.MANAGE_CONTENT_SPECIFIC_CONFIGURATIONS, UsersKeys.Products.MANAGE_CONTENT_SPECIFIC_CONFIGURATIONS));
        this.register(new ViewManagePermissionHandlerImpl(Permission.ACCOUNT_CONFIGURATION_VIEW, Permission.ACCOUNT_CONFIGURATION_MANAGE, AdminProductDTO.ACCOUNT_CONFIGURATION, ActiveAdminProductsData.ACCOUNT_CONFIGURATION, UsersKeys.Products.ACCOUNT_CONFIGURATION));
        this.register(new BooleanPermissionHandlerImpl(Permission.ARCHIVED_ACCOUNTS_VIEW, AdminProductDTO.ARCHIVED_ACCOUNTS_VIEW, ActiveAdminProductsData.ARCHIVED_ACCOUNTS_VIEW, UsersKeys.Products.ARCHIVED_ACCOUNTS_VIEW));
        this.register(new ViewManagePermissionHandlerImpl(Permission.USER_CONFIGURATION_VIEW, Permission.USER_CONFIGURATION_MANAGE, AdminProductDTO.USER_CONFIGURATION, ActiveAdminProductsData.USER_CONFIGURATION, UsersKeys.Products.USER_CONFIGURATION));
        this.register(new ViewManagePermissionHandlerImpl(Permission.ACCESSIBLE_GROUPS_VIEW, Permission.ACCESSIBLE_GROUPS_MANAGE, AdminProductDTO.ACCESSIBLE_GROUPS, ActiveAdminProductsData.ACCESSIBLE_GROUPS, UsersKeys.Products.ACCESSIBLE_GROUPS));
        this.register(new BooleanPermissionHandlerImpl(Permission.SYSTEM_ALERTS_VIEW, AdminProductDTO.SYSTEM_ALERTS, ActiveAdminProductsData.SYSTEM_ALERTS, UsersKeys.Products.SYSTEM_ALERTS));
        this.register(new ViewManagePermissionHandlerImpl(Permission.ERROR_LOG_VIEW, Permission.ERROR_LOG_MANAGE, AdminProductDTO.ERROR_LOG, ActiveAdminProductsData.ERROR_LOG, UsersKeys.Products.ERROR_LOG));
        this.register(new BooleanPermissionHandlerImpl(Permission.ENTITY_LOG_VIEW_CONFIGURATION, AdminProductDTO.CONFIGURATION_ENTITY_LOG, ActiveAdminProductsData.CONFIGURATION_ENTITY_LOG, UsersKeys.Products.CONFIGURATION_ENTITY_LOG));
        this.register(new BooleanPermissionHandlerImpl(Permission.ENTITY_LOG_VIEW_USER, AdminProductDTO.USER_ENTITY_LOG, ActiveAdminProductsData.USER_ENTITY_LOG, UsersKeys.Products.USER_ENTITY_LOG));
        this.register(new BooleanPermissionHandlerImpl(Permission.ACCESS_LOG_VIEW, AdminProductDTO.ACCESS_LOG, ActiveAdminProductsData.ACCESS_LOG, UsersKeys.Products.ACCESS_LOG));
        this.register(new ViewManagePermissionHandlerImpl(Permission.AD_CONFIGURATION_VIEW, Permission.AD_CONFIGURATION_MANAGE, AdminProductDTO.AD_CONFIGURATION, ActiveAdminProductsData.AD_CONFIGURATION, UsersKeys.Products.AD_CONFIGURATION));
        this.register(new ViewManagePermissionHandlerImpl(Permission.MESSAGE_CATEGORIES_VIEW, Permission.MESSAGE_CATEGORIES_MANAGE, AdminProductDTO.MESSAGE_CATEGORIES, ActiveAdminProductsData.MESSAGE_CATEGORIES, UsersKeys.Products.MESSAGE_CATEGORIES));
        this.register(new ViewManagePermissionHandlerImpl(Permission.SYSTEM_REPORTS_VIEW, Permission.SYSTEM_REPORTS_MANAGE, AdminProductDTO.SYSTEM_REPORTS, ActiveAdminProductsData.SYSTEM_REPORTS, UsersKeys.Products.SYSTEM_REPORTS));
        this.register(new BooleanPermissionHandlerImpl(Permission.SMS_MESSAGES_VIEW, AdminProductDTO.SMS_MESSAGES, ActiveAdminProductsData.SMS_MESSAGES, UsersKeys.Products.SMS_MESSAGES));
        this.register(new ViewManagePermissionHandlerImpl(Permission.SYSTEM_IMAGE_CATEGORY_VIEW, Permission.SYSTEM_IMAGE_CATEGORY_MANAGE, AdminProductDTO.SYSTEM_IMAGE_CATEGORIES, ActiveAdminProductsData.SYSTEM_IMAGE_CATEGORIES, UsersKeys.Products.SYSTEM_IMAGE_CATEGORIES));
        this.register(new ViewManagePermissionHandlerImpl(Permission.DOCUMENT_CATEGORY_VIEW, Permission.DOCUMENT_CATEGORY_MANAGE, AdminProductDTO.DOCUMENT_CATEGORIES, ActiveAdminProductsData.DOCUMENT_CATEGORIES, UsersKeys.Products.DOCUMENT_CATEGORIES));
        this.register(new CollectionPermissionHandlerImpl(Permission.SYSTEM_ACCOUNTS_VIEW, AdminProductDTO.SYSTEM_ACCOUNTS, UsersKeys.Products.SYSTEM_ACCOUNTS));
        this.register(new CollectionPermissionHandlerImpl(Permission.SYSTEM_PAYMENT_REQUESTS_SEND_TO_USER, AdminProductDTO.SYSTEM_PAYMENT_REQUESTS_SEND_TO_USER, UsersKeys.Products.SYSTEM_PAYMENT_REQUESTS_SEND_TO_USER));
        this.register(new OperationPermissionHandlerImpl(AdminProductDTO.SYSTEM_PAYMENT_REQUESTS, ActiveAdminProductsData.SYSTEM_PAYMENT_REQUESTS, UsersKeys.Products.SYSTEM_PAYMENT_REQUESTS).master(PaymentRequestOperation.VIEW, Permission.SYSTEM_PAYMENT_REQUESTS_VIEW).map(PaymentRequestOperation.ACCEPT, Permission.SYSTEM_PAYMENT_REQUESTS_ACCEPT).map(PaymentRequestOperation.CANCEL, Permission.SYSTEM_PAYMENT_REQUESTS_CANCEL).map(PaymentRequestOperation.CHANGE_EXPIRATION_DATE, Permission.SYSTEM_PAYMENT_REQUESTS_CHANGE_EXPIRATION_DATE));
        this.register(new OperationPermissionHandlerImpl(AdminProductDTO.SYSTEM_EXTERNAL_PAYMENTS, ActiveAdminProductsData.SYSTEM_EXTERNAL_PAYMENTS, UsersKeys.Products.SYSTEM_EXTERNAL_PAYMENTS).master(ExternalPaymentOperation.VIEW, Permission.SYSTEM_EXTERNAL_PAYMENTS_VIEW).map(ExternalPaymentOperation.CANCEL, Permission.SYSTEM_EXTERNAL_PAYMENTS_CANCEL));
        this.register(new OperationPermissionHandlerImpl(AdminProductDTO.SYSTEM_SCHEDULED_PAYMENTS, ActiveAdminProductsData.SYSTEM_SCHEDULED_PAYMENTS, UsersKeys.Products.SYSTEM_SCHEDULED_PAYMENTS).master(ScheduledPaymentsOperation.VIEW, Permission.SYSTEM_SCHEDULED_PAYMENTS_VIEW).map(ScheduledPaymentsOperation.CANCEL, Permission.SYSTEM_SCHEDULED_PAYMENTS_CANCEL).map(ScheduledPaymentsOperation.MODIFY, Permission.SYSTEM_SCHEDULED_PAYMENTS_MODIFY).map(ScheduledPaymentsOperation.BLOCK, Permission.SYSTEM_SCHEDULED_PAYMENTS_BLOCK).map(ScheduledPaymentsOperation.UNBLOCK, Permission.SYSTEM_SCHEDULED_PAYMENTS_UNBLOCK).map(ScheduledPaymentsOperation.PROCESS_INSTALLMENT, Permission.SYSTEM_SCHEDULED_PAYMENTS_PROCESS_INSTALLMENT).map(ScheduledPaymentsOperation.SETTLE_INSTALLMENT, Permission.SYSTEM_SCHEDULED_PAYMENTS_SETTLE_INSTALLMENT));
        this.register(new BooleanPermissionHandlerImpl(Permission.SYSTEM_AUTHORIZED_PAYMENTS_CANCEL, AdminProductDTO.SYSTEM_AUTHORIZED_PAYMENTS_CANCEL, ActiveAdminProductsData.SYSTEM_AUTHORIZED_PAYMENTS_CANCEL, UsersKeys.Products.SYSTEM_AUTHORIZED_PAYMENTS_CANCEL));
        this.register(new PermissionHandler<AdminProductDTO, ActiveAdminProductsData>(){

            public Property<?, ? super AdminProductDTO> getDTOProperty() {
                return AdminProductDTO.AUTHORIZATION_ROLES;
            }

            public MessageKey getKey() {
                return UsersKeys.Products.AUTHORIZATION_ROLES;
            }

            public List<Permission> getPermissions() {
                return Arrays.asList(Permission.ADMIN_AUTHORIZATIONS_VIEW, Permission.ADMIN_AUTHORIZATIONS_MANAGE);
            }

            public void writePermissions(AdminProductDTO adminProductDTO, Collection<Permission> collection) {
                List list = adminProductDTO.getAuthorizationRoles();
                boolean bl = false;
                boolean bl2 = false;
                if (list != null) {
                    for (AdminProductAuthorizationRoleDTO adminProductAuthorizationRoleDTO : list) {
                        if (adminProductAuthorizationRoleDTO.isManage()) {
                            bl2 = true;
                        }
                        if (adminProductAuthorizationRoleDTO.isView()) {
                            bl = true;
                        }
                        if (!bl || !bl2) continue;
                        break;
                    }
                }
                CollectionHelper.addOrRemove(collection, (Object)Permission.ADMIN_AUTHORIZATIONS_VIEW, (boolean)bl);
                CollectionHelper.addOrRemove(collection, (Object)Permission.ADMIN_AUTHORIZATIONS_MANAGE, (boolean)bl2);
            }
        });
        this.register(new CollectionPermissionHandlerImpl(Permission.SYSTEM_PAYMENTS_PAY_TO_SYSTEM, AdminProductDTO.SYSTEM_TO_SYSTEM_PAYMENTS, UsersKeys.Products.SYSTEM_TO_SYSTEM_PAYMENTS));
        this.register(new CollectionPermissionHandlerImpl(Permission.SYSTEM_PAYMENTS_PAY_TO_USER, AdminProductDTO.SYSTEM_TO_USER_PAYMENTS, UsersKeys.Products.SYSTEM_TO_USER_PAYMENTS));
        this.register(new CollectionPermissionHandlerImpl(Permission.SYSTEM_EXTERNAL_PAYMENTS_PAY_TO_USER, AdminProductDTO.SYSTEM_TO_USER_EXTERNAL_PAYMENTS, UsersKeys.Products.SYSTEM_TO_USER_EXTERNAL_PAYMENTS));
        this.register(new CollectionPermissionHandlerImpl(Permission.SYSTEM_PAYMENTS_CHARGEBACK, AdminProductDTO.CHARGEBACK_PAYMENTS_TO_SYSTEM, UsersKeys.Products.CHARGEBACK_PAYMENTS_TO_SYSTEM));
        this.register(new ViewManagePermissionHandlerImpl(Permission.ACCOUNT_FEE_LOGS_VIEW, Permission.ACCOUNT_FEE_LOGS_MANAGE, AdminProductDTO.ACCOUNT_FEE_CHARGES, ActiveAdminProductsData.ACCOUNT_FEE_CHARGES, UsersKeys.Products.ACCOUNT_FEE_CHARGES));
        this.register(new ViewManagePermissionHandlerImpl(Permission.VOUCHER_TYPES_VIEW, Permission.VOUCHER_TYPES_MANAGE, AdminProductDTO.VOUCHER_TYPES, ActiveAdminProductsData.VOUCHER_TYPES, UsersKeys.Products.VOUCHER_TYPES));
        this.register(new BooleanPermissionHandlerImpl(Permission.MY_NOTIFICATIONS_ENABLE, AdminProductDTO.NOTIFICATIONS, ActiveAdminProductsData.NOTIFICATIONS, UsersKeys.Products.NOTIFICATIONS));
        this.register(new ViewManagePermissionHandlerImpl(Permission.OIDC_CLIENTS_VIEW, Permission.OIDC_CLIENTS_MANAGE, AdminProductDTO.OIDC_CLIENTS, ActiveAdminProductsData.OIDC_CLIENTS, UsersKeys.Products.OIDC_CLIENTS));
        this.register(new CollectionPermissionHandlerImpl(Permission.PRODUCTS_ASSIGN_TO_USER, AdminProductDTO.MANAGE_INDIVIDUAL_PRODUCTS, UsersKeys.Products.MANAGE_INDIVIDUAL_PRODUCTS));
        this.register(new BooleanPermissionHandlerImpl(Permission.USER_ALERTS_VIEW, AdminProductDTO.USER_ALERTS, ActiveAdminProductsData.USER_ALERTS, UsersKeys.Products.USER_ALERTS));
        this.register(new BooleanPermissionHandlerImpl(Permission.USERS_REGISTER, AdminProductDTO.USER_REGISTRATION, ActiveAdminProductsData.USER_REGISTRATION, UsersKeys.Products.USER_REGISTRATION));
        this.register(new CollectionPermissionHandlerImpl(Permission.CONNECTED_USERS_LOGIN, AdminProductDTO.LOGIN_USER_PRINCIPAL_TYPES, UsersKeys.Products.LOGIN_USER_PRINCIPAL_TYPES));
        this.register(new OperationPermissionHandlerImpl(AdminProductDTO.IMPORTS, ActiveAdminProductsData.IMPORTS, UsersKeys.Products.IMPORTS).map(ImportOperation.IMPORT_USERS, Permission.IMPORT_USERS).map(ImportOperation.IMPORT_ADS, Permission.IMPORT_ADS).map(ImportOperation.IMPORT_RECORDS, Permission.IMPORT_RECORDS).map(ImportOperation.IMPORT_TRANSFERS, Permission.IMPORT_TRANSFERS).map(ImportOperation.IMPORT_PAYMENTS, Permission.IMPORT_PAYMENTS).map(ImportOperation.IMPORT_GENERAL_REFERENCES, Permission.IMPORT_GENERAL_REFERENCES).map(ImportOperation.IMPORT_TOKENS, Permission.IMPORT_TOKENS));
        this.register(new ViewManagePermissionHandlerImpl(Permission.USER_GROUP_VIEW, Permission.USER_GROUP_MANAGE, AdminProductDTO.USER_GROUP, ActiveAdminProductsData.USER_GROUP, UsersKeys.Products.USER_GROUP));
        this.register(new CollectionPermissionHandlerImpl(Permission.SYSTEM_MESSAGES_VIEW, AdminProductDTO.VIEW_MESSAGES_SENT_TO_SYS_WITH_CAT, UsersKeys.Products.VIEW_MESSAGES_SENT_TO_SYS_WITH_CAT));
        this.register(new CollectionPermissionHandlerImpl(Permission.SYSTEM_MESSAGES_MANAGE, AdminProductDTO.MANAGE_MESSAGES_SENT_TO_SYS_WITH_CAT, UsersKeys.Products.MANAGE_MESSAGES_SENT_TO_SYS_WITH_CAT));
        this.register(new CollectionPermissionHandlerImpl(Permission.SYSTEM_MESSAGES_SEND_TO_USER, AdminProductDTO.SEND_MESSAGES_FROM_SYS_WITH_CAT, UsersKeys.Products.SEND_MESSAGES_FROM_SYS_WITH_CAT));
        this.register(new BooleanPermissionHandlerImpl(Permission.SYSTEM_MESSAGES_SEND_TO_GROUPS, AdminProductDTO.SEND_MESSAGES_TO_GROUPS, ActiveAdminProductsData.SEND_MESSAGES_TO_GROUPS, UsersKeys.Products.SEND_MESSAGES_TO_GROUPS));
        this.register(new CollectionPermissionHandlerImpl(Permission.APPLICATION_TRANSLATION_ENABLE, AdminProductDTO.APPLICATION_TRANSLATION, UsersKeys.Products.APPLICATION_TRANSLATION));
        this.register(new CollectionPermissionHandlerImpl(Permission.SYSTEM_CUSTOM_IMAGES_VIEW, AdminProductDTO.SYSTEM_IMAGE_CATEGORIES_VIEW, UsersKeys.Products.SYSTEM_IMAGE_CATEGORIES_VIEW));
        this.register(new CollectionPermissionHandlerImpl(Permission.SYSTEM_CUSTOM_IMAGES_MANAGE, AdminProductDTO.SYSTEM_IMAGE_CATEGORIES_MANAGE, UsersKeys.Products.SYSTEM_IMAGE_CATEGORIES_MANAGE));
        this.register(new CollectionPermissionHandlerImpl(Permission.DOCUMENTS_MANAGE, AdminProductDTO.DOCUMENT_CATEGORY_MANAGE, UsersKeys.Products.DOCUMENT_CATEGORY_MANAGE));
        this.register(new PermissionHandler<AdminProductDTO, ActiveAdminProductsData>(){

            public Property<?, ? super AdminProductDTO> getDTOProperty() {
                return AdminProductDTO.VOUCHERS;
            }

            public MessageKey getKey() {
                return UsersKeys.Products.VOUCHERS;
            }

            public List<Permission> getPermissions() {
                return Arrays.asList(Permission.VOUCHERS_VIEW, Permission.VOUCHERS_GENERATE, Permission.USER_VOUCHERS_VIEW_VOUCHERS, Permission.USER_VOUCHERS_BUY, Permission.USER_VOUCHERS_SEND, Permission.USER_VOUCHERS_VIEW_TRANSACTIONS, Permission.USER_VOUCHERS_REDEEM, Permission.USER_VOUCHERS_TOP_UP);
            }

            public void writePermissions(AdminProductDTO adminProductDTO, Collection<Permission> collection) {
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                boolean bl4 = false;
                boolean bl5 = false;
                boolean bl6 = false;
                List list = adminProductDTO.getVouchers();
                if (list != null) {
                    for (ProductAdminVoucherDTO productAdminVoucherDTO : list) {
                        VoucherConfiguration voucherConfiguration = (VoucherConfiguration)AdminProductConversionHandlerImpl.this.conversionHandler.convert(VoucherConfiguration.class, (Object)productAdminVoucherDTO.getConfiguration());
                        if (!productAdminVoucherDTO.isView()) continue;
                        bl4 = true;
                        if (productAdminVoucherDTO.isGenerate()) {
                            bl = true;
                        }
                        if (productAdminVoucherDTO.isRedeem()) {
                            bl2 = true;
                        }
                        if (voucherConfiguration.getGenerationStatus() == VoucherGenerationStatus.INACTIVE) {
                            if (!productAdminVoucherDTO.isTopUp()) continue;
                            bl3 = true;
                            continue;
                        }
                        if (productAdminVoucherDTO.isBuy()) {
                            bl5 = true;
                        }
                        if (!productAdminVoucherDTO.isSend()) continue;
                        bl6 = true;
                    }
                }
                CollectionHelper.addOrRemove(collection, (Object)Permission.VOUCHERS_VIEW, (boolean)bl4);
                CollectionHelper.addOrRemove(collection, (Object)Permission.USER_VOUCHERS_VIEW_VOUCHERS, (boolean)bl4);
                CollectionHelper.addOrRemove(collection, (Object)Permission.USER_VOUCHERS_VIEW_TRANSACTIONS, (boolean)bl4);
                CollectionHelper.addOrRemove(collection, (Object)Permission.VOUCHERS_GENERATE, (boolean)bl);
                CollectionHelper.addOrRemove(collection, (Object)Permission.USER_VOUCHERS_REDEEM, (boolean)bl2);
                CollectionHelper.addOrRemove(collection, (Object)Permission.USER_VOUCHERS_BUY, (boolean)bl5);
                CollectionHelper.addOrRemove(collection, (Object)Permission.USER_VOUCHERS_SEND, (boolean)bl6);
                CollectionHelper.addOrRemove(collection, (Object)Permission.USER_VOUCHERS_TOP_UP, (boolean)bl3);
            }
        });
        this.register(new ViewManagePermissionHandlerImpl(Permission.VOUCHER_TEMPLATES_VIEW, Permission.VOUCHER_TEMPLATES_MANAGE, AdminProductDTO.VOUCHER_TEMPLATES, ActiveAdminProductsData.VOUCHER_TEMPLATES, UsersKeys.Products.VOUCHER_TEMPLATES));
    }

    @Override
    public AdminProductDTO toDTO(AdminProduct adminProduct) {
        AdminProductDTO adminProductDTO = (AdminProductDTO)super.toDTO(adminProduct);
        this.ensureSystemRecordTypes(adminProduct, adminProductDTO);
        this.ensureAuthorizationRoles(adminProduct, adminProductDTO);
        this.ensureVouchers(adminProduct, adminProductDTO);
        this.ensureProductManagement(adminProduct, adminProductDTO);
        return adminProductDTO;
    }

    @Override
    public AdminProduct toEntity(AdminProductDTO adminProductDTO) {
        Object object;
        Object object2;
        AdminGroup adminGroup;
        if (adminProductDTO.isPersistent() && (adminGroup = (object2 = this.find(AdminProduct.class, adminProductDTO.getId())).getAdminGroup()) != null) {
            object = adminGroup.getAdminType();
            if (object == AdminGroupType.GLOBAL) {
                if (!this.isSystem()) {
                    throw new IllegalActionException();
                }
                adminProductDTO.setGlobalConfiguration(ViewManageOperation.MANAGE);
            } else {
                adminProductDTO.setGlobalConfiguration(ViewManageOperation.NONE);
            }
            if (object != null) {
                adminProductDTO.setSystemConfiguration(ViewManageOperation.MANAGE);
                adminProductDTO.setUserConfiguration(ViewManageOperation.MANAGE);
            }
            if (object == AdminGroupType.NETWORK) {
                adminProductDTO.setAccountConfiguration(ViewManageOperation.MANAGE);
            }
        }
        object2 = this.conversionHandler.convertSet(SystemAccountType.class, (Iterable)adminProductDTO.getSystemAccounts());
        adminProductDTO.setSystemToSystemPayments(this.filterPaymentTypesByFromAccount(adminProductDTO.getSystemToSystemPayments(), (Collection<AccountType>)object2, TransferTypeDirection.SYSTEM_TO_SYSTEM));
        adminProductDTO.setSystemToUserPayments(this.filterPaymentTypesByFromAccount(adminProductDTO.getSystemToUserPayments(), (Collection<AccountType>)object2, TransferTypeDirection.SYSTEM_TO_USER));
        adminProductDTO.setChargebackPaymentsToSystem(this.filterPaymentTypesByToAccount(adminProductDTO.getChargebackPaymentsToSystem(), (Collection<AccountType>)object2, TransferTypeDirection.USER_TO_SYSTEM, TransferTypeDirection.SYSTEM_TO_SYSTEM));
        adminProductDTO.setSystemTransferFilters(this.filterTransferFilters(adminProductDTO.getSystemTransferFilters(), (Collection<AccountType>)object2));
        adminProductDTO.setSystemPaymentRequestsSendToUser(this.filterPaymentTypesByToAccount(adminProductDTO.getSystemPaymentRequestsSendToUser(), (Collection<AccountType>)object2, TransferTypeDirection.USER_TO_SYSTEM));
        adminProductDTO.setSystemToUserExternalPayments(this.filterPaymentTypesByFromAccount(adminProductDTO.getSystemToUserExternalPayments(), (Collection<AccountType>)object2, TransferTypeDirection.SYSTEM_TO_USER));
        adminGroup = (AdminProduct)super.toEntity(adminProductDTO);
        object = new ArrayList();
        if (CollectionHelper.isNotEmpty((Iterable)adminProductDTO.getSystemToSystemPayments())) {
            object.addAll(adminProductDTO.getSystemToSystemPayments());
        }
        if (CollectionHelper.isNotEmpty((Iterable)adminProductDTO.getSystemToUserPayments())) {
            object.addAll(adminProductDTO.getSystemToUserPayments());
        }
        Set set = this.conversionHandler.convertSet(PaymentTransferType.class, (Iterable)object);
        adminGroup.setSystemPayments(set);
        adminGroup.getDocumentCategoryManage().retainAll(adminGroup.getDocumentCategoryView());
        adminGroup.getSendMessagesFromSysWithCat().retainAll(adminGroup.getViewMessagesSentToSysWithCat());
        adminGroup.getManageMessagesSentToSysWithCat().retainAll(adminGroup.getViewMessagesSentToSysWithCat());
        this.recordFieldHandler.toEntityProductRecordTypes((Product)adminGroup, (Collection)adminGroup.getSystemRecordTypes(), (Collection)adminProductDTO.getSystemRecordTypeFields(), ProductSystemRecordType.class);
        return adminGroup;
    }

    private void ensureAuthorizationRoles(AdminProduct adminProduct, AdminProductDTO adminProductDTO) {
        adminProductDTO.setAuthorizationRoles(new ArrayList());
        List list = this.authorizationRoleService.listAll();
        for (AuthorizationRole authorizationRole : list) {
            AdminProductAuthorizationRoleDTO adminProductAuthorizationRoleDTO = this.getAdminProductAuthorizationRoleDTO(authorizationRole, adminProduct);
            if (adminProductAuthorizationRoleDTO == null) {
                adminProductAuthorizationRoleDTO = new AdminProductAuthorizationRoleDTO();
                adminProductAuthorizationRoleDTO.setAuthorizationRole((AuthorizationRoleVO)this.conversionHandler.convert(AuthorizationRoleVO.class, (Object)authorizationRole));
            }
            adminProductDTO.getAuthorizationRoles().add(adminProductAuthorizationRoleDTO);
        }
    }

    private void ensureProductManagement(AdminProduct adminProduct, AdminProductDTO adminProductDTO) {
        adminProductDTO.setManagedProducts(new ArrayList());
        List list = this.productService.listEntities();
        for (Product product : list) {
            ProductManagementDTO productManagementDTO = this.getProductManagementDTO(product, adminProduct);
            if (productManagementDTO == null) {
                productManagementDTO = new ProductManagementDTO();
                productManagementDTO.setManagedProduct((ProductVO)this.conversionHandler.convert(ProductVO.class, (Object)product));
            }
            adminProductDTO.getManagedProducts().add(productManagementDTO);
        }
    }

    private void ensureSystemRecordTypes(AdminProduct adminProduct, AdminProductDTO adminProductDTO) {
        adminProductDTO.setSystemRecordTypeFields(this.recordFieldHandler.getProductRecordFields((Product)adminProduct, ProductSystemRecordType.class));
    }

    private void ensureVouchers(AdminProduct adminProduct, AdminProductDTO adminProductDTO) {
        adminProductDTO.setVouchers(new ArrayList());
        List list = this.voucherConfigurationService.listAll();
        for (VoucherConfiguration voucherConfiguration : list) {
            ProductAdminVoucherDTO productAdminVoucherDTO = this.getProductVoucherDTO(voucherConfiguration, adminProduct);
            if (productAdminVoucherDTO == null) {
                productAdminVoucherDTO = new ProductAdminVoucherDTO();
                productAdminVoucherDTO.setConfiguration((VoucherConfigurationVO)this.conversionHandler.convert(VoucherConfigurationVO.class, (Object)voucherConfiguration));
            }
            adminProductDTO.getVouchers().add(productAdminVoucherDTO);
        }
    }

    private AdminProductAuthorizationRoleDTO getAdminProductAuthorizationRoleDTO(AuthorizationRole authorizationRole, AdminProduct adminProduct) {
        for (AdminProductAuthorizationRole adminProductAuthorizationRole : adminProduct.getAuthorizationRoles()) {
            if (!adminProductAuthorizationRole.getAuthorizationRole().equals((Object)authorizationRole)) continue;
            return (AdminProductAuthorizationRoleDTO)this.conversionHandler.convert(AdminProductAuthorizationRoleDTO.class, (Object)adminProductAuthorizationRole);
        }
        return null;
    }

    private ProductManagementDTO getProductManagementDTO(Product product, AdminProduct adminProduct) {
        return (ProductManagementDTO)this.conversionHandler.convert(ProductManagementDTO.class, adminProduct.getManagedProducts().stream().filter(productManagement -> productManagement.getManagedProduct().equals((Object)product)).findFirst().orElse(null));
    }

    private ProductAdminVoucherDTO getProductVoucherDTO(VoucherConfiguration voucherConfiguration, AdminProduct adminProduct) {
        for (ProductAdminVoucher productAdminVoucher : adminProduct.getVouchers()) {
            if (!productAdminVoucher.getConfiguration().equals((Object)voucherConfiguration)) continue;
            return (ProductAdminVoucherDTO)this.conversionHandler.convert(ProductAdminVoucherDTO.class, (Object)productAdminVoucher);
        }
        return null;
    }
}

