/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Order;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.EntityPathBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.cyclos.entities.NamedEntity;
import org.cyclos.entities.NetworkedEntity;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.access.Channel;
import org.cyclos.entities.access.IdentityProvider;
import org.cyclos.entities.access.PasswordType;
import org.cyclos.entities.access.PrincipalType;
import org.cyclos.entities.access.UserAgent;
import org.cyclos.entities.access.UserIdentityProvider;
import org.cyclos.entities.messaging.MailContext;
import org.cyclos.entities.system.CustomField;
import org.cyclos.entities.system.IpGeolocation;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.system.UserFormatConfiguration;
import org.cyclos.entities.users.AccessLog;
import org.cyclos.entities.users.AdminGroup;
import org.cyclos.entities.users.BasicGroup;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.Group;
import org.cyclos.entities.users.LandLinePhone;
import org.cyclos.entities.users.MobilePhone;
import org.cyclos.entities.users.Operator;
import org.cyclos.entities.users.OperatorGroup;
import org.cyclos.entities.users.QAccessLog;
import org.cyclos.entities.users.QBasicUser;
import org.cyclos.entities.users.QMobilePhone;
import org.cyclos.entities.users.QUserCustomFieldValue;
import org.cyclos.entities.users.User;
import org.cyclos.entities.users.UserActivity;
import org.cyclos.entities.users.UserCustomField;
import org.cyclos.entities.users.UserCustomFieldValue;
import org.cyclos.entities.users.ValidationKeyType;
import org.cyclos.entities.utils.DatePeriod;
import org.cyclos.entities.utils.IntegerRange;
import org.cyclos.impl.BaseServiceImpl;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.access.ChannelServiceLocal;
import org.cyclos.impl.access.ChannelsComparator;
import org.cyclos.impl.access.CredentialAccessor;
import org.cyclos.impl.access.InternalIdentityProviderServiceLocal;
import org.cyclos.impl.access.PasswordHandler;
import org.cyclos.impl.access.PasswordServiceLocal;
import org.cyclos.impl.access.PrincipalTypeServiceLocal;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.access.UserChannelServiceLocal;
import org.cyclos.impl.access.UserIdentityProviderServiceLocal;
import org.cyclos.impl.banking.ExternalPaymentServiceLocal;
import org.cyclos.impl.locks.LockHandler;
import org.cyclos.impl.locks.LockType;
import org.cyclos.impl.messaging.InviteServiceLocal;
import org.cyclos.impl.search.UserSearchHandler;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.system.ConfigurationServiceLocal;
import org.cyclos.impl.system.CustomFieldValueHandler;
import org.cyclos.impl.system.CustomWizardServiceLocal;
import org.cyclos.impl.system.IpAddressServiceLocal;
import org.cyclos.impl.system.NetworkServiceLocal;
import org.cyclos.impl.users.BasicUserServiceLocal;
import org.cyclos.impl.users.LocateUserResult;
import org.cyclos.impl.users.OperatorServiceLocal;
import org.cyclos.impl.users.PhoneServiceLocal;
import org.cyclos.impl.users.ProductsAccessor;
import org.cyclos.impl.users.ProfileFieldHandler;
import org.cyclos.impl.users.UserAddressServiceLocal;
import org.cyclos.impl.users.UserServiceLocal;
import org.cyclos.impl.users.UserStatusServiceLocal;
import org.cyclos.impl.users.UserValidationFields;
import org.cyclos.impl.utils.LinkGeneratorHandler;
import org.cyclos.impl.utils.PhoneNumberDescriptor;
import org.cyclos.impl.utils.PhoneNumberHandler;
import org.cyclos.impl.utils.QueryHelper;
import org.cyclos.impl.utils.formatting.FormatterImpl;
import org.cyclos.impl.utils.notifications.MailContent;
import org.cyclos.impl.utils.notifications.MailContentProducer;
import org.cyclos.impl.utils.notifications.MailHandler;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.impl.utils.validation.BeanPropertyAccess;
import org.cyclos.impl.utils.validation.Property;
import org.cyclos.impl.utils.validation.PropertyAccess;
import org.cyclos.impl.utils.validation.ValidationError;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.impl.utils.validation.validations.GeneralValidations;
import org.cyclos.model.CRUDOperation;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IEntity;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.QueryParameters;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.AccessKeys;
import org.cyclos.model.access.CredentialUsage;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.Role;
import org.cyclos.model.access.channels.ChannelVO;
import org.cyclos.model.access.passwords.PasswordStatus;
import org.cyclos.model.access.passwordtypes.PasswordMode;
import org.cyclos.model.access.passwordtypes.PasswordTypeDetailedVO;
import org.cyclos.model.access.passwordtypes.PasswordTypeVO;
import org.cyclos.model.access.principaltypes.ExistingBuiltInPrincipalType;
import org.cyclos.model.access.principaltypes.PrincipalTypeVO;
import org.cyclos.model.access.useridentityproviders.UserIdentityProviderStatus;
import org.cyclos.model.contentmanagement.ContentManagementKeys;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.system.fields.CustomFieldValueVO;
import org.cyclos.model.system.fields.ICustomField;
import org.cyclos.model.system.images.ImageVO;
import org.cyclos.model.users.UsersKeys;
import org.cyclos.model.users.accesslogs.AccessLogQuery;
import org.cyclos.model.users.accesslogs.AccessLogResult;
import org.cyclos.model.users.accesslogs.AccessLogSearchData;
import org.cyclos.model.users.accesslogs.AccessLogVO;
import org.cyclos.model.users.addresses.AddressDTO;
import org.cyclos.model.users.addresses.UserAddressDTO;
import org.cyclos.model.users.fields.UserCustomFieldDetailedVO;
import org.cyclos.model.users.groups.GroupVO;
import org.cyclos.model.users.operators.OperatorDTO;
import org.cyclos.model.users.operators.OperatorRegistrationDTO;
import org.cyclos.model.users.operators.OperatorVO;
import org.cyclos.model.users.phones.LandLinePhoneData;
import org.cyclos.model.users.phones.MobilePhoneData;
import org.cyclos.model.users.phones.PhoneDTO;
import org.cyclos.model.users.phones.PhoneDataParams;
import org.cyclos.model.users.phones.PhoneNature;
import org.cyclos.model.users.products.UserBasicFieldActions;
import org.cyclos.model.users.products.UserProfileFieldActions;
import org.cyclos.model.users.users.AbstractSimpleUserRegistrationDTO;
import org.cyclos.model.users.users.AbstractUserRegistrationDTO;
import org.cyclos.model.users.users.AbstractViewProfileData;
import org.cyclos.model.users.users.BaseUserRegistrationResult;
import org.cyclos.model.users.users.BasicProfileField;
import org.cyclos.model.users.users.BasicUserDTO;
import org.cyclos.model.users.users.BasicUserRegistrationDTO;
import org.cyclos.model.users.users.BasicUserRegistrationData;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.EmailValidation;
import org.cyclos.model.users.users.PasswordRegistrationDTO;
import org.cyclos.model.users.users.PasswordRegistrationData;
import org.cyclos.model.users.users.ProfileField;
import org.cyclos.model.users.users.ProfileFieldAction;
import org.cyclos.model.users.users.PublicRegistrationDTO;
import org.cyclos.model.users.users.RegistrationStatus;
import org.cyclos.model.users.users.SimpleBasicUserRegistrationDTO;
import org.cyclos.model.users.users.SimpleBasicUserRegistrationData;
import org.cyclos.model.users.users.UserActivityType;
import org.cyclos.model.users.users.UserDTO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserPrincipalData;
import org.cyclos.model.users.users.UserQuery;
import org.cyclos.model.users.users.UserRegistration;
import org.cyclos.model.users.users.UserRegistrationByMemberDTO;
import org.cyclos.model.users.users.UserRegistrationDTO;
import org.cyclos.model.users.users.UserRegistrationResult;
import org.cyclos.model.users.users.UserStatus;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.users.users.UserValidationResult;
import org.cyclos.model.users.users.UserWithFieldsVO;
import org.cyclos.model.users.users.ViewProfileData;
import org.cyclos.model.utils.FieldSelector;
import org.cyclos.model.utils.FileInfo;
import org.cyclos.model.utils.IIntegerRange;
import org.cyclos.model.utils.IpGeolocationResultDTO;
import org.cyclos.model.utils.SendMedium;
import org.cyclos.security.users.OperatorServiceSecurity;
import org.cyclos.security.users.UserServiceSecurity;
import org.cyclos.server.utils.DateHelper;
import org.cyclos.server.utils.SecureRandomHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.CustomFieldHelper;
import org.cyclos.utils.MessageFormat;
import org.cyclos.utils.MessageKey;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.Page;
import org.cyclos.utils.PageImpl;
import org.cyclos.utils.Pair;
import org.cyclos.utils.StringHelper;
import org.cyclos.utils.TranslationMessageSpecification;
import org.pac4j.core.profile.CommonProfile;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BasicUserServiceImpl
extends BaseServiceImpl
implements BasicUserServiceLocal {
    private static final String CUSTOM_VALUES = "customValues";
    private static final String PHONES = "phones";
    private static final String ADDRESSES = "addresses";
    private static final List<String> RESERVED_LOGIN_NAMES = Arrays.asList("self", "system", "data-for-search", "data-for-new", "groups-for-registration", "map");
    private static final QBasicUser $ = QBasicUser.basicUser;
    @Autowired
    private RawEntityManagerHandler rawEntityManagerHandler;
    @Autowired
    private MailHandler mailHandler;
    @Autowired
    private PasswordHandler passwordHandler;
    @Autowired
    private LinkGeneratorHandler linkGeneratorHandler;
    @Autowired
    private InvokerHandler invokerHandler;
    @Autowired
    private UserChannelServiceLocal userChannelService;
    @Autowired
    private UserServiceLocal userService;
    @Autowired
    private PasswordServiceLocal passwordService;
    @Autowired
    private UserStatusServiceLocal userStatusService;
    @Autowired
    private ExternalPaymentServiceLocal externalPaymentService;
    @Autowired
    private ConfigurationServiceLocal configurationService;
    @Autowired
    private UserAddressServiceLocal addressService;
    @Autowired
    private PhoneServiceLocal phoneService;
    @Autowired
    private CustomFieldValueHandler customFieldValueHandler;
    @Autowired
    private ProfileFieldHandler profileFieldHandler;
    @Autowired
    private PrincipalTypeServiceLocal principalTypeService;
    @Autowired
    private OperatorServiceLocal operatorService;
    @Autowired
    private OperatorServiceSecurity operatorServiceSecurity;
    @Autowired
    private UserServiceSecurity userServiceSecurity;
    @Autowired
    private UserSearchHandler userSearchHandler;
    @Autowired
    private InternalIdentityProviderServiceLocal internalIdentityProviderService;
    @Autowired
    private CustomWizardServiceLocal customWizardService;
    @Autowired
    private InviteServiceLocal inviteService;
    @Autowired
    private LockHandler lockHandler;
    @Autowired
    private IpAddressServiceLocal ipAddressService;
    @Autowired
    private ChannelServiceLocal channelService;
    @Autowired
    private NetworkServiceLocal networkService;
    @Autowired
    private UserIdentityProviderServiceLocal userIdentityProviderService;
    @Autowired
    private PhoneNumberHandler phoneNumberHandler;

    public void addNameValidations(Property property, BasicUserDTO basicUserDTO) throws FrameworkException {
        if (basicUserDTO.isTransient() && this.isNameRequired(basicUserDTO)) {
            property.required();
        }
        property.name().minLength(3).maxWordSize(50);
    }

    public void addRegistrationValidations(Validator validator, SimpleBasicUserRegistrationDTO simpleBasicUserRegistrationDTO, UserRegistration userRegistration, BasicUser basicUser, UserValidationFields userValidationFields) {
        List list;
        BasicUserRegistrationDTO basicUserRegistrationDTO;
        if (userValidationFields == null) {
            userValidationFields = new UserValidationFields();
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        Group group = basicUser instanceof User ? ((User)basicUser).getGroup() : ((Operator)basicUser).getUser().getGroup();
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor((BasicGroup)group);
        CommonProfile commonProfile = InternalIdentityProviderServiceLocal.getProfile((SimpleBasicUserRegistrationDTO)simpleBasicUserRegistrationDTO);
        Set<Object> set = commonProfile != null ? Collections.emptySet() : this.passwordHandler.getPasswordTypesAtRegistration(group, userRegistration, null).keySet();
        if (simpleBasicUserRegistrationDTO instanceof BasicUserRegistrationDTO && userValidationFields.isPassword()) {
            basicUserRegistrationDTO = (BasicUserRegistrationDTO)simpleBasicUserRegistrationDTO;
            list = basicUserRegistrationDTO.getPasswords();
            Map<PasswordType, PasswordRegistrationDTO> map = this.toMap(set, list);
            basicUserRegistrationDTO.setPasswords(new ArrayList<PasswordRegistrationDTO>(map.values()));
            for (PasswordType passwordType2 : set) {
                boolean bl4;
                if (passwordType2.getPasswordMode() == PasswordMode.GENERATED) {
                    bl2 = true;
                    continue;
                }
                PasswordRegistrationDTO passwordRegistrationDTO = map.get(passwordType2);
                if (passwordRegistrationDTO == null) {
                    validator.property((org.cyclos.model.Property)AbstractUserRegistrationDTO.PASSWORDS, UsersKeys.Users.PASSWORDS).invalid(true, new ValidationError(UsersKeys.Users.PASSWORDS, new Object[]{passwordType2.getName()}));
                    continue;
                }
                bl3 = !passwordRegistrationDTO.isAssign() ? true : bl3;
                boolean bl5 = true;
                boolean bl6 = bl4 = UserRegistration.PUBLIC == userRegistration ? true : passwordRegistrationDTO.isAssign();
                if (userRegistration == UserRegistration.ADMIN || userRegistration == UserRegistration.BROKER || userRegistration == UserRegistration.USER || userRegistration == UserRegistration.IMPORT) {
                    bl5 = passwordRegistrationDTO.isAssign();
                }
                if (commonProfile != null) {
                    bl5 = false;
                    bl4 = false;
                }
                if (!bl && StringHelper.isBlank((Object)simpleBasicUserRegistrationDTO.getEmail()) && StringHelper.isBlank((Object)passwordRegistrationDTO.getValue()) && !bl4) {
                    bl = true;
                }
                if (!bl5) continue;
                PropertyAccess propertyAccess = this.passwordService.getPropertyAccess((org.cyclos.model.Property)PasswordRegistrationDTO.VALUE, passwordType2, map.get(passwordType2).getValue());
                PropertyAccess propertyAccess2 = this.passwordService.getPropertyAccess((org.cyclos.model.Property)PasswordRegistrationDTO.CONFIRMATION_VALUE, passwordType2, map.get(passwordType2).getConfirmationValue());
                Property property = validator.property(propertyAccess, (NamedEntity)passwordType2).required();
                this.passwordService.addValidations(property, basicUser, simpleBasicUserRegistrationDTO.getUsername(), passwordType2, true);
                if (userRegistration == UserRegistration.IMPORT) continue;
                Property property2 = validator.property(propertyAccess2, new TranslationMessageSpecification(AccessKeys.Passwords.CONFIRMATION, new Object[]{passwordType2}));
                property2.required();
                if (Objects.equals(passwordRegistrationDTO.getValue(), passwordRegistrationDTO.getConfirmationValue())) continue;
                property2.invalid(true);
            }
        } else {
            bl2 = set.stream().anyMatch(passwordType -> passwordType.getPasswordMode() == PasswordMode.GENERATED);
        }
        if (simpleBasicUserRegistrationDTO instanceof OperatorRegistrationDTO) {
            list = (OperatorRegistrationDTO)simpleBasicUserRegistrationDTO;
            basicUserRegistrationDTO = new Operator((User)this.conversionHandler.convert(User.class, (Object)list.getUser()));
            ((Operator)basicUserRegistrationDTO).setGroup((OperatorGroup)this.conversionHandler.convert(OperatorGroup.class, (Object)list.getGroup()));
        } else {
            basicUserRegistrationDTO = new User(group);
        }
        if (userValidationFields.has((ProfileField)BasicProfileField.PHONE) && this.profileFieldHandler.isAllowed((BasicUser)basicUserRegistrationDTO, (ProfileField)BasicProfileField.PHONE, ProfileFieldAction.EDIT)) {
            this.addPhoneValidators(validator, simpleBasicUserRegistrationDTO, userRegistration, (BasicUser)basicUserRegistrationDTO, userValidationFields.hasPhone(PhoneNature.MOBILE), userValidationFields.hasPhone(PhoneNature.LANDLINE));
        }
        if (simpleBasicUserRegistrationDTO instanceof AbstractSimpleUserRegistrationDTO && userValidationFields.has((ProfileField)BasicProfileField.ADDRESS) && this.profileFieldHandler.isAllowed((BasicUser)basicUserRegistrationDTO, (ProfileField)BasicProfileField.ADDRESS, ProfileFieldAction.EDIT)) {
            this.addAddressValidators(validator, (AbstractSimpleUserRegistrationDTO)simpleBasicUserRegistrationDTO, userRegistration, group);
        }
        if (userRegistration != UserRegistration.IMPORT && simpleBasicUserRegistrationDTO instanceof PublicRegistrationDTO && userValidationFields.isSecurityQuestion() && configurationAccessor.isRequireSecurityQuestionOnRegistration()) {
            validator.property((org.cyclos.model.Property)AbstractUserRegistrationDTO.SECURITY_QUESTION, UsersKeys.Users.PUBLIC_REGISTRATION_SECURITY_QUESTION_QUESTION).required();
            validator.property((org.cyclos.model.Property)AbstractUserRegistrationDTO.SECURITY_ANSWER, UsersKeys.Users.PUBLIC_REGISTRATION_SECURITY_QUESTION_ANSWER).required();
        }
        if (!bl2 && bl) {
            validator.general(GeneralValidations.invalid((boolean)true, (ValidationError)new ValidationError(UsersKeys.Users.PASSWORD_REQUIRED)));
        } else if (userRegistration != UserRegistration.SMS) {
            boolean bl7;
            boolean bl8 = bl7 = simpleBasicUserRegistrationDTO instanceof UserRegistrationDTO && ((UserRegistrationDTO)simpleBasicUserRegistrationDTO).isSkipActivationEmail();
            if (userValidationFields.has((ProfileField)BasicProfileField.EMAIL) && bl2 && (userRegistration != UserRegistration.IMPORT || !bl7)) {
                validator.property((org.cyclos.model.Property)UserDTO.EMAIL, UsersKeys.Users.EMAIL).required();
            }
            if (bl7) {
                if (userRegistration != UserRegistration.IMPORT && bl2) {
                    validator.general(GeneralValidations.invalid((boolean)true, (ValidationError)new ValidationError(UsersKeys.Users.CANNOT_SKIP_EMAIL_VALIDATION_GENERATED_PASSWORDS_CREATED)));
                } else if (bl3) {
                    validator.general(GeneralValidations.invalid((boolean)true, (ValidationError)new ValidationError(UsersKeys.Users.CANNOT_SKIP_EMAIL_VALIDATION_MANUAL_PASSWORDS_CREATED)));
                }
            }
        }
    }

    public void addValidations(Validator validator, BasicUserDTO basicUserDTO, BasicUser basicUser, UserValidationFields userValidationFields) {
        boolean bl;
        UserCustomField userCustomField;
        IntegerRange integerRange;
        Object object;
        boolean bl2;
        boolean bl3;
        if (userValidationFields == null) {
            userValidationFields = new UserValidationFields();
        }
        List list = this.profileFieldHandler.getFieldsByAction(basicUser, ProfileFieldAction.EDIT);
        UserRegistration userRegistration = basicUser.getRegistrationType();
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor(basicUser);
        boolean bl4 = userRegistration == UserRegistration.SMS;
        boolean bl5 = bl3 = userValidationFields.has((ProfileField)BasicProfileField.FULL_NAME) && list.contains(BasicProfileField.FULL_NAME);
        if (basicUser.isTransient() && bl3) {
            this.addNameValidations(validator.property(UserDTO.NAME, UsersKeys.Users.NAME), basicUserDTO);
        }
        boolean bl6 = bl2 = userValidationFields.has((ProfileField)BasicProfileField.LOGIN_NAME) && list.contains(BasicProfileField.LOGIN_NAME);
        if (bl2) {
            Property property = validator.property((org.cyclos.model.Property)UserDTO.USERNAME, UsersKeys.Users.USERNAME);
            property.noneOf(RESERVED_LOGIN_NAMES);
            if (basicUserDTO.getUsername() != null && (basicUserDTO.getUsername().contains(" ") || basicUserDTO.getUsername().contains(":"))) {
                property.invalid();
            }
            if (basicUserDTO.getUsername() != null) {
                property.unique("username_" + SimpleEntity.id((SimpleEntity)basicUser.getNetwork()) + "_" + basicUserDTO.getUsername().toLowerCase(), this.uniqueUsernameQuery(basicUser.getUser().getGroup().getNetwork(), basicUserDTO));
            }
            if (!configurationAccessor.isGeneratedUsername()) {
                property.required();
                object = configurationAccessor.getRegexForUsername();
                if (StringHelper.isNotBlank((Object)object)) {
                    property.regex((String)object);
                }
                userCustomField = (integerRange = configurationAccessor.getUsernameLength()) == null ? new IntegerRange(Integer.valueOf(2), Integer.valueOf(16)) : (integerRange.isOpen() ? new IntegerRange((Integer)ObjectHelper.defaultValue((Object)integerRange.getMin(), (Object)2), (Integer)ObjectHelper.defaultValue((Object)integerRange.getMax(), (Object)16)) : integerRange);
                property.length((IIntegerRange)userCustomField);
            }
        }
        boolean bl7 = bl = userValidationFields.has((ProfileField)BasicProfileField.EMAIL) && list.contains(BasicProfileField.EMAIL);
        if (bl) {
            object = validator.property((org.cyclos.model.Property)UserDTO.EMAIL, UsersKeys.Users.EMAIL).maxLength(100).email();
            if (configurationAccessor.isEmailRequired() && !bl4) {
                object.required();
            }
            if (basicUserDTO.getEmail() != null && configurationAccessor.isEmailUnique()) {
                object.unique("email_" + SimpleEntity.id((SimpleEntity)basicUser.getNetwork()) + "_" + basicUserDTO.getEmail().toLowerCase(), this.uniqueEmailQuery(basicUser.getUser().getGroup().getNetwork(), basicUserDTO));
            }
        }
        if (!bl4) {
            object = this.profileFieldHandler.getCustomFields((Collection)list);
            integerRange = object.iterator();
            while (integerRange.hasNext()) {
                userCustomField = (UserCustomField)integerRange.next();
                if (!userValidationFields.has((ProfileField)userCustomField)) continue;
                this.customFieldValueHandler.addValueValidation(validator, (CustomField)userCustomField, (EntityPathBase)QUserCustomFieldValue.userCustomFieldValue, Collections.singletonMap("user", basicUser));
            }
        }
    }

    public Page<BasicUserVO> autocomplete(UserQuery userQuery) {
        boolean bl;
        block7: {
            bl = CollectionHelper.containsAny((Collection)userQuery.getRoles(), (Object[])new Object[]{Role.OPERATOR});
            try {
                Set set;
                LocateUserResult locateUserResult = this.userLocatorHandler.locate(new UserLocatorVO((org.cyclos.model.Property)UserLocatorVO.PRINCIPAL, (Object)userQuery.getKeywords()));
                if (locateUserResult != null && !(set = this.conversionHandler.convertSet(BasicUser.class, (Iterable)userQuery.getUsersToExclude())).isEmpty() && set.contains(locateUserResult.getBasicUser())) {
                    locateUserResult = null;
                }
                if (locateUserResult != null && !(set = this.conversionHandler.convertSet(BasicUser.class, (Iterable)userQuery.getUsersToInclude())).isEmpty() && !set.contains(locateUserResult.getBasicUser())) {
                    locateUserResult = null;
                }
                if (locateUserResult == null) break block7;
                if (locateUserResult.getBasicUser() instanceof Operator) {
                    if (bl) {
                        return PageImpl.page((Object)((BasicUserVO)this.conversionHandler.convert(OperatorVO.class, (Object)locateUserResult.getBasicUser())));
                    }
                    break block7;
                }
                return PageImpl.page((Object)((BasicUserVO)this.conversionHandler.convert(UserVO.class, (Object)locateUserResult.getUser())));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        userQuery.setLocateFirst(false);
        userQuery.setIgnoreProfileFieldsInList(true);
        if (bl) {
            userQuery.getRoles().remove(Role.OPERATOR);
        }
        return PageImpl.transformed((Page)this.userService.search(userQuery), userWithFieldsVO -> (BasicUserVO)this.conversionHandler.convert(UserWithFieldsVO.class, userWithFieldsVO));
    }

    public UserRegistrationResult buildRegistrationResult(BasicUser basicUser, Set<PasswordType> set) {
        RegistrationStatus registrationStatus = basicUser.isPendingValidation() ? RegistrationStatus.EMAIL_VALIDATION : (basicUser.isActive() ? RegistrationStatus.ACTIVE : RegistrationStatus.INACTIVE);
        UserRegistrationResult userRegistrationResult = this.fillRegistrationResult(new UserRegistrationResult(), basicUser, set);
        userRegistrationResult.setStatus(registrationStatus);
        return userRegistrationResult;
    }

    public boolean canViewProfile(BasicUser basicUser) {
        if (basicUser == null) {
            return false;
        }
        if (basicUser.isOperator()) {
            return this.operatorServiceSecurity.canViewOperators(basicUser.getUser());
        }
        return this.userServiceSecurity.canViewProfile((User)basicUser);
    }

    public void clearValidationKey(BasicUser basicUser) throws FrameworkException {
        basicUser.setValidationKey(null);
        basicUser.setValidationKeyType(null);
        basicUser.setValidationKeyDate(null);
    }

    public List<ProfileField> fillProfileFields(BasicUser basicUser, AbstractViewProfileData abstractViewProfileData) {
        SessionData sessionData = this.getSessionData();
        FieldSelector fieldSelector = sessionData.getRequestData().getFields();
        boolean bl = sessionData.manages(basicUser);
        boolean bl2 = this.profileFieldHandler.canViewHidden(basicUser);
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor(basicUser);
        UserLocatorVO userLocatorVO = new UserLocatorVO(basicUser.getId());
        List list = this.profileFieldHandler.getFieldsByAction(basicUser, ProfileFieldAction.VIEW);
        ArrayList<CustomFieldValueVO> arrayList = new ArrayList<CustomFieldValueVO>();
        ArrayList<UserCustomField> arrayList2 = new ArrayList<UserCustomField>();
        for (ProfileField profileField : list) {
            UserCustomFieldValue userCustomFieldValue;
            UserCustomField userCustomField;
            if (!bl2 && this.profileFieldHandler.isHidden(basicUser, profileField, null)) continue;
            if (profileField instanceof BasicProfileField) {
                switch ((BasicProfileField)profileField) {
                    case LOGIN_NAME: {
                        abstractViewProfileData.setUsername(basicUser.getUsername());
                        break;
                    }
                    case FULL_NAME: {
                        abstractViewProfileData.setName(basicUser.getName());
                        break;
                    }
                    case EMAIL: {
                        abstractViewProfileData.setEmail(basicUser.getEmail());
                        if (!bl || !StringHelper.isNotBlank((Object)basicUser.getNewEmail())) break;
                        abstractViewProfileData.setEmailPendingValidation(basicUser.getNewEmail());
                        break;
                    }
                    case IMAGE: {
                        if (!(basicUser instanceof User) || !(abstractViewProfileData instanceof ViewProfileData)) break;
                        userCustomField = this.productsHandler.getAccessor(basicUser);
                        userCustomFieldValue = (ViewProfileData)abstractViewProfileData;
                        userCustomFieldValue.setManageUserImages(this.profileFieldHandler.isAllowed(basicUser, profileField, ProfileFieldAction.EDIT));
                        userCustomFieldValue.setImages(this.conversionHandler.convertList(ImageVO.class, (Iterable)((User)basicUser).getImages()));
                        int n = userCustomField.product().getMaxProfileImages();
                        userCustomFieldValue.setCanHaveImages(!basicUser.isRemoved() && n > 0);
                        userCustomFieldValue.setMaxUserImages(Integer.valueOf(n));
                        userCustomFieldValue.setProfileImageRequired(configurationAccessor.isProfileImageRequired());
                        break;
                    }
                    case ADDRESS: {
                        if (!fieldSelector.includes(ADDRESSES) || !(abstractViewProfileData instanceof ViewProfileData)) break;
                        userCustomField = (ViewProfileData)abstractViewProfileData;
                        userCustomField.setAddressListData(this.addressService.getAddressListData(userLocatorVO));
                        userCustomField.setAddressConfiguration(this.configurationService.toAddressConfiguration(configurationAccessor));
                        break;
                    }
                    case PHONE: {
                        if (!fieldSelector.includes(PHONES)) break;
                        abstractViewProfileData.setPhoneListData(this.phoneService.getPhoneListData(userLocatorVO));
                        abstractViewProfileData.setPhoneConfiguration(this.configurationService.toPhoneConfiguration(configurationAccessor));
                        break;
                    }
                }
                continue;
            }
            if (!fieldSelector.includes(CUSTOM_VALUES) || (userCustomFieldValue = (UserCustomFieldValue)CustomFieldHelper.findValue((ICustomField)(userCustomField = (UserCustomField)profileField), (Collection)basicUser.getCustomValues())) == null) continue;
            arrayList.add((CustomFieldValueVO)this.conversionHandler.convert(CustomFieldValueVO.class, (Object)userCustomFieldValue));
            arrayList2.add(userCustomField);
        }
        if (fieldSelector.includes(CUSTOM_VALUES)) {
            abstractViewProfileData.setCustomValues(this.conversionHandler.convertList(CustomFieldValueVO.class, arrayList));
            abstractViewProfileData.setFields(this.conversionHandler.convertList(UserCustomFieldDetailedVO.class, arrayList2));
            this.customFieldValueHandler.sortAndRemoveMissingFromVO(abstractViewProfileData.getCustomValues(), this.profileFieldHandler.getCustomFields((Collection)list));
        }
        return list;
    }

    public void fillRegistrationData(SimpleBasicUserRegistrationData simpleBasicUserRegistrationData, UserRegistration userRegistration, BasicUser basicUser) {
        boolean bl;
        BasicProfileField basicProfileField;
        PasswordRegistrationData passwordRegistrationData;
        Object object2;
        BasicUserRegistrationData basicUserRegistrationData;
        User user = basicUser.getUser();
        Group group = user.getGroup();
        boolean bl2 = false;
        Map map = this.passwordHandler.getPasswordTypesAtRegistration(group, userRegistration, null);
        Set set = map.keySet();
        if (simpleBasicUserRegistrationData instanceof BasicUserRegistrationData) {
            basicUserRegistrationData = (BasicUserRegistrationData)simpleBasicUserRegistrationData;
            ArrayList<PasswordRegistrationData> arrayList = new ArrayList<PasswordRegistrationData>();
            for (Object object2 : set) {
                if (object2.getPasswordMode() == PasswordMode.MANUAL) {
                    passwordRegistrationData = new PasswordRegistrationData();
                    passwordRegistrationData.setType((PasswordTypeDetailedVO)this.conversionHandler.convert(PasswordTypeDetailedVO.class, object2));
                    passwordRegistrationData.setUserCanChangePassword(this.passwordService.isUserCanChangePassword(basicUser, object2));
                    arrayList.add(passwordRegistrationData);
                    continue;
                }
                if (object2.getPasswordMode() != PasswordMode.GENERATED) continue;
                bl2 = true;
            }
            basicUserRegistrationData.setPasswordsData(arrayList);
        } else {
            bl2 = set.stream().filter(passwordType -> passwordType.getPasswordMode() == PasswordMode.GENERATED).findAny().isPresent();
        }
        basicUserRegistrationData = this.configurationHandler.getAccessor(basicUser);
        boolean bl3 = false;
        boolean bl4 = false;
        object2 = simpleBasicUserRegistrationData.getProfileFieldActions().iterator();
        while (object2.hasNext()) {
            passwordRegistrationData = (UserProfileFieldActions)object2.next();
            if (!(passwordRegistrationData instanceof UserBasicFieldActions)) continue;
            basicProfileField = ((UserBasicFieldActions)passwordRegistrationData).getBasicField();
            if (basicProfileField == BasicProfileField.LOGIN_NAME) {
                bl3 = passwordRegistrationData.isEdit();
                continue;
            }
            if (basicProfileField != BasicProfileField.EMAIL) continue;
            bl4 = passwordRegistrationData.isEdit();
        }
        simpleBasicUserRegistrationData.setGeneratedUsername(!bl3 || basicUserRegistrationData.isGeneratedUsername());
        if (bl4) {
            simpleBasicUserRegistrationData.setEmailRequired((simpleBasicUserRegistrationData.isEmailRequired() || bl2) && userRegistration != UserRegistration.SMS);
            object2 = this.requiresEmailValidation(userRegistration, (ConfigurationAccessor)basicUserRegistrationData, null);
            simpleBasicUserRegistrationData.setEmailValidation(object2 == EmailValidationResult.REQUIRES_VALIDATION);
        }
        boolean bl5 = bl = (object2 = CustomFieldHelper.findActions((ProfileField)BasicProfileField.PHONE, (Iterable)simpleBasicUserRegistrationData.getProfileFieldActions())) != null && object2.isEdit();
        if (bl) {
            basicProfileField = new PhoneDataParams();
            basicProfileField.setSuggestPhoneName(true);
            if (basicUser.isOperator()) {
                basicProfileField.setOperatorOwner(new UserLocatorVO(user.getId()));
            } else {
                basicProfileField.setGroup(new GroupVO(group.getId()));
            }
            basicProfileField.setNature(PhoneNature.LANDLINE);
            LandLinePhoneData landLinePhoneData = (LandLinePhoneData)this.phoneService.getDataForNew((Object)basicProfileField);
            simpleBasicUserRegistrationData.setLandLinePhoneData(landLinePhoneData);
            simpleBasicUserRegistrationData.setLandLineRequired(basicUserRegistrationData.isLandLineRequired());
            basicProfileField.setNature(PhoneNature.MOBILE);
            MobilePhoneData mobilePhoneData = (MobilePhoneData)this.phoneService.getDataForNew((Object)basicProfileField);
            simpleBasicUserRegistrationData.setMobilePhoneData(mobilePhoneData);
            simpleBasicUserRegistrationData.setMobileRequired(basicUserRegistrationData.isMobileRequired());
            ProductsAccessor productsAccessor = this.productsHandler.getAccessor((BasicUser)user);
            int n = productsAccessor.product().getMaxMobilePhones();
            int n2 = productsAccessor.product().getMaxLandlinePhones();
            simpleBasicUserRegistrationData.setMaxMobilePhones(n);
            simpleBasicUserRegistrationData.setMaxLandLinePhones(n2);
            simpleBasicUserRegistrationData.setCanCreateMobilePhone(n > 0);
            simpleBasicUserRegistrationData.setCanCreateLandlinePhone(n2 > 0);
        }
    }

    public Map<PasswordType, String> finishActivation(BasicUser basicUser) {
        Map map = this.passwordHandler.getPasswordTypesAtRegistration(basicUser.getUser().getGroup(), basicUser.getRegistrationType(), null);
        HashMap<PasswordType, String> hashMap = new HashMap<PasswordType, String>();
        for (PasswordType passwordType : map.keySet()) {
            boolean bl;
            if (basicUser.getRegistrationType() == UserRegistration.IMPORT && !basicUser.isSendActivationEmail() && passwordType.getPasswordMode().isGeneratedPassword() || this.passwordService.exists(basicUser, passwordType) || passwordType.isRequiresAdminAuthorization() || (bl = ((Boolean)map.get(passwordType)).booleanValue()) && basicUser.getIdentityProviderRequestId() != null) continue;
            PasswordStatus passwordStatus = passwordType.getPasswordMode() == PasswordMode.MANUAL && bl ? PasswordStatus.RESET : PasswordStatus.ACTIVE;
            String string = (String)this.passwordService.create(basicUser, passwordType, null, passwordStatus).getFirst();
            hashMap.put(passwordType, string);
        }
        if (StringHelper.isNotBlank((Object)basicUser.getEmail())) {
            this.sendActivationEmail(basicUser, hashMap);
        }
        return hashMap;
    }

    public AccessLogSearchData getAccessLogSearchData() {
        AccessLogSearchData accessLogSearchData = new AccessLogSearchData();
        accessLogSearchData.setChannels(this.conversionHandler.convertList(ChannelVO.class, this.resolveStatefulChannels()));
        AccessLogQuery accessLogQuery = (AccessLogQuery)QueryHelper.newQuery(AccessLogQuery.class);
        accessLogSearchData.setQuery((QueryParameters)accessLogQuery);
        if (this.getSessionData().getNetwork() == null) {
            accessLogSearchData.setNetworks(this.networkService.getManagedNetworks());
        }
        return accessLogSearchData;
    }

    public List<UserPrincipalData> getPrincipalsData(BasicUser basicUser, Channel channel) {
        FormatterImpl formatterImpl = this.getFormatter();
        return this.getRawPrincipalsData(basicUser, channel).stream().map(rawUserPrincipalData -> {
            UserPrincipalData userPrincipalData = new UserPrincipalData();
            userPrincipalData.setChannels(this.conversionHandler.convertList(ChannelVO.class, rawUserPrincipalData.getChannels()));
            if (rawUserPrincipalData.getPrincipal() instanceof IdentityProvider) {
                IdentityProvider identityProvider = (IdentityProvider)rawUserPrincipalData.getPrincipal();
                PrincipalTypeVO principalTypeVO = new PrincipalTypeVO();
                principalTypeVO.setInternalName(identityProvider.getInternalName());
                principalTypeVO.setName(formatterImpl.format(rawUserPrincipalData.getPrincipalType()));
                userPrincipalData.setPrincipalType(principalTypeVO);
            } else {
                userPrincipalData.setPrincipalType((PrincipalTypeVO)this.conversionHandler.convert(PrincipalTypeVO.class, rawUserPrincipalData.getPrincipalType()));
            }
            userPrincipalData.setPrincipal(formatterImpl.format(rawUserPrincipalData.getPrincipal()));
            return userPrincipalData;
        }).collect(Collectors.toList());
    }

    public BasicUser getUserForValidationKey(ValidationKeyType validationKeyType, String string) throws FrameworkException {
        Network network = this.getSessionData().getNetwork();
        BasicUser basicUser = (BasicUser)((DBQuery)this.rawEntityManagerHandler.from(new EntityPath[]{$}).where(new Predicate[]{network == null ? $.network().isNull() : $.network().eq((Object)network), BasicUserServiceImpl.$.validationKey.eq((Object)string), BasicUserServiceImpl.$.validationKeyType.eq((Object)validationKeyType)})).singleResult((Expression)$);
        if (basicUser == null) {
            throw new ValidationException(this.message(UsersKeys.Users.VALIDATION_KEY_WRONG_KEY, new Object[0]));
        }
        return basicUser;
    }

    public boolean isEmailTaken(ConfigurationAccessor configurationAccessor, String string) {
        string = StringHelper.trimToNull((Object)string);
        if (!configurationAccessor.isEmailUnique() || string == null) {
            return false;
        }
        QBasicUser qBasicUser = QBasicUser.basicUser;
        return ((DBQuery)this.from(new EntityPath[]{qBasicUser}).where(new Predicate[]{qBasicUser.email.equalsIgnoreCase(string), qBasicUser.status.notIn((Object[])new UserStatus[]{UserStatus.REMOVED, UserStatus.PURGED})})).hasResults();
    }

    public boolean isMobileNumberTaken(ConfigurationAccessor configurationAccessor, String string) {
        string = StringHelper.trimToNull((Object)string);
        if (!configurationAccessor.isMobileUnique() || string == null) {
            return false;
        }
        PhoneNumberDescriptor phoneNumberDescriptor = this.phoneNumberHandler.parse(string, configurationAccessor);
        if (phoneNumberDescriptor == null) {
            return false;
        }
        QMobilePhone qMobilePhone = QMobilePhone.mobilePhone;
        return ((DBQuery)this.from(new EntityPath[]{qMobilePhone}).where(new Predicate[]{qMobilePhone.normalizedNumber.eq((Object)phoneNumberDescriptor.toE164()), qMobilePhone.user().status.notIn((Object[])new UserStatus[]{UserStatus.REMOVED, UserStatus.PURGED})})).hasResults();
    }

    public boolean isNameRequired(BasicUserDTO basicUserDTO) throws FrameworkException {
        BasicUser basicUser;
        if (basicUserDTO.isPersistent()) {
            basicUser = this.find(BasicUser.class, basicUserDTO.getId());
        } else if (basicUserDTO instanceof UserDTO) {
            Group group = (Group)this.conversionHandler.convert(Group.class, (Object)((UserDTO)basicUserDTO).getGroup());
            if (group == null) {
                return true;
            }
            basicUser = new User(group);
        } else {
            User user = (User)this.conversionHandler.convert(User.class, (Object)((OperatorDTO)basicUserDTO).getUser());
            basicUser = new Operator(user);
        }
        return this.profileFieldHandler.isAllowed(basicUser, (ProfileField)BasicProfileField.FULL_NAME, ProfileFieldAction.EDIT);
    }

    public boolean isUsernameTaken(ConfigurationAccessor configurationAccessor, String string) {
        string = StringHelper.trimToNull((Object)string);
        if (configurationAccessor.isGeneratedUsername() || string == null) {
            return false;
        }
        QBasicUser qBasicUser = QBasicUser.basicUser;
        return ((DBQuery)this.from(new EntityPath[]{qBasicUser}).where(new Predicate[]{qBasicUser.username.equalsIgnoreCase(string), qBasicUser.status.notIn((Object[])new UserStatus[]{UserStatus.REMOVED, UserStatus.PURGED})})).hasResults();
    }

    public AccessLogVO loadAccessLog(@NotNull Long l) {
        UserAgent userAgent;
        AccessLog accessLog = this.getSessionData().getNetwork() == null ? (AccessLog)this.rawEntityManagerHandler.find(AccessLog.class, l) : this.find(AccessLog.class, l);
        AccessLogVO accessLogVO = (AccessLogVO)this.conversionHandler.convert(AccessLogVO.class, (Object)accessLog);
        IpGeolocation ipGeolocation = this.ipAddressService.geolocate(accessLog.getRemoteAddress());
        if (ipGeolocation != null) {
            accessLogVO.setGeolocation((IpGeolocationResultDTO)this.conversionHandler.convert(IpGeolocationResultDTO.class, (Object)ipGeolocation));
        }
        if ((userAgent = accessLog.getUserAgent()) != null) {
            Object object = userAgent.getDevice();
            if (!((String)object).contains(userAgent.getOperatingSystem())) {
                object = (String)object + " (" + userAgent.getOperatingSystem() + ")";
            }
            String string = accessLog.getChannel() != null && accessLog.getChannel().isMobile() ? accessLog.getChannel().getName() : userAgent.getAgent();
            accessLogVO.setDevice(this.message(UsersKeys.AccessLogs.DEVICE_VALUE, string, object));
        }
        return accessLogVO;
    }

    public void manuallyValidateEmailChange(UserLocatorVO userLocatorVO) throws FrameworkException {
        BasicUser basicUser = this.userLocatorHandler.locate(userLocatorVO).getBasicUser();
        if (basicUser.getValidationKeyType() != ValidationKeyType.EMAIL_CHANGE) {
            throw new IllegalActionException();
        }
        this.validateEmailChange(basicUser);
    }

    public UserValidationResult manuallyValidateRegistration(UserLocatorVO userLocatorVO) throws FrameworkException {
        BasicUser basicUser = this.userLocatorHandler.locate(userLocatorVO).getBasicUser();
        if (basicUser.getValidationKeyType() != ValidationKeyType.REGISTRATION) {
            throw new IllegalActionException();
        }
        return this.validateRegistration(basicUser);
    }

    public void persistAdditionalRegistrationData(BasicUser basicUser, SimpleBasicUserRegistrationDTO simpleBasicUserRegistrationDTO, List<ProfileField> list) {
        if (list.contains(BasicProfileField.PHONE) || basicUser.getRegistrationType() == UserRegistration.SMS) {
            Long l;
            Object object5;
            BasicUserVO basicUserVO = new BasicUserVO(basicUser.getId());
            if (CollectionHelper.isNotEmpty((Iterable)simpleBasicUserRegistrationDTO.getMobilePhones())) {
                Object object2;
                Object object3 = null;
                if (simpleBasicUserRegistrationDTO instanceof PublicRegistrationDTO) {
                    object2 = (PublicRegistrationDTO)simpleBasicUserRegistrationDTO;
                    if (object2.getExternalPaymentToken() != null && (object5 = this.externalPaymentService.findByToken(object2.getExternalPaymentToken())).getToPrincipalType().getInternalName().equals(ExistingBuiltInPrincipalType.MOBILE_PHONE.getInternalName())) {
                        object3 = object5.getToPrincipalValue();
                    }
                    if (object3 == null) {
                        object5 = this.customWizardService.getStorage((PublicRegistrationDTO)object2);
                        Object object4 = object3 = object5 == null ? null : object5.getVerifiedSms();
                    }
                }
                if (object3 != null && (object5 = this.phoneNumberHandler.parse(object3, (ConfigurationAccessor)(object2 = this.configurationHandler.getAccessAccessor(basicUser)))) != null) {
                    object3 = object5.toE164();
                }
                for (Object object5 : simpleBasicUserRegistrationDTO.getMobilePhones()) {
                    MobilePhone mobilePhone;
                    object5.setUser(basicUserVO);
                    if (StringHelper.isBlank((Object)object5.getName())) {
                        object5.setName(this.message(UsersKeys.Users.MOBILE_PHONE, new Object[0]));
                    }
                    if ((mobilePhone = (MobilePhone)this.rawEntityManagerHandler.find(MobilePhone.class, l = this.phoneService.save((EntityDTO)object5))).getNormalizedNumber().equals(object3)) {
                        mobilePhone.setVerificationDate(new Date());
                        mobilePhone.setEnabledForSms(true);
                    }
                    basicUser.getPhones().add(mobilePhone);
                }
            }
            if (CollectionHelper.isNotEmpty((Iterable)simpleBasicUserRegistrationDTO.getLandLinePhones())) {
                for (Object object2 : simpleBasicUserRegistrationDTO.getLandLinePhones()) {
                    object2.setUser(basicUserVO);
                    if (StringHelper.isBlank((Object)object2.getName())) {
                        object2.setName(this.message(UsersKeys.Users.LAND_LINE_PHONE, new Object[0]));
                    }
                    object5 = this.phoneService.save((EntityDTO)object2);
                    l = (LandLinePhone)this.rawEntityManagerHandler.find(LandLinePhone.class, (Long)object5);
                    basicUser.getPhones().add(l);
                }
            }
        }
    }

    public <BU extends BasicUser> BU preProcessRegistration(SimpleBasicUserRegistrationDTO simpleBasicUserRegistrationDTO, UserRegistration userRegistration) throws FrameworkException {
        boolean bl;
        EmailValidationResult emailValidationResult;
        BasicUser basicUser = simpleBasicUserRegistrationDTO instanceof AbstractSimpleUserRegistrationDTO ? (BasicUser)this.conversionHandler.convertExcluding(User.class, (Object)simpleBasicUserRegistrationDTO, this.userService.getExcludedPropertiesToEntity()) : (BasicUser)this.conversionHandler.convertExcluding(Operator.class, (Object)simpleBasicUserRegistrationDTO, this.operatorService.getExcludedPropertiesToEntity());
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor(basicUser);
        if (configurationAccessor.isGeneratedUsername() || basicUser.getUsername() == null) {
            basicUser.setUsername(this.generateNewUsername(configurationAccessor));
        }
        if (basicUser.getCreationDate() == null) {
            basicUser.setCreationDate(DateHelper.now());
        }
        UserStatus userStatus = (emailValidationResult = this.requiresEmailValidation(userRegistration, configurationAccessor, simpleBasicUserRegistrationDTO)) == EmailValidationResult.REQUIRES_VALIDATION ? UserStatus.PENDING : (basicUser.isOperator() ? UserStatus.ACTIVE : ((User)basicUser).getGroup().getInitialUserStatus());
        if (simpleBasicUserRegistrationDTO instanceof PublicRegistrationDTO || simpleBasicUserRegistrationDTO instanceof UserRegistrationByMemberDTO) {
            bl = true;
        } else if (simpleBasicUserRegistrationDTO instanceof UserRegistrationDTO) {
            bl = !((UserRegistrationDTO)simpleBasicUserRegistrationDTO).isSkipActivationEmail();
        } else {
            boolean bl2 = bl = !((OperatorRegistrationDTO)simpleBasicUserRegistrationDTO).isSkipActivationEmail();
        }
        if (simpleBasicUserRegistrationDTO instanceof PublicRegistrationDTO) {
            basicUser.setLocale(this.getSessionData().getConfiguration().getLanguage().getTemplate().getLocale());
        } else if (simpleBasicUserRegistrationDTO instanceof OperatorRegistrationDTO) {
            basicUser.setLocale(basicUser.getUser().getLocale());
        }
        basicUser.setStatus(userStatus);
        basicUser.setSendActivationEmail(bl);
        basicUser.setRegistrationType(userRegistration);
        basicUser.setRegisteredBy(this.getLoggedBasicUser());
        this.updateDisplay(basicUser);
        return (BU)basicUser;
    }

    public Map<PasswordType, String> processRegistration(BasicUser basicUser, SimpleBasicUserRegistrationDTO simpleBasicUserRegistrationDTO) {
        Object object;
        if (basicUser.getRegistrationType() == null) {
            throw new IllegalArgumentException("Registration type is required");
        }
        if (simpleBasicUserRegistrationDTO instanceof BasicUserRegistrationDTO && CollectionHelper.isNotEmpty((Iterable)(object = (BasicUserRegistrationDTO)simpleBasicUserRegistrationDTO).getPasswords())) {
            for (PasswordRegistrationDTO passwordRegistrationDTO : object.getPasswords()) {
                PasswordType passwordType;
                if (!StringUtils.isNotBlank((CharSequence)passwordRegistrationDTO.getValue()) || (passwordType = (PasswordType)this.conversionHandler.convert(PasswordType.class, (Object)passwordRegistrationDTO.getType())).getPasswordMode() != PasswordMode.MANUAL) continue;
                PasswordStatus passwordStatus = basicUser.getRegistrationType() == UserRegistration.PUBLIC || !passwordRegistrationDTO.isForceChange() ? PasswordStatus.ACTIVE : PasswordStatus.RESET;
                this.passwordService.create(basicUser, passwordType, passwordRegistrationDTO.getValue(), passwordStatus);
            }
        }
        if ((object = this.requiresEmailValidation(basicUser.getRegistrationType(), this.configurationHandler.getAccessor(basicUser), simpleBasicUserRegistrationDTO)) == EmailValidationResult.REQUIRES_VALIDATION) {
            this.setRegistrationValidation(basicUser);
            return Collections.emptyMap();
        }
        if (object == EmailValidationResult.ALREADY_VERIFIED) {
            basicUser.setEmailVerified(true);
        }
        return this.processActivation(basicUser);
    }

    public void reindex(BasicUser basicUser) throws FrameworkException {
        ProductsAccessor productsAccessor;
        this.doReindex(basicUser);
        if (basicUser instanceof User) {
            this.userSearchHandler.index((NetworkedEntity)((User)basicUser));
        }
        if ((productsAccessor = this.productsHandler.getAccessor(basicUser)).memberOrBroker().hasPermission(Permission.MY_OPERATORS_ENABLE)) {
            this.operatorService.list(basicUser.getUser()).forEach(this::doReindex);
        }
    }

    public boolean requiresEmailChangeValidation(BasicUser basicUser) {
        SessionData sessionData = this.getSessionData();
        if (sessionData.isSystem()) {
            return false;
        }
        User user = basicUser.getUser();
        Set set = this.configurationHandler.getAccessor(basicUser).getEmailValidation();
        if (user.equals((Object)sessionData.getLoggedUser())) {
            return set.contains(EmailValidation.EDIT_BY_SELF);
        }
        if (sessionData.isAdminOf((BasicUser)user)) {
            return set.contains(EmailValidation.EDIT_BY_ADMIN);
        }
        if (sessionData.isBrokerOf((BasicUser)user)) {
            return set.contains(EmailValidation.EDIT_BY_BROKER);
        }
        return false;
    }

    public void resendEmailChangeMail(UserLocatorVO userLocatorVO) throws FrameworkException {
        BasicUser basicUser = this.userLocatorHandler.locate(userLocatorVO).getBasicUser();
        if (basicUser.getValidationKeyType() != ValidationKeyType.EMAIL_CHANGE) {
            throw new IllegalActionException();
        }
        this.sendEmailChangeValidation(basicUser);
    }

    public void resendRegistrationValidationMail(UserLocatorVO userLocatorVO) {
        BasicUser basicUser = this.userLocatorHandler.locate(userLocatorVO).getBasicUser();
        if (basicUser.getValidationKeyType() != ValidationKeyType.REGISTRATION) {
            throw new IllegalActionException();
        }
        this.doSendRegistrationValidation(basicUser);
    }

    public Page<AccessLogResult> searchAccessLogs(@NotNull AccessLogQuery accessLogQuery) throws FrameworkException {
        DBQuery dBQuery;
        QAccessLog qAccessLog = QAccessLog.accessLog;
        SessionData sessionData = this.getSessionData();
        if (sessionData.getNetwork() != null) {
            dBQuery = this.from(new EntityPath[]{qAccessLog});
        } else {
            dBQuery = this.rawEntityManagerHandler.from(new EntityPath[]{qAccessLog});
            if (sessionData.isMultiNetworkAdminInGlobalMode()) {
                dBQuery.where((Predicate)qAccessLog.user().network().in((Collection)((AdminGroup)this.getLoggedUser().getGroup()).getManagedNetworks()));
            }
        }
        if (QueryHelper.useParameter((Object)accessLogQuery.getNetwork())) {
            dBQuery.where((Predicate)qAccessLog.user().network().eq((Object)((Network)this.conversionHandler.convert(Network.class, (Object)accessLogQuery.getNetwork()))));
        }
        if (Boolean.TRUE.equals(accessLogQuery.getOnlyGlobal()) && sessionData.isGlobalAdmin()) {
            dBQuery.where((Predicate)qAccessLog.user().network().isNull());
        }
        if (QueryHelper.useParameter((Object)accessLogQuery.getChannels())) {
            dBQuery.where((Predicate)qAccessLog.channel().in((Collection)this.conversionHandler.convertList(Channel.class, (Iterable)accessLogQuery.getChannels())));
        }
        if (QueryHelper.useParameter((Object)accessLogQuery.getPeriod())) {
            dBQuery.where(qAccessLog.date.period((DatePeriod)this.conversionHandler.convert(DatePeriod.class, (Object)accessLogQuery.getPeriod())));
        }
        if (QueryHelper.useParameter((Object)accessLogQuery.getUser())) {
            dBQuery.where((Predicate)qAccessLog.user().eq((Object)((BasicUser)this.conversionHandler.convert(BasicUser.class, (Object)accessLogQuery.getUser()))));
        }
        if (QueryHelper.useParameter((Object)accessLogQuery.getMobileAppVersion())) {
            dBQuery.where((Predicate)qAccessLog.mobileAppVersion.containsIgnoreCase(accessLogQuery.getMobileAppVersion()));
        }
        dBQuery.orderBy(new OrderSpecifier(Order.DESC, (Expression)qAccessLog.date));
        return PageImpl.transformed((Page)dBQuery.page((QueryParameters)accessLogQuery, (Expression)qAccessLog), accessLog -> (AccessLogResult)this.conversionHandler.convert(AccessLogResult.class, accessLog));
    }

    public void setEmailChangeValidation(BasicUser basicUser, String string) {
        basicUser.setNewEmail(basicUser.getEmail());
        basicUser.setEmail(string);
        this.setValidationKey(basicUser, ValidationKeyType.EMAIL_CHANGE);
        this.sendEmailChangeValidation(basicUser);
    }

    public boolean shouldCheckConfirmationPassword(BasicUser basicUser, CRUDOperation cRUDOperation) {
        CredentialAccessor credentialAccessor;
        if (basicUser.equals((Object)this.getLoggedBasicUser()) && (credentialAccessor = this.passwordHandler.accessor(CredentialUsage.CONFIRMATION)).isDefined()) {
            if (!credentialAccessor.getOtpSendMediums().contains(SendMedium.EMAIL)) {
                return true;
            }
            return StringHelper.isNotBlank((Object)basicUser.getEmail());
        }
        return false;
    }

    public DBQuery<?> uniqueEmailQuery(Network network, BasicUserDTO basicUserDTO) {
        String string = basicUserDTO.getEmail();
        if (StringHelper.isBlank((Object)string)) {
            return null;
        }
        return (DBQuery)this.rawEntityManagerHandler.from(new EntityPath[]{$}).where(new Predicate[]{network == null ? $.network().isNull() : $.network().eq((Object)network), BasicUserServiceImpl.$.status.notIn((Object[])new UserStatus[]{UserStatus.REMOVED, UserStatus.PURGED}), BasicUserServiceImpl.$.email.equalsIgnoreCase(string).or((Predicate)BasicUserServiceImpl.$.newEmail.equalsIgnoreCase(string)), basicUserDTO.isPersistent() ? BasicUserServiceImpl.$.id.ne((Object)basicUserDTO.getId()) : BasicUserServiceImpl.$.id.isNotNull()});
    }

    public void updateDisplay(BasicUser basicUser) {
        if (basicUser.isRemoved()) {
            return;
        }
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor(basicUser);
        List list = this.profileFieldHandler.getEnabledProfileFields(basicUser);
        FormatterImpl formatterImpl = this.getFormatter(basicUser);
        basicUser.setDisplayForManagers(this.getDisplay(basicUser, list, configurationAccessor.getUserFormatForManagers(), formatterImpl));
        basicUser.setDisplayForOthers(this.getDisplay(basicUser, list, configurationAccessor.getUserFormatForOthers(), formatterImpl));
    }

    public void updateUserActivity(UserActivityType userActivityType) {
        BasicUser basicUser = this.getLoggedBasicUser();
        if (basicUser == null) {
            return;
        }
        UserActivity userActivity = basicUser.getActivity();
        if (userActivity == null) {
            userActivity = new UserActivity();
            userActivity.setUser(basicUser);
            basicUser.setActivity(userActivity);
        }
        switch (userActivityType) {
            case MESSAGE: {
                userActivity.setMessageAlert(DateHelper.now());
                break;
            }
            case NOTIFICATION: {
                userActivity.setNotificationAlert(DateHelper.now());
            }
        }
        this.persist((IEntity)userActivity);
    }

    public Long validateEmailChange(String string) throws FrameworkException {
        BasicUser basicUser = this.getUserForValidationKey(ValidationKeyType.EMAIL_CHANGE, string);
        return this.validateEmailChange(basicUser);
    }

    public UserValidationResult validateRegistration(String string) {
        BasicUser basicUser = this.getUserForValidationKey(ValidationKeyType.REGISTRATION, string);
        return this.validateRegistration(basicUser);
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(QAccessLog.accessLog.user().network());
    }

    private void addAddressValidators(Validator validator, AbstractSimpleUserRegistrationDTO abstractSimpleUserRegistrationDTO, UserRegistration userRegistration, Group group) {
        List list;
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor((BasicGroup)group);
        if (userRegistration != UserRegistration.SMS && configurationAccessor.isRequiredAddress()) {
            validator.property((org.cyclos.model.Property)AbstractSimpleUserRegistrationDTO.ADDRESSES, UsersKeys.Users.ADDRESS).required();
        }
        if (CollectionHelper.isNotEmpty((Iterable)(list = abstractSimpleUserRegistrationDTO.getAddresses()))) {
            for (UserAddressDTO userAddressDTO : list) {
                validator.nested((PropertyAccess)new BeanPropertyAccess((org.cyclos.model.Property)AbstractSimpleUserRegistrationDTO.ADDRESSES), this.addressService.getValidator((AddressDTO)userAddressDTO, group, true));
            }
        }
    }

    private void addPhoneValidators(Validator validator, SimpleBasicUserRegistrationDTO simpleBasicUserRegistrationDTO, UserRegistration userRegistration, BasicUser basicUser, boolean bl, boolean bl2) {
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor(basicUser);
        if (bl) {
            if (simpleBasicUserRegistrationDTO.getMobilePhones() != null) {
                for (PhoneDTO phoneDTO : simpleBasicUserRegistrationDTO.getMobilePhones()) {
                    validator.nested((org.cyclos.model.Property)AbstractSimpleUserRegistrationDTO.MOBILE_PHONES, this.phoneService.getValidator(phoneDTO, basicUser));
                }
            }
            if (userRegistration == UserRegistration.SMS || configurationAccessor.isMobileRequired()) {
                validator.property((org.cyclos.model.Property)AbstractSimpleUserRegistrationDTO.MOBILE_PHONES, UsersKeys.Users.MOBILE_PHONE).required();
            }
        }
        if (bl2) {
            if (userRegistration != UserRegistration.SMS && configurationAccessor.isLandLineRequired()) {
                validator.property((org.cyclos.model.Property)AbstractSimpleUserRegistrationDTO.LAND_LINE_PHONES, UsersKeys.Users.LAND_LINE_PHONE).required();
            }
            if (simpleBasicUserRegistrationDTO.getLandLinePhones() != null) {
                for (PhoneDTO phoneDTO : simpleBasicUserRegistrationDTO.getLandLinePhones()) {
                    validator.nested((org.cyclos.model.Property)AbstractSimpleUserRegistrationDTO.LAND_LINE_PHONES, this.phoneService.getValidator(phoneDTO, basicUser));
                }
            }
        }
    }

    private void doReindex(BasicUser basicUser) {
        if (basicUser.getStatus().isRemoved()) {
            return;
        }
        this.profileFieldHandler.purgeDisabled(basicUser);
        this.customFieldValueHandler.setDefaultValues((SimpleEntity)basicUser, (Collection)this.profileFieldHandler.getCustomFields((Collection)this.profileFieldHandler.getEnabledProfileFields(basicUser)));
        this.updateDisplay(basicUser);
        this.passwordService.updateUser(basicUser);
    }

    private void doSendRegistrationValidation(BasicUser basicUser) {
        String string = basicUser.getValidationKey();
        String string2 = this.linkGeneratorHandler.registrationValidation(string, basicUser);
        String string3 = this.linkGeneratorHandler.mobileRedirect("/validateRegistration?key=" + string, basicUser);
        this.mailHandler.send(null, basicUser, MailContext.REGISTRATION_VALIDATION, (MailContentProducer)this.mailContentBuilder().subject(ContentManagementKeys.Emails.VALIDATION_SUBJECT, new Object[0]).body(ContentManagementKeys.Emails.VALIDATION_USER_REGISTRATION_BODY, new Object[]{string2, string3}), new FileInfo[0]);
    }

    private UserValidationResult doValidateRegistration(BasicUser basicUser) {
        basicUser.setEmailVerified(true);
        this.userStatusService.setInitialStatusOnEmailValidation(basicUser);
        Set<PasswordType> set = this.processActivation(basicUser).keySet();
        UserValidationResult userValidationResult = this.fillRegistrationResult(new UserValidationResult(), basicUser, set);
        userValidationResult.setActive(basicUser.isActive());
        this.clearValidationKey(basicUser);
        if (basicUser instanceof User) {
            this.userSearchHandler.index((NetworkedEntity)((User)basicUser));
        }
        return userValidationResult;
    }

    private <R extends BaseUserRegistrationResult> R fillRegistrationResult(R r, BasicUser basicUser, Set<PasswordType> set) {
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor(basicUser);
        r.setGeneratedPasswords(this.conversionHandler.convertList(PasswordTypeVO.class, set));
        Collections.sort(r.getGeneratedPasswords());
        r.setPrincipalsData(this.getPrincipalsData(basicUser, null));
        r.setUser((BasicUserVO)this.conversionHandler.convert(UserVO.class, (Object)basicUser));
        r.setRootUrl(configurationAccessor.getFullUrl());
        return r;
    }

    private String generateNewUsername(ConfigurationAccessor configurationAccessor) throws FrameworkException {
        String string;
        Network network = configurationAccessor.getConfiguration().getNetwork();
        Integer n = (Integer)ObjectHelper.defaultValue((Object)configurationAccessor.getGeneratedUsernameLength(), (Object)10);
        Object object = null;
        do {
            if (!((String)(object = StringHelper.randomNumeric((int)n))).startsWith("0")) continue;
            object = (int)(Math.random() * 9.0) + 1 + ((String)object).substring(1);
        } while (!this.lockHandler.tryLock(LockType.UNIQUE_VALIDATION.key(string = "username_" + SimpleEntity.id((SimpleEntity)network) + "_" + (String)object)) || !this.uniqueUsernameQuery(network, (String)object, null).hasEmptyResults());
        return object;
    }

    private String getDisplay(BasicUser basicUser, List<ProfileField> list, UserFormatConfiguration userFormatConfiguration, FormatterImpl formatterImpl) {
        if (userFormatConfiguration == null) {
            return null;
        }
        List list2 = userFormatConfiguration.getProfileFields();
        ArrayList<String> arrayList = new ArrayList<String>(list2.size());
        for (ProfileField profileField : list2) {
            String string;
            if (!list.contains(profileField)) continue;
            Object object = null;
            if (profileField == BasicProfileField.PHONE) {
                if (basicUser instanceof User) {
                    object = basicUser.getPreferredPhone();
                }
            } else {
                object = this.profileFieldHandler.getFieldValue(basicUser, profileField);
                if (object instanceof Iterable) {
                    object = CollectionHelper.first((Iterable)((Iterable)object));
                }
            }
            if (object == null || (string = StringHelper.trimToNull((Object)formatterImpl.format(object))) == null) continue;
            arrayList.add(string);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        String string = userFormatConfiguration.getSeparator().apply(arrayList);
        return StringUtils.left((String)string, (int)255);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<RawUserPrincipalData> getRawPrincipalsData(BasicUser basicUser, Channel channel) {
        Object object;
        Set set;
        Object object2;
        List<Channel> list;
        TreeMap<PrincipalType, Object> treeMap = new TreeMap<PrincipalType, Object>();
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor(basicUser);
        if (channel != null) {
            if (!this.userChannelService.isChannelAccessible(basicUser, channel)) return Collections.emptyList();
            list = Collections.singletonList(channel);
        } else {
            list = this.userChannelService.getAccessibleChannels(basicUser);
        }
        for (Channel channel2 : list) {
            object2 = configurationAccessor.getChannelConfiguration(channel2);
            set = object2.getPrincipalTypes();
            for (PrincipalType principalType : set) {
                Object object3;
                object = (Pair)treeMap.get(principalType);
                if (object == null) {
                    object3 = this.profileFieldHandler.getPrincipal(basicUser, principalType);
                    String string = object3 == null ? null : object3.getPrincipal();
                    object = Pair.create((Object)string, (Object)(string == null ? null : new LinkedHashSet()));
                    treeMap.put(principalType, object);
                } else if (object.getFirst() == null) continue;
                object3 = (Set)object.getSecond();
                if (object3 == null) {
                    object3 = new HashSet();
                    object.setSecond(object3);
                }
                object3.add(channel2);
            }
        }
        List list2 = this.principalTypeService.listAll();
        ArrayList<RawUserPrincipalData> arrayList = new ArrayList<RawUserPrincipalData>();
        object2 = list2.iterator();
        while (object2.hasNext()) {
            set = (PrincipalType)object2.next();
            Pair pair = (Pair)treeMap.get(set);
            String string = pair == null ? null : (String)pair.getFirst();
            if (string == null || (object = CollectionHelper.sort((Collection)((Collection)pair.getSecond()), (Comparator)ChannelsComparator.getInstance())).isEmpty()) continue;
            arrayList.add(this.toUserPrincipalData((List<Channel>)object, (PrincipalType)set, string));
        }
        object2 = this.userIdentityProviderService.list(basicUser).stream().filter(userIdentityProvider -> userIdentityProvider.getStatus() == UserIdentityProviderStatus.LINKED).map(userIdentityProvider -> this.toUserPrincipalData(configurationAccessor, list, (UserIdentityProvider)userIdentityProvider)).collect(Collectors.toList());
        return ListUtils.union((List)object2, arrayList);
    }

    private String newValidationKey() {
        return SecureRandomHelper.randomAlphanumeric((int)32);
    }

    private Map<PasswordType, String> processActivation(BasicUser basicUser) {
        if (basicUser.getRegistrationConfirmationDate() == null) {
            basicUser.setRegistrationConfirmationDate(new Date());
        }
        boolean bl = false;
        if (basicUser instanceof User) {
            User user = (User)basicUser;
            this.userService.onRegistrationValidation(user);
            bl = StringHelper.isNotBlank((Object)user.getEmail()) && (user.getRegistrationType() == UserRegistration.PUBLIC || user.getRegistrationType() == UserRegistration.MEMBER);
        } else {
            Operator operator = (Operator)basicUser;
            this.operatorService.onRegistrationValidation(operator);
        }
        this.reindex(basicUser);
        if (basicUser.isActive()) {
            return this.finishActivation(basicUser);
        }
        if (bl) {
            this.mailHandler.send(null, basicUser, MailContext.PENDING_ACTIVATION, (MailContentProducer)this.mailContentBuilder().subject(ContentManagementKeys.Emails.PENDING_ACTIVATION_SUBJECT, new Object[0]).body(ContentManagementKeys.Emails.PENDING_ACTIVATION_BODY, new Object[0]), new FileInfo[0]);
        }
        return Collections.emptyMap();
    }

    private EmailValidationResult requiresEmailValidation(UserRegistration userRegistration, ConfigurationAccessor configurationAccessor, SimpleBasicUserRegistrationDTO simpleBasicUserRegistrationDTO) {
        Boolean bl = null;
        if (this.isSystem()) {
            bl = false;
        } else {
            switch (userRegistration) {
                case ADMIN: {
                    bl = configurationAccessor.getEmailValidation().contains(EmailValidation.REGISTRATION_BY_ADMIN);
                    break;
                }
                case BROKER: {
                    bl = configurationAccessor.getEmailValidation().contains(EmailValidation.REGISTRATION_BY_BROKER);
                    break;
                }
                case IMPORT: {
                    bl = configurationAccessor.getEmailValidation().contains(EmailValidation.IMPORTED_USERS);
                    break;
                }
                case PUBLIC: {
                    String string;
                    CommonProfile commonProfile;
                    PublicRegistrationDTO publicRegistrationDTO;
                    if (simpleBasicUserRegistrationDTO instanceof PublicRegistrationDTO) {
                        publicRegistrationDTO = (PublicRegistrationDTO)simpleBasicUserRegistrationDTO;
                        commonProfile = this.internalIdentityProviderService.getRegistrationProfile(publicRegistrationDTO);
                        if (commonProfile != null && publicRegistrationDTO.getEmail() != null && publicRegistrationDTO.getEmail().equalsIgnoreCase(commonProfile.getEmail())) {
                            return EmailValidationResult.ALREADY_VERIFIED;
                        }
                        string = this.inviteService.inviteToken(publicRegistrationDTO.getInviteToken());
                        if (string != null && string.getEmail() != null && string.getEmail().equalsIgnoreCase(publicRegistrationDTO.getEmail())) {
                            return EmailValidationResult.ALREADY_VERIFIED;
                        }
                        if (publicRegistrationDTO.getExternalPaymentToken() != null && this.externalPaymentService.findByToken(publicRegistrationDTO.getExternalPaymentToken()).getToPrincipalType().getInternalName().equals(ExistingBuiltInPrincipalType.EMAIL.getInternalName())) {
                            return EmailValidationResult.ALREADY_VERIFIED;
                        }
                    }
                    bl = configurationAccessor.getEmailValidation().contains(EmailValidation.PUBLIC_REGISTRATION);
                }
                case WIZARD: {
                    String string;
                    CommonProfile commonProfile;
                    PublicRegistrationDTO publicRegistrationDTO;
                    if (simpleBasicUserRegistrationDTO instanceof PublicRegistrationDTO) {
                        publicRegistrationDTO = (PublicRegistrationDTO)simpleBasicUserRegistrationDTO;
                        commonProfile = this.customWizardService.getStorage(publicRegistrationDTO);
                        String string2 = string = commonProfile == null ? null : commonProfile.getVerifiedEmail();
                        if (string != null && string.equalsIgnoreCase(publicRegistrationDTO.getEmail())) {
                            return EmailValidationResult.ALREADY_VERIFIED;
                        }
                    }
                    bl = configurationAccessor.getEmailValidation().contains(EmailValidation.PUBLIC_REGISTRATION);
                    break;
                }
                case USER: {
                    bl = configurationAccessor.getEmailValidation().contains(EmailValidation.OPERATOR_REGISTRATION_BY_MEMBER);
                    break;
                }
                case MEMBER: {
                    bl = configurationAccessor.getEmailValidation().contains(EmailValidation.REGISTRATION_BY_MEMBER);
                    break;
                }
                case SMS: 
                case POPULATOR: {
                    bl = false;
                }
            }
        }
        if (bl == null) {
            throw new IllegalArgumentException("Unhandled registration type: " + String.valueOf(userRegistration));
        }
        return bl != false ? EmailValidationResult.REQUIRES_VALIDATION : EmailValidationResult.NO_VALIDATION;
    }

    private List<Channel> resolveStatefulChannels() {
        return this.channelService.listAll().stream().filter(Channel::isStateful).collect(Collectors.toList());
    }

    private void sendActivationEmail(BasicUser basicUser, Map<PasswordType, String> map) {
        if (!basicUser.isSendActivationEmail()) {
            return;
        }
        String string = this.linkGeneratorHandler.login(basicUser);
        String string2 = this.linkGeneratorHandler.mobileRedirect("/login", basicUser);
        List<RawUserPrincipalData> list = this.getRawPrincipalsData(basicUser, null);
        this.mailHandler.send(null, basicUser, MailContext.REGISTRATION_ACTIVATION, () -> {
            Object object;
            Object object22;
            String string3;
            Object object3;
            if (list.size() == 1) {
                object3 = (RawUserPrincipalData)CollectionHelper.first((Iterable)list);
                string3 = this.message(MessageFormat.HTML, ContentManagementKeys.Emails.ACTIVATED_BODY_SINGLE_PRINCIPAL, string, ((RawUserPrincipalData)object3).getPrincipalType(), ((RawUserPrincipalData)object3).getPrincipal());
            } else {
                object3 = new StringBuilder();
                for (Object object22 : list) {
                    ((StringBuilder)object3).append(this.message(MessageFormat.HTML, ContentManagementKeys.Emails.ACTIVATED_BODY_PRINCIPAL_TEMPLATE, ((RawUserPrincipalData)object22).getPrincipalType(), ((RawUserPrincipalData)object22).getPrincipal(), ((RawUserPrincipalData)object22).getChannels()));
                }
                string3 = this.message(MessageFormat.HTML, ContentManagementKeys.Emails.ACTIVATED_BODY_MULTIPLE_PRINCIPALS, string, ((StringBuilder)object3).toString());
            }
            if (map.isEmpty()) {
                object3 = "";
            } else if (map.size() == 1) {
                object = (Map.Entry)CollectionHelper.first(map.entrySet());
                object3 = this.message(MessageFormat.HTML, ContentManagementKeys.Emails.ACTIVATED_BODY_GENERATED_PASSWORD_SINGLE, object.getKey(), object.getValue());
            } else {
                object = new StringBuilder();
                for (PasswordType passwordType : CollectionHelper.sort(map.keySet())) {
                    ((StringBuilder)object).append(this.message(MessageFormat.HTML, ContentManagementKeys.Emails.ACTIVATED_BODY_GENERATED_PASSWORD_TEMPLATE, this.getTranslatedName((NamedEntity)passwordType), map.get(passwordType)));
                }
                object3 = this.message(MessageFormat.HTML, ContentManagementKeys.Emails.ACTIVATED_BODY_GENERATED_PASSWORD_MULTIPLE, ((StringBuilder)object).toString());
            }
            object = basicUser.isOperator() ? ContentManagementKeys.Emails.ACTIVATED_OPERATOR_BODY_TEMPLATE : ContentManagementKeys.Emails.ACTIVATED_BODY_TEMPLATE;
            object22 = this.message(MessageFormat.HTML, (MessageKey)object, string3, object3, string2);
            return new MailContent(this.message(ContentManagementKeys.Emails.ACTIVATED_SUBJECT, new Object[0]), (String)object22);
        }, new FileInfo[0]);
    }

    private void sendEmailChangeValidation(BasicUser basicUser) {
        String string = this.linkGeneratorHandler.emailChange(basicUser.getValidationKey(), basicUser);
        this.mailHandler.send(null, basicUser, MailContext.NEW_EMAIL_VALIDATION, (MailContentProducer)this.mailContentBuilder().subject(ContentManagementKeys.Emails.VALIDATION_SUBJECT, new Object[0]).body(ContentManagementKeys.Emails.EMAIL_MODIFICATION_BODY, new Object[]{basicUser.getNewEmail(), string}), new FileInfo[0]);
        if (StringHelper.isNotBlank((Object)basicUser.getEmail())) {
            this.mailHandler.send(null, basicUser, MailContext.EMAIL_CHANGE, (MailContentProducer)this.mailContentBuilder().subject(ContentManagementKeys.Emails.CHANGE_OF_EMAIL_SUBJECT, new Object[0]).body(ContentManagementKeys.Emails.CHANGE_OF_EMAIL_BODY, new Object[]{basicUser.getNewEmail()}), new FileInfo[0]);
        }
    }

    private void setRegistrationValidation(BasicUser basicUser) {
        if (StringHelper.isBlank((Object)basicUser.getEmail())) {
            String string = this.message(GeneralKeys.Errors.REQUIRED, UsersKeys.Users.EMAIL);
            throw new ValidationException(UserDTO.EMAIL.getName(), string);
        }
        this.setValidationKey(basicUser, ValidationKeyType.REGISTRATION);
        this.doSendRegistrationValidation(basicUser);
    }

    private void setValidationKey(BasicUser basicUser, ValidationKeyType validationKeyType) throws FrameworkException {
        basicUser.setValidationKey(this.newValidationKey());
        basicUser.setValidationKeyType(validationKeyType);
        basicUser.setValidationKeyDate(new Date());
    }

    private Map<PasswordType, PasswordRegistrationDTO> toMap(Set<PasswordType> set, List<PasswordRegistrationDTO> list) {
        Map<PasswordType, PasswordRegistrationDTO> map = Collections.emptyMap();
        if (CollectionHelper.isNotEmpty(list)) {
            map = new HashMap<PasswordType, PasswordRegistrationDTO>();
            for (PasswordRegistrationDTO passwordRegistrationDTO : list) {
                PasswordType passwordType = (PasswordType)this.conversionHandler.convert(PasswordType.class, (Object)passwordRegistrationDTO.getType());
                if (!set.contains(passwordType)) continue;
                map.put(passwordType, passwordRegistrationDTO);
            }
        }
        return map;
    }

    private RawUserPrincipalData toUserPrincipalData(ConfigurationAccessor configurationAccessor, List<Channel> list, UserIdentityProvider userIdentityProvider) {
        RawUserPrincipalData rawUserPrincipalData = new RawUserPrincipalData();
        IdentityProvider identityProvider = userIdentityProvider.getIdentityProvider();
        rawUserPrincipalData.setChannels(list.stream().filter(channel -> configurationAccessor.getChannelConfiguration(channel).getIdentityProviders().contains(identityProvider)).collect(Collectors.toList()));
        rawUserPrincipalData.setPrincipalType(AccessKeys.IdentityProviders.IDENTITY_PROVIDER);
        rawUserPrincipalData.setPrincipal(identityProvider);
        return rawUserPrincipalData;
    }

    private RawUserPrincipalData toUserPrincipalData(List<Channel> list, PrincipalType principalType, String string) {
        RawUserPrincipalData rawUserPrincipalData = new RawUserPrincipalData();
        rawUserPrincipalData.setPrincipalType(principalType);
        rawUserPrincipalData.setPrincipal(string);
        rawUserPrincipalData.setChannels(list);
        return rawUserPrincipalData;
    }

    private DBQuery<?> uniqueUsernameQuery(Network network, BasicUserDTO basicUserDTO) {
        return this.uniqueUsernameQuery(network, basicUserDTO.getUsername(), basicUserDTO.getId());
    }

    private DBQuery<?> uniqueUsernameQuery(Network network, String string, Long l) {
        if (StringHelper.isBlank((Object)string)) {
            return null;
        }
        return (DBQuery)this.rawEntityManagerHandler.from(new EntityPath[]{$}).where(new Predicate[]{network == null ? $.network().isNull() : $.network().eq((Object)network), BasicUserServiceImpl.$.status.notIn((Object[])new UserStatus[]{UserStatus.REMOVED, UserStatus.PURGED}), BasicUserServiceImpl.$.username.equalsIgnoreCase(string), l != null ? BasicUserServiceImpl.$.id.ne((Object)l) : BasicUserServiceImpl.$.id.isNotNull()});
    }

    private Long validateEmailChange(BasicUser basicUser) {
        basicUser.setEmail(basicUser.getNewEmail());
        basicUser.setNewEmail(null);
        basicUser.setEmailVerified(true);
        this.reindex(basicUser);
        this.clearValidationKey(basicUser);
        if (basicUser instanceof User) {
            User user = (User)basicUser;
            this.externalPaymentService.processExternalPayments(user);
            this.userSearchHandler.updateUserFields(user);
        }
        return basicUser.getId();
    }

    private UserValidationResult validateRegistration(BasicUser basicUser) {
        return (UserValidationResult)this.invokerHandler.runAs(SessionDataFactory.script((boolean)true), () -> this.doValidateRegistration(basicUser));
    }

    private static enum EmailValidationResult {
        REQUIRES_VALIDATION,
        ALREADY_VERIFIED,
        NO_VALIDATION;

    }

    public static class RawUserPrincipalData {
        private List<Channel> channels;
        private Object principal;
        private Object principalType;

        public List<Channel> getChannels() {
            return this.channels;
        }

        public Object getPrincipal() {
            return this.principal;
        }

        public Object getPrincipalType() {
            return this.principalType;
        }

        public void setChannels(List<Channel> list) {
            this.channels = list;
        }

        public void setPrincipal(Object object) {
            this.principal = object;
        }

        public void setPrincipalType(Object object) {
            this.principalType = object;
        }
    }
}

