/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import com.querydsl.core.types.dsl.NumberPath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.cyclos.entities.banking.VoucherConfiguration;
import org.cyclos.entities.users.BrokerProduct;
import org.cyclos.entities.users.IMemberOrBrokerProduct;
import org.cyclos.entities.users.ProductBrokerVoucher;
import org.cyclos.entities.users.QBrokerProduct;
import org.cyclos.impl.users.CollectionPermissionHandlerImpl;
import org.cyclos.impl.users.IntegerPermissionHandlerImpl;
import org.cyclos.impl.users.MemberOrBrokerProductConversionHandlerImpl;
import org.cyclos.impl.users.OperationPermissionHandlerImpl;
import org.cyclos.impl.users.PermissionHandler;
import org.cyclos.impl.users.UserManagementProductConversionHandlerImpl;
import org.cyclos.model.Property;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.Role;
import org.cyclos.model.banking.voucherconfigurations.VoucherConfigurationVO;
import org.cyclos.model.banking.voucherconfigurations.VoucherGenerationStatus;
import org.cyclos.model.users.UsersKeys;
import org.cyclos.model.users.products.ActiveUserProductsData;
import org.cyclos.model.users.products.AuthorizedPaymentsOperation;
import org.cyclos.model.users.products.BrokerMessagesOperation;
import org.cyclos.model.users.products.BrokerProductDTO;
import org.cyclos.model.users.products.IMemberOrBrokerProductDTO;
import org.cyclos.model.users.products.ProductBrokerVoucherDTO;
import org.cyclos.model.users.products.ProductNature;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.MessageKey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BrokerProductConversionHandlerImpl
extends UserManagementProductConversionHandlerImpl<BrokerProduct, BrokerProductDTO, ActiveUserProductsData> {
    @Autowired
    private MemberOrBrokerProductConversionHandlerImpl memberOrBrokerProductConversionHandler;

    public BrokerProductConversionHandlerImpl() {
        super(BrokerProduct.class, BrokerProductDTO.class, ActiveUserProductsData.class);
    }

    public ProductNature getProductNature() {
        return ProductNature.BROKER;
    }

    public Role getRole() {
        return Role.BROKER;
    }

    @Override
    public void registerHandlers() {
        super.registerHandlers();
        this.memberOrBrokerProductConversionHandler.registerHandlers(this);
        this.register(new OperationPermissionHandlerImpl(BrokerProductDTO.BROKER_AUTHORIZED_PAYMENTS, ActiveUserProductsData.BROKER_AUTHORIZED_PAYMENTS, UsersKeys.Products.BROKER_AUTHORIZED_PAYMENTS).master(AuthorizedPaymentsOperation.VIEW, Permission.BROKER_AUTHORIZED_PAYMENTS_VIEW).map(AuthorizedPaymentsOperation.AUTHORIZE, Permission.BROKER_AUTHORIZED_PAYMENTS_AUTHORIZE));
        this.register(new IntegerPermissionHandlerImpl(Permission.MY_CUSTOM_IMAGES_ENABLE, (NumberPath<Integer>)QBrokerProduct.brokerProduct.maxCustomImages, BrokerProductDTO.MAX_CUSTOM_IMAGES, UsersKeys.Products.MAX_CUSTOM_IMAGES));
        this.register(new CollectionPermissionHandlerImpl(Permission.USERS_REGISTER, BrokerProductDTO.USER_REGISTRATION_GROUPS, UsersKeys.Products.USER_REGISTRATION));
        this.register(new OperationPermissionHandlerImpl(BrokerProductDTO.BROKER_MESSAGES, ActiveUserProductsData.BROKER_MESSAGES, UsersKeys.Products.BROKER_MESSAGES).master(BrokerMessagesOperation.VIEW, Permission.MY_MESSAGES_VIEW).map(BrokerMessagesOperation.SEND_TO_BROKERED, Permission.MY_MESSAGES_SEND_TO_BROKERED_USERS));
        this.register(new PermissionHandler<BrokerProductDTO, ActiveUserProductsData>(){

            public Property<?, ? super BrokerProductDTO> getDTOProperty() {
                return BrokerProductDTO.USER_VOUCHERS;
            }

            public MessageKey getKey() {
                return UsersKeys.Products.VOUCHERS;
            }

            public List<Permission> getPermissions() {
                return Arrays.asList(Permission.USER_VOUCHERS_VIEW_VOUCHERS, Permission.USER_VOUCHERS_BUY, Permission.USER_VOUCHERS_SEND, Permission.USER_VOUCHERS_VIEW_TRANSACTIONS, Permission.USER_VOUCHERS_REDEEM, Permission.USER_VOUCHERS_TOP_UP);
            }

            public void writePermissions(BrokerProductDTO brokerProductDTO, Collection<Permission> collection) {
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                boolean bl4 = false;
                boolean bl5 = false;
                boolean bl6 = false;
                List list = brokerProductDTO.getUserVouchers();
                if (list != null) {
                    for (ProductBrokerVoucherDTO productBrokerVoucherDTO : list) {
                        VoucherConfiguration voucherConfiguration = (VoucherConfiguration)BrokerProductConversionHandlerImpl.this.conversionHandler.convert(VoucherConfiguration.class, (Object)productBrokerVoucherDTO.getConfiguration());
                        if (productBrokerVoucherDTO.isViewVouchers()) {
                            bl4 = true;
                        }
                        if (productBrokerVoucherDTO.isViewTransactions()) {
                            bl = true;
                            if (productBrokerVoucherDTO.isRedeem()) {
                                bl2 = true;
                            }
                        }
                        if (voucherConfiguration.getGenerationStatus() == VoucherGenerationStatus.INACTIVE) {
                            if (!productBrokerVoucherDTO.isViewTransactions() || !productBrokerVoucherDTO.isTopUp()) continue;
                            bl3 = true;
                            continue;
                        }
                        if (!productBrokerVoucherDTO.isViewVouchers()) continue;
                        if (productBrokerVoucherDTO.isBuy()) {
                            bl5 = true;
                        }
                        if (!productBrokerVoucherDTO.isSend()) continue;
                        bl6 = true;
                    }
                }
                CollectionHelper.addOrRemove(collection, (Object)Permission.USER_VOUCHERS_VIEW_TRANSACTIONS, (boolean)bl);
                CollectionHelper.addOrRemove(collection, (Object)Permission.USER_VOUCHERS_REDEEM, (boolean)bl2);
                CollectionHelper.addOrRemove(collection, (Object)Permission.USER_VOUCHERS_VIEW_VOUCHERS, (boolean)bl4);
                CollectionHelper.addOrRemove(collection, (Object)Permission.USER_VOUCHERS_BUY, (boolean)bl5);
                CollectionHelper.addOrRemove(collection, (Object)Permission.USER_VOUCHERS_SEND, (boolean)bl6);
                CollectionHelper.addOrRemove(collection, (Object)Permission.USER_VOUCHERS_TOP_UP, (boolean)bl3);
            }
        });
    }

    @Override
    public BrokerProductDTO toDTO(BrokerProduct brokerProduct) {
        BrokerProductDTO brokerProductDTO = (BrokerProductDTO)super.toDTO(brokerProduct);
        this.ensureVouchers(brokerProduct, brokerProductDTO);
        this.memberOrBrokerProductConversionHandler.fillToDTO((IMemberOrBrokerProduct)brokerProduct, (IMemberOrBrokerProductDTO)brokerProductDTO);
        return brokerProductDTO;
    }

    @Override
    protected void enssureDTOConsistency(BrokerProductDTO brokerProductDTO) {
        super.enssureDTOConsistency(brokerProductDTO);
        CollectionHelper.orEmpty((List)brokerProductDTO.getUserVouchers()).forEach(productBrokerVoucherDTO -> {
            if (!productBrokerVoucherDTO.isViewTransactions()) {
                productBrokerVoucherDTO.setRedeem(false);
            }
            if (!productBrokerVoucherDTO.isViewVouchers()) {
                productBrokerVoucherDTO.setBuy(false);
            }
        });
    }

    private void ensureVouchers(BrokerProduct brokerProduct, BrokerProductDTO brokerProductDTO) {
        brokerProductDTO.setUserVouchers(new ArrayList());
        List list = this.voucherConfigurationService.listAll();
        for (VoucherConfiguration voucherConfiguration : list) {
            ProductBrokerVoucherDTO productBrokerVoucherDTO = this.getProductVoucherDTO(voucherConfiguration, brokerProduct);
            if (productBrokerVoucherDTO == null) {
                productBrokerVoucherDTO = new ProductBrokerVoucherDTO();
                productBrokerVoucherDTO.setConfiguration((VoucherConfigurationVO)this.conversionHandler.convert(VoucherConfigurationVO.class, (Object)voucherConfiguration));
            }
            brokerProductDTO.getUserVouchers().add(productBrokerVoucherDTO);
        }
    }

    private ProductBrokerVoucherDTO getProductVoucherDTO(VoucherConfiguration voucherConfiguration, BrokerProduct brokerProduct) {
        for (ProductBrokerVoucher productBrokerVoucher : brokerProduct.getUserVouchers()) {
            if (!productBrokerVoucher.getConfiguration().equals((Object)voucherConfiguration)) continue;
            return (ProductBrokerVoucherDTO)this.conversionHandler.convert(ProductBrokerVoucherDTO.class, (Object)productBrokerVoucher);
        }
        return null;
    }
}

