/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.Brokering;
import org.cyclos.entities.users.BrokeringLog;
import org.cyclos.entities.users.QBrokering;
import org.cyclos.entities.users.QBrokeringLog;
import org.cyclos.entities.users.QUser;
import org.cyclos.entities.users.User;
import org.cyclos.impl.BaseServiceImpl;
import org.cyclos.impl.search.UserSearchHandler;
import org.cyclos.impl.system.EntityLogServiceLocal;
import org.cyclos.impl.users.BrokeringServiceLocal;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IEntity;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.QueryParameters;
import org.cyclos.model.access.Role;
import org.cyclos.model.system.entitylogs.EntityActionLog;
import org.cyclos.model.users.UsersKeys;
import org.cyclos.model.users.brokering.AddBrokerData;
import org.cyclos.model.users.brokering.BrokeringAction;
import org.cyclos.model.users.brokering.BrokeringData;
import org.cyclos.model.users.brokering.BrokeringLogVO;
import org.cyclos.model.users.brokering.BrokeringVO;
import org.cyclos.model.users.brokering.BrokeringWithUserVO;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserQuery;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.server.utils.DateHelper;
import org.cyclos.utils.CollectionHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BrokeringServiceImpl
extends BaseServiceImpl
implements BrokeringServiceLocal {
    private static final QBrokering $ = QBrokering.brokering;
    private static String USER_BROKERS_PROPERTY_NAME = "brokers";
    @Autowired
    private UserSearchHandler userSearchHandler;
    @Autowired
    private EntityLogServiceLocal entityLogService;

    public Long addBroker(User user, User user2, boolean bl, boolean bl2) {
        Brokering brokering;
        if (user.isAdmin() || user.equals((Object)user2) || !user2.isActive() || !user2.isBroker()) {
            throw new IllegalActionException();
        }
        HashSet<User> hashSet = new HashSet<User>(user.getBrokers());
        try {
            brokering = this.getActiveBrokering(user, user2);
        }
        catch (EntityNotFoundException entityNotFoundException) {
            brokering = new Brokering();
            brokering.setUser(user);
            brokering.setBroker(user2);
            brokering.setBeginDate(DateHelper.now());
            this.persist((IEntity)brokering);
            this.createLog(brokering, BrokeringAction.ADD_BROKER);
            if (bl2) {
                this.notificationHandler.user((BasicUser)user).personal().brokerAssigned(user2, user2);
            }
            this.notificationHandler.user((BasicUser)user2).brokering().memberAssigned(user, user);
        }
        List<Brokering> list = this.listActiveBrokerings(user);
        if (bl || list.size() == 1) {
            this.assignMainBrokering(brokering, list);
        }
        this.updateUser(user, list);
        this.createEntityLog(user, hashSet, list.stream().map(Brokering::getBroker).collect(Collectors.toSet()));
        return brokering.getId();
    }

    public Long addBroker(UserLocatorVO userLocatorVO, UserLocatorVO userLocatorVO2, boolean bl) throws FrameworkException, IllegalActionException {
        User user = this.userLocatorHandler.locate(userLocatorVO).getUser();
        User user2 = this.userLocatorHandler.locate(userLocatorVO2).getUser();
        return this.addBroker(user, user2, bl, true);
    }

    public Brokering getActiveBrokering(User user, User user2) throws FrameworkException {
        return (Brokering)((DBQuery)this.from(new EntityPath[]{$}).where(new Predicate[]{$.user().eq((Object)user), $.broker().eq((Object)user2), BrokeringServiceImpl.$.endDate.isNull()})).requiredUniqueResult((Expression)$);
    }

    public AddBrokerData getAddBrokerData(UserLocatorVO userLocatorVO) throws FrameworkException {
        User user = this.userLocatorHandler.locate(userLocatorVO).getUser();
        List list = this.conversionHandler.convertList(UserVO.class, (Iterable)user.getBrokers());
        AddBrokerData addBrokerData = new AddBrokerData();
        addBrokerData.setUser((UserVO)this.conversionHandler.convert(UserVO.class, (Object)user));
        addBrokerData.setBrokers(CollectionHelper.sort((Collection)list, Comparator.comparing(BasicUserVO::getDisplay)));
        addBrokerData.setPossibleBrokerGroups(this.groupsHandler.accessibles().brokers().sorted());
        return addBrokerData;
    }

    public BrokeringWithUserVO getByUserAndBroker(@NotNull UserLocatorVO userLocatorVO, @NotNull UserLocatorVO userLocatorVO2) throws FrameworkException {
        User user = this.userLocatorHandler.locate(userLocatorVO).getUser();
        User user2 = this.userLocatorHandler.locate(userLocatorVO2).getUser();
        Brokering brokering = this.getActiveBrokering(user, user2);
        return (BrokeringWithUserVO)this.conversionHandler.convert(BrokeringWithUserVO.class, (Object)brokering);
    }

    public BrokeringData getData(UserLocatorVO userLocatorVO) throws FrameworkException {
        User user = this.userLocatorHandler.locate(userLocatorVO).getUser();
        BrokeringData brokeringData = new BrokeringData();
        brokeringData.setUser((UserVO)this.conversionHandler.convert(UserVO.class, (Object)user));
        List<Brokering> list = this.listActiveBrokerings(user);
        brokeringData.setBrokerings(this.conversionHandler.convertList(BrokeringVO.class, list));
        brokeringData.setLogs(this.listBrokeringLogs(user));
        AddBrokerData addBrokerData = this.getAddBrokerData(userLocatorVO);
        UserQuery userQuery = new UserQuery();
        HashSet<UserVO> hashSet = new HashSet<UserVO>();
        hashSet.add(brokeringData.getUser());
        hashSet.addAll(addBrokerData.getBrokers());
        userQuery.setUsersToExclude(hashSet);
        userQuery.setRoles(Collections.singleton(Role.BROKER));
        userQuery.setGroups(new HashSet(addBrokerData.getPossibleBrokerGroups()));
        userQuery.setPageSize(Integer.valueOf(1));
        brokeringData.setPotentialBrokersAvailable(this.userSearchHandler.search((QueryParameters)userQuery).getPageItems().size() > 0);
        return brokeringData;
    }

    public List<Long> listBrokeredIds(User user) {
        if (user == null || !user.isBroker()) {
            return Collections.emptyList();
        }
        QUser qUser = new QUser("b");
        QUser qUser2 = new QUser("u");
        return ((DBQuery)((DBQuery)((DBQuery)this.from(new EntityPath[]{$}).innerJoin((EntityPath)$.broker(), (Path)qUser)).innerJoin((EntityPath)$.user(), (Path)qUser2)).where(new Predicate[]{qUser.eq((Object)user), BrokeringServiceImpl.$.endDate.isNull()})).list((Expression)qUser2.id);
    }

    public void removeAllBrokered(User user) throws FrameworkException {
        user.getBrokeredUsers().forEach(user2 -> this.removeBroker((User)user2, user));
    }

    public void removeBroker(User user, User user2) {
        Brokering brokering;
        HashSet<User> hashSet = new HashSet<User>(user.getBrokers());
        try {
            brokering = this.getActiveBrokering(user, user2);
        }
        catch (EntityNotFoundException entityNotFoundException) {
            throw new IllegalActionException();
        }
        if (user2.equals((Object)this.getLoggedUser())) {
            throw new IllegalActionException();
        }
        brokering.setEndDate(DateHelper.now());
        brokering.setMain(false);
        this.createLog(brokering, BrokeringAction.REMOVE_BROKER);
        List<Brokering> list = this.listActiveBrokerings(user);
        Brokering brokering2 = (Brokering)CollectionHelper.first(list);
        if (brokering2 != null) {
            this.assignMainBrokering(brokering2, list);
        }
        this.updateUser(user, list);
        this.createEntityLog(user, hashSet, list.stream().map(Brokering::getBroker).collect(Collectors.toSet()));
        this.notificationHandler.user((BasicUser)user).personal().brokerUnassigned(user2, user2);
        this.notificationHandler.user((BasicUser)user2).brokering().memberUnassigned(user, user);
    }

    public void removeBroker(UserLocatorVO userLocatorVO, UserLocatorVO userLocatorVO2) throws IllegalActionException {
        User user = this.userLocatorHandler.locate(userLocatorVO).getUser();
        User user2 = this.userLocatorHandler.locate(userLocatorVO2).getUser();
        this.removeBroker(user, user2);
    }

    public void setMainBroker(UserLocatorVO userLocatorVO, UserLocatorVO userLocatorVO2) throws FrameworkException, IllegalActionException {
        Brokering brokering;
        User user = this.userLocatorHandler.locate(userLocatorVO).getUser();
        User user2 = this.userLocatorHandler.locate(userLocatorVO2).getUser();
        try {
            brokering = this.getActiveBrokering(user, user2);
        }
        catch (EntityNotFoundException entityNotFoundException) {
            throw new IllegalActionException();
        }
        this.assignMainBrokering(brokering, this.listActiveBrokerings(user));
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register($.broker().network());
    }

    private void assignMainBrokering(Brokering brokering, List<Brokering> list) {
        if (brokering.isMain()) {
            return;
        }
        for (Brokering brokering2 : list) {
            if (!brokering2.isMain()) continue;
            brokering2.setMain(false);
            this.persist((IEntity)brokering2);
        }
        brokering.setMain(true);
        this.createLog(brokering, BrokeringAction.SET_MAIN_BROKER);
    }

    private void createEntityLog(User user, Collection<User> collection, Collection<User> collection2) {
        this.entityLogService.log((SimpleEntity)user, this.message(UsersKeys.Users.BROKERS, new Object[0]), USER_BROKERS_PROPERTY_NAME, this.getFormatter().format(collection), this.getFormatter().format(collection2), EntityActionLog.BROKER_ASSIGNMENT);
    }

    private void createLog(Brokering brokering, BrokeringAction brokeringAction) {
        BrokeringLog brokeringLog = new BrokeringLog();
        brokeringLog.setAction(brokeringAction);
        brokeringLog.setUser(brokering.getUser());
        brokeringLog.setBroker(brokering.getBroker());
        brokeringLog.setDate(DateHelper.now());
        brokeringLog.setBy(this.getLoggedUser());
        this.persist((IEntity)brokeringLog);
    }

    private List<Brokering> listActiveBrokerings(User user) {
        return ((DBQuery)((DBQuery)this.from(new EntityPath[]{$}).where(new Predicate[]{$.user().eq((Object)user), BrokeringServiceImpl.$.endDate.isNull()})).orderBy(new OrderSpecifier[]{BrokeringServiceImpl.$.main.desc(), BrokeringServiceImpl.$.broker().name.asc()})).list((Expression)$);
    }

    private List<BrokeringLogVO> listBrokeringLogs(User user) {
        QBrokeringLog qBrokeringLog = QBrokeringLog.brokeringLog;
        return ((DBQuery)((DBQuery)this.from(new EntityPath[]{qBrokeringLog}).where((Predicate)qBrokeringLog.user().eq((Object)user))).orderBy(qBrokeringLog.date.desc())).list(BrokeringLogVO.class, (Expression)qBrokeringLog);
    }

    private void updateUser(User user, Collection<Brokering> collection) {
        user.setBrokerIds(CollectionHelper.isEmpty(collection) ? null : collection.stream().map(brokering -> brokering.getBroker().getId()).collect(Collectors.toSet()));
        this.userSearchHandler.onBrokerChange(user);
    }
}

