/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.access.Channel;
import org.cyclos.entities.access.QSession;
import org.cyclos.entities.access.Session;
import org.cyclos.entities.system.CustomSessionConfiguration;
import org.cyclos.entities.users.AdminGroup;
import org.cyclos.entities.users.BasicGroup;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.Group;
import org.cyclos.entities.users.ProductOwner;
import org.cyclos.entities.users.QGroup;
import org.cyclos.entities.users.QUser;
import org.cyclos.entities.users.User;
import org.cyclos.impl.BaseServiceImpl;
import org.cyclos.impl.access.ChannelServiceLocal;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.access.SessionHandler;
import org.cyclos.impl.sql.CountConnectedUsersParams;
import org.cyclos.impl.sql.NativeQueryHandler;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.system.CustomScriptServiceLocal;
import org.cyclos.impl.users.ConnectedUserServiceLocal;
import org.cyclos.impl.utils.PushNotificationEventContext;
import org.cyclos.impl.utils.PushNotificationHandler;
import org.cyclos.impl.utils.QueryHelper;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.QueryParameters;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.Role;
import org.cyclos.model.access.channels.ChannelVO;
import org.cyclos.model.system.scripts.ScriptFunction;
import org.cyclos.model.system.scripts.SessionHandlingScriptFunction;
import org.cyclos.model.users.groups.BasicGroupNature;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.ConnectedUserQuery;
import org.cyclos.model.users.users.ConnectedUserSearchData;
import org.cyclos.model.users.users.ConnectedUserVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.Page;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConnectedUserServiceImpl
extends BaseServiceImpl
implements ConnectedUserServiceLocal {
    private static final QSession s = QSession.session;
    private static final QUser u = QUser.user;
    private static final QGroup g = QGroup.group;
    @Autowired
    private RawEntityManagerHandler rawEntityManagerHandler;
    @Autowired
    private ChannelServiceLocal channelService;
    @Autowired
    private SessionHandler sessionHandler;
    @Autowired
    private CustomScriptServiceLocal customScriptService;
    @Autowired
    private PushNotificationHandler pushNotificationHandler;
    @Autowired
    private NativeQueryHandler nativeQueryHandler;

    public int countConnectedUsers(Role role) {
        return this.countConnectedUsers(Set.of(role), true).get(role);
    }

    public Map<Role, Integer> countConnectedUsers(Set<Role> set, boolean bl) {
        CountConnectedUsersParams countConnectedUsersParams = new CountConnectedUsersParams();
        countConnectedUsersParams.setRoles(set);
        if (bl) {
            SessionData sessionData = this.getSessionData();
            if (sessionData.getNetwork() == null) {
                countConnectedUsersParams.setGlobal(true);
            } else {
                countConnectedUsersParams.setNetworkId(sessionData.getNetwork().getId());
                if (sessionData.isAdmin()) {
                    Set set2 = SimpleEntity.uniqueIds((Collection)this.groupsHandler.accessibles().groups().items());
                    countConnectedUsersParams.setGroupIds(set2);
                } else if (sessionData.isBroker()) {
                    countConnectedUsersParams.setBrokerId(sessionData.getLoggedUser().getId());
                } else {
                    throw new IllegalActionException("Not admin or broker");
                }
            }
        }
        return this.nativeQueryHandler.countConnectedUsers(countConnectedUsersParams);
    }

    public int disconnect(UserLocatorVO userLocatorVO) throws FrameworkException {
        BasicUser basicUser = this.userLocatorHandler.locate(userLocatorVO).getBasicUser();
        QSession qSession = QSession.session;
        List list = ((DBQuery)this.from(new EntityPath[]{qSession}).where((Predicate)qSession.basicUser().eq((Object)basicUser))).list((Expression)qSession.sessionToken);
        return this.sessionHandler.remove((Collection)list);
    }

    public int disconnectBySessionTokens(Set<String> set) throws FrameworkException {
        if (CollectionHelper.isEmpty(set)) {
            return 0;
        }
        SessionData sessionData = this.getSessionData();
        Session session = sessionData.getSession();
        if (session != null) {
            set.remove(session.getSessionToken());
        }
        return this.sessionHandler.remove(set);
    }

    public int disconnectUserAndOperators(User user) {
        QSession qSession = QSession.session;
        List list = ((DBQuery)this.from(new EntityPath[]{qSession}).where((Predicate)qSession.user().eq((Object)user))).list((Expression)qSession.sessionToken);
        return this.sessionHandler.remove((Collection)list);
    }

    public ConnectedUserSearchData getSearchData() throws FrameworkException {
        Collection<Role> collection;
        ConnectedUserSearchData connectedUserSearchData = new ConnectedUserSearchData();
        SessionData sessionData = this.getSessionData();
        connectedUserSearchData.setCanManage(sessionData.hasPermission(Permission.MY_OPERATORS_ENABLE) || sessionData.hasPermission(Permission.CONNECTED_USERS_MANAGE));
        if (sessionData.isAdmin()) {
            collection = this.channelService.listAll();
            collection.removeIf(channel -> !channel.isStateful());
            connectedUserSearchData.setChannels(this.conversionHandler.convertList(ChannelVO.class, collection));
        }
        collection = new HashSet();
        if (sessionData.isGlobalAdmin()) {
            collection.add(Role.ADMIN);
        } else {
            if (sessionData.isAdmin()) {
                collection.addAll(this.groupsHandler.accessibles().groups().items().stream().map(Group::getRole).collect(Collectors.toSet()));
            } else if (sessionData.isBroker()) {
                collection.add(Role.MEMBER);
            }
            if (sessionData.hasPermission(Permission.MY_OPERATORS_ENABLE) || sessionData.hasPermission(Permission.USER_OPERATORS_VIEW)) {
                collection.add(Role.OPERATOR);
            }
        }
        connectedUserSearchData.setRoles(collection);
        ConnectedUserQuery connectedUserQuery = (ConnectedUserQuery)QueryHelper.newQuery(ConnectedUserQuery.class);
        connectedUserSearchData.setQuery((QueryParameters)connectedUserQuery);
        return connectedUserSearchData;
    }

    public boolean isOnline(BasicUser basicUser) {
        if (basicUser.equals((Object)this.getLoggedUser())) {
            return true;
        }
        if (!this.hasPermission(Permission.CONNECTED_USERS_VIEW)) {
            return false;
        }
        ConnectedUserQuery connectedUserQuery = new ConnectedUserQuery();
        connectedUserQuery.setCountOnly();
        connectedUserQuery.setUser((BasicUserVO)new UserVO(basicUser.getId()));
        Page<ConnectedUserVO> page = this.search(connectedUserQuery);
        return page.getTotalCount() > 0;
    }

    public void notifySessionsOfPermissionChange(ProductOwner productOwner) {
        QSession qSession = QSession.session;
        DBQuery<?> dBQuery = this.from(new EntityPath[]{qSession});
        if (productOwner instanceof User) {
            User user = (User)productOwner;
            dBQuery.where((Predicate)qSession.user().eq((Object)user));
        } else if (productOwner instanceof BasicGroup) {
            BasicGroup basicGroup = (BasicGroup)productOwner;
            Set set = this.groupsHandler.flatten(Collections.singleton(basicGroup));
            dBQuery.where((Predicate)qSession.user().group().in((Collection)set));
        }
        this.processBatch(dBQuery.iterate((Expression)qSession.sessionToken), (T string) -> this.pushNotificationHandler.publish(PushNotificationEventContext.permissionsChanged((String)string), null));
    }

    public Page<ConnectedUserVO> search(ConnectedUserQuery connectedUserQuery) throws FrameworkException {
        Object object;
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getDefaultAccessor();
        CustomSessionConfiguration customSessionConfiguration = configurationAccessor.getCustomSessionConfiguration();
        if (customSessionConfiguration != null && customSessionConfiguration.isEnabled() && (object = this.customScriptService.newAccessor(customSessionConfiguration.getScript(), customSessionConfiguration.getScriptParameters()).bind("query", (Object)connectedUserQuery).run((ScriptFunction)SessionHandlingScriptFunction.SEARCH)) instanceof Iterable) {
            return this.conversionHandler.convertPage(ConnectedUserVO.class, (Iterable)object);
        }
        object = this.createQuery(connectedUserQuery);
        return object.page(ConnectedUserVO.class, (QueryParameters)connectedUserQuery, (Expression)QSession.session);
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(QSession.session.user().network(), true);
    }

    private DBQuery<?> createQuery(ConnectedUserQuery connectedUserQuery) {
        Set set;
        User user;
        Session session;
        BasicUser basicUser;
        DBQuery dBQuery = (DBQuery)((DBQuery)this.rawEntityManagerHandler.from(new EntityPath[]{s}).innerJoin((EntityPath)s.user(), (Path)u)).innerJoin((EntityPath)u.group(), (Path)g);
        SessionData sessionData = this.getSessionData();
        if (!sessionData.isSystem()) {
            if (sessionData.isMultiNetworkAdminInGlobalMode()) {
                dBQuery.where((Predicate)u.network().in((Collection)((AdminGroup)this.getLoggedUser().getGroup()).getManagedNetworks()));
            } else {
                this.visibility(dBQuery, u).onlySelf();
            }
        }
        if ((basicUser = (BasicUser)this.conversionHandler.convert(BasicUser.class, (Object)connectedUserQuery.getUser())) != null) {
            dBQuery.where((Predicate)s.basicUser().eq((Object)basicUser));
        }
        if (connectedUserQuery.isExcludeCurrentSession() && (session = sessionData.getSession()) != null) {
            dBQuery.where((Predicate)s.ne((Object)session));
        }
        if ((session = (User)this.conversionHandler.convert(User.class, (Object)connectedUserQuery.getOperatorsOf())) != null) {
            dBQuery.where((Predicate)s.user().eq((Object)session));
        }
        if ((user = (User)this.conversionHandler.convert(User.class, (Object)connectedUserQuery.getBroker())) != null) {
            dBQuery.where((Predicate)ConnectedUserServiceImpl.s.user().brokers.contains((Object)user));
        }
        if (CollectionHelper.isNotEmpty((Iterable)(set = connectedUserQuery.getRoles()))) {
            EnumSet<BasicGroupNature> enumSet = EnumSet.noneOf(BasicGroupNature.class);
            boolean bl = false;
            for (Role role : set) {
                switch (role) {
                    case ADMIN: 
                    case GLOBAL_ADMIN: 
                    case NETWORK_ADMIN: {
                        enumSet.add(BasicGroupNature.ADMIN_GROUP);
                        break;
                    }
                    case BROKER: {
                        enumSet.add(BasicGroupNature.BROKER_GROUP);
                        break;
                    }
                    case MEMBER: {
                        enumSet.add(BasicGroupNature.MEMBER_GROUP);
                        break;
                    }
                    case ALIAS_OPERATOR: 
                    case OPERATOR: 
                    case RESTRICTED_OPERATOR: {
                        bl = true;
                    }
                }
            }
            if (!enumSet.isEmpty() && bl) {
                dBQuery.where((Predicate)ConnectedUserServiceImpl.g.nature.in(enumSet).and((Predicate)s.basicUser().eq((Expression)ConnectedUserServiceImpl.u._super)).or((Predicate)s.basicUser().ne((Expression)ConnectedUserServiceImpl.u._super)));
            } else if (bl) {
                dBQuery.where((Predicate)s.basicUser().ne((Expression)ConnectedUserServiceImpl.u._super));
            } else if (!enumSet.isEmpty()) {
                dBQuery.where((Predicate)ConnectedUserServiceImpl.g.nature.in(enumSet).and((Predicate)s.basicUser().eq((Expression)ConnectedUserServiceImpl.u._super)));
            }
        }
        if (QueryHelper.useParameter((Object)connectedUserQuery.getChannels())) {
            dBQuery.where((Predicate)ConnectedUserServiceImpl.s.channel().id.in((Collection)SimpleEntity.uniqueIds((Collection)this.conversionHandler.convertList(Channel.class, (Iterable)connectedUserQuery.getChannels()))));
        }
        dBQuery.orderBy(ConnectedUserServiceImpl.s.creationDate.desc());
        return dBQuery;
    }
}

