/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import java.util.List;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.ContactInfoField;
import org.cyclos.entities.users.ContactInfoFieldPossibleValue;
import org.cyclos.entities.users.ContactInfoFieldPossibleValueCategory;
import org.cyclos.entities.users.QContactInfoField;
import org.cyclos.entities.users.QContactInfoFieldValue;
import org.cyclos.entities.users.QMemberProduct;
import org.cyclos.entities.users.User;
import org.cyclos.impl.system.BaseCustomFieldServiceImpl;
import org.cyclos.impl.users.ContactInfoFieldPossibleValueCategoryServiceLocal;
import org.cyclos.impl.users.ContactInfoFieldPossibleValueServiceLocal;
import org.cyclos.impl.users.ContactInfoFieldServiceLocal;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.model.ConstraintViolatedOnRemoveException;
import org.cyclos.model.system.fields.CustomFieldType;
import org.cyclos.model.system.fields.CustomFieldVO;
import org.cyclos.model.users.contactinfos.ContactInfoFieldDTO;
import org.cyclos.model.users.contactinfos.ContactInfoFieldData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ContactInfoFieldServiceImpl
extends BaseCustomFieldServiceImpl<ContactInfoField, ContactInfoFieldPossibleValueCategory, ContactInfoFieldPossibleValue, QContactInfoField, ContactInfoFieldDTO, ContactInfoFieldData, Void>
implements ContactInfoFieldServiceLocal {
    @Autowired
    private ContactInfoFieldPossibleValueServiceLocal contactCustomFieldPossibleValueService;
    @Autowired
    private ContactInfoFieldPossibleValueCategoryServiceLocal contactCustomFieldPossibleValueCategoryService;

    public ContactInfoFieldServiceImpl() {
        super(ContactInfoField.class, QContactInfoField.contactInfoField, ContactInfoFieldDTO.class, ContactInfoFieldData.class);
    }

    public List<CustomFieldVO> list() {
        return this.conversionHandler.convertList(CustomFieldVO.class, this.listAll());
    }

    public List<ContactInfoField> listAll() {
        return ((DBQuery)this.from(this.$).orderBy(((QContactInfoField)this.$).order.asc())).list((Expression)this.$);
    }

    public List<ContactInfoField> listEnabled(User user) {
        return this.productsHandler.getAccessor((BasicUser)user).member().getContactInfoFields();
    }

    public List<ContactInfoField> listForMap() {
        return ((DBQuery)((DBQuery)this.from(this.$).where((Predicate)((QContactInfoField)this.$).showInMap.isTrue())).orderBy(((QContactInfoField)this.$).order.asc())).list((Expression)this.$);
    }

    @Override
    public ContactInfoField newEntity(Void void_) {
        ContactInfoField contactInfoField = new ContactInfoField();
        contactInfoField.setShowInMap(true);
        return contactInfoField;
    }

    @Override
    protected void addCustomValidations(Validator validator, ContactInfoFieldDTO contactInfoFieldDTO) {
        CustomFieldType customFieldType = contactInfoFieldDTO.getType();
        if (customFieldType != null && customFieldType == CustomFieldType.MULTI_SELECTION || customFieldType.isBinary()) {
            // empty if block
        }
    }

    @Override
    protected Integer getMaxOrder(ContactInfoField contactInfoField) {
        return (Integer)this.from(this.$).singleResult((Expression)((QContactInfoField)this.$).order.max());
    }

    protected ContactInfoFieldPossibleValueCategoryServiceLocal getPossibleValueCategoryService() {
        return this.contactCustomFieldPossibleValueCategoryService;
    }

    protected ContactInfoFieldPossibleValueServiceLocal getPossibleValueService() {
        return this.contactCustomFieldPossibleValueService;
    }

    @Override
    protected boolean isBinaryTypesAllowed() {
        return true;
    }

    @Override
    protected void onBeforeRemove(ContactInfoField contactInfoField) {
        QContactInfoFieldValue qContactInfoFieldValue = QContactInfoFieldValue.contactInfoFieldValue;
        boolean bl = ((DBQuery)this.from(new EntityPath[]{qContactInfoFieldValue}).where((Predicate)qContactInfoFieldValue.field().eq((Object)contactInfoField))).hasResults();
        QMemberProduct qMemberProduct = QMemberProduct.memberProduct;
        boolean bl2 = ((DBQuery)this.from(new EntityPath[]{qMemberProduct}).where((Predicate)qMemberProduct.contactInfoFields.contains((Object)contactInfoField))).hasResults();
        if (bl && bl2) {
            throw new ConstraintViolatedOnRemoveException();
        }
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(((QContactInfoField)this.$).network());
    }
}

