/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.CaseBuilder;
import com.querydsl.core.types.dsl.NumberExpression;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.contentmanagement.QDataTranslation;
import org.cyclos.entities.system.Configuration;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.users.AdminGroup;
import org.cyclos.entities.users.AdminProduct;
import org.cyclos.entities.users.BasicGroup;
import org.cyclos.entities.users.BrokerGroup;
import org.cyclos.entities.users.Group;
import org.cyclos.entities.users.GroupSet;
import org.cyclos.entities.users.MemberGroup;
import org.cyclos.entities.users.Product;
import org.cyclos.entities.users.ProductOwner;
import org.cyclos.entities.users.QAdminGroup;
import org.cyclos.entities.users.QAdminProduct;
import org.cyclos.entities.users.QBasicGroup;
import org.cyclos.entities.users.QBrokerProduct;
import org.cyclos.entities.users.QGroup;
import org.cyclos.entities.users.QGroupSet;
import org.cyclos.entities.users.QMemberProduct;
import org.cyclos.entities.users.QProduct;
import org.cyclos.entities.users.QUser;
import org.cyclos.entities.users.QUserGroup;
import org.cyclos.entities.users.UserGroup;
import org.cyclos.impl.CRUDServiceImpl;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.system.ConfigurationAccessorCacheKey;
import org.cyclos.impl.system.ConfigurationServiceLocal;
import org.cyclos.impl.system.NetworkServiceLocal;
import org.cyclos.impl.users.GroupServiceLocal;
import org.cyclos.impl.users.GroupsHandler;
import org.cyclos.impl.users.ProductServiceLocal;
import org.cyclos.impl.users.ProductsAccessorCacheKey;
import org.cyclos.impl.users.ProductsGroupServiceLocal;
import org.cyclos.impl.users.UserGroupServiceLocal;
import org.cyclos.impl.utils.QueryHelper;
import org.cyclos.impl.utils.SerializablePredicate;
import org.cyclos.impl.utils.cache.CacheHandler;
import org.cyclos.impl.utils.cache.CacheType;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.impl.utils.validation.ValidationError;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.model.Bean;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IEntity;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.NamedEntityVO;
import org.cyclos.model.Property;
import org.cyclos.model.QueryParameters;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.contentmanagement.translations.DataTranslationType;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.system.configurations.ActiveConfigurationForGroupsData;
import org.cyclos.model.system.configurations.ConfigurationDetailedVO;
import org.cyclos.model.system.configurations.ConfigurationVO;
import org.cyclos.model.system.networks.NetworkOrderBy;
import org.cyclos.model.system.networks.NetworkQuery;
import org.cyclos.model.users.UsersKeys;
import org.cyclos.model.users.groups.AdminGroupDTO;
import org.cyclos.model.users.groups.AdminGroupData;
import org.cyclos.model.users.groups.AdminGroupType;
import org.cyclos.model.users.groups.AdminGroupVO;
import org.cyclos.model.users.groups.BasicGroupDTO;
import org.cyclos.model.users.groups.BasicGroupData;
import org.cyclos.model.users.groups.BasicGroupNature;
import org.cyclos.model.users.groups.BasicGroupQuery;
import org.cyclos.model.users.groups.BasicGroupVO;
import org.cyclos.model.users.groups.BrokerGroupDTO;
import org.cyclos.model.users.groups.GroupDTO;
import org.cyclos.model.users.groups.GroupProductsCollections;
import org.cyclos.model.users.groups.GroupSearchData;
import org.cyclos.model.users.groups.GroupSetDTO;
import org.cyclos.model.users.groups.GroupSetData;
import org.cyclos.model.users.groups.GroupSetVO;
import org.cyclos.model.users.groups.GroupVO;
import org.cyclos.model.users.groups.MemberGroupDTO;
import org.cyclos.model.users.groups.UserGroupDTO;
import org.cyclos.model.users.groups.UserGroupData;
import org.cyclos.model.users.products.AdminGroupAccessibility;
import org.cyclos.model.users.products.BrokerProductDTO;
import org.cyclos.model.users.products.MemberProductDTO;
import org.cyclos.model.users.products.ProductNature;
import org.cyclos.model.users.products.ProductQuery;
import org.cyclos.model.users.products.ProductVO;
import org.cyclos.model.users.users.UserStatus;
import org.cyclos.server.utils.PropertyHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.Page;
import org.cyclos.utils.ValidationResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GroupServiceImpl
extends CRUDServiceImpl<BasicGroup, QBasicGroup, BasicGroupDTO, BasicGroupData, BasicGroupNature>
implements GroupServiceLocal {
    private static final BidiMap<Class<? extends BasicGroup>, Class<? extends BasicGroupDTO>> SUBCLASS_MAPPINGS = new DualHashBidiMap();
    @Autowired
    private ProductsGroupServiceLocal groupProductsService;
    @Autowired
    private UserGroupServiceLocal userGroupService;
    @Autowired
    private ConfigurationServiceLocal configurationService;
    @Autowired
    private ProductServiceLocal productService;
    @Autowired
    private RawEntityManagerHandler rawEntityManagerHandler;
    @Autowired
    private NetworkServiceLocal networkService;
    @Autowired
    private CacheHandler cacheHandler;

    public GroupServiceImpl() {
        super(BasicGroup.class, QBasicGroup.basicGroup, BasicGroupDTO.class);
    }

    public void changeConfiguration(BasicGroupVO basicGroupVO, ConfigurationVO configurationVO) {
        Object object;
        BasicGroup basicGroup = (BasicGroup)this.conversionHandler.convert(BasicGroup.class, (Object)basicGroupVO);
        Configuration configuration = (Configuration)this.conversionHandler.convert(Configuration.class, (Object)configurationVO);
        Configuration configuration2 = basicGroup.getConfiguration();
        if (Objects.equals(configuration2, configuration)) {
            return;
        }
        basicGroup.setConfiguration(configuration);
        if (basicGroup instanceof GroupSet) {
            object = ((GroupSet)basicGroup).getGroups();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                UserGroup userGroup = (UserGroup)iterator.next();
                if (!userGroup.isInheritsConfiguration()) continue;
                userGroup.setConfiguration(configuration);
            }
        } else if (basicGroup instanceof UserGroup && (object = (UserGroup)basicGroup).isInheritsConfiguration()) {
            throw new IllegalArgumentException();
        }
        this.flush();
        this.cacheHandler.scheduleClear(CacheType.REQUEST_DATA);
        object = SimpleEntity.id((SimpleEntity)configuration2);
        this.cacheHandler.schedulePartialEvict(CacheType.CONFIGURATION_ACCESSOR, arg_0 -> GroupServiceImpl.lambda$changeConfiguration$47ab4c6c$1((Long)object, arg_0));
    }

    public AdminGroup createNetworkAdmins(Network network) throws FrameworkException {
        AdminGroup adminGroup = new AdminGroup();
        adminGroup.setName(this.message(UsersKeys.Groups.NAME_DEFAULT_FOR_NETWORK, network.getName()));
        adminGroup.setInternalName("networkAdmins");
        adminGroup.setAdminType(AdminGroupType.NETWORK);
        adminGroup.setNetwork(network);
        adminGroup.setConfiguration(network.getDefaultConfiguration());
        adminGroup.setAdminProduct(this.productService.createAdminProduct(adminGroup, true));
        this.rawEntityManagerHandler.persist((IEntity)adminGroup);
        return adminGroup;
    }

    public Group findByName(String string) {
        QGroup qGroup = QGroup.group;
        Group group = (Group)((DBQuery)this.from(new EntityPath[]{qGroup}).where((Predicate)qGroup.name.eq((Object)string))).singleResult((Expression)qGroup);
        if (group != null) {
            this.entityManagerHandler.checkAccess((IEntity)group);
        }
        return group;
    }

    public ActiveConfigurationForGroupsData getActiveConfiguration(BasicGroupVO basicGroupVO) throws EntityNotFoundException {
        BasicGroup basicGroup = (BasicGroup)this.conversionHandler.convert(BasicGroup.class, (Object)basicGroupVO);
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor(basicGroup);
        ActiveConfigurationForGroupsData activeConfigurationForGroupsData = (ActiveConfigurationForGroupsData)this.configurationService.toActiveConfiguration(ActiveConfigurationForGroupsData.class, configurationAccessor);
        activeConfigurationForGroupsData.setBasicGroup((BasicGroupVO)this.conversionHandler.convert(BasicGroupVO.class, (Object)basicGroup));
        if (this.hasPermission(Permission.USER_CONFIGURATION_MANAGE)) {
            List list = this.conversionHandler.convertList(ConfigurationDetailedVO.class, (Iterable)this.configurationService.listAll());
            ArrayList arrayList = new ArrayList(this.configurationService.list());
            arrayList.retainAll(list);
            activeConfigurationForGroupsData.setPossibleConfigurations(arrayList);
        }
        return activeConfigurationForGroupsData;
    }

    public List<AdminGroup> getAdminGroups() {
        QAdminGroup qAdminGroup = QAdminGroup.adminGroup;
        return ((DBQuery)((DBQuery)this.from(new EntityPath[]{qAdminGroup}).where((Predicate)qAdminGroup.enabled.isTrue())).orderBy(qAdminGroup.name.asc())).list((Expression)qAdminGroup);
    }

    public Set<BasicGroup> getBasicUserGroups() {
        QBasicGroup qBasicGroup = QBasicGroup.basicGroup;
        return ((DBQuery)this.from(new EntityPath[]{qBasicGroup}).where((Predicate)qBasicGroup.nature.ne((Object)BasicGroupNature.ADMIN_GROUP).and((Predicate)qBasicGroup.nature.eq((Object)BasicGroupNature.GROUP_SET).or((Predicate)qBasicGroup.enabled.isTrue())))).set((Expression)qBasicGroup);
    }

    public List<BasicGroup> getGroupsUsingConfiguration(Configuration configuration) throws FrameworkException {
        return ((DBQuery)((DBQuery)this.from().where((Predicate)((QBasicGroup)this.$).configuration().eq((Object)configuration))).orderBy(((QBasicGroup)this.$).nameHierarchy().asc())).list((Expression)this.$);
    }

    public List<BasicGroup> getGroupsUsingProduct(Product product) {
        return ((DBQuery)((DBQuery)this.from().where((Predicate)((QBasicGroup)this.$).products.contains((Object)product))).orderBy(((QBasicGroup)this.$).nameHierarchy().asc())).list((Expression)this.$);
    }

    public GroupSearchData getSearchData() {
        GroupSearchData groupSearchData = new GroupSearchData();
        groupSearchData.setCanCreateNew(true);
        groupSearchData.setCanRemove(true);
        groupSearchData.setGroupSets(this.conversionHandler.convertList(GroupSetVO.class, this.getGroupSets()));
        BasicGroupQuery basicGroupQuery = (BasicGroupQuery)QueryHelper.newQuery(BasicGroupQuery.class);
        groupSearchData.setQuery((QueryParameters)basicGroupQuery);
        return groupSearchData;
    }

    public AdminGroup getSystemAdmins() throws FrameworkException {
        Network network = this.getSessionData().getNetwork();
        QAdminGroup qAdminGroup = QAdminGroup.adminGroup;
        DBQuery<?> dBQuery = this.from(new EntityPath[]{qAdminGroup});
        if (network == null) {
            dBQuery.where(new Predicate[]{qAdminGroup.network().isNull(), qAdminGroup.adminType.eq((Object)AdminGroupType.GLOBAL)});
        } else {
            dBQuery.where(new Predicate[]{qAdminGroup.network().eq((Object)network), qAdminGroup.adminType.eq((Object)AdminGroupType.NETWORK)});
        }
        return (AdminGroup)dBQuery.singleResult((Expression)qAdminGroup);
    }

    public boolean hasNonRemovedUsers(Group group) {
        QUser qUser = QUser.user;
        return ((DBQuery)this.from(new EntityPath[]{qUser}).where(new Predicate[]{qUser.group().eq((Object)group), qUser.status.notIn((Object[])new UserStatus[]{UserStatus.REMOVED, UserStatus.PURGED})})).hasResults();
    }

    public Boolean hasUsers(BasicGroup basicGroup) {
        if (basicGroup instanceof Group) {
            QGroup qGroup = QGroup.group;
            Group group = (Group)basicGroup;
            return ((DBQuery)this.from(new EntityPath[]{qGroup}).where(new Predicate[]{qGroup.eq((Object)group), qGroup.users.isNotEmpty()})).hasResults();
        }
        if (basicGroup instanceof GroupSet) {
            QUserGroup qUserGroup = QUserGroup.userGroup;
            GroupSet groupSet = (GroupSet)basicGroup;
            return ((DBQuery)this.from(new EntityPath[]{qUserGroup}).where(new Predicate[]{qUserGroup.groupSet().eq((Object)groupSet), qUserGroup.users.isNotEmpty()})).hasResults();
        }
        return false;
    }

    public Collection<BasicGroup> listEntities(BasicGroupQuery basicGroupQuery) {
        return this.getSearchQuery(basicGroupQuery).list(BasicGroup.class, (Expression)this.$);
    }

    @Override
    public BasicGroup newEntity(BasicGroupNature basicGroupNature) {
        GroupSet groupSet;
        switch (basicGroupNature) {
            case GROUP_SET: {
                groupSet = new GroupSet();
                break;
            }
            case ADMIN_GROUP: {
                groupSet = new AdminGroup();
                ((AdminGroup)groupSet).setCopySystemAdminProfileFields(true);
                break;
            }
            case MEMBER_GROUP: {
                groupSet = new MemberGroup();
                break;
            }
            case BROKER_GROUP: {
                groupSet = new BrokerGroup();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid group nature " + String.valueOf(basicGroupNature));
            }
        }
        if (groupSet instanceof Group) {
            ((Group)groupSet).setEnabled(true);
        }
        groupSet.setConfiguration(this.configurationHandler.getDefault());
        return groupSet;
    }

    public Page<BasicGroupVO> search(BasicGroupQuery basicGroupQuery) {
        DBQuery<?> dBQuery = this.getSearchQuery(basicGroupQuery);
        return this.conversionHandler.convertPage((Map)GroupsHandler.VO_MAPPINGS, (Iterable)dBQuery.page((QueryParameters)basicGroupQuery, (Expression)this.$));
    }

    @Override
    public BasicGroupDTO toDTO(BasicGroup basicGroup) {
        BasicGroupDTO basicGroupDTO = (BasicGroupDTO)super.toDTO(basicGroup);
        if (basicGroup instanceof Group && basicGroupDTO instanceof AdminGroupDTO) {
            AdminGroup adminGroup = (AdminGroup)basicGroup;
            AdminGroupDTO adminGroupDTO = (AdminGroupDTO)basicGroupDTO;
            if (adminGroup.isPersistent()) {
                adminGroupDTO.setCanRegisterNetworks(adminGroup.getAdminProduct().getPermissions().contains(Permission.NETWORKS_REGISTER));
            }
        }
        return basicGroupDTO;
    }

    @Override
    public BasicGroup toEntity(BasicGroupDTO basicGroupDTO) {
        BasicGroup basicGroup = (BasicGroup)super.toEntity(basicGroupDTO);
        if (basicGroupDTO instanceof GroupDTO) {
            AdminGroupDTO adminGroupDTO;
            GroupDTO groupDTO = (GroupDTO)basicGroupDTO;
            Group group = (Group)basicGroup;
            if (group instanceof AdminGroup && !(adminGroupDTO = (AdminGroupDTO)groupDTO).isLimitMaxManagedNetworks()) {
                adminGroupDTO.setMaxManagedNetworks(null);
            }
        }
        return basicGroup;
    }

    @Override
    protected void doRemove(BasicGroup basicGroup, boolean bl) {
        this.productService.removeAllRelationships((Property)BrokerProductDTO.USER_REGISTRATION_GROUPS, (SimpleEntity)basicGroup);
        this.productService.removeAllRelationships((Property)MemberProductDTO.USER_REGISTRATION_GROUPS, (SimpleEntity)basicGroup);
        super.doRemove(basicGroup, bl);
    }

    @Override
    protected BasicGroupData getData(BasicGroup basicGroup) {
        Object object;
        UserGroupData userGroupData;
        Object object2;
        GroupSetData groupSetData;
        Object object3;
        Object object4;
        Object object5;
        int n = basicGroup.getProducts().size();
        if (basicGroup instanceof GroupSet) {
            object5 = (GroupSet)basicGroup;
            object4 = new GroupSetData();
            object3 = this.conversionHandler.convertList(GroupVO.class, (Iterable)object5.getGroups());
            object4.setGroups(CollectionHelper.sort((Collection)object3));
            groupSetData = object4;
        } else {
            Collection collection;
            object5 = (Group)basicGroup;
            if (object5 instanceof AdminGroup) {
                object3 = new AdminGroupData();
                object2 = this.groupsHandler.viewFactory(this.getBasicUserGroups()).basic().sorted();
                object3.setUserGroups((List)object2);
                object3.setAdminGroups(this.conversionHandler.convertList(AdminGroupVO.class, this.getAdminGroups()));
                if (this.getSessionData().getNetwork() == null) {
                    userGroupData = new NetworkQuery();
                    userGroupData.setUnlimited();
                    userGroupData.setOrderBy(NetworkOrderBy.NAME);
                    userGroupData.setReturnDisabled(true);
                    object3.setNetworks(this.networkService.search((NetworkQuery)userGroupData).getPageItems());
                    object3.setConfigurations(this.configurationService.list());
                } else {
                    userGroupData = new ProductQuery();
                    userGroupData.setNatures(Collections.singleton(ProductNature.ADMIN));
                    userGroupData.setUnlimited();
                    object = this.productService.search((ProductQuery)userGroupData).getPageItems().stream().map(productWithUserAccountVO -> {
                        ProductVO productVO = new ProductVO();
                        productWithUserAccountVO.copyPropertiesTo((Bean)productVO);
                        return productVO;
                    }).collect(Collectors.toList());
                    object3.setSharedAdminProducts((List)object);
                    collection = new HashSet(object5.getProducts());
                    if (object5 instanceof AdminGroup) {
                        ((HashSet)collection).remove(((AdminGroup)object5).getAdminProduct());
                    }
                    List list = this.conversionHandler.convertList(ProductVO.class, collection);
                    list.sort(Comparator.comparing(NamedEntityVO::getName));
                    object3.setAssignedAdminProducts(list);
                }
                object4 = object3;
            } else {
                object3 = (UserGroup)object5;
                object2 = object3.getGroupSet();
                userGroupData = new UserGroupData();
                userGroupData.setUserGroups(this.groupsHandler.visibles().accessibles().basicUsers().sorted());
                if (object2 != null && CollectionHelper.isNotEmpty((Iterable)object2.getProducts())) {
                    n += object2 == null ? 0 : object2.getProducts().size();
                    userGroupData.setCanChangeGroupset(false);
                    userGroupData.setGroupSets(Arrays.asList((GroupSetVO)this.conversionHandler.convert(GroupSetVO.class, object2)));
                } else {
                    userGroupData.setCanChangeGroupset(true);
                    userGroupData.setGroupSets(this.conversionHandler.convertList(GroupSetVO.class, this.getGroupSets()));
                }
                object = new BasicGroupQuery();
                object.setUnlimited();
                object.setNatures(Collections.singleton(object5.getNature()));
                collection = this.search((BasicGroupQuery)object).getPageItems();
                if (object5.isPersistent()) {
                    collection.remove(new GroupVO(object5.getId()));
                }
                object4 = userGroupData;
            }
            object4.setCanChangeEnable(this.canChangeEnabled((Group)object5));
            object4.setDto((EntityDTO)this.toDTO((BasicGroup)object5));
            groupSetData = object4;
        }
        groupSetData.setDto((EntityDTO)this.toDTO(basicGroup));
        groupSetData.setEditable(this.hasPermission(Permission.SYSTEM_CONFIGURATION_MANAGE));
        if (basicGroup.isPersistent()) {
            if (n <= 50) {
                groupSetData.setProducts((GroupProductsCollections)this.groupProductsService.getData((ProductOwner)basicGroup));
            }
            object5 = this.configurationHandler.getAccessor(basicGroup);
            object4 = this.configurationService.getConfigurationTreePath(object5.getConfiguration());
            groupSetData.setConfigurationHierarchy(this.conversionHandler.convertList(ConfigurationVO.class, (Iterable)object4));
        } else {
            groupSetData.setPossibleConfigurations(this.conversionHandler.convertList(ConfigurationDetailedVO.class, (Iterable)this.configurationService.listAll()));
            if (basicGroup instanceof UserGroup) {
                object5 = this.getGroupSets();
                object4 = new HashMap(object5.size());
                object3 = this.configurationHandler.getDefault();
                object2 = object5.iterator();
                while (object2.hasNext()) {
                    userGroupData = (GroupSet)object2.next();
                    object = userGroupData.getConfiguration();
                    if (object == null) {
                        object = object3;
                    }
                    object4.put(userGroupData.getId(), (ConfigurationDetailedVO)this.conversionHandler.convert(ConfigurationDetailedVO.class, object));
                }
                ((UserGroupData)groupSetData).setGroupSetConfigurations((Map)object4);
            }
        }
        return groupSetData;
    }

    @Override
    protected void onAfterRemove(BasicGroup basicGroup) {
        Long l = SimpleEntity.id((SimpleEntity)basicGroup.getNetwork());
        List list = PropertyHelper.getGetterNames((Path[])new Path[]{QProduct.product.groups, QProduct.product.accessibleUserGroups, QProduct.product.groupsForUserDirectory, QAdminProduct.adminProduct.accessibleAdminGroups, QAdminProduct.adminProduct.userGroupsToNotify, QMemberProduct.memberProduct.groupsForUserSearch, QMemberProduct.memberProduct.defaultFilterGroups, QBrokerProduct.brokerProduct.userRegistrationGroups});
        this.cacheHandler.schedulePartialEvict(CacheType.PRODUCTS_ACCESSOR, (SerializablePredicate & Serializable)productsAccessorCacheKey -> productsAccessorCacheKey.matchesNetworkAndMethod(l, (Collection)list));
        this.cacheHandler.schedulePartialEvict(CacheType.GROUPS, (SerializablePredicate & Serializable)groupsCacheKey -> groupsCacheKey.matchesNetwork(l));
    }

    @Override
    protected void onAfterSave(BasicGroup basicGroup, BasicGroup basicGroup2, Object object) {
        Group group;
        Long l;
        if (basicGroup2 != null) {
            if (basicGroup instanceof Group) {
                l = (Group)basicGroup;
                group = (Group)basicGroup2;
                if (!l.isEnabled() && group.isEnabled()) {
                    this.configurationService.removeGroup((Group)l);
                }
            }
        } else {
            l = SimpleEntity.id((SimpleEntity)basicGroup.getNetwork());
            this.cacheHandler.schedulePartialEvict(CacheType.GROUPS, (SerializablePredicate & Serializable)groupsCacheKey -> groupsCacheKey.matchesNetwork(l));
        }
        if (basicGroup instanceof UserGroup) {
            l = (UserGroup)basicGroup;
            group = l.getGroupSet();
            if (group != null && !group.getGroups().contains(l)) {
                group.getGroups().add(l);
            }
        } else if (basicGroup instanceof AdminGroup && basicGroup.isGlobal()) {
            l = (AdminGroup)basicGroup;
            group = l.getAdminProduct();
            Set set = group.getPermissions();
            CollectionHelper.addOrRemove((Collection)set, (Object)Permission.NETWORKS_REGISTER, (boolean)l.isCanRegisterNetworks());
            boolean bl = CollectionHelper.isNotEmpty((Iterable)l.getManagedNetworks());
            CollectionHelper.addOrRemove((Collection)set, (Object)Permission.SPECIFIC_NETWORKS_MANAGE, (boolean)bl);
            this.cacheHandler.scheduleClear(CacheType.PRODUCTS_ACCESSOR);
            group.setAdminGroupAccessibility(AdminGroupAccessibility.SPECIFIC);
            group.setAccessibleAdminGroups(CollectionHelper.asSet((Object[])new AdminGroup[]{l}));
        }
    }

    @Override
    protected void onBeforeRemove(BasicGroup basicGroup) {
        Object object;
        if (basicGroup instanceof Group && (this.hasUsers((BasicGroup)(object = (Group)basicGroup)).booleanValue() || this.userGroupService.existsInGroupHistoryLog(object.getId()))) {
            String string = this.message(UsersKeys.Groups.VALIDATE_GROUP_NOT_REMOVABLE, new Object[0]);
            ValidationResult validationResult = new ValidationResult(string);
            throw new ValidationException(validationResult);
        }
        if (basicGroup instanceof GroupSet && CollectionHelper.isNotEmpty((Iterable)(object = (GroupSet)basicGroup).getGroups())) {
            String string = this.message(UsersKeys.Groups.VALIDATE_GROUPSET_NOT_REMOVABLE, new Object[0]);
            ValidationResult validationResult = new ValidationResult(string);
            throw new ValidationException(validationResult);
        }
        if (basicGroup instanceof AdminGroup) {
            object = ((AdminGroup)basicGroup).getAdminProduct().getId();
            this.cacheHandler.schedulePartialEvict(CacheType.PRODUCTS_ACCESSOR, arg_0 -> GroupServiceImpl.lambda$onBeforeRemove$9c13d0f4$1((Long)object, arg_0));
        }
    }

    @Override
    protected Object onBeforeSave(BasicGroup basicGroup, BasicGroup basicGroup2) {
        AdminGroup adminGroup;
        if (basicGroup instanceof AdminGroup) {
            adminGroup = (AdminGroup)basicGroup;
            if (basicGroup2 == null) {
                if (adminGroup.getAdminType() != null) {
                    throw new IllegalActionException();
                }
                AdminProduct adminProduct = this.productService.createAdminProduct(adminGroup, adminGroup.isCopySystemAdminProfileFields());
                adminGroup.setAdminProduct(adminProduct);
            } else {
                adminGroup.getAdminProduct().setName(adminGroup.getName());
            }
            if (!adminGroup.isGlobal() || adminGroup.getAdminType() != null) {
                adminGroup.setManageScripts(Boolean.valueOf(false));
                adminGroup.setManagedNetworks(null);
                adminGroup.setMaxManagedNetworks(null);
            }
        }
        if (basicGroup instanceof UserGroup) {
            adminGroup = (UserGroup)basicGroup;
            if (adminGroup.getGroupSet() != null && adminGroup.isInheritsConfiguration()) {
                adminGroup.setConfiguration(adminGroup.getGroupSet().getConfiguration());
            }
            if (!adminGroup.isMoveUsersAutomatically()) {
                adminGroup.setMoveUsersAfterPeriod(null);
                adminGroup.setMoveUsersToGroup(null);
            }
        }
        if (basicGroup.getConfiguration() == null) {
            adminGroup = this.configurationHandler.getForGroup(basicGroup);
            basicGroup.setConfiguration((Configuration)adminGroup);
        }
        return null;
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(((QBasicGroup)this.$).network());
    }

    @Override
    protected Validator resolveValidator(BasicGroupDTO basicGroupDTO) {
        if (basicGroupDTO instanceof UserGroupDTO) {
            return this.getUserGroupValidator((UserGroupDTO)basicGroupDTO);
        }
        if (basicGroupDTO instanceof AdminGroupDTO) {
            return this.getAdminGroupValidator((AdminGroupDTO)basicGroupDTO);
        }
        if (basicGroupDTO instanceof GroupSetDTO) {
            return this.getGroupSetValidator();
        }
        return null;
    }

    @Override
    protected BidiMap<Class<? extends BasicGroup>, Class<? extends BasicGroupDTO>> subClassMappings() {
        return SUBCLASS_MAPPINGS;
    }

    private boolean canChangeEnabled(Group group) {
        return !this.hasNonRemovedUsers(group);
    }

    private void fillGroupValidator(GroupDTO groupDTO, Validator validator) {
        validator.general(object -> {
            Group group;
            GroupDTO groupDTO = (GroupDTO)object;
            if (groupDTO.isPersistent() && (group = this.find(Group.class, groupDTO.getId())).isEnabled() && !groupDTO.isEnabled() && !this.canChangeEnabled(group)) {
                return new ValidationError(UsersKeys.Groups.VALIDATE_NO_DISABLING);
            }
            return null;
        });
        validator.property((Property)GroupDTO.INITIAL_USER_STATUS, UsersKeys.Groups.INITIAL_USER_STATUS).required().anyOf(new Object[]{UserStatus.ACTIVE, UserStatus.BLOCKED, UserStatus.DISABLED});
    }

    private Validator getAdminGroupValidator(AdminGroupDTO adminGroupDTO) {
        Validator validator = this.getBasicValidator();
        this.fillGroupValidator((GroupDTO)adminGroupDTO, validator);
        if (this.getSessionData().getNetwork() == null) {
            Integer n;
            if (adminGroupDTO.isLimitMaxManagedNetworks() && (n = adminGroupDTO.getMaxManagedNetworks()) != null) {
                validator.property((Property)AdminGroupDTO.MANAGED_NETWORKS, UsersKeys.Groups.MANAGED_NETWORKS).maxElements(n.intValue());
            }
            if (adminGroupDTO.isLimitMaxManagedNetworks()) {
                validator.property((Property)AdminGroupDTO.MAX_MANAGED_NETWORKS, UsersKeys.Groups.MAX_MANAGED_NETWORKS).required().positiveOrZero();
            }
            if (adminGroupDTO.isCanRegisterNetworks()) {
                validator.property((Property)AdminGroupDTO.POSSIBLE_PARENT_CONFIGURATIONS, UsersKeys.Groups.POSSIBLE_PARENT_CONFIGURATIONS).required();
            }
        }
        return validator;
    }

    private Validator getBasicValidator() {
        Validator validator = new Validator();
        validator.property(BasicGroupDTO.DESCRIPTION, GeneralKeys.Ui.DESCRIPTION).maxLength(4000);
        return validator;
    }

    private List<GroupSet> getGroupSets() {
        QGroupSet qGroupSet = QGroupSet.groupSet;
        return this.from(new EntityPath[]{qGroupSet}).list((Expression)qGroupSet);
    }

    private Validator getGroupSetValidator() {
        return this.getBasicValidator();
    }

    private DBQuery<?> getSearchQuery(BasicGroupQuery basicGroupQuery) {
        QUserGroup qUserGroup;
        SessionData sessionData = this.getSessionData();
        DBQuery<?> dBQuery = this.from();
        GroupSet groupSet = (GroupSet)this.conversionHandler.convert(GroupSet.class, (Object)basicGroupQuery.getGroupSet());
        if (groupSet != null) {
            qUserGroup = QUserGroup.userGroup;
            DBQuery dBQuery2 = (DBQuery)this.subQuery(new EntityPath[]{qUserGroup}).where(new Predicate[]{qUserGroup.eq((Expression)this.$), qUserGroup.groupSet().eq((Object)groupSet)});
            dBQuery.where((Predicate)((QBasicGroup)this.$).eq((Object)groupSet).or((Predicate)dBQuery2.exists()));
        }
        if (QueryHelper.useParameter((Object)basicGroupQuery.getName())) {
            qUserGroup = QDataTranslation.dataTranslation;
            ((DBQuery)((DBQuery)dBQuery.leftJoin((EntityPath)qUserGroup)).on((Predicate)qUserGroup.entityId.eq((Expression)((QBasicGroup)this.$).id).and((Predicate)qUserGroup.type.eq((Object)DataTranslationType.GROUPS).and((Predicate)qUserGroup.propertyName.eq((Object)"name"))))).where((Predicate)((QBasicGroup)this.$).name.containsIgnoreCase(basicGroupQuery.getName()).or((Predicate)qUserGroup.value.containsIgnoreCase(basicGroupQuery.getName())));
        }
        if (CollectionHelper.isNotEmpty((Iterable)basicGroupQuery.getNatures())) {
            dBQuery.where((Predicate)((QBasicGroup)this.$).nature.in((Collection)basicGroupQuery.getNatures()));
        }
        if (basicGroupQuery.isShowDisabled()) {
            dBQuery.where((Predicate)((QBasicGroup)this.$).nature.ne((Object)BasicGroupNature.GROUP_SET).and((Predicate)((QBasicGroup)this.$).enabled.isFalse()));
        } else {
            dBQuery.where((Predicate)((QBasicGroup)this.$).nature.eq((Object)BasicGroupNature.GROUP_SET).or((Predicate)((QBasicGroup)this.$).enabled.isTrue()));
        }
        if (!sessionData.hasPermission(Permission.USER_CONFIGURATION_VIEW)) {
            dBQuery.where((Predicate)((QBasicGroup)this.$).in((Collection)this.groupsHandler.accessibles().basic().items()));
        }
        dBQuery.orderBy(new OrderSpecifier[]{((NumberExpression)new CaseBuilder().when((Predicate)((QBasicGroup)this.$).nature.eq((Object)BasicGroupNature.ADMIN_GROUP).and((Predicate)((QBasicGroup)this.$).adminType.isNotNull())).then((Number)1).when((Predicate)((QBasicGroup)this.$).nature.eq((Object)BasicGroupNature.ADMIN_GROUP)).then((Object)2).otherwise((Object)3)).asc(), ((QBasicGroup)this.$).nameHierarchy().asc()});
        return dBQuery;
    }

    private Validator getUserGroupValidator(UserGroupDTO userGroupDTO) {
        Validator validator = this.getBasicValidator();
        this.fillGroupValidator((GroupDTO)userGroupDTO, validator);
        validator.property((Property)UserGroupDTO.INITIAL_GROUP_DISPLAY_NAME, UsersKeys.Groups.INITIAL_GROUP_DISPLAY_NAME).maxLength(100);
        validator.property((Property)UserGroupDTO.INITIAL_GROUP_DESCRIPTION, UsersKeys.Groups.INITIAL_GROUP_DESCRIPTION).maxLength(4000);
        validator.general(object -> {
            UserGroup userGroup;
            UserGroupDTO userGroupDTO = (UserGroupDTO)object;
            if (userGroupDTO.isPersistent() && (userGroup = this.find(UserGroup.class, userGroupDTO.getId())).getGroupSet() != null && CollectionHelper.isNotEmpty((Iterable)userGroup.getGroupSet().getProducts())) {
                boolean bl;
                boolean bl2 = bl = userGroupDTO.getGroupSet() == null || !userGroupDTO.getGroupSet().getId().equals(userGroup.getGroupSet().getId());
                if (bl) {
                    return new ValidationError(UsersKeys.Groups.VALIDATE_NO_GROUP_SET_CHANGE);
                }
            }
            return null;
        });
        if (userGroupDTO.isMoveUsersAutomatically()) {
            validator.property((Property)UserGroupDTO.MOVE_USERS_AFTER_PERIOD, UsersKeys.Groups.MOVE_USERS_AFTER_PERIOD).required().positiveIntegerNonZero().timeInterval();
            Set set = this.groupsHandler.accessibles().users().items();
            if (userGroupDTO.isPersistent()) {
                UserGroup userGroup = this.find(UserGroup.class, userGroupDTO.getId());
                set.remove(userGroup);
            }
            validator.property((Property)UserGroupDTO.MOVE_USERS_TO_GROUP, UsersKeys.Groups.MOVE_USERS_TO_GROUP).required().anyOf((Collection)this.conversionHandler.convertList(GroupVO.class, (Iterable)set));
        }
        return validator;
    }

    private static /* synthetic */ boolean lambda$onBeforeRemove$9c13d0f4$1(Long l, ProductsAccessorCacheKey productsAccessorCacheKey) {
        return productsAccessorCacheKey.matchesProduct(l);
    }

    private static /* synthetic */ boolean lambda$changeConfiguration$47ab4c6c$1(Long l, ConfigurationAccessorCacheKey configurationAccessorCacheKey) {
        return configurationAccessorCacheKey.matchesConfiguration(l);
    }

    static {
        SUBCLASS_MAPPINGS.put(GroupSet.class, GroupSetDTO.class);
        SUBCLASS_MAPPINGS.put(AdminGroup.class, AdminGroupDTO.class);
        SUBCLASS_MAPPINGS.put(MemberGroup.class, MemberGroupDTO.class);
        SUBCLASS_MAPPINGS.put(BrokerGroup.class, BrokerGroupDTO.class);
    }
}

