/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.cyclos.entities.BaseEntity;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.system.Image;
import org.cyclos.entities.system.TempImage;
import org.cyclos.entities.users.BaseContactInfo;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.ContactInfo;
import org.cyclos.entities.users.ContactInfoField;
import org.cyclos.entities.users.LandLinePhone;
import org.cyclos.entities.users.MobilePhone;
import org.cyclos.entities.users.Operator;
import org.cyclos.entities.users.OperatorGroup;
import org.cyclos.entities.users.Phone;
import org.cyclos.entities.users.User;
import org.cyclos.entities.users.UserAddress;
import org.cyclos.entities.users.UserImage;
import org.cyclos.impl.BaseServiceImpl;
import org.cyclos.impl.CRUDServiceLocal;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.access.PasswordHandler;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.system.ConfigurationServiceLocal;
import org.cyclos.impl.users.ContactInfoFieldServiceLocal;
import org.cyclos.impl.users.ContactInfoServiceLocal;
import org.cyclos.impl.users.InternalBasicUserServiceLocal;
import org.cyclos.impl.users.OperatorGroupServiceLocal;
import org.cyclos.impl.users.OperatorServiceLocal;
import org.cyclos.impl.users.PhoneServiceLocal;
import org.cyclos.impl.users.ProductsAccessor;
import org.cyclos.impl.users.UserAddressServiceLocal;
import org.cyclos.impl.users.UserGroupServiceLocal;
import org.cyclos.impl.users.UserImageServiceLocal;
import org.cyclos.impl.users.UserServiceLocal;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.validation.PropertyAccess;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.model.Bean;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IEntity;
import org.cyclos.model.MaxItemsException;
import org.cyclos.model.Property;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.CredentialUsage;
import org.cyclos.model.access.Role;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.system.fields.CustomFieldDetailedVO;
import org.cyclos.model.system.images.ImageVO;
import org.cyclos.model.system.images.TempImageTarget;
import org.cyclos.model.system.scripts.LoadValuesScriptFunction;
import org.cyclos.model.users.UsersKeys;
import org.cyclos.model.users.addresses.UserAddressDTO;
import org.cyclos.model.users.addresses.UserAddressData;
import org.cyclos.model.users.addresses.UserAddressDataParams;
import org.cyclos.model.users.contactinfos.ContactInfoDTO;
import org.cyclos.model.users.contactinfos.ContactInfoData;
import org.cyclos.model.users.groups.BasicChangeGroupData;
import org.cyclos.model.users.groups.ChangeGroupDTO;
import org.cyclos.model.users.groups.ChangeGroupData;
import org.cyclos.model.users.groups.GroupSetVO;
import org.cyclos.model.users.operatorgroups.ChangeOperatorGroupDTO;
import org.cyclos.model.users.operatorgroups.OperatorGroupVO;
import org.cyclos.model.users.operators.OperatorDTO;
import org.cyclos.model.users.operators.OperatorVO;
import org.cyclos.model.users.phones.LandLinePhoneDTO;
import org.cyclos.model.users.phones.MobilePhoneDTO;
import org.cyclos.model.users.phones.PhoneData;
import org.cyclos.model.users.phones.PhoneDataParams;
import org.cyclos.model.users.phones.PhoneNature;
import org.cyclos.model.users.users.AbstractViewProfileData;
import org.cyclos.model.users.users.BasicProfileField;
import org.cyclos.model.users.users.BasicUserDTO;
import org.cyclos.model.users.users.BasicUserEditProfileData;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.EditProfileConfirmationField;
import org.cyclos.model.users.users.ProfileField;
import org.cyclos.model.users.users.ProfileFieldAction;
import org.cyclos.model.users.users.UserDTO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.security.users.UserServiceSecurity;
import org.cyclos.server.model.AggregatedFrameworkExceptions;
import org.cyclos.server.model.NestedFrameworkException;
import org.cyclos.server.model.users.users.SaveFullProfileData;
import org.cyclos.server.model.users.users.SaveFullProfileParams;
import org.cyclos.server.model.users.users.SaveFullProfileResult;
import org.cyclos.server.model.users.users.UserProfileAddressesData;
import org.cyclos.server.model.users.users.UserProfileContactInfosData;
import org.cyclos.server.model.users.users.UserProfileImagesData;
import org.cyclos.server.model.users.users.UserProfilePhonesData;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.MessageKey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InternalBasicUserServiceImpl
extends BaseServiceImpl
implements InternalBasicUserServiceLocal {
    private static final String USER = "user";
    private static final String CONFIRMATION_PASSWORD = "confirmationPassword";
    private static final String LAND_LINE_PHONES = "landLinePhones";
    private static final String CREATE_LAND_LINE_PHONES = "createLandLinePhones";
    private static final String MODIFY_LAND_LINE_PHONES = "modifyLandLinePhones";
    private static final String MOBILE_PHONES = "mobilePhones";
    private static final String CREATE_MOBILE_PHONES = "createMobilePhones";
    private static final String MODIFY_MOBILE_PHONES = "modifyMobilePhones";
    private static final String REMOVE_PHONES = "removePhones";
    private static final String ADDRESSES = "addresses";
    private static final String CREATE_ADDRESSES = "createAddresses";
    private static final String MODIFY_ADDRESSES = "modifyAddresses";
    private static final String REMOVE_ADDRESSES = "removeAddresses";
    private static final String CONTACT_INFOS = "contactInfos";
    private static final String CREATE_CONTACT_INFOS = "createContactInfos";
    private static final String MODIFY_CONTACT_INFOS = "modifyContactInfos";
    private static final String REMOVE_CONTACT_INFOS = "removeContactInfos";
    private static final String IMAGES = "images";
    private static final String ADD_IMAGES = "addImages";
    private static final String REMOVE_IMAGES = "removeImages";
    private static final String REORDER_IMAGES = "reorderImages";
    private static final ConfirmationPasswordAccess CONFIRMATION_PASSWORD_ACCESS = new ConfirmationPasswordAccess();
    @Autowired
    private UserServiceLocal userService;
    @Autowired
    private UserServiceSecurity userServiceSecurity;
    @Autowired
    private OperatorServiceLocal operatorService;
    @Autowired
    private PasswordHandler passwordHandler;
    @Autowired
    private ConfigurationServiceLocal configurationService;
    @Autowired
    private PhoneServiceLocal phoneService;
    @Autowired
    private UserAddressServiceLocal userAddressService;
    @Autowired
    private ContactInfoServiceLocal contactInfoService;
    @Autowired
    private ContactInfoFieldServiceLocal contactInfoFieldService;
    @Autowired
    private UserImageServiceLocal userImageService;
    @Autowired
    private OperatorGroupServiceLocal operatorGroupService;
    @Autowired
    private UserGroupServiceLocal userGroupService;

    public void applyPermissionsToBasicFields(BasicUserDTO basicUserDTO, BasicUser basicUser) {
        SessionData sessionData = this.getSessionData();
        if (sessionData.isSystem()) {
            return;
        }
        Map map = this.profileFieldHandler.getFieldActionsMap(basicUser);
        for (BasicProfileField basicProfileField : BasicProfileField.simple()) {
            boolean bl;
            Property property;
            boolean bl2;
            Set set = (Set)map.get(basicProfileField);
            boolean bl3 = bl2 = set != null && set.contains(ProfileFieldAction.EDIT);
            if (!bl2) {
                property = basicProfileField.property();
                basicUserDTO.set(property, (Object)((String)this.profileFieldHandler.getFieldValue(basicUser, (ProfileField)basicProfileField)));
            }
            if (!(basicUserDTO instanceof UserDTO) || !(basicUser instanceof User)) continue;
            property = (User)basicUser;
            Property property2 = basicProfileField.hideProperty();
            if (property2 == null || (bl = set != null && set.contains(ProfileFieldAction.MANAGE_PRIVACY))) continue;
            if (basicUser.isTransient()) {
                basicUserDTO.set(property2, (Object)this.profileFieldHandler.isDefaultHidden(property.getGroup(), (ProfileField)basicProfileField));
                continue;
            }
            basicUserDTO.set(property2, (Object)this.profileFieldHandler.isHidden(basicUser, (ProfileField)basicProfileField, null));
        }
    }

    public boolean canEditProfile(BasicUser basicUser) {
        if (basicUser instanceof Operator) {
            return this.operatorService.canEditProfile((Operator)basicUser);
        }
        if (basicUser instanceof User) {
            return this.userServiceSecurity.canEditProfile((User)basicUser);
        }
        return false;
    }

    public void changeGroup(ChangeGroupDTO changeGroupDTO) {
        BasicUser basicUser = (BasicUser)this.conversionHandler.convert(BasicUser.class, (Object)changeGroupDTO.getUser());
        if (basicUser.isOperator()) {
            ChangeOperatorGroupDTO changeOperatorGroupDTO = this.toChangeOperatorGroupDTO(changeGroupDTO, basicUser);
            this.operatorGroupService.changeGroup(changeOperatorGroupDTO);
        } else {
            this.userGroupService.changeGroup(changeGroupDTO);
        }
    }

    public void filterGroupSets(BasicChangeGroupData basicChangeGroupData) {
        basicChangeGroupData.getPossibleNewGroups().removeIf(GroupSetVO.class::isInstance);
    }

    public BasicChangeGroupData getChangeGroupData(UserLocatorVO userLocatorVO) throws FrameworkException {
        BasicUser basicUser = (BasicUser)this.conversionHandler.convert(BasicUser.class, (Object)userLocatorVO);
        if (basicUser.isOperator()) {
            return this.operatorGroupService.getChangeGroupData(userLocatorVO);
        }
        ChangeGroupData changeGroupData = this.userGroupService.getChangeGroupData(userLocatorVO);
        this.filterGroupSets((BasicChangeGroupData)changeGroupData);
        return changeGroupData;
    }

    public BasicUserEditProfileData<?> getEditData(UserLocatorVO userLocatorVO) {
        BasicUser basicUser = (BasicUser)this.conversionHandler.convert(BasicUser.class, (Object)userLocatorVO);
        if (basicUser.isOperator()) {
            return (BasicUserEditProfileData)this.operatorService.getData(basicUser.getId());
        }
        return (BasicUserEditProfileData)this.userService.getData(basicUser.getId());
    }

    public SaveFullProfileData getEditFullProfileData(UserLocatorVO userLocatorVO) throws FrameworkException {
        Object object;
        Object object2;
        UserProfileAddressesData userProfileAddressesData;
        UserProfilePhonesData userProfilePhonesData;
        BasicUser basicUser = (BasicUser)this.conversionHandler.convert(BasicUser.class, (Object)userLocatorVO);
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor(basicUser);
        ProductsAccessor productsAccessor = this.productsHandler.getAccessor(basicUser);
        SaveFullProfileData saveFullProfileData = new SaveFullProfileData();
        saveFullProfileData.setUserVO((BasicUserVO)this.conversionHandler.convert(BasicUserVO.class, (Object)basicUser));
        BasicUserEditProfileData basicUserEditProfileData = basicUser instanceof Operator ? (BasicUserEditProfileData)this.operatorService.getData(basicUser.getId()) : (BasicUserEditProfileData)this.userService.getData(basicUser.getId());
        saveFullProfileData.setUser(basicUserEditProfileData);
        this.passwordHandler.ignoreNextConfirmationPasswords();
        if (this.profileFieldHandler.getFieldActions(basicUser, (ProfileField)BasicProfileField.PHONE).contains(ProfileFieldAction.VIEW)) {
            userProfilePhonesData = new UserProfilePhonesData();
            userProfilePhonesData.setConfiguration(this.configurationService.toPhoneConfiguration(configurationAccessor));
            userProfilePhonesData.setLandLineRequired(configurationAccessor.isLandLineRequired());
            userProfilePhonesData.setMobileRequired(configurationAccessor.isMobileRequired());
            userProfileAddressesData = new PhoneDataParams();
            userProfileAddressesData.setSuggestPhoneName(true);
            userProfileAddressesData.setUser(userLocatorVO);
            userProfileAddressesData.setNature(PhoneNature.LANDLINE);
            userProfilePhonesData.setLandLinePhone((LandLinePhoneDTO)((PhoneData)this.phoneService.getDataForNew((Object)userProfileAddressesData)).getDto());
            userProfileAddressesData.setNature(PhoneNature.MOBILE);
            userProfilePhonesData.setMobilePhone((MobilePhoneDTO)((PhoneData)this.phoneService.getDataForNew((Object)userProfileAddressesData)).getDto());
            saveFullProfileData.setPhoneConfiguration(userProfilePhonesData);
            object2 = this.phoneService.listByUser(basicUser, null).stream().map(arg_0 -> ((PhoneServiceLocal)this.phoneService).toDTO(arg_0)).collect(Collectors.toList());
            saveFullProfileData.setLandLinePhones(object2.stream().filter(LandLinePhoneDTO.class::isInstance).map(LandLinePhoneDTO.class::cast).collect(Collectors.toList()));
            saveFullProfileData.setMobilePhones(object2.stream().filter(MobilePhoneDTO.class::isInstance).map(MobilePhoneDTO.class::cast).collect(Collectors.toList()));
            object = this.phoneService.counters(basicUser);
            userProfilePhonesData.setMaxLandLines(Math.max(0, productsAccessor.product().getMaxLandlinePhones() - ((Integer)object.get(PhoneNature.LANDLINE) - saveFullProfileData.getLandLinePhones().size())));
            userProfilePhonesData.setMaxMobiles(Math.max(0, productsAccessor.product().getMaxMobilePhones() - ((Integer)object.get(PhoneNature.MOBILE) - saveFullProfileData.getMobilePhones().size())));
        }
        if (basicUser instanceof User) {
            userProfilePhonesData = (User)basicUser;
            if (this.profileFieldHandler.getFieldActions(basicUser, (ProfileField)BasicProfileField.ADDRESS).contains(ProfileFieldAction.VIEW)) {
                userProfileAddressesData = new UserProfileAddressesData();
                userProfileAddressesData.setConfiguration(this.configurationService.toAddressConfiguration(configurationAccessor));
                userProfileAddressesData.setRequired(configurationAccessor.isRequiredAddress());
                object2 = new UserAddressDataParams();
                object2.setUser(userLocatorVO);
                object2.setSuggestAddressName(true);
                userProfileAddressesData.setAddress((UserAddressDTO)((UserAddressData)this.userAddressService.getDataForNew(object2)).getDto());
                saveFullProfileData.setAddressConfiguration(userProfileAddressesData);
                saveFullProfileData.setAddresses(this.userAddressService.listByUser((User)userProfilePhonesData).stream().map(arg_0 -> ((UserAddressServiceLocal)this.userAddressService).toDTO(arg_0)).collect(Collectors.toList()));
                userProfileAddressesData.setMaxAddresses(Math.max(0, productsAccessor.product().getMaxAddresses() - (this.userAddressService.count((User)userProfilePhonesData) - saveFullProfileData.getAddresses().size())));
            }
            userProfileAddressesData = new UserProfileContactInfosData();
            saveFullProfileData.setContactInfoConfiguration((UserProfileContactInfosData)userProfileAddressesData);
            if (this.contactInfoService.canHaveContactInfos((User)userProfilePhonesData)) {
                userProfileAddressesData.setCustomFields(this.conversionHandler.convertList(CustomFieldDetailedVO.class, (Iterable)this.contactInfoFieldService.listEnabled((User)userProfilePhonesData)));
                object2 = new HashMap();
                object2.put("contactInfo", new ContactInfo((User)userProfilePhonesData));
                this.customFieldValueHandler.fillValuesFromScript(ContactInfoField.class, LoadValuesScriptFunction.ENTITY, (Map)object2, (Collection)userProfileAddressesData.getCustomFields());
                userProfileAddressesData.setMaxContactInfos(productsAccessor.member().getMaxContactInfos());
                userProfileAddressesData.setContactInfo((ContactInfoDTO)((ContactInfoData)this.contactInfoService.getDataForNew((Object)userLocatorVO)).getDto());
                saveFullProfileData.setContactInfos(this.contactInfoService.list((User)userProfilePhonesData).stream().map(arg_0 -> ((ContactInfoServiceLocal)this.contactInfoService).toDTO(arg_0)).collect(Collectors.toList()));
            } else {
                userProfileAddressesData.setCustomFields(Collections.emptyList());
                userProfileAddressesData.setMaxContactInfos(0);
            }
            if (this.profileFieldHandler.getFieldActions(basicUser, (ProfileField)BasicProfileField.IMAGE).contains(ProfileFieldAction.VIEW)) {
                object2 = new UserProfileImagesData();
                object = this.userImageService.getListData((IEntity)userLocatorVO);
                object2.setRequired(object.isRequired());
                object2.setCanManage(object.isCanManage());
                object2.setMaxImages(object.getMaxImages().intValue());
                saveFullProfileData.setImageConfiguration((UserProfileImagesData)object2);
                saveFullProfileData.setImages(object.getImages());
            }
        }
        return saveFullProfileData;
    }

    public Role getMainRole(UserLocatorVO userLocatorVO) throws FrameworkException {
        BasicUser basicUser = this.userLocatorHandler.toBasicUserOrCurrent((BasicUserVO)userLocatorVO);
        return basicUser == null ? null : basicUser.getMainRole();
    }

    public AbstractViewProfileData getViewProfileData(UserLocatorVO userLocatorVO) throws FrameworkException {
        BasicUser basicUser = this.userLocatorHandler.locate(userLocatorVO).getBasicUser();
        userLocatorVO = new UserLocatorVO(basicUser.getId());
        if (basicUser instanceof Operator) {
            return this.operatorService.getViewProfileData(userLocatorVO);
        }
        return this.userService.getViewProfileData(userLocatorVO);
    }

    public void remove(@NotNull UserLocatorVO userLocatorVO) {
        BasicUser basicUser = (BasicUser)this.conversionHandler.convert(BasicUser.class, (Object)userLocatorVO);
        if (basicUser.isOperator()) {
            this.operatorService.remove((SimpleEntity)((Operator)basicUser));
        } else {
            this.userService.remove((SimpleEntity)((User)basicUser));
        }
    }

    public void save(UserLocatorVO userLocatorVO, BasicUserDTO basicUserDTO, String string) {
        BasicUser basicUser = (BasicUser)this.conversionHandler.convert(BasicUser.class, (Object)userLocatorVO);
        if (basicUserDTO.getId() == null) {
            basicUserDTO.setId(basicUser.getId());
        } else if (!basicUserDTO.getId().equals(basicUser.getId())) {
            throw new EntityNotFoundException(User.class, basicUserDTO.getId());
        }
        this.applyPermissionsToBasicFields(basicUserDTO, basicUser);
        if (basicUser.isOperator()) {
            this.operatorService.saveWithConfirmationPassword((EntityDTO)this.ensureOperatorDTO(basicUserDTO), string);
        } else {
            this.userService.saveWithConfirmationPassword((EntityDTO)((UserDTO)basicUserDTO), string);
        }
    }

    public SaveFullProfileResult saveFullProfile(SaveFullProfileParams saveFullProfileParams) throws FrameworkException {
        SessionData sessionData;
        User user;
        BasicUser basicUser = this.validate(saveFullProfileParams);
        if (basicUser.equals((Object)(user = (sessionData = this.getSessionData()).getLoggedUser()))) {
            this.passwordHandler.accessor(CredentialUsage.CONFIRMATION).check(saveFullProfileParams.getConfirmationPassword(), EditProfileConfirmationField.confirmation());
        }
        this.passwordHandler.ignoreNextConfirmationPasswords();
        SaveFullProfileResult saveFullProfileResult = new SaveFullProfileResult();
        BasicUserDTO basicUserDTO = saveFullProfileParams.getUser();
        if (basicUserDTO != null) {
            try {
                this.applyPermissionsToBasicFields(basicUserDTO, basicUser);
                if (basicUser.isOperator()) {
                    this.operatorService.save((EntityDTO)this.ensureOperatorDTO(basicUserDTO));
                } else {
                    this.userService.save((EntityDTO)((UserDTO)basicUserDTO));
                }
            }
            catch (FrameworkException frameworkException) {
                throw new NestedFrameworkException(frameworkException, USER);
            }
        }
        saveFullProfileResult.setCreatedLandLinePhones(this.save(saveFullProfileParams, CREATE_LAND_LINE_PHONES, (CRUDServiceLocal)this.phoneService));
        this.save(saveFullProfileParams, MODIFY_LAND_LINE_PHONES, (CRUDServiceLocal)this.phoneService);
        saveFullProfileResult.setCreatedMobilePhones(this.save(saveFullProfileParams, CREATE_MOBILE_PHONES, (CRUDServiceLocal)this.phoneService));
        this.save(saveFullProfileParams, MODIFY_MOBILE_PHONES, (CRUDServiceLocal)this.phoneService);
        this.remove(saveFullProfileParams, REMOVE_PHONES, (CRUDServiceLocal<?, ?, ?, ?>)this.phoneService);
        if (basicUser instanceof User) {
            User user2 = (User)basicUser;
            saveFullProfileResult.setCreatedAddresses(this.save(saveFullProfileParams, CREATE_ADDRESSES, (CRUDServiceLocal)this.userAddressService));
            this.save(saveFullProfileParams, MODIFY_ADDRESSES, (CRUDServiceLocal)this.userAddressService);
            this.remove(saveFullProfileParams, REMOVE_ADDRESSES, (CRUDServiceLocal<?, ?, ?, ?>)this.userAddressService);
            HashMap hashMap = new HashMap();
            Function<ImageVO, ImageVO> function = imageVO -> {
                TempImage tempImage = (TempImage)this.conversionHandler.convert(TempImage.class, imageVO);
                Long l = this.userImageService.importTempImage((BaseEntity)user2, tempImage);
                UserImage userImage = (UserImage)this.userImageService.find(l);
                hashMap.put(tempImage, userImage);
                return (ImageVO)this.conversionHandler.convert(ImageVO.class, (Object)userImage);
            };
            saveFullProfileResult.setCreatedImages(this.doThrowing(saveFullProfileParams, ADD_IMAGES, function));
            this.processEach(saveFullProfileParams, REMOVE_IMAGES, object -> {
                try {
                    UserImage userImage = (UserImage)this.conversionHandler.convert(UserImage.class, object);
                    this.userImageService.remove(userImage.getId());
                }
                catch (EntityNotFoundException entityNotFoundException) {
                    // empty catch block
                }
            });
            List list = CollectionHelper.orEmpty((List)saveFullProfileParams.getReorderImages()).stream().map(this.conversionHandler.convertingFunction(Image.class, new Object[0])).map(image -> {
                if (image instanceof TempImage) {
                    return (UserImage)hashMap.get(image);
                }
                return (UserImage)image;
            }).collect(Collectors.toList());
            if (CollectionHelper.isNotEmpty(list)) {
                List list2 = list.stream().map(userImage -> new ImageVO(userImage.getId())).collect(Collectors.toList());
                this.userImageService.saveOrder((IEntity)new UserLocatorVO(user2.getId()), list2);
            }
            saveFullProfileResult.setCreatedContactInfos(this.save(saveFullProfileParams, CREATE_CONTACT_INFOS, (CRUDServiceLocal)this.contactInfoService));
            this.save(saveFullProfileParams, MODIFY_CONTACT_INFOS, (CRUDServiceLocal)this.contactInfoService);
            this.remove(saveFullProfileParams, REMOVE_CONTACT_INFOS, (CRUDServiceLocal<?, ?, ?, ?>)this.contactInfoService);
        }
        return saveFullProfileResult;
    }

    public ChangeOperatorGroupDTO toChangeOperatorGroupDTO(ChangeGroupDTO changeGroupDTO, BasicUser basicUser) {
        OperatorGroup operatorGroup = (OperatorGroup)this.conversionHandler.convert(OperatorGroup.class, (Object)changeGroupDTO.getGroup());
        ChangeOperatorGroupDTO changeOperatorGroupDTO = new ChangeOperatorGroupDTO();
        changeOperatorGroupDTO.setOperator(new OperatorVO(basicUser.getId()));
        changeOperatorGroupDTO.setGroup(operatorGroup == null ? null : new OperatorGroupVO(operatorGroup.getId()));
        changeOperatorGroupDTO.setComment(changeGroupDTO.getComment());
        return changeOperatorGroupDTO;
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
    }

    private void checkMinMax(AggregatedFrameworkExceptions aggregatedFrameworkExceptions, String string, int n, int n2, int n3, int n4) throws ValidationException {
        this.checkMinMax(aggregatedFrameworkExceptions, string, n, n2, n3, n4, false, null);
    }

    private void checkMinMax(AggregatedFrameworkExceptions aggregatedFrameworkExceptions, String string, int n, int n2, int n3, int n4, boolean bl, MessageKey messageKey) throws ValidationException {
        int n5 = n + n2 - n3;
        if (n4 > 0 && n5 > n4) {
            aggregatedFrameworkExceptions.set(string, (FrameworkException)((Object)new MaxItemsException(n4)));
        } else if (n5 <= 0 && bl) {
            String string2 = this.message(messageKey, new Object[0]);
            aggregatedFrameworkExceptions.set(string, (FrameworkException)((Object)new ValidationException(this.message(GeneralKeys.Errors.REQUIRED, string2))));
        }
    }

    private <T, R> List<R> doThrowing(SaveFullProfileParams saveFullProfileParams, String string, Function<T, R> function) {
        List list = (List)InvocationContext.wrap((Object)saveFullProfileParams).getPropertyValue(string);
        if (CollectionHelper.isEmpty((Iterable)list)) {
            return Collections.emptyList();
        }
        ArrayList<R> arrayList = new ArrayList<R>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            Object e = list.get(i);
            try {
                arrayList.add(function.apply(e));
                continue;
            }
            catch (FrameworkException frameworkException) {
                throw new NestedFrameworkException(frameworkException, string, Integer.valueOf(i));
            }
        }
        return arrayList;
    }

    private void ensureEmpty(AggregatedFrameworkExceptions aggregatedFrameworkExceptions, String string, Collection<?> collection) {
        if (CollectionHelper.isNotEmpty(collection)) {
            aggregatedFrameworkExceptions.add(string, (FrameworkException)((Object)new ValidationException()));
        }
    }

    private OperatorDTO ensureOperatorDTO(BasicUserDTO basicUserDTO) {
        OperatorDTO operatorDTO;
        if (!(basicUserDTO instanceof OperatorDTO)) {
            operatorDTO = new OperatorDTO();
            basicUserDTO.copyPropertiesTo((Bean)operatorDTO);
            basicUserDTO = operatorDTO;
        }
        operatorDTO = (OperatorDTO)basicUserDTO;
        return operatorDTO;
    }

    private <E extends BaseEntity> void ensureUser(BasicUser basicUser, AggregatedFrameworkExceptions aggregatedFrameworkExceptions, SaveFullProfileParams saveFullProfileParams, String string, Class<E> clazz, Function<E, ? extends BasicUser> function) {
        this.ensureUser(basicUser, aggregatedFrameworkExceptions, saveFullProfileParams, string, clazz, function, null);
    }

    private <E extends BaseEntity> void ensureUser(BasicUser basicUser, AggregatedFrameworkExceptions aggregatedFrameworkExceptions, SaveFullProfileParams saveFullProfileParams, String string, Class<E> clazz, Function<E, ? extends BasicUser> function, Predicate<E> predicate) {
        List list = this.conversionHandler.convertList(clazz, (Iterable)((List)InvocationContext.wrap((Object)saveFullProfileParams).getPropertyValue(string)));
        CollectionHelper.orEmpty((List)list).forEach(baseEntity -> {
            BasicUser basicUser2 = (BasicUser)function.apply(baseEntity);
            EntityNotFoundException entityNotFoundException = null;
            if (!basicUser.equals((Object)basicUser2) || predicate != null && !predicate.test(baseEntity)) {
                entityNotFoundException = new EntityNotFoundException(baseEntity.getClass(), baseEntity.getId());
            }
            aggregatedFrameworkExceptions.add(string, entityNotFoundException);
        });
    }

    private <T> void processEach(SaveFullProfileParams saveFullProfileParams, String string, Consumer<T> consumer) {
        Function<Object, Void> function = object -> {
            consumer.accept(object);
            return null;
        };
        this.doThrowing(saveFullProfileParams, string, function);
    }

    private void remove(SaveFullProfileParams saveFullProfileParams, String string, CRUDServiceLocal<?, ?, ?, ?> cRUDServiceLocal) {
        this.processEach(saveFullProfileParams, string, arg_0 -> cRUDServiceLocal.remove(arg_0));
    }

    private <DTO extends EntityDTO, ADTO extends DTO, E extends BaseEntity> List<Long> save(SaveFullProfileParams saveFullProfileParams, String string, CRUDServiceLocal<E, DTO, ?, ?> cRUDServiceLocal) {
        return this.doThrowing(saveFullProfileParams, string, arg_0 -> cRUDServiceLocal.save(arg_0));
    }

    private <DTO extends EntityDTO, ADTO extends DTO, E extends BaseEntity> void validate(BasicUser basicUser, AggregatedFrameworkExceptions aggregatedFrameworkExceptions, SaveFullProfileParams saveFullProfileParams, String string, CRUDServiceLocal<E, DTO, ?, ?> cRUDServiceLocal, Function<E, ? extends BasicUser> function, Consumer<DTO> consumer) {
        List list = (List)InvocationContext.wrap((Object)saveFullProfileParams).getPropertyValue(string);
        if (list == null) {
            return;
        }
        for (EntityDTO entityDTO : list) {
            Throwable throwable = null;
            if (entityDTO.isPersistent()) {
                BaseEntity baseEntity = (BaseEntity)cRUDServiceLocal.find(entityDTO.getId());
                BasicUser basicUser2 = function.apply(baseEntity);
                if (!basicUser.equals((Object)basicUser2)) {
                    throwable = new EntityNotFoundException(baseEntity.getClass(), baseEntity.getId());
                }
            } else {
                consumer.accept(entityDTO);
            }
            if (throwable == null) {
                try {
                    cRUDServiceLocal.validate(entityDTO);
                }
                catch (FrameworkException frameworkException) {
                    throwable = frameworkException;
                }
            }
            aggregatedFrameworkExceptions.add(string, throwable);
        }
    }

    private BasicUser validate(SaveFullProfileParams saveFullProfileParams) {
        int n;
        int n2;
        User user;
        Object object;
        Object object2;
        UserVO userVO;
        User user2;
        Object object3;
        SessionData sessionData = this.getSessionData();
        BasicUser basicUser = sessionData.getLoggedBasicUser();
        BasicUser basicUser2 = (BasicUser)this.conversionHandler.convert(BasicUser.class, (Object)saveFullProfileParams.getLocator());
        BasicUserVO basicUserVO = new BasicUserVO(basicUser2.getId());
        AggregatedFrameworkExceptions aggregatedFrameworkExceptions = new AggregatedFrameworkExceptions();
        if (basicUser2.equals((Object)basicUser)) {
            object3 = new Validator();
            this.passwordHandler.accessor(CredentialUsage.CONFIRMATION).addRequiredValidation(object3, (PropertyAccess)CONFIRMATION_PASSWORD_ACCESS);
            try {
                this.validate((Validator)object3, saveFullProfileParams, "validate_confirmationPassword");
            }
            catch (FrameworkException frameworkException) {
                aggregatedFrameworkExceptions.set(CONFIRMATION_PASSWORD, frameworkException);
            }
        }
        if (saveFullProfileParams.getUser() != null) {
            object3 = saveFullProfileParams.getUser();
            if (object3.getId() == null) {
                object3.setId(basicUser2.getId());
            } else if (!object3.getId().equals(basicUser2.getId())) {
                throw new EntityNotFoundException(User.class, object3.getId());
            }
            try {
                if (basicUser2.isOperator()) {
                    this.operatorService.validate((EntityDTO)this.ensureOperatorDTO((BasicUserDTO)object3));
                } else {
                    this.userService.validate((EntityDTO)((UserDTO)object3));
                }
            }
            catch (FrameworkException frameworkException) {
                aggregatedFrameworkExceptions.set(USER, frameworkException);
            }
        }
        object3 = phoneDTO -> phoneDTO.setUser(basicUserVO);
        Function<Phone, BasicUser> function = Phone::getUser;
        this.validate(basicUser2, aggregatedFrameworkExceptions, saveFullProfileParams, CREATE_LAND_LINE_PHONES, (CRUDServiceLocal)this.phoneService, (Function)function, (Consumer)object3);
        this.validate(basicUser2, aggregatedFrameworkExceptions, saveFullProfileParams, MODIFY_LAND_LINE_PHONES, (CRUDServiceLocal)this.phoneService, (Function)function, (Consumer)object3);
        this.validate(basicUser2, aggregatedFrameworkExceptions, saveFullProfileParams, CREATE_MOBILE_PHONES, (CRUDServiceLocal)this.phoneService, (Function)function, (Consumer)object3);
        this.validate(basicUser2, aggregatedFrameworkExceptions, saveFullProfileParams, MODIFY_MOBILE_PHONES, (CRUDServiceLocal)this.phoneService, (Function)function, (Consumer)object3);
        this.ensureUser(basicUser2, aggregatedFrameworkExceptions, saveFullProfileParams, REMOVE_PHONES, Phone.class, function);
        if (basicUser2 instanceof User) {
            user2 = (User)basicUser2;
            userVO = new UserVO(user2.getId());
            object2 = userAddressDTO -> userAddressDTO.setUser(userVO);
            object = UserAddress::getUser;
            this.validate((BasicUser)user2, aggregatedFrameworkExceptions, saveFullProfileParams, CREATE_ADDRESSES, (CRUDServiceLocal)this.userAddressService, (Function)object, (Consumer)object2);
            this.validate((BasicUser)user2, aggregatedFrameworkExceptions, saveFullProfileParams, MODIFY_ADDRESSES, (CRUDServiceLocal)this.userAddressService, (Function)object, (Consumer)object2);
            this.ensureUser((BasicUser)user2, aggregatedFrameworkExceptions, saveFullProfileParams, REMOVE_ADDRESSES, (Class)UserAddress.class, (Function)object);
            user = contactInfoDTO -> contactInfoDTO.setUser(userVO);
            Function<ContactInfo, BasicUser> function2 = BaseContactInfo::getUser;
            this.validate((BasicUser)user2, aggregatedFrameworkExceptions, saveFullProfileParams, CREATE_CONTACT_INFOS, (CRUDServiceLocal)this.contactInfoService, (Function)function2, (Consumer)user);
            this.validate((BasicUser)user2, aggregatedFrameworkExceptions, saveFullProfileParams, MODIFY_CONTACT_INFOS, (CRUDServiceLocal)this.contactInfoService, (Function)function2, (Consumer)user);
            this.ensureUser((BasicUser)user2, aggregatedFrameworkExceptions, saveFullProfileParams, REMOVE_CONTACT_INFOS, ContactInfo.class, function2);
            this.ensureUser((BasicUser)user2, aggregatedFrameworkExceptions, saveFullProfileParams, ADD_IMAGES, TempImage.class, TempImage::getUser, tempImage -> tempImage.getTarget() == TempImageTarget.USER_PROFILE && tempImage.getByUser() != null && tempImage.getByUser().equals((Object)basicUser));
            this.ensureUser((BasicUser)user2, aggregatedFrameworkExceptions, saveFullProfileParams, REMOVE_IMAGES, UserImage.class, UserImage::getUser);
            this.ensureUser((BasicUser)user2, aggregatedFrameworkExceptions, saveFullProfileParams, REORDER_IMAGES, Image.class, image -> {
                if (image instanceof TempImage) {
                    TempImage tempImage = (TempImage)image;
                    if (tempImage.getTarget() != TempImageTarget.USER_PROFILE || tempImage.getByUser() == null || !tempImage.getByUser().equals((Object)basicUser)) {
                        return null;
                    }
                    return tempImage.getUser();
                }
                if (image instanceof UserImage) {
                    return ((UserImage)image).getUser();
                }
                return null;
            });
        } else {
            this.ensureEmpty(aggregatedFrameworkExceptions, CREATE_ADDRESSES, saveFullProfileParams.getCreateAddresses());
            this.ensureEmpty(aggregatedFrameworkExceptions, MODIFY_ADDRESSES, saveFullProfileParams.getModifyAddresses());
            this.ensureEmpty(aggregatedFrameworkExceptions, REMOVE_ADDRESSES, saveFullProfileParams.getModifyAddresses());
            this.ensureEmpty(aggregatedFrameworkExceptions, CREATE_CONTACT_INFOS, saveFullProfileParams.getCreateAddresses());
            this.ensureEmpty(aggregatedFrameworkExceptions, MODIFY_CONTACT_INFOS, saveFullProfileParams.getModifyAddresses());
            this.ensureEmpty(aggregatedFrameworkExceptions, REMOVE_CONTACT_INFOS, saveFullProfileParams.getModifyAddresses());
            this.ensureEmpty(aggregatedFrameworkExceptions, ADD_IMAGES, saveFullProfileParams.getModifyAddresses());
            this.ensureEmpty(aggregatedFrameworkExceptions, REMOVE_IMAGES, saveFullProfileParams.getModifyAddresses());
            this.ensureEmpty(aggregatedFrameworkExceptions, REORDER_IMAGES, saveFullProfileParams.getModifyAddresses());
        }
        user2 = this.configurationHandler.getAccessor(basicUser2);
        userVO = this.productsHandler.getAccessor(basicUser2);
        object2 = this.profileFieldHandler.getFieldsByAction(basicUser2, ProfileFieldAction.EDIT);
        object = CollectionHelper.orEmpty((List)saveFullProfileParams.getRemovePhones()).stream().map(l -> (Phone)this.entityManagerHandler.find(Phone.class, l)).collect(Collectors.toList());
        if (object2.contains(BasicProfileField.PHONE)) {
            int n3 = CollectionHelper.size((Collection)saveFullProfileParams.getCreateLandLinePhones());
            int n4 = (int)object.stream().filter(LandLinePhone.class::isInstance).count();
            Map map = this.phoneService.counters(basicUser2);
            this.checkMinMax(aggregatedFrameworkExceptions, LAND_LINE_PHONES, (Integer)map.get(PhoneNature.LANDLINE), n3, n4, userVO.product().getMaxLandlinePhones(), user2.isLandLineRequired(), UsersKeys.Users.LAND_LINE_PHONE);
            n2 = CollectionHelper.size((Collection)saveFullProfileParams.getCreateMobilePhones());
            n = (int)object.stream().filter(MobilePhone.class::isInstance).count();
            this.checkMinMax(aggregatedFrameworkExceptions, MOBILE_PHONES, (Integer)map.get(PhoneNature.MOBILE), n2, n, userVO.product().getMaxMobilePhones(), user2.isMobileRequired(), UsersKeys.Users.MOBILE_PHONE);
        }
        if (basicUser2 instanceof User) {
            user = (User)basicUser2;
            if (object2.contains(BasicProfileField.ADDRESS)) {
                int n5 = CollectionHelper.size((Collection)saveFullProfileParams.getCreateAddresses());
                int n6 = CollectionHelper.size((Collection)saveFullProfileParams.getRemoveAddresses());
                this.checkMinMax(aggregatedFrameworkExceptions, ADDRESSES, this.userAddressService.count(user), n5, n6, userVO.product().getMaxAddresses(), user2.isRequiredAddress(), UsersKeys.Users.ADDRESS);
            }
            int n7 = CollectionHelper.size((Collection)saveFullProfileParams.getCreateContactInfos());
            int n8 = CollectionHelper.size((Collection)saveFullProfileParams.getRemoveContactInfos());
            this.checkMinMax(aggregatedFrameworkExceptions, CONTACT_INFOS, this.contactInfoService.list(user).size(), n7, n8, userVO.member().getMaxContactInfos());
            if (object2.contains(BasicProfileField.IMAGE)) {
                n2 = CollectionHelper.size((Collection)saveFullProfileParams.getAddImages());
                n = CollectionHelper.size((Collection)saveFullProfileParams.getRemoveImages());
                this.checkMinMax(aggregatedFrameworkExceptions, IMAGES, this.userImageService.listByCategory((BaseEntity)user).size(), n2, n, userVO.product().getMaxProfileImages());
            }
        }
        aggregatedFrameworkExceptions.throwIfHasExceptions();
        return basicUser2;
    }

    private static class ConfirmationPasswordAccess
    implements PropertyAccess {
        private ConfirmationPasswordAccess() {
        }

        public Object get(Object object) {
            return ((SaveFullProfileParams)object).getConfirmationPassword();
        }

        public Object getIdentifier() {
            return this.getPropertyName();
        }

        public String getPropertyName() {
            return InternalBasicUserServiceImpl.CONFIRMATION_PASSWORD;
        }
    }
}

