/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.cyclos.entities.users.IMemberOrBrokerProduct;
import org.cyclos.entities.users.Product;
import org.cyclos.entities.users.ProductOperatorProfileField;
import org.cyclos.entities.users.UserProductNotification;
import org.cyclos.impl.BaseNetworkedHandlerImpl;
import org.cyclos.impl.users.OperationPermissionHandlerImpl;
import org.cyclos.impl.users.PermissionHandler;
import org.cyclos.impl.users.ProductConversionHandlerImpl;
import org.cyclos.impl.utils.notifications.UserNotificationMapping;
import org.cyclos.model.ListProperty;
import org.cyclos.model.Property;
import org.cyclos.model.SetProperty;
import org.cyclos.model.access.Permission;
import org.cyclos.model.messaging.notifications.UserNotificationType;
import org.cyclos.model.users.UsersKeys;
import org.cyclos.model.users.products.ActiveUserProductsData;
import org.cyclos.model.users.products.IMemberOrBrokerProductDTO;
import org.cyclos.model.users.products.MemberProductDTO;
import org.cyclos.model.users.products.MyOperatorsOperation;
import org.cyclos.model.users.products.ProductDTO;
import org.cyclos.model.users.products.ProductOperatorProfileFieldDTO;
import org.cyclos.model.users.products.UserProductNotificationDTO;
import org.cyclos.model.users.users.ProfileField;
import org.cyclos.server.utils.ClassHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.MessageKey;
import org.springframework.stereotype.Component;

@Component
public class MemberOrBrokerProductConversionHandlerImpl
extends BaseNetworkedHandlerImpl {
    public void fillToDTO(IMemberOrBrokerProduct iMemberOrBrokerProduct, IMemberOrBrokerProductDTO iMemberOrBrokerProductDTO) {
        this.ensureOperatorProfileFields(iMemberOrBrokerProduct, iMemberOrBrokerProductDTO);
        this.ensureNotifications(iMemberOrBrokerProduct, iMemberOrBrokerProductDTO);
    }

    public <P extends Product, DTO extends ProductDTO> void registerHandlers(ProductConversionHandlerImpl<P, DTO, ActiveUserProductsData> productConversionHandlerImpl) {
        SetProperty setProperty = (SetProperty)this.property(productConversionHandlerImpl, (Property<?, ?>)MemberProductDTO.MY_OPERATORS);
        productConversionHandlerImpl.register(new OperationPermissionHandlerImpl(setProperty, ActiveUserProductsData.MY_OPERATORS, UsersKeys.Products.MY_OPERATORS).master(MyOperatorsOperation.ENABLE, Permission.MY_OPERATORS_ENABLE).map(MyOperatorsOperation.MANAGE_OPERATORS, Permission.MY_OPERATORS_MANAGE_OPERATORS).map(MyOperatorsOperation.MANAGE_GROUPS, Permission.MY_OPERATORS_MANAGE_GROUPS));
        final ListProperty listProperty = (ListProperty)this.property(productConversionHandlerImpl, (Property<?, ?>)MemberProductDTO.NOTIFICATIONS);
        productConversionHandlerImpl.register(new PermissionHandler<DTO, ActiveUserProductsData>(){

            public Property<?, DTO> getDTOProperty() {
                return listProperty;
            }

            public MessageKey getKey() {
                return UsersKeys.Products.NOTIFICATIONS;
            }

            public List<Permission> getPermissions() {
                return Collections.singletonList(Permission.MY_NOTIFICATIONS_ENABLE);
            }

            public void writePermissions(DTO DTO, Collection<Permission> collection) {
                CollectionHelper.addOrRemove(collection, (Object)Permission.MY_NOTIFICATIONS_ENABLE, (boolean)MemberOrBrokerProductConversionHandlerImpl.this.hasEnabledNotifications((IMemberOrBrokerProductDTO)DTO));
            }
        });
    }

    private void ensureNotifications(IMemberOrBrokerProduct iMemberOrBrokerProduct, IMemberOrBrokerProductDTO iMemberOrBrokerProductDTO) {
        ArrayList arrayList = new ArrayList();
        iMemberOrBrokerProductDTO.setNotifications(arrayList);
        UserNotificationMapping.list().stream().filter(userNotificationType -> userNotificationType.getRole() == iMemberOrBrokerProduct.getRole()).forEach(userNotificationType -> {
            UserProductNotificationDTO userProductNotificationDTO = this.getUserProductNotificationDTO((UserNotificationType)userNotificationType, iMemberOrBrokerProduct);
            if (userProductNotificationDTO == null) {
                userProductNotificationDTO = new UserProductNotificationDTO();
                userProductNotificationDTO.setType(userNotificationType);
            }
            arrayList.add(userProductNotificationDTO);
        });
    }

    private void ensureOperatorProfileFields(IMemberOrBrokerProduct iMemberOrBrokerProduct, IMemberOrBrokerProductDTO iMemberOrBrokerProductDTO) {
        List list = this.profileFieldHandler.getAllProfileFieldsForOperators();
        iMemberOrBrokerProductDTO.setOperatorProfileFields(new ArrayList());
        for (ProfileField profileField : list) {
            ProductOperatorProfileFieldDTO productOperatorProfileFieldDTO = this.getProductOperatorProfileFieldDTO(profileField, iMemberOrBrokerProduct);
            if (productOperatorProfileFieldDTO == null) {
                productOperatorProfileFieldDTO = new ProductOperatorProfileFieldDTO();
                productOperatorProfileFieldDTO.setProfileField(this.profileFieldHandler.toVO(profileField));
            }
            iMemberOrBrokerProductDTO.getOperatorProfileFields().add(productOperatorProfileFieldDTO);
        }
    }

    private ProductOperatorProfileFieldDTO getProductOperatorProfileFieldDTO(ProfileField profileField, IMemberOrBrokerProduct iMemberOrBrokerProduct) {
        for (ProductOperatorProfileField productOperatorProfileField : iMemberOrBrokerProduct.getOperatorProfileFields()) {
            if (!profileField.equals((Object)productOperatorProfileField.getProfileField())) continue;
            return (ProductOperatorProfileFieldDTO)this.conversionHandler.convert(ProductOperatorProfileFieldDTO.class, (Object)productOperatorProfileField);
        }
        return null;
    }

    private UserProductNotificationDTO getUserProductNotificationDTO(UserNotificationType userNotificationType, IMemberOrBrokerProduct iMemberOrBrokerProduct) {
        for (UserProductNotification userProductNotification : iMemberOrBrokerProduct.getNotifications()) {
            if (!userProductNotification.getType().equals((Object)userNotificationType)) continue;
            return (UserProductNotificationDTO)this.conversionHandler.convert(UserProductNotificationDTO.class, (Object)userProductNotification);
        }
        return null;
    }

    private boolean hasEnabledNotifications(IMemberOrBrokerProductDTO iMemberOrBrokerProductDTO) {
        if (CollectionHelper.isNotEmpty((Iterable)iMemberOrBrokerProductDTO.getNotifications())) {
            for (UserProductNotificationDTO userProductNotificationDTO : iMemberOrBrokerProductDTO.getNotifications()) {
                if (!userProductNotificationDTO.isEnabled()) continue;
                return true;
            }
        }
        return false;
    }

    private <P extends Property<T, DTO>, T, DTO extends ProductDTO> P property(ProductConversionHandlerImpl<?, DTO, ActiveUserProductsData> productConversionHandlerImpl, Property<?, ?> property) {
        ProductDTO productDTO = (ProductDTO)ClassHelper.instantiate(productConversionHandlerImpl.getDTOType());
        return (P)productDTO.property(property.getName());
    }
}

