/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import com.querydsl.core.types.Path;
import com.querydsl.core.types.dsl.NumberPath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.cyclos.entities.access.PrincipalType;
import org.cyclos.entities.access.TokenPrincipalType;
import org.cyclos.entities.banking.PaymentTransferType;
import org.cyclos.entities.banking.UserAccountType;
import org.cyclos.entities.banking.VoucherConfiguration;
import org.cyclos.entities.marketplace.AdCustomField;
import org.cyclos.entities.system.CustomOperation;
import org.cyclos.entities.system.UserWizard;
import org.cyclos.entities.users.IMemberOrBrokerProduct;
import org.cyclos.entities.users.MemberProduct;
import org.cyclos.entities.users.MemberProductCustomOperation;
import org.cyclos.entities.users.MemberProductCustomWizard;
import org.cyclos.entities.users.ProductMemberVoucher;
import org.cyclos.entities.users.ProductMyAdField;
import org.cyclos.entities.users.ProductMyTokenType;
import org.cyclos.entities.users.QMemberProduct;
import org.cyclos.impl.marketplace.AdCustomFieldServiceLocal;
import org.cyclos.impl.system.CustomOperationServiceLocal;
import org.cyclos.impl.system.CustomWizardServiceLocal;
import org.cyclos.impl.users.BooleanPermissionHandlerImpl;
import org.cyclos.impl.users.CollectionPermissionHandlerImpl;
import org.cyclos.impl.users.EnumPermissionHandlerImpl;
import org.cyclos.impl.users.IntegerPermissionHandlerImpl;
import org.cyclos.impl.users.MemberOrBrokerProductConversionHandlerImpl;
import org.cyclos.impl.users.OperationPermissionHandlerImpl;
import org.cyclos.impl.users.PermissionHandler;
import org.cyclos.impl.users.ProductConversionHandlerImpl;
import org.cyclos.model.Property;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.Role;
import org.cyclos.model.access.principaltypes.PrincipalTypeNature;
import org.cyclos.model.access.principaltypes.TokenPrincipalTypeVO;
import org.cyclos.model.banking.transfertypes.TransferTypeDirection;
import org.cyclos.model.banking.voucherconfigurations.VoucherConfigurationVO;
import org.cyclos.model.banking.voucherconfigurations.VoucherGenerationStatus;
import org.cyclos.model.system.fields.CustomFieldVO;
import org.cyclos.model.system.operations.CustomOperationScope;
import org.cyclos.model.system.operations.CustomOperationVO;
import org.cyclos.model.system.wizards.CustomWizardVO;
import org.cyclos.model.users.UsersKeys;
import org.cyclos.model.users.products.AccountAccessibility;
import org.cyclos.model.users.products.AccountVisibility;
import org.cyclos.model.users.products.ActiveUserProductsData;
import org.cyclos.model.users.products.AuthorizedPaymentsOperation;
import org.cyclos.model.users.products.ExternalPaymentOperation;
import org.cyclos.model.users.products.IMemberOrBrokerProductDTO;
import org.cyclos.model.users.products.MemberProductCustomOperationDTO;
import org.cyclos.model.users.products.MemberProductCustomWizardDTO;
import org.cyclos.model.users.products.MemberProductDTO;
import org.cyclos.model.users.products.MyMessagesForwardOperation;
import org.cyclos.model.users.products.MyMessagesOperation;
import org.cyclos.model.users.products.MyReferencesOperation;
import org.cyclos.model.users.products.PaymentRequestOperation;
import org.cyclos.model.users.products.ProductMemberVoucherDTO;
import org.cyclos.model.users.products.ProductMyAdFieldDTO;
import org.cyclos.model.users.products.ProductMyTokenTypeDTO;
import org.cyclos.model.users.products.ProductNature;
import org.cyclos.model.users.products.ScheduledPaymentsOperation;
import org.cyclos.model.users.products.TicketsOperation;
import org.cyclos.model.users.products.UserGroupAccessibility;
import org.cyclos.model.users.recordtypes.RecordTypeNature;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.MessageKey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MemberProductConversionHandlerImpl
extends ProductConversionHandlerImpl<MemberProduct, MemberProductDTO, ActiveUserProductsData> {
    @Autowired
    private CustomOperationServiceLocal customOperationService;
    @Autowired
    private AdCustomFieldServiceLocal adCustomFieldService;
    @Autowired
    private MemberOrBrokerProductConversionHandlerImpl memberOrBrokerProductConversionHandler;
    @Autowired
    private CustomWizardServiceLocal customWizardService;

    public MemberProductConversionHandlerImpl() {
        super(MemberProduct.class, MemberProductDTO.class, ActiveUserProductsData.class);
    }

    public ProductNature getProductNature() {
        return ProductNature.MEMBER;
    }

    public Role getRole() {
        return Role.MEMBER;
    }

    @Override
    public void registerHandlers() {
        super.registerHandlers();
        this.memberOrBrokerProductConversionHandler.registerHandlers(this);
        this.registerPropertyMapping((Property<?, ?>)MemberProductDTO.SELF_PAYMENTS, (Path<?>)QMemberProduct.memberProduct.myPaymentTypes);
        this.registerPropertyMapping((Property<?, ?>)MemberProductDTO.USER_PAYMENTS, (Path<?>)QMemberProduct.memberProduct.myPaymentTypes);
        this.registerPropertyMapping((Property<?, ?>)MemberProductDTO.SYSTEM_PAYMENTS, (Path<?>)QMemberProduct.memberProduct.myPaymentTypes);
        this.registerPropertyMapping((Property<?, ?>)MemberProductDTO.MY_PAYMENT_REQUESTS_SEND_TO_SYSTEM, (Path<?>)QMemberProduct.memberProduct.myPaymentRequestTypes);
        this.registerPropertyMapping((Property<?, ?>)MemberProductDTO.MY_PAYMENT_REQUESTS_SEND_TO_USER, (Path<?>)QMemberProduct.memberProduct.myPaymentRequestTypes);
        this.registerPropertyMapping((Property<?, ?>)MemberProductDTO.MY_EXTERNAL_PAYMENT_TYPES, (Path<?>)QMemberProduct.memberProduct.myExternalPaymentTypes);
        this.registerPropertyMapping((Property<?, ?>)MemberProductDTO.MY_CREATE_TICKET_PAYMENT_TYPES, (Path<?>)QMemberProduct.memberProduct.myCreateTicketPaymentTypes);
        this.registerPropertyMapping((Property<?, ?>)MemberProductDTO.MY_APPROVE_TICKET_PAYMENT_TYPES, (Path<?>)QMemberProduct.memberProduct.myApproveTicketPaymentTypes);
        this.register(new EnumPermissionHandlerImpl<UserGroupAccessibility, MemberProduct, MemberProductDTO, ActiveUserProductsData>(Permission.USER_VISIBILITY_SEARCH, QMemberProduct.memberProduct.searchUsersOnGroups, (Property)MemberProductDTO.SEARCH_USERS_ON_GROUPS, UsersKeys.Products.SEARCH_USERS_ON_GROUPS){

            public void writePermissions(MemberProductDTO memberProductDTO, Collection<Permission> collection) {
                boolean bl = memberProductDTO.getSearchUsersOnGroups() != null && memberProductDTO.getSearchUsersOnGroups() != UserGroupAccessibility.NONE;
                CollectionHelper.addOrRemove(collection, (Object)Permission.USER_VISIBILITY_SEARCH, (boolean)bl);
            }
        });
        this.register(new EnumPermissionHandlerImpl<UserGroupAccessibility, MemberProduct, MemberProductDTO, ActiveUserProductsData>(Permission.USER_VISIBILITY_PROFILE, QMemberProduct.memberProduct.viewProfileOnGroups, (Property)MemberProductDTO.VIEW_PROFILE_ON_GROUPS, UsersKeys.Products.VIEW_PROFILE_ON_GROUPS){

            public void writePermissions(MemberProductDTO memberProductDTO, Collection<Permission> collection) {
                boolean bl = memberProductDTO.getViewProfileOnGroups() != null && memberProductDTO.getViewProfileOnGroups() != UserGroupAccessibility.NONE;
                CollectionHelper.addOrRemove(collection, (Object)Permission.USER_VISIBILITY_PROFILE, (boolean)bl);
            }
        });
        this.register(new BooleanPermissionHandlerImpl(Permission.USER_OPERATORS_PAY, MemberProductDTO.USER_OPERATORS_PAY, ActiveUserProductsData.USER_OPERATORS_PAY, UsersKeys.Products.USER_OPERATORS_PAY));
        this.register(new IntegerPermissionHandlerImpl(Permission.MY_CUSTOM_IMAGES_ENABLE, (NumberPath<Integer>)QMemberProduct.memberProduct.maxCustomImages, MemberProductDTO.MAX_CUSTOM_IMAGES, UsersKeys.Products.MAX_CUSTOM_IMAGES));
        this.register(new CollectionPermissionHandlerImpl(Permission.MY_PAYMENTS_PAY_TO_SYSTEM, MemberProductDTO.SYSTEM_PAYMENTS, UsersKeys.Products.SYSTEM_PAYMENTS));
        this.register(new CollectionPermissionHandlerImpl(Permission.MY_PAYMENTS_PAY_TO_USER, MemberProductDTO.USER_PAYMENTS, UsersKeys.Products.USER_PAYMENTS));
        this.register(new OperationPermissionHandlerImpl(MemberProductDTO.MY_EXTERNAL_PAYMENTS, ActiveUserProductsData.MY_EXTERNAL_PAYMENTS, UsersKeys.Products.MY_EXTERNAL_PAYMENTS).master(ExternalPaymentOperation.VIEW, Permission.MY_EXTERNAL_PAYMENTS_VIEW).map(ExternalPaymentOperation.CANCEL, Permission.MY_EXTERNAL_PAYMENTS_CANCEL));
        this.register(new CollectionPermissionHandlerImpl(Permission.MY_EXTERNAL_PAYMENTS_PAY_TO_USER, MemberProductDTO.MY_EXTERNAL_PAYMENT_TYPES, UsersKeys.Products.MY_EXTERNAL_PAYMENT_TYPES));
        this.register(new CollectionPermissionHandlerImpl(Permission.MY_PAYMENT_TICKETS_CREATE, MemberProductDTO.MY_CREATE_TICKET_PAYMENT_TYPES, UsersKeys.Products.MY_CREATE_TICKET_PAYMENT_TYPES));
        this.register(new CollectionPermissionHandlerImpl(Permission.MY_PAYMENT_TICKETS_APPROVE, MemberProductDTO.MY_APPROVE_TICKET_PAYMENT_TYPES, UsersKeys.Products.MY_APPROVE_TICKET_PAYMENT_TYPES));
        this.register(new CollectionPermissionHandlerImpl(Permission.MY_PAYMENTS_RECEIVE, MemberProductDTO.RECEIVE_POS_PAYMENT_TYPES, UsersKeys.Products.RECEIVE_POS_PAYMENT_TYPES));
        this.register(new CollectionPermissionHandlerImpl(Permission.MY_PAYMENTS_PAY_TO_SELF, MemberProductDTO.SELF_PAYMENTS, UsersKeys.Products.SELF_PAYMENTS));
        this.register(new CollectionPermissionHandlerImpl(Permission.MY_PAYMENT_REQUESTS_SEND_TO_SYSTEM, MemberProductDTO.MY_PAYMENT_REQUESTS_SEND_TO_SYSTEM, UsersKeys.Products.MY_PAYMENT_REQUESTS_SEND_TO_SYSTEM));
        this.register(new CollectionPermissionHandlerImpl(Permission.MY_PAYMENT_REQUESTS_SEND_TO_USER, MemberProductDTO.MY_PAYMENT_REQUESTS_SEND_TO_USER, UsersKeys.Products.MY_PAYMENT_REQUESTS_SEND_TO_USER));
        this.register(new OperationPermissionHandlerImpl(MemberProductDTO.MY_PAYMENT_REQUESTS, ActiveUserProductsData.MY_PAYMENT_REQUESTS, UsersKeys.Products.MY_PAYMENT_REQUESTS).master(PaymentRequestOperation.VIEW, Permission.MY_PAYMENT_REQUESTS_VIEW).map(PaymentRequestOperation.ACCEPT, Permission.MY_PAYMENT_REQUESTS_ACCEPT).map(PaymentRequestOperation.CANCEL, Permission.MY_PAYMENT_REQUESTS_CANCEL).map(PaymentRequestOperation.CHANGE_EXPIRATION_DATE, Permission.MY_PAYMENT_REQUESTS_CHANGE_EXPIRATION_DATE));
        this.register(new OperationPermissionHandlerImpl(MemberProductDTO.MY_TICKETS, ActiveUserProductsData.MY_TICKETS, UsersKeys.Products.MY_TICKETS).master(TicketsOperation.VIEW, Permission.MY_PAYMENT_TICKETS_VIEW).map(TicketsOperation.CANCEL, Permission.MY_PAYMENT_TICKETS_CANCEL));
        this.register(new OperationPermissionHandlerImpl(MemberProductDTO.MY_SCHEDULED_PAYMENTS, ActiveUserProductsData.MY_SCHEDULED_PAYMENTS, UsersKeys.Products.MY_SCHEDULED_PAYMENTS).master(ScheduledPaymentsOperation.VIEW, Permission.MY_SCHEDULED_PAYMENTS_VIEW).map(ScheduledPaymentsOperation.CANCEL, Permission.MY_SCHEDULED_PAYMENTS_CANCEL).map(ScheduledPaymentsOperation.MODIFY, Permission.MY_SCHEDULED_PAYMENTS_MODIFY).map(ScheduledPaymentsOperation.BLOCK, Permission.MY_SCHEDULED_PAYMENTS_BLOCK).map(ScheduledPaymentsOperation.UNBLOCK, Permission.MY_SCHEDULED_PAYMENTS_UNBLOCK).map(ScheduledPaymentsOperation.PROCESS_INSTALLMENT, Permission.MY_SCHEDULED_PAYMENTS_PROCESS_INSTALLMENT).map(ScheduledPaymentsOperation.SETTLE_INSTALLMENT, Permission.MY_SCHEDULED_PAYMENTS_SETTLE_INSTALLMENT));
        this.register(new OperationPermissionHandlerImpl(MemberProductDTO.MY_AUTHORIZED_PAYMENTS, ActiveUserProductsData.MY_AUTHORIZED_PAYMENTS, UsersKeys.Products.MY_AUTHORIZED_PAYMENTS).master(AuthorizedPaymentsOperation.VIEW, Permission.MY_AUTHORIZED_PAYMENTS_VIEW).map(AuthorizedPaymentsOperation.CANCEL, Permission.MY_AUTHORIZED_PAYMENTS_CANCEL).map(AuthorizedPaymentsOperation.AUTHORIZE, Permission.MY_AUTHORIZED_PAYMENTS_AUTHORIZE));
        this.register(new CollectionPermissionHandlerImpl(Permission.MY_PAYMENTS_CHARGEBACK, MemberProductDTO.CHARGEBACK_PAYMENT_TYPES, UsersKeys.Products.CHARGEBACK_PAYMENT_TYPES));
        this.register(new BooleanPermissionHandlerImpl(Permission.MY_IMPORTED_PAYMENTS_ENABLE, MemberProductDTO.MY_IMPORTED_PAYMENTS, ActiveUserProductsData.MY_IMPORTED_PAYMENTS, UsersKeys.Products.MY_IMPORTED_PAYMENTS));
        this.register(new CollectionPermissionHandlerImpl(Permission.USERS_REGISTER, MemberProductDTO.USER_REGISTRATION_GROUPS, UsersKeys.Products.USER_REGISTRATION));
        this.register(new BooleanPermissionHandlerImpl(Permission.USER_ADS_VIEW, MemberProductDTO.USER_ADS_VIEW, ActiveUserProductsData.USER_ADS_VIEW, UsersKeys.Products.USER_ADS_VIEW));
        this.register(new BooleanPermissionHandlerImpl(Permission.USER_WEB_SHOP_VIEW, MemberProductDTO.USER_WEB_SHOP_VIEW, ActiveUserProductsData.USER_WEB_SHOP_VIEW, UsersKeys.Products.USER_WEB_SHOP_VIEW));
        this.register(new BooleanPermissionHandlerImpl(Permission.USER_WEB_SHOP_PURCHASE, MemberProductDTO.USER_WEB_SHOP_VIEW, ActiveUserProductsData.USER_WEB_SHOP_VIEW, UsersKeys.Products.USER_WEB_SHOP_VIEW));
        this.register(new BooleanPermissionHandlerImpl(Permission.MY_ADS_ENABLE, MemberProductDTO.MY_ADS_ENABLE, ActiveUserProductsData.MY_ADS_ENABLE, UsersKeys.Products.MY_ADS_ENABLE));
        this.register(new BooleanPermissionHandlerImpl<MemberProduct, MemberProductDTO, ActiveUserProductsData>(Permission.MY_ADS_MANAGE, (Property)MemberProductDTO.MY_ADS_MANAGE, (Property)ActiveUserProductsData.MY_ADS_MANAGE, UsersKeys.Products.MY_ADS_MANAGE){

            @Override
            public void writePermissions(MemberProductDTO memberProductDTO, Collection<Permission> collection) {
                CollectionHelper.addOrRemove(collection, (Object)Permission.MY_ADS_MANAGE, (memberProductDTO.isMyAdsManage() && memberProductDTO.isMyAdsEnable() ? 1 : 0) != 0);
            }
        });
        this.register(new BooleanPermissionHandlerImpl<MemberProduct, MemberProductDTO, ActiveUserProductsData>(Permission.MY_AD_QUESTIONS_ENABLE, (Property)MemberProductDTO.MY_AD_QUESTIONS_ENABLE, (Property)ActiveUserProductsData.MY_AD_QUESTIONS_ENABLE, UsersKeys.Products.MY_AD_QUESTIONS_ENABLE){

            @Override
            public void writePermissions(MemberProductDTO memberProductDTO, Collection<Permission> collection) {
                CollectionHelper.addOrRemove(collection, (Object)Permission.MY_AD_QUESTIONS_ENABLE, (memberProductDTO.isMyAdQuestionsEnable() && memberProductDTO.isMyAdsManage() && memberProductDTO.isMyAdsEnable() ? 1 : 0) != 0);
            }
        });
        this.register(new BooleanPermissionHandlerImpl<MemberProduct, MemberProductDTO, ActiveUserProductsData>(Permission.MY_WEB_SHOP_QUESTIONS_ENABLE, (Property)MemberProductDTO.MY_WEB_SHOP_QUESTIONS_ENABLE, (Property)ActiveUserProductsData.MY_WEB_SHOP_QUESTIONS_ENABLE, UsersKeys.Products.MY_WEB_SHOP_QUESTIONS_ENABLE){

            @Override
            public void writePermissions(MemberProductDTO memberProductDTO, Collection<Permission> collection) {
                CollectionHelper.addOrRemove(collection, (Object)Permission.MY_WEB_SHOP_QUESTIONS_ENABLE, (memberProductDTO.isMyWebShopQuestionsEnable() && memberProductDTO.isMyWebShopManage() && memberProductDTO.isMyWebShopEnable() ? 1 : 0) != 0);
            }
        });
        this.register(new BooleanPermissionHandlerImpl(Permission.MY_WEB_SHOP_ENABLE, MemberProductDTO.MY_WEB_SHOP_ENABLE, ActiveUserProductsData.MY_WEB_SHOP_ENABLE, UsersKeys.Products.MY_WEB_SHOP_ENABLE));
        this.register(new BooleanPermissionHandlerImpl<MemberProduct, MemberProductDTO, ActiveUserProductsData>(Permission.MY_WEB_SHOP_MANAGE, (Property)MemberProductDTO.MY_WEB_SHOP_MANAGE, (Property)ActiveUserProductsData.MY_WEB_SHOP_MANAGE, UsersKeys.Products.MY_WEB_SHOP_MANAGE){

            @Override
            public void writePermissions(MemberProductDTO memberProductDTO, Collection<Permission> collection) {
                CollectionHelper.addOrRemove(collection, (Object)Permission.MY_WEB_SHOP_MANAGE, (memberProductDTO.isMyWebShopManage() && memberProductDTO.isMyWebShopEnable() ? 1 : 0) != 0);
            }
        });
        this.register(new BooleanPermissionHandlerImpl<MemberProduct, MemberProductDTO, ActiveUserProductsData>(Permission.MY_AD_INTERESTS_ENABLE, (Property)MemberProductDTO.AD_INTERESTS, (Property)ActiveUserProductsData.AD_INTERESTS, UsersKeys.Products.AD_INTERESTS){

            @Override
            public void writePermissions(MemberProductDTO memberProductDTO, Collection<Permission> collection) {
                CollectionHelper.addOrRemove(collection, (Object)Permission.MY_AD_INTERESTS_ENABLE, (memberProductDTO.isAdInterests() && (memberProductDTO.isUserAdsView() || memberProductDTO.isUserWebShopView()) ? 1 : 0) != 0);
            }
        });
        this.register(new BooleanPermissionHandlerImpl<MemberProduct, MemberProductDTO, ActiveUserProductsData>(Permission.MY_FAVORITE_ADS_ENABLE, (Property)MemberProductDTO.MY_FAVORITE_ADS_ENABLE, (Property)ActiveUserProductsData.MY_FAVORITE_ADS_ENABLE, UsersKeys.Products.MY_FAVORITE_ADS_ENABLE){

            @Override
            public void writePermissions(MemberProductDTO memberProductDTO, Collection<Permission> collection) {
                CollectionHelper.addOrRemove(collection, (Object)Permission.MY_FAVORITE_ADS_ENABLE, (memberProductDTO.isMyFavoriteAdsEnable() && (memberProductDTO.isUserAdsView() || memberProductDTO.isUserWebShopView()) ? 1 : 0) != 0);
            }
        });
        this.register(new OperationPermissionHandlerImpl(MemberProductDTO.MY_MESSAGES, ActiveUserProductsData.MY_MESSAGES, UsersKeys.Products.MY_MESSAGES).master(MyMessagesOperation.VIEW, Permission.MY_MESSAGES_VIEW).map(MyMessagesOperation.SEND_TO_USER, Permission.MY_MESSAGES_SEND_TO_USER));
        this.register(new EnumPermissionHandlerImpl<MyMessagesForwardOperation, MemberProduct, MemberProductDTO, ActiveUserProductsData>(Permission.MY_MESSAGES_FORWARD_TO_EMAIL, QMemberProduct.memberProduct.fwdMessageToEmail, (Property)MemberProductDTO.FWD_MESSAGE_TO_EMAIL, UsersKeys.Products.FWD_MESSAGE_TO_EMAIL){

            public void writePermissions(MemberProductDTO memberProductDTO, Collection<Permission> collection) {
                CollectionHelper.addOrRemove(collection, (Object)Permission.MY_MESSAGES_FORWARD_TO_EMAIL, (collection.contains(Permission.MY_MESSAGES_VIEW) && memberProductDTO.getFwdMessageToEmail() != MyMessagesForwardOperation.DISABLED ? 1 : 0) != 0);
            }
        });
        this.register(new CollectionPermissionHandlerImpl(Permission.MY_MESSAGES_SEND_TO_SYSTEM, MemberProductDTO.SEND_MESSAGES_TO_ADMIN, UsersKeys.Products.SEND_MESSAGES_TO_ADMIN));
        this.register(new OperationPermissionHandlerImpl(MemberProductDTO.MY_REFERENCES, ActiveUserProductsData.MY_REFERENCES, UsersKeys.Products.MY_REFERENCES).map(MyReferencesOperation.VIEW, Permission.MY_REFERENCES_VIEW).map(MyReferencesOperation.GIVE, Permission.MY_REFERENCES_GIVE).map(MyReferencesOperation.RECEIVE, Permission.MY_REFERENCES_RECEIVE));
        this.register(new OperationPermissionHandlerImpl(MemberProductDTO.MY_TRANSACTION_FEEDBACKS, ActiveUserProductsData.MY_TRANSACTION_FEEDBACKS, UsersKeys.Products.MY_TRANSACTION_FEEDBACKS).map(MyReferencesOperation.VIEW, Permission.MY_TRANSACTION_FEEDBACKS_VIEW).map(MyReferencesOperation.GIVE, Permission.MY_TRANSACTION_FEEDBACKS_GIVE).map(MyReferencesOperation.RECEIVE, Permission.MY_TRANSACTION_FEEDBACKS_RECEIVE));
        this.register(new CollectionPermissionHandlerImpl(Permission.MY_SHARED_DOCUMENTS_VIEW, MemberProductDTO.DOCUMENT_CATEGORY_VIEW, UsersKeys.Products.DOCUMENT_CATEGORY_VIEW));
        this.register(new BooleanPermissionHandlerImpl(Permission.MY_INDIVIDUAL_DOCUMENTS_VIEW, MemberProductDTO.MY_INDIVIDUAL_DOCUMENTS, ActiveUserProductsData.MY_INDIVIDUAL_DOCUMENTS, UsersKeys.Products.MY_INDIVIDUAL_DOCUMENTS));
        this.register(new PermissionHandler<MemberProductDTO, ActiveUserProductsData>(){

            public Property<?, ? super MemberProductDTO> getDTOProperty() {
                return MemberProductDTO.VOUCHERS;
            }

            public MessageKey getKey() {
                return UsersKeys.Products.VOUCHERS;
            }

            public List<Permission> getPermissions() {
                return Arrays.asList(Permission.MY_VOUCHERS_VIEW_VOUCHERS, Permission.MY_VOUCHERS_BUY, Permission.MY_VOUCHERS_SEND, Permission.MY_VOUCHERS_BATCH_SEND, Permission.MY_VOUCHERS_VIEW_TRANSACTIONS, Permission.MY_VOUCHERS_REDEEM, Permission.MY_VOUCHERS_TOP_UP);
            }

            public void writePermissions(MemberProductDTO memberProductDTO, Collection<Permission> collection) {
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                boolean bl4 = false;
                boolean bl5 = false;
                boolean bl6 = false;
                boolean bl7 = false;
                List list = memberProductDTO.getVouchers();
                if (list != null) {
                    for (ProductMemberVoucherDTO productMemberVoucherDTO : list) {
                        VoucherConfiguration voucherConfiguration = (VoucherConfiguration)MemberProductConversionHandlerImpl.this.conversionHandler.convert(VoucherConfiguration.class, (Object)productMemberVoucherDTO.getConfiguration());
                        if (productMemberVoucherDTO.isViewTransactions()) {
                            bl = true;
                            if (productMemberVoucherDTO.isRedeem()) {
                                bl2 = true;
                            }
                        }
                        if (productMemberVoucherDTO.isViewVouchers()) {
                            bl3 = true;
                        }
                        if (voucherConfiguration.getGenerationStatus() == VoucherGenerationStatus.INACTIVE) {
                            if (!productMemberVoucherDTO.isViewTransactions() || !productMemberVoucherDTO.isTopUp()) continue;
                            bl7 = true;
                            continue;
                        }
                        if (!productMemberVoucherDTO.isViewVouchers()) continue;
                        if (productMemberVoucherDTO.isBuy()) {
                            bl4 = true;
                        }
                        if (productMemberVoucherDTO.isSend()) {
                            bl5 = true;
                        }
                        if (!productMemberVoucherDTO.isSendBatch()) continue;
                        bl6 = true;
                    }
                }
                CollectionHelper.addOrRemove(collection, (Object)Permission.MY_VOUCHERS_VIEW_TRANSACTIONS, (boolean)bl);
                CollectionHelper.addOrRemove(collection, (Object)Permission.MY_VOUCHERS_REDEEM, (boolean)bl2);
                CollectionHelper.addOrRemove(collection, (Object)Permission.MY_VOUCHERS_VIEW_VOUCHERS, (boolean)bl3);
                CollectionHelper.addOrRemove(collection, (Object)Permission.MY_VOUCHERS_BUY, (boolean)bl4);
                CollectionHelper.addOrRemove(collection, (Object)Permission.MY_VOUCHERS_SEND, (boolean)bl5);
                CollectionHelper.addOrRemove(collection, (Object)Permission.MY_VOUCHERS_BATCH_SEND, (boolean)bl6);
                CollectionHelper.addOrRemove(collection, (Object)Permission.MY_VOUCHERS_TOP_UP, (boolean)bl7);
            }
        });
        this.register(new EnumPermissionHandlerImpl<AccountVisibility, MemberProduct, MemberProductDTO, ActiveUserProductsData>(Permission.MY_ACCOUNT_VISIBILITY_ENABLE, QMemberProduct.memberProduct.accountVisibility, (Property)MemberProductDTO.ACCOUNT_VISIBILITY, UsersKeys.Products.ACCOUNT_VISIBILITY){

            public void writePermissions(MemberProductDTO memberProductDTO, Collection<Permission> collection) {
                boolean bl = memberProductDTO.getUserAccount() != null && memberProductDTO.getAccountVisibility() != null && memberProductDTO.getAccountVisibility().canConfigure();
                CollectionHelper.addOrRemove(collection, (Object)Permission.MY_ACCOUNT_VISIBILITY_ENABLE, (boolean)bl);
            }
        });
    }

    @Override
    public MemberProductDTO toDTO(MemberProduct memberProduct) {
        MemberProductDTO memberProductDTO = (MemberProductDTO)super.toDTO(memberProduct);
        this.ensureVouchers(memberProduct, memberProductDTO);
        this.ensureCustomOperations(memberProduct, memberProductDTO);
        this.ensureWizards(memberProduct, memberProductDTO);
        this.ensureMyTokenTypes(memberProduct, memberProductDTO);
        this.ensureMyAdFields(memberProduct, memberProductDTO);
        this.memberOrBrokerProductConversionHandler.fillToDTO((IMemberOrBrokerProduct)memberProduct, (IMemberOrBrokerProductDTO)memberProductDTO);
        return memberProductDTO;
    }

    @Override
    public MemberProduct toEntity(MemberProductDTO memberProductDTO) {
        UserAccountType userAccountType = (UserAccountType)this.conversionHandler.convert(UserAccountType.class, (Object)memberProductDTO.getUserAccount());
        Set<Object> set = userAccountType == null ? Collections.emptySet() : Collections.singleton(userAccountType);
        memberProductDTO.setSystemPayments(this.filterPaymentTypesByFromAccount(memberProductDTO.getSystemPayments(), set, TransferTypeDirection.USER_TO_SYSTEM));
        memberProductDTO.setUserPayments(this.filterPaymentTypesByFromAccount(memberProductDTO.getUserPayments(), set, TransferTypeDirection.USER_TO_USER));
        memberProductDTO.setSelfPayments(this.filterPaymentTypesByFromOrToAccount(memberProductDTO.getSelfPayments(), set, TransferTypeDirection.USER_TO_SELF));
        memberProductDTO.setChargebackPaymentTypes(this.filterPaymentTypesByToAccount(memberProductDTO.getChargebackPaymentTypes(), set, TransferTypeDirection.USER_TO_USER, TransferTypeDirection.SYSTEM_TO_USER, TransferTypeDirection.USER_TO_SELF));
        memberProductDTO.setMyTransferFilters(this.filterTransferFilters(memberProductDTO.getMyTransferFilters(), set));
        memberProductDTO.setMyExternalPaymentTypes(this.filterPaymentTypesByFromAccount(memberProductDTO.getMyExternalPaymentTypes(), set, TransferTypeDirection.USER_TO_USER));
        memberProductDTO.setMakePosPaymentTypes(this.filterPaymentTypesByFromAccount(memberProductDTO.getMakePosPaymentTypes(), set, TransferTypeDirection.USER_TO_USER));
        memberProductDTO.setReceivePosPaymentTypes(this.filterPaymentTypesByToAccount(memberProductDTO.getReceivePosPaymentTypes(), set, TransferTypeDirection.USER_TO_USER));
        memberProductDTO.setMyPaymentRequestsSendToUser(this.filterPaymentTypesByToAccount(memberProductDTO.getMyPaymentRequestsSendToUser(), set, TransferTypeDirection.USER_TO_USER));
        memberProductDTO.setMyPaymentRequestsSendToSystem(this.filterPaymentTypesByToAccount(memberProductDTO.getMyPaymentRequestsSendToSystem(), set, TransferTypeDirection.SYSTEM_TO_USER));
        memberProductDTO.setMyCreateTicketPaymentTypes(this.filterPaymentTypesByToAccount(memberProductDTO.getMyCreateTicketPaymentTypes(), set, TransferTypeDirection.USER_TO_USER));
        memberProductDTO.setMyApproveTicketPaymentTypes(this.filterPaymentTypesByFromAccount(memberProductDTO.getMyApproveTicketPaymentTypes(), set, TransferTypeDirection.USER_TO_USER));
        if (userAccountType == null) {
            memberProductDTO.setAccountAccessibility(null);
            memberProductDTO.setAccountVisibility(null);
        } else if (memberProductDTO.getAccountAccessibility() == AccountAccessibility.NEVER) {
            memberProductDTO.setAccountVisibility(null);
        }
        MemberProduct memberProduct = (MemberProduct)super.toEntity(memberProductDTO);
        ArrayList arrayList = new ArrayList(memberProductDTO.getSystemPayments());
        arrayList.addAll(memberProductDTO.getUserPayments());
        arrayList.addAll(memberProductDTO.getSelfPayments());
        Set set2 = this.conversionHandler.convertSet(PaymentTransferType.class, arrayList);
        memberProduct.setMyPaymentTypes(set2);
        ArrayList arrayList2 = new ArrayList();
        if (memberProductDTO.getMyPaymentRequestsSendToSystem() != null) {
            arrayList2.addAll(memberProductDTO.getMyPaymentRequestsSendToSystem());
        }
        if (memberProductDTO.getMyPaymentRequestsSendToUser() != null) {
            arrayList2.addAll(memberProductDTO.getMyPaymentRequestsSendToUser());
        }
        Set set3 = this.conversionHandler.convertSet(PaymentTransferType.class, arrayList2);
        memberProduct.setMyPaymentRequestTypes(set3);
        if (memberProduct.getMaxContactInfos() == null || memberProduct.getMaxContactInfos() == 0) {
            memberProduct.getContactInfoFields().clear();
        }
        return memberProduct;
    }

    @Override
    protected void enssureDTOConsistency(MemberProductDTO memberProductDTO) {
        super.enssureDTOConsistency(memberProductDTO);
        CollectionHelper.orEmpty((List)memberProductDTO.getVouchers()).forEach(productMemberVoucherDTO -> {
            if (!productMemberVoucherDTO.isViewTransactions()) {
                productMemberVoucherDTO.setRedeem(false);
            }
            if (!productMemberVoucherDTO.isViewVouchers()) {
                productMemberVoucherDTO.setBuy(false);
            }
        });
    }

    private void ensureCustomOperations(MemberProduct memberProduct, MemberProductDTO memberProductDTO) {
        List list = this.customOperationService.listByScope(new CustomOperationScope[]{CustomOperationScope.USER, CustomOperationScope.CONTACT, CustomOperationScope.CONTACT_INFO, CustomOperationScope.ADVERTISEMENT});
        list.addAll(this.customOperationService.listWithRecordScope(new RecordTypeNature[]{RecordTypeNature.USER}));
        ArrayList<MemberProductCustomOperationDTO> arrayList = new ArrayList<MemberProductCustomOperationDTO>();
        memberProductDTO.setCustomOperations(arrayList);
        for (CustomOperation customOperation : list) {
            MemberProductCustomOperationDTO memberProductCustomOperationDTO = this.getMemberProductCustomOperationDTO(customOperation, memberProduct);
            if (memberProductCustomOperationDTO == null) {
                memberProductCustomOperationDTO = new MemberProductCustomOperationDTO();
                memberProductCustomOperationDTO.setCustomOperation((CustomOperationVO)this.conversionHandler.convert(CustomOperationVO.class, (Object)customOperation));
            }
            arrayList.add(memberProductCustomOperationDTO);
        }
    }

    private void ensureMyAdFields(MemberProduct memberProduct, MemberProductDTO memberProductDTO) {
        memberProductDTO.setMyAdFields(new ArrayList());
        List list = this.adCustomFieldService.listAll();
        for (AdCustomField adCustomField : list) {
            ProductMyAdFieldDTO productMyAdFieldDTO = this.getProductMyAdFieldDTO(adCustomField, memberProduct);
            if (productMyAdFieldDTO == null) {
                productMyAdFieldDTO = new ProductMyAdFieldDTO();
                productMyAdFieldDTO.setCustomField((CustomFieldVO)this.conversionHandler.convert(CustomFieldVO.class, (Object)adCustomField));
            }
            memberProductDTO.getMyAdFields().add(productMyAdFieldDTO);
        }
    }

    private void ensureMyTokenTypes(MemberProduct memberProduct, MemberProductDTO memberProductDTO) {
        memberProductDTO.setMyTokenTypes(new ArrayList());
        List list = this.principalTypeService.listByNatures(new PrincipalTypeNature[]{PrincipalTypeNature.TOKEN, PrincipalTypeNature.NFC_TOKEN});
        for (PrincipalType principalType : list) {
            TokenPrincipalType tokenPrincipalType = (TokenPrincipalType)principalType;
            ProductMyTokenTypeDTO productMyTokenTypeDTO = this.getProductMyTokenTypeDTO(tokenPrincipalType, memberProduct);
            if (productMyTokenTypeDTO == null) {
                productMyTokenTypeDTO = new ProductMyTokenTypeDTO();
                productMyTokenTypeDTO.setTokenType((TokenPrincipalTypeVO)this.conversionHandler.convert(TokenPrincipalTypeVO.class, (Object)tokenPrincipalType));
            }
            memberProductDTO.getMyTokenTypes().add(productMyTokenTypeDTO);
        }
    }

    private void ensureVouchers(MemberProduct memberProduct, MemberProductDTO memberProductDTO) {
        memberProductDTO.setVouchers(new ArrayList());
        List list = this.voucherConfigurationService.listAll();
        for (VoucherConfiguration voucherConfiguration : list) {
            ProductMemberVoucherDTO productMemberVoucherDTO = this.getProductVoucherDTO(voucherConfiguration, memberProduct);
            if (productMemberVoucherDTO == null) {
                productMemberVoucherDTO = new ProductMemberVoucherDTO();
                productMemberVoucherDTO.setConfiguration((VoucherConfigurationVO)this.conversionHandler.convert(VoucherConfigurationVO.class, (Object)voucherConfiguration));
            }
            memberProductDTO.getVouchers().add(productMemberVoucherDTO);
        }
    }

    private void ensureWizards(MemberProduct memberProduct, MemberProductDTO memberProductDTO) {
        List list = this.customWizardService.listUserWizards();
        ArrayList<MemberProductCustomWizardDTO> arrayList = new ArrayList<MemberProductCustomWizardDTO>();
        memberProductDTO.setWizards(arrayList);
        for (UserWizard userWizard : list) {
            MemberProductCustomWizardDTO memberProductCustomWizardDTO = this.getMemberProductCustomWizardDTO(userWizard, memberProduct);
            if (memberProductCustomWizardDTO == null) {
                memberProductCustomWizardDTO = new MemberProductCustomWizardDTO();
                memberProductCustomWizardDTO.setWizard((CustomWizardVO)this.conversionHandler.convert(CustomWizardVO.class, (Object)userWizard));
            }
            arrayList.add(memberProductCustomWizardDTO);
        }
    }

    private MemberProductCustomOperationDTO getMemberProductCustomOperationDTO(CustomOperation customOperation, MemberProduct memberProduct) {
        for (MemberProductCustomOperation memberProductCustomOperation : memberProduct.getCustomOperations()) {
            if (!memberProductCustomOperation.getCustomOperation().equals((Object)customOperation)) continue;
            return (MemberProductCustomOperationDTO)this.conversionHandler.convert(MemberProductCustomOperationDTO.class, (Object)memberProductCustomOperation);
        }
        return null;
    }

    private MemberProductCustomWizardDTO getMemberProductCustomWizardDTO(UserWizard userWizard, MemberProduct memberProduct) {
        for (MemberProductCustomWizard memberProductCustomWizard : memberProduct.getWizards()) {
            if (!memberProductCustomWizard.getWizard().equals((Object)userWizard)) continue;
            return (MemberProductCustomWizardDTO)this.conversionHandler.convert(MemberProductCustomWizardDTO.class, (Object)memberProductCustomWizard);
        }
        return null;
    }

    private ProductMyAdFieldDTO getProductMyAdFieldDTO(AdCustomField adCustomField, MemberProduct memberProduct) {
        for (ProductMyAdField productMyAdField : memberProduct.getMyAdFields()) {
            if (!productMyAdField.getCustomField().equals((Object)adCustomField)) continue;
            return (ProductMyAdFieldDTO)this.conversionHandler.convert(ProductMyAdFieldDTO.class, (Object)productMyAdField);
        }
        return null;
    }

    private ProductMyTokenTypeDTO getProductMyTokenTypeDTO(TokenPrincipalType tokenPrincipalType, MemberProduct memberProduct) {
        for (ProductMyTokenType productMyTokenType : memberProduct.getMyTokenTypes()) {
            if (!productMyTokenType.getTokenType().equals((Object)tokenPrincipalType)) continue;
            return (ProductMyTokenTypeDTO)this.conversionHandler.convert(ProductMyTokenTypeDTO.class, (Object)productMyTokenType);
        }
        return null;
    }

    private ProductMemberVoucherDTO getProductVoucherDTO(VoucherConfiguration voucherConfiguration, MemberProduct memberProduct) {
        for (ProductMemberVoucher productMemberVoucher : memberProduct.getVouchers()) {
            if (!productMemberVoucher.getConfiguration().equals((Object)voucherConfiguration)) continue;
            return (ProductMemberVoucherDTO)this.conversionHandler.convert(ProductMemberVoucherDTO.class, (Object)productMemberVoucher);
        }
        return null;
    }
}

