/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.DateTimeExpression;
import java.util.Collection;
import java.util.Date;
import org.cyclos.entities.system.Language;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.QUserGroup;
import org.cyclos.entities.users.QUserGroupLog;
import org.cyclos.entities.users.User;
import org.cyclos.entities.users.UserGroup;
import org.cyclos.impl.contentmanagement.TranslationHandler;
import org.cyclos.impl.messaging.AlertServiceLocal;
import org.cyclos.impl.users.UserGroupServiceLocal;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.tasks.EntityBatchRecurringTask;
import org.cyclos.model.messaging.alerts.UserAlertType;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.users.UsersKeys;
import org.cyclos.model.users.groups.BasicGroupVO;
import org.cyclos.model.users.groups.ChangeGroupDTO;
import org.cyclos.model.users.groups.GroupVO;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.utils.ITimeInterval;
import org.cyclos.server.utils.DateHelper;
import org.cyclos.utils.MessageKey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MoveUsersToGroupRecurringTask
extends EntityBatchRecurringTask<User> {
    @Autowired
    private UserGroupServiceLocal userGroupService;
    @Autowired
    private AlertServiceLocal alertService;
    @Autowired
    private TranslationHandler translationHandler;

    public MoveUsersToGroupRecurringTask() {
        super(User.class);
    }

    public MessageKey getMessageKey() {
        return SystemKeys.RecurringTasks.MOVE_USERS_TO_GROUP;
    }

    @Override
    protected boolean doShouldGenerateErrorLog(Long l, Throwable throwable) {
        return false;
    }

    @Override
    protected void finish(User user, Throwable throwable) throws Throwable {
        if (throwable != null) {
            QUserGroupLog qUserGroupLog = QUserGroupLog.userGroupLog;
            this.update((EntityPath<?>)qUserGroupLog).where(new Predicate[]{qUserGroupLog.user().eq((Object)user), qUserGroupLog.endDate.isNull(), qUserGroupLog.group().eq((Object)user.getGroup())}).set((Path)qUserGroupLog.movedUserFailed, (Object)true).execute();
            UserGroup userGroup = (UserGroup)user.getGroup();
            Date date = (Date)((DBQuery)this.from(new EntityPath[]{qUserGroupLog}).where(new Predicate[]{qUserGroupLog.user().eq((Object)user), qUserGroupLog.endDate.isNull(), qUserGroupLog.group().eq((Object)user.getGroup())})).singleResult((Expression)qUserGroupLog.startDate);
            Date date2 = DateHelper.add((Date)date, (ITimeInterval)userGroup.getMoveUsersAfterPeriod());
            this.alertService.create(user, UserAlertType.MOVE_USER_AUTOMATICALLY_FAILED, new Object[]{user, userGroup.getMoveUsersToGroup(), userGroup, date2});
        }
    }

    @Override
    protected Collection<Long> nextIds() throws Throwable {
        QUserGroup qUserGroup = QUserGroup.userGroup;
        QUserGroupLog qUserGroupLog = QUserGroupLog.userGroupLog;
        return ((DBQuery)((DBQuery)((DBQuery)this.from(new EntityPath[]{qUserGroupLog}).innerJoin((EntityPath)qUserGroupLog.group(), (Path)qUserGroup._super)).where(new Predicate[]{qUserGroup.moveUsersAutomatically.isTrue(), qUserGroup.moveUsersToGroup().isNotNull(), qUserGroupLog.startDate.addInterval((Expression)qUserGroup.moveUsersAfterPeriod()).before((Expression)DateTimeExpression.currentTimestamp()), qUserGroupLog.endDate.isNull(), qUserGroupLog.movedUserFailed.isFalse()})).limit(200L)).list((Expression)qUserGroupLog.user().id);
    }

    @Override
    protected void process(User user) throws Throwable {
        Language language = this.configurationHandler.getAccessor((BasicUser)user).getLanguage();
        String string = this.translationHandler.message(language, UsersKeys.Groups.MOVED_AUTOMATICALLY, new Object[0]);
        UserGroup userGroup = (UserGroup)user.getGroup();
        UserGroup userGroup2 = userGroup.getMoveUsersToGroup();
        ChangeGroupDTO changeGroupDTO = new ChangeGroupDTO();
        changeGroupDTO.setUser((BasicUserVO)new UserVO(user.getId()));
        changeGroupDTO.setGroup((BasicGroupVO)new GroupVO(userGroup2.getId()));
        changeGroupDTO.setComment(string);
        this.userGroupService.changeGroup(changeGroupDTO);
    }
}

