/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import com.querydsl.core.types.Path;
import com.querydsl.core.types.dsl.CollectionPathBase;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.cyclos.entities.NamedEntity;
import org.cyclos.entities.system.EntityPropertyLog;
import org.cyclos.entities.users.AdminProduct;
import org.cyclos.entities.users.AdminProductNotification;
import org.cyclos.entities.users.BrokerProduct;
import org.cyclos.entities.users.MemberProduct;
import org.cyclos.entities.users.Product;
import org.cyclos.entities.users.ProfileFieldComparator;
import org.cyclos.entities.users.QAdminProduct;
import org.cyclos.entities.users.QProduct;
import org.cyclos.entities.users.QProductMyRecordType;
import org.cyclos.entities.users.QProductRecordField;
import org.cyclos.entities.users.QProductRecordType;
import org.cyclos.entities.users.QProductSystemRecordType;
import org.cyclos.entities.users.QUserManagementProduct;
import org.cyclos.entities.users.UserManagementProduct;
import org.cyclos.impl.EntityLogDescriptor;
import org.cyclos.impl.contentmanagement.DataTranslationHandler;
import org.cyclos.impl.system.BaseEntityLogHandlerImpl;
import org.cyclos.impl.users.CollectionPermissionHandlerImpl;
import org.cyclos.impl.users.OperationPermissionHandlerImpl;
import org.cyclos.impl.users.ProductConversionHandler;
import org.cyclos.impl.users.ProductServiceLocal;
import org.cyclos.impl.users.SinglePermissionHandlerImpl;
import org.cyclos.impl.utils.formatting.FormatterImpl;
import org.cyclos.impl.utils.validation.BeanPropertyAccess;
import org.cyclos.impl.utils.validation.PropertyAccess;
import org.cyclos.model.IterableProperty;
import org.cyclos.model.Property;
import org.cyclos.model.access.Permission;
import org.cyclos.model.banking.transferfilters.TransferFilterWithAccountTypeVO;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.messaging.MessagingKeys;
import org.cyclos.model.messaging.notifications.AdminNotificationType;
import org.cyclos.model.system.entitylogs.EntityLogEvent;
import org.cyclos.model.system.entitylogs.EntityLogType;
import org.cyclos.model.users.UsersKeys;
import org.cyclos.model.users.products.AdminProductAuthorizationRoleDTO;
import org.cyclos.model.users.products.AdminProductDTO;
import org.cyclos.model.users.products.BrokerProductDTO;
import org.cyclos.model.users.products.MemberProductCustomOperationDTO;
import org.cyclos.model.users.products.MemberProductCustomWizardDTO;
import org.cyclos.model.users.products.MemberProductDTO;
import org.cyclos.model.users.products.MyProductPasswordActionDTO;
import org.cyclos.model.users.products.ProductAdminVoucherDTO;
import org.cyclos.model.users.products.ProductBrokerVoucherDTO;
import org.cyclos.model.users.products.ProductDTO;
import org.cyclos.model.users.products.ProductManagementDTO;
import org.cyclos.model.users.products.ProductMemberVoucherDTO;
import org.cyclos.model.users.products.ProductMyAccessClientDTO;
import org.cyclos.model.users.products.ProductMyAdFieldDTO;
import org.cyclos.model.users.products.ProductMyContactFieldDTO;
import org.cyclos.model.users.products.ProductMyProfileFieldDTO;
import org.cyclos.model.users.products.ProductMyRecordFieldDTO;
import org.cyclos.model.users.products.ProductMyTokenTypeDTO;
import org.cyclos.model.users.products.ProductOperatorProfileFieldDTO;
import org.cyclos.model.users.products.ProductRecordFieldDTO;
import org.cyclos.model.users.products.ProductTransferStatusFlowDTO;
import org.cyclos.model.users.products.ProductUserAccessClientDTO;
import org.cyclos.model.users.products.ProductUserAdFieldDTO;
import org.cyclos.model.users.products.ProductUserContactFieldDTO;
import org.cyclos.model.users.products.ProductUserProfileFieldDTO;
import org.cyclos.model.users.products.ProductUserTokenTypeDTO;
import org.cyclos.model.users.products.UserGroupAccessibility;
import org.cyclos.model.users.products.UserManagementProductDTO;
import org.cyclos.model.users.products.UserProductNotificationDTO;
import org.cyclos.model.users.products.UserProductPasswordActionDTO;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.ObjectHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class ProductEntityLogHandlerImpl
extends BaseEntityLogHandlerImpl<Product, ProductDTO> {
    @Autowired
    @Lazy
    private DataTranslationHandler dataTranslationHandler;
    @Autowired
    @Lazy
    private ProductServiceLocal productService;

    public Class<Product> getEntityClass() {
        return Product.class;
    }

    public EntityLogType getType() {
        return EntityLogType.PRODUCT;
    }

    public EntityLogDescriptor<? extends ProductDTO> resolveLogDescriptor(Product product) {
        EntityLogDescriptor entityLogDescriptor = new EntityLogDescriptor(this.resolveDtoType(product));
        Set<Property<?, ?>> set = this.doResolveLogDescriptor(product, (EntityLogDescriptor<ProductDTO>)entityLogDescriptor);
        if (product instanceof MemberProduct) {
            set.addAll(this.doResolveLogDescriptor((MemberProduct)product, (EntityLogDescriptor<MemberProductDTO>)entityLogDescriptor.cast()));
        } else {
            set.addAll(this.doResolveLogDescriptor((UserManagementProduct)product, (EntityLogDescriptor<UserManagementProductDTO>)entityLogDescriptor.cast()));
            if (product instanceof BrokerProduct) {
                set.addAll(this.doResolveLogDescriptor((BrokerProduct)product, (EntityLogDescriptor<BrokerProductDTO>)entityLogDescriptor.cast()));
            } else {
                set.addAll(this.doResolveLogDescriptor((AdminProduct)product, (EntityLogDescriptor<AdminProductDTO>)entityLogDescriptor.cast()));
            }
        }
        return this.processPermissionHandlers(product, set, (EntityLogDescriptor<ProductDTO>)entityLogDescriptor);
    }

    @Override
    protected List<EntityPropertyLog> doOnBeforeLog(Product product, Product product2, List<EntityPropertyLog> list, EntityLogEvent entityLogEvent) {
        if (ObjectHelper.coalesce((Object[])new Product[]{product, product2}) instanceof AdminProduct && entityLogEvent != EntityLogEvent.DELETE) {
            AdminProduct adminProduct = (AdminProduct)product;
            AdminProduct adminProduct2 = (AdminProduct)product2;
            HashMap<AdminNotificationType, String> hashMap = new HashMap<AdminNotificationType, String>();
            HashMap<AdminNotificationType, String> hashMap2 = new HashMap<AdminNotificationType, String>();
            CollectionHelper.orEmpty((Set)adminProduct.getDefaultNotifications()).forEach(adminProductNotification -> hashMap.put(adminProductNotification.getType(), this.getStringValue(adminProduct, (AdminProductNotification)adminProductNotification)));
            CollectionHelper.orEmpty((Set)adminProduct2.getDefaultNotifications()).forEach(adminProductNotification -> hashMap2.put(adminProductNotification.getType(), this.getStringValue(adminProduct2, (AdminProductNotification)adminProductNotification)));
            TreeMap<AdminNotificationType, EntityPropertyLog> treeMap = new TreeMap<AdminNotificationType, EntityPropertyLog>();
            hashMap.forEach((adminNotificationType, string) -> {
                String string2 = (String)hashMap2.get(adminNotificationType);
                if (!string.equals(string2)) {
                    treeMap.put((AdminNotificationType)adminNotificationType, this.createEntityPropertyLog((String)string, string2, (AdminNotificationType)adminNotificationType));
                }
                hashMap2.remove(adminNotificationType);
            });
            hashMap2.forEach((adminNotificationType, string) -> treeMap.put((AdminNotificationType)adminNotificationType, this.createEntityPropertyLog(null, (String)string, (AdminNotificationType)adminNotificationType)));
            treeMap.forEach((adminNotificationType, entityPropertyLog) -> {
                entityPropertyLog.setOrder(Integer.valueOf(list.size()));
                list.add((EntityPropertyLog)entityPropertyLog);
            });
        }
        return super.doOnBeforeLog(product, product2, list, entityLogEvent);
    }

    @Override
    protected Product getEntityToViewLog(long l) {
        return this.hasPermission(Permission.USER_CONFIGURATION_VIEW) ? this.find(this.getEntityClass(), l) : null;
    }

    private EntityPropertyLog createEntityPropertyLog(String string, String string2, AdminNotificationType adminNotificationType) {
        EntityPropertyLog entityPropertyLog = new EntityPropertyLog();
        entityPropertyLog.setValues(string, string2);
        switch (adminNotificationType) {
            case AD_PENDING_AUTHORIZATION: {
                entityPropertyLog.setName(this.message(MessagingKeys.NotificationSettings.ADMIN_AD_PENDING_AUTHORIZATION, new Object[0]));
                break;
            }
            case APPLICATION_ERROR: {
                entityPropertyLog.setName(this.message(MessagingKeys.NotificationSettings.ADMIN_APPLICATION_ERROR, new Object[0]));
                break;
            }
            case EXTERNAL_PAYMENT_EXPIRED: {
                entityPropertyLog.setName(this.message(MessagingKeys.NotificationSettings.ADMIN_EXTERNAL_PAYMENT_EXPIRED, new Object[0]));
                break;
            }
            case EXTERNAL_PAYMENT_PERFORMED_FAILED: {
                entityPropertyLog.setName(this.message(MessagingKeys.NotificationSettings.ADMIN_EXTERNAL_PAYMENT_PERFORMED_FAILED, new Object[0]));
                break;
            }
            case GENERATED_VOUCHERS_EXPIRED: {
                entityPropertyLog.setName(this.message(MessagingKeys.NotificationSettings.ADMIN_GENERATED_VOUCHERS_EXPIRED, new Object[0]));
                break;
            }
            case PAYMENT_AWAITING_AUTHORIZATION: {
                entityPropertyLog.setName(this.message(MessagingKeys.NotificationSettings.ADMIN_PAYMENT_AWAITING_AUTHORIZATION, new Object[0]));
                break;
            }
            case PAYMENT_PERFORMED: {
                entityPropertyLog.setName(this.message(MessagingKeys.NotificationSettings.ADMIN_PAYMENT_PERFORMED, new Object[0]));
                break;
            }
            case SYSTEM_ALERT: {
                entityPropertyLog.setName(this.message(MessagingKeys.NotificationSettings.ADMIN_SYSTEM_ALERT, new Object[0]));
                break;
            }
            case USER_ALERT: {
                entityPropertyLog.setName(this.message(MessagingKeys.NotificationSettings.ADMIN_USER_ALERT, new Object[0]));
                break;
            }
            case USER_REGISTRATION: {
                entityPropertyLog.setName(this.message(MessagingKeys.NotificationSettings.ADMIN_USER_REGISTRATION, new Object[0]));
                break;
            }
            case VOUCHER_BUYING_ABOUT_TO_EXPIRE: {
                entityPropertyLog.setName(this.message(MessagingKeys.NotificationSettings.ADMIN_VOUCHER_BUYING_ABOUT_TO_EXPIRE, new Object[0]));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported admin notification type");
            }
        }
        return entityPropertyLog;
    }

    private Set<Property<?, ?>> doResolveLogDescriptor(AdminProduct adminProduct, EntityLogDescriptor<AdminProductDTO> entityLogDescriptor) {
        entityLogDescriptor.ignore((Property)ProductDTO.MAX_CUSTOM_IMAGES).property((Property)AdminProductDTO.ACCESSIBLE_ADMIN_GROUPS, UsersKeys.Products.ACCESSIBLE_ADMIN_GROUPS).property((Property)AdminProductDTO.ACCESSIBLE_VOUCHER_CONFIGURATIONS, UsersKeys.Products.ACCESSIBLE_VOUCHER_CONFIGURATIONS).property((Property)AdminProductDTO.ADMIN_GROUP_ACCESSIBILITY, UsersKeys.Products.ADMIN_GROUP_ACCESSIBILITY).property((Property)AdminProductDTO.SYSTEM_CUSTOM_OPERATIONS_RUN, UsersKeys.Products.SYSTEM_CUSTOM_OPERATIONS_RUN).property((Property)AdminProductDTO.SYSTEM_WIZARDS_RUN, UsersKeys.Products.SYSTEM_WIZARDS_RUN).property(this.toFilterAccess((Property<Set<TransferFilterWithAccountTypeVO>, ? extends ProductDTO>)AdminProductDTO.SYSTEM_TRANSFER_FILTERS), UsersKeys.Products.SYSTEM_TRANSFER_FILTERS).tableProperty((IterableProperty)AdminProductDTO.MANAGED_PRODUCTS, (Object)UsersKeys.Products.PRODUCT_MANAGEMENT).row(ProductManagementDTO.class, (Property)ProductManagementDTO.MANAGED_PRODUCT).col((Property)ProductManagementDTO.VIEW, (Object)UsersKeys.Products.PRODUCT_MANAGEMENT_VIEW).col((Property)ProductManagementDTO.ASSIGN_TO_GROUPS, (Object)UsersKeys.Products.PRODUCT_MANAGEMENT_ASSIGN_TO_GROUPS).col((Property)ProductManagementDTO.MANAGE, (Object)UsersKeys.Products.PRODUCT_MANAGEMENT_MANAGE).add().tableProperty((IterableProperty)AdminProductDTO.AUTHORIZATION_ROLES, (Object)UsersKeys.Products.AUTHORIZATION_ROLES).row(AdminProductAuthorizationRoleDTO.class, (Property)AdminProductAuthorizationRoleDTO.AUTHORIZATION_ROLE).col((Property)AdminProductAuthorizationRoleDTO.VIEW, (Object)UsersKeys.Products.GENERAL_VIEW).col((Property)AdminProductAuthorizationRoleDTO.MANAGE, (Object)UsersKeys.Products.GENERAL_MANAGE).add().ignore((Property)AdminProductDTO.SYSTEM_RECORD_TYPE_FIELDS).tableProperty((CollectionPathBase)QAdminProduct.adminProduct.systemRecordTypes, (Object)UsersKeys.Products.SYSTEM_RECORD_TYPES).row(ProductRecordFieldDTO.class, (Property)ProductRecordFieldDTO.RECORD_TYPE).nestedRow((CollectionPathBase)QProductSystemRecordType.productSystemRecordType.productRecordCustomFields, (Path)QProductRecordField.productRecordField.customField()).col((Property)ProductRecordFieldDTO.VIEW, (Object)UsersKeys.Products.RECORD_TYPE_VIEW, true).col((Property)ProductRecordFieldDTO.CREATE, (Object)UsersKeys.Products.RECORD_TYPE_CREATE, true).col((Property)ProductRecordFieldDTO.EDIT, (Object)UsersKeys.Products.RECORD_TYPE_EDIT, true).col((Property)ProductRecordFieldDTO.REMOVE, (Object)UsersKeys.Products.RECORD_TYPE_REMOVE).ignore((Property)ProductRecordFieldDTO.CUSTOM_FIELD).add().tableProperty((IterableProperty)AdminProductDTO.VOUCHERS, (Object)UsersKeys.Products.VOUCHERS).row(ProductAdminVoucherDTO.class, (Property)ProductAdminVoucherDTO.CONFIGURATION).col((Property)ProductAdminVoucherDTO.VIEW, (Object)UsersKeys.Products.GENERAL_VIEW).col((Property)ProductAdminVoucherDTO.GENERATE, (Object)UsersKeys.Products.VOUCHERS_GENERATE).col((Property)ProductAdminVoucherDTO.CANCEL, (Object)UsersKeys.Products.VOUCHERS_CANCEL).col((Property)ProductAdminVoucherDTO.CHANGE_EXPIRATION_DATE, (Object)UsersKeys.Products.VOUCHERS_CHANGE_EXPIRATION_DATE).col((Property)ProductAdminVoucherDTO.NOTIFICATION_SETTINGS, (Object)UsersKeys.Products.VOUCHERS_NOTIFICATION_SETTINGS).col((Property)ProductAdminVoucherDTO.CHANGE_PIN, (Object)UsersKeys.Products.VOUCHERS_CHANGE_PIN).col((Property)ProductAdminVoucherDTO.BUY, (Object)UsersKeys.Products.VOUCHERS_BUY).col((Property)ProductAdminVoucherDTO.SEND, (Object)UsersKeys.Products.VOUCHERS_SEND).col((Property)ProductAdminVoucherDTO.REFUND, (Object)UsersKeys.Products.VOUCHERS_REFUND).col((Property)ProductAdminVoucherDTO.REDEEM, (Object)UsersKeys.Products.VOUCHERS_REDEEM).col((Property)ProductAdminVoucherDTO.TOP_UP, (Object)UsersKeys.Products.VOUCHERS_TOP_UP).add().property((Property)AdminProductDTO.FWD_MESSAGE_CATEGORIES_TO_EMAIL_TO_NOTIFY, UsersKeys.Products.NOTIFICATIONS_FWD_MESSAGES_TO_EMAIL).ignore((Property)AdminProductDTO.GLOBAL_CONFIGURATION).ignore((Property)AdminProductDTO.DEFAULT_NOTIFICATIONS).ignore((Property)AdminProductDTO.AUTHORIZABLE_PAYMENTS_TO_NOTIFY).ignore((Property)AdminProductDTO.EXTERNAL_PAYMENTS_EXPIRED_TO_NOTIFY).ignore((Property)AdminProductDTO.EXTERNAL_PAYMENTS_FAILED_TO_NOTIFY).ignore((Property)AdminProductDTO.PAYMENTS_TO_NOTIFY).ignore((Property)AdminProductDTO.SYSTEM_ALERTS_TO_NOTIFY).ignore((Property)AdminProductDTO.USER_ALERTS_TO_NOTIFY).ignore((Property)AdminProductDTO.USER_GROUPS_TO_NOTIFY).ignore((Property)AdminProductDTO.VOUCHER_CONFIGURATIONS_BUYING_TO_NOTIFY).ignore((Property)AdminProductDTO.VOUCHER_CONFIGURATIONS_TO_NOTIFY);
        return CollectionHelper.asSet((Object[])new Property[]{AdminProductDTO.MAX_CUSTOM_IMAGES, AdminProductDTO.GLOBAL_CONFIGURATION, AdminProductDTO.AUTHORIZATION_ROLES, AdminProductDTO.VOUCHERS});
    }

    private Set<Property<?, ?>> doResolveLogDescriptor(BrokerProduct brokerProduct, EntityLogDescriptor<BrokerProductDTO> entityLogDescriptor) {
        entityLogDescriptor.property((Property)BrokerProductDTO.GROUP_VISIBILITY, UsersKeys.Products.GROUP_VISIBILITY).property((Property)BrokerProductDTO.MAX_OPERATORS, UsersKeys.Products.MAX_OPERATORS).tableProperty((IterableProperty)BrokerProductDTO.NOTIFICATIONS, (Object)UsersKeys.Products.NOTIFICATIONS).row(UserProductNotificationDTO.class, (Property)UserProductNotificationDTO.TYPE).col((Property)UserProductNotificationDTO.ENABLED, (Object)UsersKeys.Products.NOTIFICATIONS_ENABLED).col((Property)UserProductNotificationDTO.ALLOW_MAIL, (Object)UsersKeys.Products.NOTIFICATIONS_ALLOW_MAIL).col((Property)UserProductNotificationDTO.DEFAULT_MAIL, (Object)UsersKeys.Products.NOTIFICATIONS_DEFAULT_MAIL).col((Property)UserProductNotificationDTO.ALLOW_SMS, (Object)UsersKeys.Products.NOTIFICATIONS_ALLOW_SMS).col((Property)UserProductNotificationDTO.DEFAULT_SMS, (Object)UsersKeys.Products.NOTIFICATIONS_DEFAULT_SMS).col((Property)UserProductNotificationDTO.ALLOW_APP, (Object)UsersKeys.Products.NOTIFICATIONS_ALLOW_SMS).col((Property)UserProductNotificationDTO.DEFAULT_APP, (Object)UsersKeys.Products.NOTIFICATIONS_DEFAULT_APP).col((Property)UserProductNotificationDTO.ALLOW_APP, (Object)UsersKeys.Products.NOTIFICATIONS_ALLOW_APP).add().tableProperty((IterableProperty)BrokerProductDTO.OPERATOR_PROFILE_FIELDS, (Object)UsersKeys.Products.OPERATOR_PROFILE_FIELDS).row(ProductOperatorProfileFieldDTO.class, (Property)ProductOperatorProfileFieldDTO.PROFILE_FIELD, (Comparator)ProfileFieldComparator.getInstance()).col((Property)ProductOperatorProfileFieldDTO.ENABLED, (Object)UsersKeys.Products.PROFILE_FIELDS_ENABLE).col((Property)ProductOperatorProfileFieldDTO.VISIBLE, (Object)UsersKeys.Products.PROFILE_FIELDS_VIEW).col((Property)ProductOperatorProfileFieldDTO.EDITABLE, (Object)UsersKeys.Products.PROFILE_FIELDS_EDIT).col((Property)ProductOperatorProfileFieldDTO.EDITABLE_AT_REGISTRATION, (Object)UsersKeys.Products.PROFILE_FIELDS_EDIT_AT_REGISTRATION).col((Property)ProductOperatorProfileFieldDTO.OPERATOR_LIST, (Object)UsersKeys.Products.OPERATOR_PROFILE_FIELDS_OPERATOR_LIST).add().tableProperty((IterableProperty)BrokerProductDTO.USER_VOUCHERS, (Object)UsersKeys.Products.VOUCHERS).row(ProductBrokerVoucherDTO.class, (Property)ProductBrokerVoucherDTO.CONFIGURATION).col((Property)ProductBrokerVoucherDTO.VIEW_VOUCHERS, (Object)UsersKeys.Products.VOUCHERS_VIEW_VOUCHERS).col((Property)ProductBrokerVoucherDTO.BUY, (Object)UsersKeys.Products.VOUCHERS_BUY).col((Property)ProductBrokerVoucherDTO.SEND, (Object)UsersKeys.Products.VOUCHERS_SEND).col((Property)ProductBrokerVoucherDTO.NOTIFICATION_SETTINGS, (Object)UsersKeys.Products.VOUCHERS_NOTIFICATION_SETTINGS).col((Property)ProductBrokerVoucherDTO.CHANGE_PIN, (Object)UsersKeys.Products.VOUCHERS_CHANGE_PIN).col((Property)ProductBrokerVoucherDTO.REFUND, (Object)UsersKeys.Products.VOUCHERS_REFUND).col((Property)ProductBrokerVoucherDTO.VIEW_TRANSACTIONS, (Object)UsersKeys.Products.VOUCHERS_VIEW_TRANSACTIONS).col((Property)ProductBrokerVoucherDTO.REDEEM, (Object)UsersKeys.Products.VOUCHERS_REDEEM).col((Property)ProductBrokerVoucherDTO.TOP_UP, (Object)UsersKeys.Products.VOUCHERS_TOP_UP).add();
        return CollectionHelper.asSet((Object[])new Property[]{BrokerProductDTO.NOTIFICATIONS, BrokerProductDTO.USER_VOUCHERS});
    }

    private Set<Property<?, ?>> doResolveLogDescriptor(MemberProduct memberProduct, EntityLogDescriptor<MemberProductDTO> entityLogDescriptor) {
        entityLogDescriptor.property((Property)MemberProductDTO.ACCOUNT_ACCESSIBILITY, UsersKeys.Products.ACCOUNT_ACCESSIBILITY).property((Property)MemberProductDTO.ACCOUNT_FEES, UsersKeys.Products.ACCOUNT_FEES).property((Property)MemberProductDTO.ACTIVATE_USER_TOKEN_TYPES, UsersKeys.Products.ACTIVATE_USER_TOKEN_TYPES).property((Property)MemberProductDTO.ADS_REQUIRE_AUTHORIZATION, UsersKeys.Products.ADS_REQUIRE_AUTHORIZATION).property((Property)MemberProductDTO.CONTACT_INFO_FIELDS, UsersKeys.Products.CONTACT_INFO_FIELDS).property((Property)MemberProductDTO.DEFAULT_AD_PUBLICATION_TIME, UsersKeys.Products.DEFAULT_AD_PUBLICATION_TIME).property(this.toAmountAccess((Property<?, MemberProductDTO>)MemberProductDTO.DEFAULT_CREDIT_LIMIT, true), UsersKeys.Products.DEFAULT_CREDIT_LIMIT).property((Property)MemberProductDTO.DEFAULT_FILTER_GROUPS, UsersKeys.Products.DEFAULT_FILTER_GROUPS).property(this.toAmountAccess((Property<?, MemberProductDTO>)MemberProductDTO.DEFAULT_UPPER_CREDIT_LIMIT, false), UsersKeys.Products.DEFAULT_UPPER_CREDIT_LIMIT).property((Property)MemberProductDTO.GROUP_FILTER_DEFAULT, UsersKeys.Products.GROUP_FILTER_DEFAULT).property((Property)MemberProductDTO.GROUP_VISIBILITY, UsersKeys.Products.GROUP_VISIBILITY).property((Property)MemberProductDTO.GROUPS_FOR_USER_SEARCH, UsersKeys.Products.GROUPS_FOR_USER_SEARCH).property((Property)MemberProductDTO.GROUPS_FOR_VIEW_PROFILE, UsersKeys.Products.GROUPS_FOR_VIEW_PROFILE).property(this.toAmountAccess((Property<?, MemberProductDTO>)MemberProductDTO.INDIVIDUAL_CREDIT_LIMIT, true), UsersKeys.Products.INDIVIDUAL_CREDIT_LIMIT).property(this.toAmountAccess((Property<?, MemberProductDTO>)MemberProductDTO.INITIAL_CREDIT, false), UsersKeys.Products.INITIAL_CREDIT).property(this.toAmountAccess((Property<?, MemberProductDTO>)MemberProductDTO.DEFAULT_PAYMENT_AMOUNT_LIMIT, false), UsersKeys.Products.DEFAULT_PAYMENT_AMOUNT_LIMIT).property(this.toAmountAccess((Property<?, MemberProductDTO>)MemberProductDTO.DEFAULT_PAYMENT_AMOUNT_PER_DAY_LIMIT, false), UsersKeys.Products.DEFAULT_PAYMENT_AMOUNT_PER_DAY_LIMIT).property(this.toAmountAccess((Property<?, MemberProductDTO>)MemberProductDTO.DEFAULT_PAYMENT_AMOUNT_PER_WEEK_LIMIT, false), UsersKeys.Products.DEFAULT_PAYMENT_AMOUNT_PER_WEEK_LIMIT).property(this.toAmountAccess((Property<?, MemberProductDTO>)MemberProductDTO.DEFAULT_PAYMENT_AMOUNT_PER_MONTH_LIMIT, false), UsersKeys.Products.DEFAULT_PAYMENT_AMOUNT_PER_MONTH_LIMIT).property(this.toAmountAccess((Property<?, MemberProductDTO>)MemberProductDTO.DEFAULT_PAYMENT_AMOUNT_PER_YEAR_LIMIT, false), UsersKeys.Products.DEFAULT_PAYMENT_AMOUNT_PER_YEAR_LIMIT).property((Property)MemberProductDTO.INITIAL_CREDIT_TYPE, UsersKeys.Products.INITIAL_CREDIT_TYPE).property((Property)MemberProductDTO.MAX_AD_DESCRIPTION_SIZE, UsersKeys.Products.MAX_AD_DESCRIPTION_SIZE).property((Property)MemberProductDTO.MAX_AD_IMAGES, UsersKeys.Products.MAX_AD_IMAGES).property((Property)MemberProductDTO.MAX_AD_PUBLICATION_TIME, UsersKeys.Products.MAX_AD_PUBLICATION_TIME).property((Property)MemberProductDTO.SHOW_AD_PUBLICATION_DATE, UsersKeys.Products.SHOW_AD_PUBLICATION_DATE).property((Property)MemberProductDTO.SHOW_AD_EXPIRATION_DATE, UsersKeys.Products.SHOW_AD_EXPIRATION_DATE).property((Property)MemberProductDTO.MAX_ADDRESSES_PER_AD, UsersKeys.Products.MAX_ADDRESSES_PER_AD).property((Property)MemberProductDTO.MAX_ADS, UsersKeys.Products.MAX_ADS).property((Property)MemberProductDTO.MAX_CATEGORIES_PER_AD, UsersKeys.Products.MAX_CATEGORIES_PER_AD).property((Property)MemberProductDTO.MAX_CONTACT_INFOS, UsersKeys.Products.MAX_CONTACT_INFOS).property((Property)MemberProductDTO.MAX_OPERATORS, UsersKeys.Products.MAX_OPERATORS).property((Property)MemberProductDTO.MAKE_POS_PAYMENT_TYPES, UsersKeys.Products.MAKE_POS_PAYMENT_TYPES).property((Property)MemberProductDTO.RECEIVE_PAYMENT_REQUEST_TYPES, UsersKeys.Products.RECEIVE_PAYMENT_REQUEST_TYPES).property((Property)MemberProductDTO.SHOW_ACCOUNT_IN_PROFILE, UsersKeys.Products.SHOW_ACCOUNT_IN_PROFILE).property((Property)MemberProductDTO.SHOW_ACTIVITIES_IN_PROFILE, UsersKeys.Products.SHOW_ACTIVITIES_IN_PROFILE).property((Property)MemberProductDTO.SHOW_BROKERS, UsersKeys.Products.SHOW_BROKERS).property((Property)MemberProductDTO.USER_ACCOUNT, UsersKeys.Products.USER_ACCOUNT).property((Property)MemberProductDTO.VIEW_ADS_IN_OTHER_CURRENCIES, UsersKeys.Products.VIEW_ADS_IN_OTHER_CURRENCIES).property((Property)MemberProductDTO.WEB_SHOP_ADS_REQUIRE_AUTHORIZATION, UsersKeys.Products.WEB_SHOP_ADS_REQUIRE_AUTHORIZATION).property((Property)MemberProductDTO.MY_TRANSFER_FILTERS, UsersKeys.Products.MY_TRANSFER_FILTERS).tableProperty((IterableProperty)MemberProductDTO.CUSTOM_OPERATIONS, (Object)UsersKeys.Products.CUSTOM_OPERATIONS).row(MemberProductCustomOperationDTO.class, (Property)MemberProductCustomOperationDTO.CUSTOM_OPERATION).col((Property)MemberProductCustomOperationDTO.ENABLED, (Object)UsersKeys.Products.CUSTOM_OPERATION_ENABLED).col((Property)MemberProductCustomOperationDTO.RUN, (Object)UsersKeys.Products.CUSTOM_OPERATION_RUN).col((Property)MemberProductCustomOperationDTO.RUN_ON_OTHERS, (Object)UsersKeys.Products.CUSTOM_OPERATION_RUN_ON_OTHERS).add().tableProperty((IterableProperty)MemberProductDTO.WIZARDS, (Object)UsersKeys.Products.WIZARDS).row(MemberProductCustomWizardDTO.class, (Property)MemberProductCustomWizardDTO.WIZARD).col((Property)MemberProductCustomWizardDTO.ENABLED, (Object)UsersKeys.Products.WIZARD_ENABLED).col((Property)MemberProductCustomWizardDTO.RUN, (Object)UsersKeys.Products.WIZARD_RUN).add().tableProperty((IterableProperty)MemberProductDTO.MY_AD_FIELDS, (Object)UsersKeys.Products.MY_AD_FIELDS).row(ProductMyAdFieldDTO.class, (Property)ProductMyAdFieldDTO.CUSTOM_FIELD).col((Property)ProductMyAdFieldDTO.ENABLE, (Object)UsersKeys.Products.AD_FIELDS_ENABLE).col((Property)ProductMyAdFieldDTO.VIEW, (Object)UsersKeys.Products.AD_FIELDS_VIEW).col((Property)ProductMyAdFieldDTO.MANAGE, (Object)UsersKeys.Products.AD_FIELDS_MANAGE).add().tableProperty((IterableProperty)MemberProductDTO.MY_TOKEN_TYPES, (Object)UsersKeys.Products.MY_TOKEN_TYPES).row(ProductMyTokenTypeDTO.class, (Property)ProductMyTokenTypeDTO.TOKEN_TYPE).col((Property)ProductMyTokenTypeDTO.ENABLE, (Object)UsersKeys.Products.TOKENS_ENABLE).col((Property)ProductMyTokenTypeDTO.BLOCK, (Object)UsersKeys.Products.TOKENS_BLOCK).col((Property)ProductMyTokenTypeDTO.UNBLOCK, (Object)UsersKeys.Products.TOKENS_UNBLOCK).col((Property)ProductMyTokenTypeDTO.CANCEL, (Object)UsersKeys.Products.TOKENS_CANCEL).col((Property)ProductMyTokenTypeDTO.PERSONALIZE, (Object)UsersKeys.Products.TOKENS_PERSONALIZE).col((Property)ProductMyTokenTypeDTO.ACTIVATE, (Object)UsersKeys.Products.TOKENS_ACTIVATE).add().tableProperty((IterableProperty)MemberProductDTO.NOTIFICATIONS, (Object)UsersKeys.Products.NOTIFICATIONS).row(UserProductNotificationDTO.class, (Property)UserProductNotificationDTO.TYPE).col((Property)UserProductNotificationDTO.ENABLED, (Object)UsersKeys.Products.NOTIFICATIONS_ENABLED).col((Property)UserProductNotificationDTO.ALLOW_MAIL, (Object)UsersKeys.Products.NOTIFICATIONS_ALLOW_MAIL).col((Property)UserProductNotificationDTO.DEFAULT_MAIL, (Object)UsersKeys.Products.NOTIFICATIONS_DEFAULT_MAIL).col((Property)UserProductNotificationDTO.ALLOW_SMS, (Object)UsersKeys.Products.NOTIFICATIONS_ALLOW_SMS).col((Property)UserProductNotificationDTO.DEFAULT_SMS, (Object)UsersKeys.Products.NOTIFICATIONS_DEFAULT_SMS).col((Property)UserProductNotificationDTO.DEFAULT_APP, (Object)UsersKeys.Products.NOTIFICATIONS_DEFAULT_APP).col((Property)UserProductNotificationDTO.ALLOW_APP, (Object)UsersKeys.Products.NOTIFICATIONS_ALLOW_APP).add().tableProperty((IterableProperty)MemberProductDTO.OPERATOR_PROFILE_FIELDS, (Object)UsersKeys.Products.OPERATOR_PROFILE_FIELDS).row(ProductOperatorProfileFieldDTO.class, (Property)ProductOperatorProfileFieldDTO.PROFILE_FIELD, (Comparator)ProfileFieldComparator.getInstance()).col((Property)ProductOperatorProfileFieldDTO.ENABLED, (Object)UsersKeys.Products.PROFILE_FIELDS_ENABLE).col((Property)ProductOperatorProfileFieldDTO.VISIBLE, (Object)UsersKeys.Products.PROFILE_FIELDS_VIEW).col((Property)ProductOperatorProfileFieldDTO.EDITABLE, (Object)UsersKeys.Products.PROFILE_FIELDS_EDIT).col((Property)ProductOperatorProfileFieldDTO.EDITABLE_AT_REGISTRATION, (Object)UsersKeys.Products.PROFILE_FIELDS_EDIT_AT_REGISTRATION).col((Property)ProductOperatorProfileFieldDTO.OPERATOR_LIST, (Object)UsersKeys.Products.OPERATOR_PROFILE_FIELDS_OPERATOR_LIST).add().tableProperty((IterableProperty)MemberProductDTO.VOUCHERS, (Object)UsersKeys.Products.VOUCHERS).row(ProductMemberVoucherDTO.class, (Property)ProductMemberVoucherDTO.CONFIGURATION).col((Property)ProductMemberVoucherDTO.ENABLE, (Object)UsersKeys.Products.VOUCHERS_ENABLE).col((Property)ProductMemberVoucherDTO.VIEW_TRANSACTIONS, (Object)UsersKeys.Products.VOUCHERS_VIEW_TRANSACTIONS).col((Property)ProductMemberVoucherDTO.REDEEM, (Object)UsersKeys.Products.VOUCHERS_REDEEM).col((Property)ProductMemberVoucherDTO.TOP_UP, (Object)UsersKeys.Products.VOUCHERS_TOP_UP).col((Property)ProductMemberVoucherDTO.VIEW_VOUCHERS, (Object)UsersKeys.Products.VOUCHERS_VIEW_VOUCHERS).col((Property)ProductMemberVoucherDTO.BUY, (Object)UsersKeys.Products.VOUCHERS_BUY).col((Property)ProductMemberVoucherDTO.SEND, (Object)UsersKeys.Products.VOUCHERS_SEND).col((Property)ProductMemberVoucherDTO.SEND_BATCH, (Object)UsersKeys.Products.VOUCHERS_SEND_BATCH).col((Property)ProductMemberVoucherDTO.REFUND, (Object)UsersKeys.Products.VOUCHERS_REFUND).ignore((Property)ProductMemberVoucherDTO.NOTIFICATION_SETTINGS).ignore((Property)ProductMemberVoucherDTO.CHANGE_PIN).add();
        return CollectionHelper.asSet((Object[])new Property[]{MemberProductDTO.NOTIFICATIONS, MemberProductDTO.VOUCHERS});
    }

    private Set<Property<?, ?>> doResolveLogDescriptor(Product product, EntityLogDescriptor<ProductDTO> entityLogDescriptor) {
        entityLogDescriptor.property(ProductDTO.NAME, GeneralKeys.Ui.NAME).property(ProductDTO.INTERNAL_NAME, GeneralKeys.Ui.INTERNAL_NAME).property(ProductDTO.DESCRIPTION, GeneralKeys.Ui.DESCRIPTION).property((Property)ProductDTO.ACCESSIBLE_USER_GROUPS, UsersKeys.Products.ACCESSIBLE_USER_GROUPS).property((Property)ProductDTO.AGREEMENTS, UsersKeys.Products.AGREEMENTS).property((Property)ProductDTO.CHANNELS, UsersKeys.Products.APPLIED_TO_CHANNELS).property((Property)ProductDTO.GROUPS_FOR_USER_DIRECTORY, UsersKeys.Products.GROUPS_FOR_USER_DIRECTORY).property((Property)ProductDTO.MAX_ADDRESSES, UsersKeys.Products.MAX_ADDRESSES).property((Property)ProductDTO.MAX_INVITATION_RECIPIENTS, UsersKeys.Products.MAX_INVITATION_RECIPIENTS).property((Property)ProductDTO.MAX_LANDLINE_PHONES, UsersKeys.Products.MAX_LANDLINE_PHONES).property((Property)ProductDTO.MAX_MESSAGE_RECIPIENTS, UsersKeys.Products.MAX_MESSAGE_RECIPIENTS).property((Property)ProductDTO.MAX_MOBILE_PHONES, UsersKeys.Products.MAX_MOBILE_PHONES).property((Property)ProductDTO.MAX_PROFILE_IMAGES, UsersKeys.Products.MAX_PROFILE_IMAGES).property((Property)ProductDTO.MAX_SMS_PER_MONTH, UsersKeys.Products.MAX_SMS_PER_MONTH).property((Property)ProductDTO.NATURE, UsersKeys.Products.NATURE).property((Property)ProductDTO.PRINCIPAL_TYPES, UsersKeys.Products.APPLIED_TO_PRINCIPAL_TYPES).property((Property)ProductDTO.RUN_TRANSFER_CUSTOM_OPERATIONS, UsersKeys.Products.RUN_TRANSFER_CUSTOM_OPERATIONS).property((Property)ProductDTO.USER_GROUP_ACCESSIBILITY, UsersKeys.Products.USER_GROUP_ACCESSIBILITY).property((Property)ProductDTO.VISIBLE_TRANSACTION_FIELDS, UsersKeys.Products.VISIBLE_TRANSACTION_FIELDS).property((Property)ProductDTO.VISIBLE_VOUCHER_FIELDS, UsersKeys.Products.VISIBLE_VOUCHER_FIELDS).property((Property)ProductDTO.RUN_CUSTOM_WEB_SERVICES, UsersKeys.Products.RUN_CUSTOM_WEB_SERVICES).property((Property)ProductDTO.SIMPLE_USER_SEARCH_PROFILE_FIELDS, UsersKeys.Products.SIMPLE_USER_SEARCH_PROFILE_FIELDS).tableProperty((IterableProperty)ProductDTO.TRANSFER_STATUS_FLOWS, (Object)UsersKeys.Products.TRANSFER_STATUS_FLOWS).row(ProductTransferStatusFlowDTO.class, (Property)ProductTransferStatusFlowDTO.FLOW).col((Property)ProductTransferStatusFlowDTO.VISIBLE, (Object)UsersKeys.Products.PROFILE_FIELDS_VIEW).col((Property)ProductTransferStatusFlowDTO.EDITABLE, (Object)UsersKeys.Products.PROFILE_FIELDS_EDIT).add().tableProperty((IterableProperty)ProductDTO.USER_PROFILE_FIELDS, (Object)UsersKeys.Products.USER_PROFILE_FIELDS).row(ProductUserProfileFieldDTO.class, (Property)ProductUserProfileFieldDTO.PROFILE_FIELD, (Comparator)ProfileFieldComparator.getInstance()).col((Property)ProductUserProfileFieldDTO.VISIBLE, (Object)UsersKeys.Products.USER_PROFILE_FIELDS_VIEW).col((Property)ProductUserProfileFieldDTO.EDITABLE, (Object)UsersKeys.Products.USER_PROFILE_FIELDS_EDIT).col((Property)ProductUserProfileFieldDTO.USER_FILTER, (Object)UsersKeys.Products.USER_PROFILE_FIELDS_USER_FILTER).col((Property)ProductUserProfileFieldDTO.USER_LIST, (Object)UsersKeys.Products.USER_PROFILE_FIELDS_USER_LIST).col((Property)ProductUserProfileFieldDTO.USER_KEYWORDS, (Object)UsersKeys.Products.USER_PROFILE_FIELDS_USER_KEYWORDS).col((Property)ProductUserProfileFieldDTO.MAP_FILTER, (Object)UsersKeys.Products.USER_PROFILE_FIELDS_MAP_FILTER).col((Property)ProductUserProfileFieldDTO.MAP_RESULT, (Object)UsersKeys.Products.USER_PROFILE_FIELDS_MAP_RESULT).col((Property)ProductUserProfileFieldDTO.AD_FILTER, (Object)UsersKeys.Products.USER_PROFILE_FIELDS_AD_FILTER).col((Property)ProductUserProfileFieldDTO.AD_KEYWORDS, (Object)UsersKeys.Products.USER_PROFILE_FIELDS_AD_KEYWORDS).col((Property)ProductUserProfileFieldDTO.RECORD_FILTER, (Object)UsersKeys.Products.USER_PROFILE_FIELDS_RECORD_FILTER).col((Property)ProductUserProfileFieldDTO.RECORD_KEYWORDS, (Object)UsersKeys.Products.USER_PROFILE_FIELDS_RECORD_KEYWORDS).add().property((Property)ProductDTO.DEFAULT_QUICK_ACCESS, UsersKeys.Products.DEFAULT_QUICK_ACCESS).tableProperty((IterableProperty)ProductDTO.MY_ACCESS_CLIENTS, (Object)UsersKeys.Products.MY_ACCESS_CLIENTS).row(ProductMyAccessClientDTO.class, (Property)ProductMyAccessClientDTO.ACCESS_CLIENT_TYPE).col((Property)ProductMyAccessClientDTO.ENABLE, (Object)UsersKeys.Products.ACCESS_CLIENTS_ENABLE).col((Property)ProductMyAccessClientDTO.VIEW, (Object)UsersKeys.Products.GENERAL_VIEW).col((Property)ProductMyAccessClientDTO.MANAGE, (Object)UsersKeys.Products.GENERAL_MANAGE).col((Property)ProductMyAccessClientDTO.BLOCK, (Object)UsersKeys.Products.ACCESS_CLIENTS_BLOCK).col((Property)ProductMyAccessClientDTO.UNBLOCK, (Object)UsersKeys.Products.ACCESS_CLIENTS_UNBLOCK).col((Property)ProductMyAccessClientDTO.ACTIVATE, (Object)UsersKeys.Products.ACCESS_CLIENTS_ACTIVATE).col((Property)ProductMyAccessClientDTO.UNASSIGN, (Object)UsersKeys.Products.ACCESS_CLIENTS_UNASSIGN).add().tableProperty((IterableProperty)ProductDTO.MY_CONTACT_FIELDS, (Object)UsersKeys.Products.MY_CONTACT_FIELDS).row(ProductMyContactFieldDTO.class, (Property)ProductMyContactFieldDTO.CUSTOM_FIELD).col((Property)ProductMyContactFieldDTO.ENABLED, (Object)UsersKeys.Products.CONTACT_FIELDS_ENABLE).col((Property)ProductMyContactFieldDTO.VISIBLE, (Object)UsersKeys.Products.CONTACT_FIELDS_VIEW).col((Property)ProductMyContactFieldDTO.EDITABLE, (Object)UsersKeys.Products.CONTACT_FIELDS_MANAGE).add().tableProperty((IterableProperty)ProductDTO.MY_PROFILE_FIELDS, (Object)UsersKeys.Products.PROFILE_FIELDS).row(ProductMyProfileFieldDTO.class, (Property)ProductMyProfileFieldDTO.PROFILE_FIELD, (Comparator)ProfileFieldComparator.getInstance()).col((Property)ProductMyProfileFieldDTO.ENABLED, (Object)UsersKeys.Products.PROFILE_FIELDS_ENABLE).col((Property)ProductMyProfileFieldDTO.VISIBLE, (Object)UsersKeys.Products.PROFILE_FIELDS_VIEW).col((Property)ProductMyProfileFieldDTO.EDITABLE, (Object)UsersKeys.Products.PROFILE_FIELDS_EDIT).col((Property)ProductMyProfileFieldDTO.EDITABLE_AT_REGISTRATION, (Object)UsersKeys.Products.PROFILE_FIELDS_EDIT_AT_REGISTRATION).col((Property)ProductMyProfileFieldDTO.MANAGE_PRIVACY, (Object)UsersKeys.Products.PROFILE_FIELDS_MANAGE_PRIVACY).add().ignore((Property)ProductDTO.MY_RECORD_TYPE_FIELDS).tableProperty((CollectionPathBase)QProduct.product.myRecordTypes, (Object)UsersKeys.Products.MY_RECORD_TYPES).row(ProductMyRecordFieldDTO.class, (Property)ProductMyRecordFieldDTO.RECORD_TYPE).nestedRow((CollectionPathBase)QProductMyRecordType.productMyRecordType.productRecordCustomFields, (Path)QProductRecordField.productRecordField.customField()).col((Property)ProductMyRecordFieldDTO.ENABLED, (Object)UsersKeys.Products.RECORD_TYPE_ENABLE).col((Property)ProductMyRecordFieldDTO.VIEW, (Object)UsersKeys.Products.RECORD_TYPE_VIEW, true).col((Property)ProductMyRecordFieldDTO.CREATE, (Object)UsersKeys.Products.RECORD_TYPE_CREATE, true).col((Property)ProductMyRecordFieldDTO.EDIT, (Object)UsersKeys.Products.RECORD_TYPE_EDIT, true).col((Property)ProductMyRecordFieldDTO.REMOVE, (Object)UsersKeys.Products.RECORD_TYPE_REMOVE).ignore((Property)ProductMyRecordFieldDTO.CUSTOM_FIELD).add().tableProperty((IterableProperty)ProductDTO.PASSWORD_ACTIONS, (Object)UsersKeys.Products.MY_PASSWORDS_MANAGE).row(MyProductPasswordActionDTO.class, (Property)MyProductPasswordActionDTO.PASSWORD_TYPE).col((Property)MyProductPasswordActionDTO.ENABLE, (Object)UsersKeys.Products.PASSWORD_ACTIONS_ENABLE).col((Property)MyProductPasswordActionDTO.AT_REGISTRATION, (Object)UsersKeys.Products.PASSWORD_ACTIONS_AT_REGISTRATION).col((Property)MyProductPasswordActionDTO.CHANGE, (Object)UsersKeys.Products.PASSWORD_ACTIONS_CHANGE).col((Property)MyProductPasswordActionDTO.UNBLOCK, (Object)UsersKeys.Products.PASSWORD_ACTIONS_UNBLOCK).ignore((Property)MyProductPasswordActionDTO.PRODUCT).add();
        return CollectionHelper.asSet((Object[])new Property[]{ProductDTO.PASSWORD_ACTIONS});
    }

    private Set<Property<?, ?>> doResolveLogDescriptor(UserManagementProduct userManagementProduct, EntityLogDescriptor<UserManagementProductDTO> entityLogDescriptor) {
        entityLogDescriptor.property((Property)UserManagementProductDTO.INCLUDE_BALANCES_IN_EXPORT_USERS_CSV, UsersKeys.Products.INCLUDE_ACCOUNT_BALANCES_AND_NUMBER_IN_EXPORT_USERS).property((Property)UserManagementProductDTO.PRIVACY_CONTROLS, UsersKeys.Products.PRIVACY_CONTROLS).property((Property)UserManagementProductDTO.USER_CUSTOM_OPERATIONS_RUN, UsersKeys.Products.USER_CUSTOM_OPERATIONS_RUN).property((Property)UserManagementProductDTO.USER_WIZARDS, UsersKeys.Products.USER_WIZARDS).property(this.toFilterAccess((Property<Set<TransferFilterWithAccountTypeVO>, ? extends ProductDTO>)UserManagementProductDTO.USER_TRANSFER_FILTERS), UsersKeys.Products.USER_TRANSFER_FILTERS).tableProperty((IterableProperty)UserManagementProductDTO.USER_ACCESS_CLIENTS, (Object)UsersKeys.Products.ACCESS_CLIENTS).row(ProductUserAccessClientDTO.class, (Property)ProductUserAccessClientDTO.ACCESS_CLIENT_TYPE).col((Property)ProductUserAccessClientDTO.VIEW, (Object)UsersKeys.Products.GENERAL_VIEW).col((Property)ProductUserAccessClientDTO.MANAGE, (Object)UsersKeys.Products.GENERAL_MANAGE).col((Property)ProductUserAccessClientDTO.BLOCK, (Object)UsersKeys.Products.ACCESS_CLIENTS_BLOCK).col((Property)ProductUserAccessClientDTO.UNBLOCK, (Object)UsersKeys.Products.ACCESS_CLIENTS_UNBLOCK).col((Property)ProductUserAccessClientDTO.ACTIVATE, (Object)UsersKeys.Products.ACCESS_CLIENTS_ACTIVATE).col((Property)ProductUserAccessClientDTO.UNASSIGN, (Object)UsersKeys.Products.ACCESS_CLIENTS_UNASSIGN).add().tableProperty((IterableProperty)UserManagementProductDTO.USER_AD_FIELDS, (Object)UsersKeys.Products.USER_AD_FIELDS).row(ProductUserAdFieldDTO.class, (Property)ProductUserAdFieldDTO.CUSTOM_FIELD).col((Property)ProductUserAdFieldDTO.VIEW, (Object)UsersKeys.Products.AD_FIELDS_VIEW).col((Property)ProductUserAdFieldDTO.MANAGE, (Object)UsersKeys.Products.AD_FIELDS_MANAGE).add().tableProperty((IterableProperty)UserManagementProductDTO.USER_CONTACT_FIELDS, (Object)UsersKeys.Products.USER_CONTACT_FIELDS).row(ProductUserContactFieldDTO.class, (Property)ProductUserContactFieldDTO.CUSTOM_FIELD).col((Property)ProductUserContactFieldDTO.VISIBLE, (Object)UsersKeys.Products.CONTACT_FIELDS_VIEW).col((Property)ProductUserContactFieldDTO.EDITABLE, (Object)UsersKeys.Products.CONTACT_FIELDS_MANAGE).add().tableProperty((IterableProperty)UserManagementProductDTO.USER_PASSWORD_ACTIONS, (Object)UsersKeys.Products.USER_PASSWORD_ACTIONS).row(UserProductPasswordActionDTO.class, (Property)UserProductPasswordActionDTO.PASSWORD_TYPE).col((Property)UserProductPasswordActionDTO.ENABLE, (Object)UsersKeys.Products.PASSWORD_ACTIONS_ENABLE).col((Property)UserProductPasswordActionDTO.CHANGE, (Object)UsersKeys.Products.PASSWORD_ACTIONS_CHANGE).col((Property)UserProductPasswordActionDTO.UNBLOCK, (Object)UsersKeys.Products.PASSWORD_ACTIONS_UNBLOCK).col((Property)UserProductPasswordActionDTO.RESET, (Object)UsersKeys.Products.PASSWORD_ACTIONS_RESET).ignore((Property)UserProductPasswordActionDTO.PRODUCT).add().ignore((Property)UserManagementProductDTO.USER_RECORD_TYPE_FIELDS).tableProperty((CollectionPathBase)QUserManagementProduct.userManagementProduct.userRecordTypes, (Object)UsersKeys.Products.USER_RECORD_TYPES).row(ProductRecordFieldDTO.class, (Property)ProductRecordFieldDTO.RECORD_TYPE).nestedRow((CollectionPathBase)QProductRecordType.productRecordType.productRecordCustomFields, (Path)QProductRecordField.productRecordField.customField()).col((Property)ProductRecordFieldDTO.VIEW, (Object)UsersKeys.Products.RECORD_TYPE_VIEW, true).col((Property)ProductRecordFieldDTO.CREATE, (Object)UsersKeys.Products.RECORD_TYPE_CREATE, true).col((Property)ProductRecordFieldDTO.EDIT, (Object)UsersKeys.Products.RECORD_TYPE_EDIT, true).col((Property)ProductRecordFieldDTO.REMOVE, (Object)UsersKeys.Products.RECORD_TYPE_REMOVE).ignore((Property)ProductRecordFieldDTO.CUSTOM_FIELD).add().tableProperty((IterableProperty)UserManagementProductDTO.USER_TOKEN_TYPES, (Object)UsersKeys.Products.USER_TOKEN_TYPES).row(ProductUserTokenTypeDTO.class, (Property)ProductUserTokenTypeDTO.TOKEN_TYPE).col((Property)ProductUserTokenTypeDTO.VIEW, (Object)UsersKeys.Products.TOKENS_VIEW).col((Property)ProductUserTokenTypeDTO.CREATE, (Object)UsersKeys.Products.TOKENS_CREATE).col((Property)ProductUserTokenTypeDTO.BLOCK, (Object)UsersKeys.Products.TOKENS_BLOCK).col((Property)ProductUserTokenTypeDTO.UNBLOCK, (Object)UsersKeys.Products.TOKENS_UNBLOCK).col((Property)ProductUserTokenTypeDTO.CHANGE_DATES, (Object)UsersKeys.Products.TOKENS_CHANGE_DATES).col((Property)ProductUserTokenTypeDTO.CANCEL, (Object)UsersKeys.Products.TOKENS_CANCEL).col((Property)ProductUserTokenTypeDTO.INITIALIZE, (Object)UsersKeys.Products.TOKENS_INITIALIZE).col((Property)ProductUserTokenTypeDTO.PERSONALIZE, (Object)UsersKeys.Products.TOKENS_PERSONALIZE).col((Property)ProductUserTokenTypeDTO.ACTIVATE, (Object)UsersKeys.Products.TOKENS_ACTIVATE).add();
        return CollectionHelper.asSet((Object[])new Property[]{UserManagementProductDTO.USER_PASSWORD_ACTIONS});
    }

    private String getStringValue(AdminProduct adminProduct, AdminProductNotification adminProductNotification) {
        Object object = "";
        FormatterImpl formatterImpl = this.getFormatter();
        boolean bl = true;
        switch (adminProductNotification.getType()) {
            case AD_PENDING_AUTHORIZATION: 
            case APPLICATION_ERROR: 
            case NETWORK_CREATED: {
                bl = false;
                break;
            }
            case EXTERNAL_PAYMENT_EXPIRED: {
                object = formatterImpl.format((Collection)adminProduct.getExternalPaymentsExpiredToNotify());
                break;
            }
            case EXTERNAL_PAYMENT_PERFORMED_FAILED: {
                object = formatterImpl.format((Collection)adminProduct.getExternalPaymentsFailedToNotify());
                break;
            }
            case GENERATED_VOUCHERS_EXPIRED: {
                object = formatterImpl.format((Collection)adminProduct.getVoucherConfigurationsToNotify());
                break;
            }
            case PAYMENT_AWAITING_AUTHORIZATION: {
                object = formatterImpl.format((Collection)adminProduct.getAuthorizablePaymentsToNotify());
                break;
            }
            case PAYMENT_PERFORMED: {
                object = formatterImpl.format((Collection)adminProduct.getPaymentsToNotify());
                break;
            }
            case SYSTEM_ALERT: {
                object = formatterImpl.format((Collection)adminProduct.getSystemAlertsToNotify());
                break;
            }
            case USER_ALERT: {
                object = formatterImpl.format((Collection)adminProduct.getUserAlertsToNotify());
                break;
            }
            case USER_REGISTRATION: {
                object = formatterImpl.format((Collection)adminProduct.getUserGroupsToNotify());
                break;
            }
            case VOUCHER_BUYING_ABOUT_TO_EXPIRE: {
                object = formatterImpl.format((Collection)adminProduct.getVoucherConfigurationsBuyingToNotify());
                break;
            }
        }
        object = (String)object + (bl ? ". " : "") + this.message(UsersKeys.Products.NOTIFICATIONS_MEDIUMS, new Object[0]) + ": " + this.message(UsersKeys.Products.NOTIFICATIONS_INTERNAL, new Object[0]);
        if (adminProductNotification.isDefaultMail()) {
            object = (String)object + ", " + this.message(UsersKeys.Products.NOTIFICATIONS_MAIL, new Object[0]);
        }
        if (adminProductNotification.isDefaultSms()) {
            object = (String)object + ", " + this.message(UsersKeys.Products.NOTIFICATIONS_SMS, new Object[0]);
        }
        return object;
    }

    private EntityLogDescriptor<? extends ProductDTO> processPermissionHandlers(Product product, Set<Property<?, ?>> set, EntityLogDescriptor<ProductDTO> entityLogDescriptor) {
        ProductConversionHandler productConversionHandler = this.productService.getProductConverter(product);
        HashMap hashMap = new HashMap();
        productConversionHandler.getPermissionHandlers().stream().filter(permissionHandler -> !set.contains(permissionHandler.getDTOProperty())).forEach(permissionHandler -> {
            BeanPropertyAccess beanPropertyAccess = null;
            if (permissionHandler instanceof SinglePermissionHandlerImpl) {
                beanPropertyAccess = new SinglePermissionPropertyAccess((SinglePermissionHandlerImpl)permissionHandler);
            } else if (permissionHandler instanceof OperationPermissionHandlerImpl) {
                beanPropertyAccess = new OperationPermissionPropertyAccess((OperationPermissionHandlerImpl)permissionHandler);
            }
            boolean bl = beanPropertyAccess != null || permissionHandler instanceof CollectionPermissionHandlerImpl;
            Property property = permissionHandler.getDTOProperty();
            if (!bl) {
                throw new IllegalArgumentException("Unsupported permission handler for property: " + String.valueOf(property) + ". Please add a mapping in the entity log handler for it and mark to be skipped by this process.");
            }
            if (!hashMap.containsKey(property.getName()) && entityLogDescriptor.getProperties().stream().anyMatch(propertyLogDescriptor -> propertyLogDescriptor.getAccess().getPropertyName().equals(property.getName()))) {
                throw new IllegalArgumentException("A property associated to a permission handler was already mapped: " + String.valueOf(property) + ". Please remove it from the entity handler to allow be added automatically.");
            }
            if (!hashMap.containsKey(property.getName())) {
                if (beanPropertyAccess != null) {
                    entityLogDescriptor.property((PropertyAccess)beanPropertyAccess, permissionHandler.getKey());
                } else {
                    entityLogDescriptor.property(property, permissionHandler.getKey());
                }
                hashMap.put(property.getName(), Boolean.TRUE);
            }
        });
        return entityLogDescriptor;
    }

    private Class<? extends ProductDTO> resolveDtoType(Product product) {
        switch (product.getNature()) {
            case ADMIN: {
                return AdminProductDTO.class;
            }
            case BROKER: {
                return BrokerProductDTO.class;
            }
            case MEMBER: {
                return MemberProductDTO.class;
            }
        }
        throw new IllegalArgumentException("Unknown product nature: " + String.valueOf(product.getNature()));
    }

    private PropertyAccess toAmountAccess(Property<?, MemberProductDTO> property, final boolean bl) {
        return new BeanPropertyAccess(property){

            public Object get(Object object) {
                if (super.get(object) == null) {
                    return null;
                }
                MemberProduct memberProduct = (MemberProduct)object;
                if (memberProduct.getCurrency() == null) {
                    return null;
                }
                BigDecimal bigDecimal = (BigDecimal)super.get(object);
                return ProductEntityLogHandlerImpl.this.getFormatter().format(bl ? bigDecimal.negate() : bigDecimal, memberProduct.getCurrency().getPrecision());
            }
        };
    }

    private PropertyAccess toFilterAccess(Property<Set<TransferFilterWithAccountTypeVO>, ? extends ProductDTO> property) {
        return new BeanPropertyAccess(property){

            public Object get(Object object) {
                if (super.get(object) == null) {
                    return null;
                }
                Set set = (Set)super.get(object);
                return CollectionHelper.asStream((Iterable)set).map(transferFilter -> ProductEntityLogHandlerImpl.this.dataTranslationHandler.getName((NamedEntity)transferFilter.getAccountType()) + " - " + ProductEntityLogHandlerImpl.this.dataTranslationHandler.getName((NamedEntity)transferFilter)).collect(Collectors.toSet());
            }
        };
    }

    private class SinglePermissionPropertyAccess
    extends BeanPropertyAccess {
        private SinglePermissionHandlerImpl<?, Product, ?, ?> sph;

        public SinglePermissionPropertyAccess(SinglePermissionHandlerImpl<?, Product, ?, ?> singlePermissionHandlerImpl) {
            super(singlePermissionHandlerImpl.getDTOProperty());
            this.sph = singlePermissionHandlerImpl;
        }

        public Object get(Object object) {
            Object obj = this.sph.getValue((Product)object);
            if ((this.sph.getDTOProperty() == MemberProductDTO.SEARCH_USERS_ON_GROUPS || this.sph.getDTOProperty() == MemberProductDTO.VIEW_PROFILE_ON_GROUPS) && obj == UserGroupAccessibility.ALL) {
                return UsersKeys.Products.ALL_ACCESSIBLE_GROUPS;
            }
            return obj;
        }
    }

    private class OperationPermissionPropertyAccess
    extends BeanPropertyAccess {
        private OperationPermissionHandlerImpl<?, ?, ?> oph;

        public OperationPermissionPropertyAccess(OperationPermissionHandlerImpl<?, ?, ?> operationPermissionHandlerImpl) {
            super(operationPermissionHandlerImpl.getDTOProperty());
            this.oph = operationPermissionHandlerImpl;
        }

        public Object get(Object object) {
            Product product = (Product)object;
            return this.oph.readOperations(product.getPermissions());
        }
    }
}

