/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.cyclos.entities.users.Product;
import org.cyclos.impl.BeanHandler;
import org.cyclos.impl.users.ProductsAccessorCacheKey;
import org.cyclos.impl.users.Resolver;
import org.cyclos.impl.users.productresolvers.MaxResolver;
import org.cyclos.impl.users.productresolvers.MinResolver;
import org.cyclos.impl.users.productresolvers.ProductsResolver;
import org.cyclos.impl.utils.cache.AccessorCacheValue;
import org.cyclos.impl.utils.cache.Cache;
import org.cyclos.impl.utils.cache.CacheHandler;
import org.cyclos.impl.utils.cache.CacheType;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.server.utils.PropertyHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.HasDefault;
import org.cyclos.utils.StringHelper;
import org.cyclos.utils.coercion.CoercionHelper;
import org.springframework.context.ApplicationContext;

public class ProductsAccessorInvocationHandlerImpl
implements InvocationHandler,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String TO_STRING = "toString";
    private final BeanHandler beanHandler;
    private final ApplicationContext applicationContext;
    private final RawEntityManagerHandler rawEntityManagerHandler;
    private final Long networkId;
    private final Set<Long> productIds;
    private Cache<ProductsAccessorCacheKey, AccessorCacheValue> cache;

    public ProductsAccessorInvocationHandlerImpl(ApplicationContext applicationContext, Long l, Set<Long> set) {
        this.applicationContext = applicationContext;
        this.cache = ((CacheHandler)applicationContext.getBean(CacheHandler.class)).getCache(CacheType.PRODUCTS_ACCESSOR);
        this.beanHandler = (BeanHandler)applicationContext.getBean(BeanHandler.class);
        this.rawEntityManagerHandler = (RawEntityManagerHandler)applicationContext.getBean(RawEntityManagerHandler.class);
        this.networkId = l;
        this.productIds = set;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public Long getNetworkId() {
        return this.networkId;
    }

    private Set<Product> getProducts() {
        if (CollectionHelper.isEmpty(this.productIds)) {
            return Collections.emptySet();
        }
        return this.productIds.stream().map(l -> (Product)this.rawEntityManagerHandler.find(Product.class, l)).collect(Collectors.toSet());
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        if (method.getName().equals(TO_STRING)) {
            return "ProductsAccessor#" + CollectionHelper.join(this.productIds, (String)",");
        }
        Object object2 = CollectionHelper.first((Object[])objectArray);
        Resolver resolver = method.getAnnotation(Resolver.class);
        if (resolver == null) {
            throw new IllegalStateException(String.format("Method %s.%s must be annotated with @%s", method.getDeclaringClass().getSimpleName(), method.getName(), Resolver.class.getSimpleName()));
        }
        ProductsResolver productsResolver = (ProductsResolver)this.beanHandler.getBean(resolver.value());
        Callable<Object> callable = () -> {
            try {
                Object object2;
                String string = resolver.name();
                if (StringHelper.isBlank((Object)string)) {
                    try {
                        string = PropertyHelper.getPropertyName((Method)method);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((object2 = productsResolver.resolve(this.getProducts(), string, object2)) == null) {
                    if (method.getReturnType().isPrimitive()) {
                        object2 = CoercionHelper.coerce(method.getReturnType(), null);
                    } else if (method.getReturnType().isEnum()) {
                        Class clazz = resolver.value();
                        ?[] objArray = method.getReturnType().getEnumConstants();
                        if (HasDefault.class.isAssignableFrom(method.getReturnType())) {
                            object2 = Stream.of(objArray).map(HasDefault.class::cast).filter(HasDefault::isDefault).findAny().get();
                        } else if (MaxResolver.class.isAssignableFrom(clazz)) {
                            object2 = objArray[0];
                        } else if (MinResolver.class.isAssignableFrom(clazz)) {
                            object2 = objArray[objArray.length - 1];
                        }
                    }
                }
                return object2;
            }
            catch (Exception exception) {
                throw exception;
            }
            catch (Throwable throwable) {
                throw new InvocationTargetException(throwable);
            }
        };
        if (productsResolver.cacheResult()) {
            ProductsAccessorCacheKey productsAccessorCacheKey = new ProductsAccessorCacheKey(this.networkId, this.productIds, method.getName(), object2);
            AccessorCacheValue accessorCacheValue = (AccessorCacheValue)this.cache.get((Serializable)productsAccessorCacheKey, () -> AccessorCacheValue.create(callable.call()));
            return accessorCacheValue.unwrap(this.applicationContext);
        }
        return callable.call();
    }
}

