/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.banking.UserAccountType;
import org.cyclos.entities.users.AdminGroup;
import org.cyclos.entities.users.BasicGroup;
import org.cyclos.entities.users.BrokerGroup;
import org.cyclos.entities.users.Group;
import org.cyclos.entities.users.GroupProductLog;
import org.cyclos.entities.users.GroupSet;
import org.cyclos.entities.users.MemberGroup;
import org.cyclos.entities.users.MemberProduct;
import org.cyclos.entities.users.Product;
import org.cyclos.entities.users.QGroupProductLog;
import org.cyclos.entities.users.QProductManagement;
import org.cyclos.entities.users.UserGroup;
import org.cyclos.impl.banking.AccountServiceLocal;
import org.cyclos.impl.system.InlineScriptBackgroundTask;
import org.cyclos.impl.users.BaseProductsOwnerServiceImpl;
import org.cyclos.impl.users.BulkActionServiceLocal;
import org.cyclos.impl.users.ProductServiceLocal;
import org.cyclos.impl.users.ProductsGroupServiceLocal;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.tasks.BackgroundTaskHandler;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.Role;
import org.cyclos.model.users.bulkactions.AdjustAccountsBulkActionDTO;
import org.cyclos.model.users.groups.AdminGroupType;
import org.cyclos.model.users.groups.BasicGroupVO;
import org.cyclos.model.users.groups.GroupProductsCollections;
import org.cyclos.model.users.products.ProductAssignmentLogVO;
import org.cyclos.model.users.products.ProductLevel;
import org.cyclos.model.users.products.ProductLevelData;
import org.cyclos.model.users.products.ProductWithUserAccountVO;
import org.cyclos.model.users.users.UserQuery;
import org.cyclos.security.users.GroupServiceSecurity;
import org.cyclos.utils.CollectionHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProductsGroupServiceImpl
extends BaseProductsOwnerServiceImpl<BasicGroup, GroupProductLog, BasicGroupVO, GroupProductsCollections>
implements ProductsGroupServiceLocal {
    @Autowired
    private ProductServiceLocal productService;
    @Autowired
    private GroupServiceSecurity groupServiceSecurity;
    @Autowired
    private BulkActionServiceLocal bulkActionService;
    @Autowired
    private AccountServiceLocal accountService;
    @Autowired
    private BackgroundTaskHandler backgroundTaskHandler;
    private boolean ignoreBulkActionOnAccountsAdjustment;

    public ProductsGroupServiceImpl() {
        super(BasicGroup.class, GroupProductLog.class);
    }

    @Override
    public GroupProductsCollections getDataWithoutLogs(BasicGroup basicGroup) {
        Collection collection;
        Object object2;
        GroupProductsCollections groupProductsCollections = new GroupProductsCollections();
        groupProductsCollections.setBasicGroup((BasicGroupVO)this.conversionHandler.convert(BasicGroupVO.class, (Object)basicGroup));
        boolean bl = this.groupServiceSecurity.hasManageAccess((SimpleEntity)basicGroup);
        HashSet hashSet = basicGroup.getProducts();
        if (basicGroup instanceof AdminGroup) {
            hashSet = new HashSet(hashSet);
            hashSet.remove(((AdminGroup)basicGroup).getAdminProduct());
        }
        List list = this.conversionHandler.convertList(ProductWithUserAccountVO.class, hashSet);
        ProductLevelData productLevelData = new ProductLevelData();
        productLevelData.setLevel(basicGroup instanceof GroupSet ? ProductLevel.GROUP_SET : ProductLevel.GROUP);
        productLevelData.setThisLevelsProducts(CollectionHelper.sort((Collection)list));
        groupProductsCollections.setAssigned(productLevelData);
        HashSet<ProductWithUserAccountVO> hashSet2 = new HashSet<ProductWithUserAccountVO>(hashSet.size());
        QProductManagement qProductManagement = QProductManagement.productManagement;
        boolean bl2 = this.hasPermission(Permission.USER_CONFIGURATION_MANAGE);
        if (bl) {
            for (Object object2 : hashSet) {
                boolean bl3 = bl2 || this.getProducts().admin().getManagedProducts().isSet(object2, (Path)qProductManagement.assignToGroups);
                if (!bl3) continue;
                hashSet2.add((ProductWithUserAccountVO)this.conversionHandler.convert(ProductWithUserAccountVO.class, object2));
            }
        }
        groupProductsCollections.setUnassignable(hashSet2);
        boolean bl4 = false;
        if (basicGroup instanceof Group) {
            object2 = (Group)basicGroup;
            bl4 = object2 instanceof AdminGroup;
            GroupSet groupSet = object2 instanceof UserGroup ? ((UserGroup)object2).getGroupSet() : null;
            collection = new HashSet();
            if (groupSet != null) {
                collection.addAll(groupSet.getProducts());
            }
            List list2 = this.conversionHandler.convertList(ProductWithUserAccountVO.class, collection);
            ProductLevelData productLevelData2 = new ProductLevelData();
            productLevelData2.setLevel(ProductLevel.GROUP_SET);
            productLevelData2.setThisLevelsProducts(CollectionHelper.sort((Collection)list2));
            productLevelData.setLevelUp(productLevelData2);
        }
        object2 = Collections.emptyList();
        if (bl) {
            Set<Role> set = bl4 ? Collections.singleton(Role.ADMIN) : (basicGroup instanceof BrokerGroup ? EnumSet.of(Role.MEMBER, Role.BROKER) : Collections.singleton(Role.MEMBER));
            object2 = this.productService.listByRoles(set);
        }
        ArrayList<Product> arrayList = new ArrayList<Product>((Collection<Product>)object2);
        arrayList.removeAll(hashSet);
        arrayList.removeIf(product -> !bl2 && !this.getProducts().admin().getManagedProducts().isSet(product, (Path)qProductManagement.assignToGroups));
        collection = this.conversionHandler.convertList(ProductWithUserAccountVO.class, arrayList);
        groupProductsCollections.setAvailable(CollectionHelper.sort(collection));
        return groupProductsCollections;
    }

    public boolean isIgnoreBulkActionOnAccountsAdjustment() {
        return this.ignoreBulkActionOnAccountsAdjustment;
    }

    public void setIgnoreBulkActionOnAccountsAdjustment(boolean bl) {
        this.ignoreBulkActionOnAccountsAdjustment = bl;
    }

    @Override
    protected List<ProductAssignmentLogVO> getLogs(BasicGroup basicGroup) {
        QGroupProductLog qGroupProductLog = QGroupProductLog.groupProductLog;
        return ((DBQuery)((DBQuery)this.from(new EntityPath[]{qGroupProductLog}).where((Predicate)qGroupProductLog.basicGroup().eq((Object)basicGroup))).orderBy(qGroupProductLog.date.desc())).list(ProductAssignmentLogVO.class, (Expression)qGroupProductLog);
    }

    @Override
    protected boolean isCanAssign(BasicGroup basicGroup) {
        return true;
    }

    @Override
    protected void onProductAssigned(BasicGroup basicGroup, Product product) {
        this.maybeAdjustAccounts(basicGroup, product, true);
    }

    @Override
    protected void onProductUnassigned(BasicGroup basicGroup, Product product) {
        this.maybeAdjustAccounts(basicGroup, product, false);
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
    }

    @Override
    protected void validateAssign(BasicGroup basicGroup, Product product) {
        if (!this.isCanAssign(basicGroup)) {
            throw new IllegalActionException();
        }
        Collection<Object> collection = Collections.emptySet();
        if (basicGroup instanceof AdminGroup) {
            AdminGroup adminGroup = (AdminGroup)basicGroup;
            collection = adminGroup.getAdminType() == AdminGroupType.GLOBAL ? Collections.emptySet() : Collections.singleton(Role.ADMIN);
        } else if (basicGroup instanceof MemberGroup) {
            collection = Arrays.asList(Role.MEMBER);
        } else if (basicGroup instanceof BrokerGroup) {
            collection = Arrays.asList(Role.MEMBER, Role.BROKER);
        } else if (basicGroup instanceof GroupSet) {
            collection = Arrays.asList(Role.MEMBER);
        }
        if (!collection.contains(product.getRole())) {
            throw new IllegalActionException();
        }
    }

    @Override
    protected void validateUnAssign(BasicGroup basicGroup, Product product) {
        AdminGroup adminGroup;
        if (basicGroup instanceof AdminGroup && product.equals((Object)(adminGroup = (AdminGroup)basicGroup).getAdminProduct())) {
            throw new IllegalActionException();
        }
    }

    private void maybeAdjustAccounts(BasicGroup basicGroup, Product product3, boolean bl) {
        MemberProduct memberProduct;
        UserAccountType userAccountType;
        if (this.isIgnoreBulkActionOnAccountsAdjustment()) {
            return;
        }
        if (product3 instanceof MemberProduct && (userAccountType = (memberProduct = (MemberProduct)product3).getUserAccount()) != null) {
            GroupSet groupSet;
            boolean bl2 = basicGroup.getProducts().stream().filter(product2 -> !product2.equals((Object)product3)).anyMatch(product -> product instanceof MemberProduct && userAccountType.equals((Object)((MemberProduct)product).getUserAccount()));
            if (!bl2 && basicGroup instanceof UserGroup && (groupSet = ((UserGroup)basicGroup).getGroupSet()) != null) {
                bl2 = groupSet.getProducts().stream().anyMatch(product -> product instanceof MemberProduct && userAccountType.equals((Object)((MemberProduct)product).getUserAccount()));
            }
            if (bl2) {
                return;
            }
            if (!bl || this.accountService.shouldAdjustAccountsWhenAssigning(memberProduct)) {
                groupSet = new AdjustAccountsBulkActionDTO();
                UserQuery userQuery = new UserQuery();
                userQuery.setUserStatus(AccountServiceLocal.POSSIBLE_STATUSES_TO_OWN_ACCOUNTS);
                userQuery.setGroups(Collections.singleton(new BasicGroupVO(basicGroup.getId())));
                groupSet.setQuery(userQuery);
                this.bulkActionService.save((EntityDTO)groupSet);
            } else {
                this.backgroundTaskHandler.schedule(InlineScriptBackgroundTask.scheduling(String.format("accountService.reactivateAccounts(%s, %s)", userAccountType.getId(), basicGroup.getId())));
            }
        }
    }
}

