/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import com.google.common.collect.Sets;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.access.Channel;
import org.cyclos.entities.access.PrincipalType;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.users.AdminProduct;
import org.cyclos.entities.users.BasicGroup;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.BrokerProduct;
import org.cyclos.entities.users.IMemberOrBrokerProduct;
import org.cyclos.entities.users.IProduct;
import org.cyclos.entities.users.MemberProduct;
import org.cyclos.entities.users.Operator;
import org.cyclos.entities.users.OperatorGroup;
import org.cyclos.entities.users.Product;
import org.cyclos.entities.users.ProductOwner;
import org.cyclos.entities.users.UserManagementProduct;
import org.cyclos.impl.BaseNetworkedHandlerImpl;
import org.cyclos.impl.BeanHandler;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.users.AdminProductAccessor;
import org.cyclos.impl.users.BrokerProductAccessor;
import org.cyclos.impl.users.EmptyAdminProductAccessor;
import org.cyclos.impl.users.EmptyBrokerProductAccessor;
import org.cyclos.impl.users.EmptyMemberOrBrokerProductAccessor;
import org.cyclos.impl.users.EmptyMemberProductAccessor;
import org.cyclos.impl.users.EmptyProductAccessor;
import org.cyclos.impl.users.EmptyUserManagementProductAccessor;
import org.cyclos.impl.users.MemberOrBrokerProductAccessor;
import org.cyclos.impl.users.MemberProductAccessor;
import org.cyclos.impl.users.ProductAccessor;
import org.cyclos.impl.users.ProductAccessorStorageKey;
import org.cyclos.impl.users.ProductsAccessor;
import org.cyclos.impl.users.ProductsAccessorImpl;
import org.cyclos.impl.users.ProductsAccessorInvocationHandlerImpl;
import org.cyclos.impl.users.ProductsHandler;
import org.cyclos.impl.users.RestrictedOperatorProductsAccessor;
import org.cyclos.impl.users.UserManagementProductAccessor;
import org.cyclos.impl.users.productresolvers.BooleanPropertiesResolver;
import org.cyclos.impl.utils.BooleanProperties;
import org.cyclos.impl.utils.BooleanPropertiesHolder;
import org.cyclos.impl.utils.LocalStorage;
import org.cyclos.impl.utils.cluster.ClusterHandler;
import org.cyclos.impl.utils.cluster.LocalStorageType;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.model.Bean;
import org.cyclos.model.Property;
import org.cyclos.utils.CollectionHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProductsHandlerImpl
extends BaseNetworkedHandlerImpl
implements ProductsHandler {
    private static final Class<?>[] ACCESSOR_INTERFACES = new Class[]{ProductAccessor.class, UserManagementProductAccessor.class, AdminProductAccessor.class, MemberOrBrokerProductAccessor.class, BrokerProductAccessor.class, MemberProductAccessor.class};
    private ProductsAccessor emptyAccessor;
    private Map<CacheKey, Object> proxyMap;
    private Map<Class<? extends IProduct>, ProductAccessor> emptyAccessorMap;
    private Map<Class<? extends BooleanPropertiesResolver<?>>, BooleanPropertiesResolver<?>> propertyResolvers = new HashMap();
    @Autowired
    private BeanHandler beanHandler;
    @Autowired
    private ClusterHandler clusterHandler;
    private LocalStorage<ProductAccessorStorageKey, ProductAccessor> accessorsLocalStorage;
    @Autowired
    private RawEntityManagerHandler rawEntityManagerHandler;

    public ProductsAccessor getAccessibleGroupsAccessor() {
        Set set = this.groupsHandler.accessibles().groups().items();
        return this.getAccessor(set);
    }

    public ProductsAccessor getAccessor(BasicGroup basicGroup) {
        return this.doGetAccessorFor(this.findAll(basicGroup.getAllProductIds()), null, null);
    }

    public ProductsAccessor getAccessor(BasicUser basicUser) {
        SessionData sessionData = this.getSessionData();
        if (!sessionData.isSystem()) {
            if (basicUser.equals((Object)sessionData.getLoggedBasicUser())) {
                return sessionData.getProducts();
            }
            if (sessionData.isOperator() && basicUser.equals((Object)sessionData.getLoggedUser())) {
                return sessionData.getProducts();
            }
        }
        return this.getAccessor(basicUser, null, null);
    }

    public ProductsAccessor getAccessor(BasicUser basicUser, Channel channel, PrincipalType principalType) {
        Object object;
        SessionData sessionData;
        if (basicUser instanceof Operator && (sessionData = (object = (Operator)basicUser).getGroup()) != null) {
            ProductsAccessor productsAccessor = this.getAccessor((BasicUser)object.getUser(), channel, principalType);
            return new RestrictedOperatorProductsAccessor((OperatorGroup)sessionData, productsAccessor);
        }
        sessionData = this.getSessionData();
        object = basicUser.isGlobal() && sessionData.getNetwork() != null ? sessionData.getNetwork().getAdministrators().getAllProductIds() : basicUser.getUser().getAllProductIds();
        return this.doGetAccessorFor(this.findAll((Collection<Long>)object), channel, principalType);
    }

    public ProductsAccessor getAccessor(BasicUser basicUser, Network network) {
        if (network != null) {
            if (basicUser.isGlobal()) {
                return this.getAccessor((BasicGroup)network.getAdministrators());
            }
            if (basicUser.getNetwork().equals((Object)network)) {
                return this.getAccessor(basicUser);
            }
            throw new IllegalArgumentException();
        }
        if (basicUser.isGlobal()) {
            return this.getAccessor(basicUser);
        }
        throw new IllegalArgumentException();
    }

    public ProductsAccessor getAccessor(Collection<? extends ProductOwner> collection) {
        if (CollectionHelper.isEmpty(collection)) {
            return this.emptyAccessor;
        }
        Set<Long> set = collection.stream().flatMap(productOwner -> productOwner.getAllProductIds().stream()).collect(Collectors.toSet());
        return this.doGetAccessorFor(this.findAll(set), null, null);
    }

    public ProductsAccessor getAccessorFor(Collection<? extends Product> collection) {
        return this.doGetAccessorFor(collection, null, null);
    }

    public ProductsAccessor getAccessorFor(Collection<Product> collection, Channel channel, PrincipalType principalType) {
        return this.doGetAccessorFor(collection, channel, principalType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <PR extends BooleanPropertiesResolver<?>> PR getPropertyResolver(Class<PR> clazz) {
        BooleanPropertiesResolver booleanPropertiesResolver = this.propertyResolvers.get(clazz);
        if (booleanPropertiesResolver == null) {
            ProductsHandlerImpl productsHandlerImpl = this;
            synchronized (productsHandlerImpl) {
                booleanPropertiesResolver = this.propertyResolvers.get(clazz);
                if (booleanPropertiesResolver == null) {
                    booleanPropertiesResolver = (BooleanPropertiesResolver)this.beanHandler.autowire(clazz);
                    this.propertyResolvers.put(clazz, booleanPropertiesResolver);
                }
            }
        }
        return (PR)booleanPropertiesResolver;
    }

    public Object getProxy(Class<? extends IProduct> clazz, Collection<? extends Product> collection) {
        if (CollectionHelper.isEmpty(collection)) {
            return this.emptyAccessorMap.get(clazz);
        }
        return this.doGetProxy(SimpleEntity.id((SimpleEntity)this.getSessionData().getNetwork()), collection);
    }

    @PostConstruct
    public void initialize() {
        this.accessorsLocalStorage = this.clusterHandler.getLocalStorage(LocalStorageType.PRODUCT_ACCESSORS);
        Set set = Collections.emptySet();
        this.emptyAccessor = this.getAccessorFor(set);
        this.proxyMap = new HashMap<CacheKey, Object>();
        this.emptyAccessorMap = new HashMap<Class<? extends IProduct>, ProductAccessor>();
        this.emptyAccessorMap.put(Product.class, EmptyProductAccessor.getInstance());
        this.emptyAccessorMap.put(UserManagementProduct.class, (ProductAccessor)EmptyUserManagementProductAccessor.getInstance());
        this.emptyAccessorMap.put(AdminProduct.class, (ProductAccessor)EmptyAdminProductAccessor.getInstance());
        this.emptyAccessorMap.put(BrokerProduct.class, (ProductAccessor)EmptyBrokerProductAccessor.getInstance());
        this.emptyAccessorMap.put(MemberProduct.class, (ProductAccessor)EmptyMemberProductAccessor.getInstance());
        this.emptyAccessorMap.put(IMemberOrBrokerProduct.class, (ProductAccessor)EmptyMemberOrBrokerProductAccessor.getInstance());
    }

    public <R extends Bean, K> List<R> toList(Collection<K> collection, BooleanPropertiesHolder<K> booleanPropertiesHolder, Class<R> clazz, Property<?, R> property) {
        ArrayList<Bean> arrayList = new ArrayList<Bean>();
        for (K k : collection) {
            BooleanProperties booleanProperties = booleanPropertiesHolder.get(k);
            Bean bean = (Bean)booleanProperties.instantiate(clazz);
            Object object = this.conversionHandler.convert(property.getType(), k);
            bean.set(property, object);
            arrayList.add(bean);
        }
        return arrayList;
    }

    private Object createProxy(CacheKey cacheKey) {
        ProductAccessorStorageKey productAccessorStorageKey = new ProductAccessorStorageKey(cacheKey.networkId, cacheKey.productIds);
        return this.accessorsLocalStorage.get((Object)productAccessorStorageKey, () -> {
            ProductsAccessorInvocationHandlerImpl productsAccessorInvocationHandlerImpl = new ProductsAccessorInvocationHandlerImpl(this.getApplicationContext(), cacheKey.networkId, Sets.newHashSet((Object[])cacheKey.productIds));
            return (ProductAccessor)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), ACCESSOR_INTERFACES, (InvocationHandler)productsAccessorInvocationHandlerImpl);
        });
    }

    private ProductsAccessor doGetAccessorFor(Collection<? extends Product> collection, Channel channel, PrincipalType principalType) {
        return new ProductsAccessorImpl(this, collection, channel, principalType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object doGetProxy(Long l, Collection<? extends Product> collection) {
        CacheKey cacheKey = new CacheKey(l, SimpleEntity.uniqueIds(collection));
        Object object = this.proxyMap.get(cacheKey);
        if (object == null) {
            Map<CacheKey, Object> map = this.proxyMap;
            synchronized (map) {
                object = this.proxyMap.get(cacheKey);
                if (object == null) {
                    object = this.createProxy(cacheKey);
                }
            }
        }
        return object;
    }

    private Set<Product> findAll(Collection<Long> collection) {
        return collection.stream().map(l -> (Product)this.rawEntityManagerHandler.find(Product.class, l)).collect(Collectors.toSet());
    }

    private static class CacheKey {
        private final Long networkId;
        private final Long[] productIds;

        public CacheKey(Long l, Collection<Long> collection) {
            this.networkId = l;
            this.productIds = (Long[])collection.toArray(Long[]::new);
            Arrays.sort((Object[])this.productIds);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)object;
            if (this.networkId == null ? cacheKey.networkId != null : !this.networkId.equals(cacheKey.networkId)) {
                return false;
            }
            return Arrays.equals((Object[])this.productIds, (Object[])cacheKey.productIds);
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this.networkId == null ? 0 : this.networkId.hashCode());
            n = 31 * n + Arrays.hashCode((Object[])this.productIds);
            return n;
        }
    }
}

