/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.DateTimeExpression;
import java.util.Collection;
import java.util.Collections;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.Operator;
import org.cyclos.entities.users.QBasicUser;
import org.cyclos.entities.users.User;
import org.cyclos.entities.users.ValidationKeyType;
import org.cyclos.impl.users.OperatorServiceLocal;
import org.cyclos.impl.users.UserServiceLocal;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.tasks.EntityBatchRecurringTask;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.users.users.UserStatus;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.utils.MessageKey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PurgeUnconfirmedUsersRecurringTask
extends EntityBatchRecurringTask<BasicUser> {
    @Autowired
    private CyclosProperties cyclosProperties;
    @Autowired
    private UserServiceLocal userService;
    @Autowired
    private OperatorServiceLocal operatorService;

    public PurgeUnconfirmedUsersRecurringTask() {
        super(BasicUser.class);
    }

    public MessageKey getMessageKey() {
        return SystemKeys.RecurringTasks.PURGE_UNCONFIRMED_USERS;
    }

    @Override
    protected void finish(BasicUser basicUser, Throwable throwable) throws Throwable {
    }

    @Override
    protected Collection<Long> nextIds() throws Throwable {
        int n = this.cyclosProperties.getPurgeUnconfirmedUsersDays();
        if (n < 1) {
            return Collections.emptyList();
        }
        QBasicUser qBasicUser = QBasicUser.basicUser;
        return ((DBQuery)((DBQuery)this.from(new EntityPath[]{qBasicUser}).where(new Predicate[]{qBasicUser.status.eq((Object)UserStatus.PENDING), qBasicUser.registrationConfirmationDate.isNull(), qBasicUser.validationKeyType.eq((Object)ValidationKeyType.REGISTRATION), qBasicUser.validationKeyDate.addDays(Integer.valueOf(n)).lt((Expression)DateTimeExpression.currentTimestamp())})).limit(200L)).list((Expression)qBasicUser.id);
    }

    @Override
    protected void process(BasicUser basicUser) throws Throwable {
        if (basicUser instanceof User) {
            this.userService.remove((SimpleEntity)((User)basicUser));
        } else if (basicUser instanceof Operator) {
            this.operatorService.remove((SimpleEntity)((Operator)basicUser));
        }
    }

    @Override
    protected boolean shouldSkipFinish(Long l, Throwable throwable) {
        return true;
    }
}

