/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import com.google.api.client.util.Objects;
import java.util.EnumMap;
import java.util.Map;
import org.cyclos.entities.ConfigurationEntity;
import org.cyclos.entities.access.TokenPrincipalType;
import org.cyclos.entities.system.CustomOperation;
import org.cyclos.entities.system.CustomWizard;
import org.cyclos.entities.users.QuickAccess;
import org.cyclos.entities.users.RecordType;
import org.cyclos.impl.BaseNetworkedHandlerImpl;
import org.cyclos.impl.users.QuickAccessHandler;
import org.cyclos.model.ConfigurationEntityVO;
import org.cyclos.model.access.principaltypes.TokenPrincipalTypeVO;
import org.cyclos.model.system.operations.CustomOperationVO;
import org.cyclos.model.system.operations.RunnableCustomOperationVO;
import org.cyclos.model.system.wizards.CustomWizardVO;
import org.cyclos.model.users.dashboard.QuickAccessType;
import org.cyclos.model.users.recordtypes.RecordTypeVO;
import org.cyclos.model.utils.QuickAccessDTO;
import org.springframework.stereotype.Component;

@Component
public class QuickAccessHandlerImpl
extends BaseNetworkedHandlerImpl
implements QuickAccessHandler {
    private Map<QuickAccessType, Types> typeMapping = new EnumMap<QuickAccessType, Types>(QuickAccessType.class);

    public QuickAccessHandlerImpl() {
        this.typeMapping.put(QuickAccessType.OPERATION, new Types(CustomOperation.class, CustomOperationVO.class));
        this.typeMapping.put(QuickAccessType.WIZARD, new Types(CustomWizard.class, CustomWizardVO.class));
        this.typeMapping.put(QuickAccessType.RECORD, new Types(RecordType.class, RecordTypeVO.class));
        this.typeMapping.put(QuickAccessType.TOKEN, new Types(TokenPrincipalType.class, TokenPrincipalTypeVO.class));
    }

    public boolean matches(QuickAccess quickAccess, QuickAccessDTO quickAccessDTO) {
        return quickAccess.matches(quickAccessDTO.getType(), this.toEntity(quickAccessDTO));
    }

    public boolean matches(QuickAccessDTO quickAccessDTO, QuickAccess quickAccess) {
        return quickAccessDTO.getType().equals((Object)quickAccess.getType()) && Objects.equal((Object)this.toEntity(quickAccessDTO), (Object)quickAccess.getEntity());
    }

    public ConfigurationEntity toEntity(QuickAccessDTO quickAccessDTO) {
        ConfigurationEntityVO configurationEntityVO = quickAccessDTO.getEntity();
        if (configurationEntityVO == null || quickAccessDTO.getType() == null) {
            return null;
        }
        Types types = this.typeMapping.get(quickAccessDTO.getType());
        return (ConfigurationEntity)this.conversionHandler.convert(types.entityType, (Object)configurationEntityVO);
    }

    public ConfigurationEntityVO toEntityVO(QuickAccess quickAccess) {
        ConfigurationEntity configurationEntity = quickAccess.getEntity();
        if (configurationEntity == null || quickAccess.getType() == null) {
            return null;
        }
        Types types = this.typeMapping.get(quickAccess.getType());
        return (ConfigurationEntityVO)this.conversionHandler.convert(types.entityVOType, (Object)configurationEntity);
    }

    public QuickAccessDTO toRunnableDTO(QuickAccess quickAccess) {
        if (quickAccess.getType() == QuickAccessType.OPERATION) {
            QuickAccessDTO quickAccessDTO = (QuickAccessDTO)this.conversionHandler.convertExcluding(QuickAccessDTO.class, (Object)quickAccess, new Object[]{QuickAccessDTO.ENTITY});
            quickAccessDTO.setEntity((ConfigurationEntityVO)this.conversionHandler.convert(RunnableCustomOperationVO.class, (Object)quickAccess.getEntity()));
            return quickAccessDTO;
        }
        return (QuickAccessDTO)this.conversionHandler.convert(QuickAccessDTO.class, (Object)quickAccess);
    }

    private static class Types {
        private final Class<? extends ConfigurationEntity> entityType;
        private final Class<? extends ConfigurationEntityVO> entityVOType;

        private Types(Class<? extends ConfigurationEntity> clazz, Class<? extends ConfigurationEntityVO> clazz2) {
            this.entityType = clazz;
            this.entityVOType = clazz2;
        }
    }
}

