/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import com.querydsl.core.types.Path;
import java.util.Collection;
import org.apache.commons.lang3.ArrayUtils;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.users.QProductRecordField;
import org.cyclos.entities.users.Record;
import org.cyclos.entities.users.RecordType;
import org.cyclos.entities.users.SystemRecordType;
import org.cyclos.entities.users.User;
import org.cyclos.entities.users.UserRecordType;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.system.CustomFieldValueHandler;
import org.cyclos.impl.users.RecordFieldHandler;
import org.cyclos.impl.utils.BooleanPropertiesHolder;
import org.cyclos.impl.utils.conversion.BaseEntityConverter;
import org.cyclos.model.marketplace.advertisements.BasicAdDTO;
import org.cyclos.model.users.records.RecordDTO;
import org.cyclos.model.users.records.UserRecordDTO;
import org.cyclos.utils.ObjectHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RecordConverter
extends BaseEntityConverter<Record> {
    @Autowired
    private CustomFieldValueHandler customFieldValueHandler;
    @Autowired
    private RecordFieldHandler recordFieldHandler;

    public RecordConverter() {
        super(Record.class);
    }

    @Override
    protected void fill(Object object, Record record, Object[] objectArray, InvocationContext.ConversionContext conversionContext) {
        if (object instanceof RecordDTO) {
            RecordDTO recordDTO = (RecordDTO)object;
            RecordType recordType = record.isPersistent() ? record.getType() : (RecordType)this.conversionHandler.convert(RecordType.class, recordDTO.getType());
            if (recordType != null) {
                Object object2;
                BooleanPropertiesHolder booleanPropertiesHolder;
                SystemRecordType systemRecordType;
                SessionData sessionData = this.getSessionData();
                if (recordType instanceof SystemRecordType) {
                    systemRecordType = (SystemRecordType)recordType;
                    booleanPropertiesHolder = sessionData.getProducts().admin().getSystemRecordFields(systemRecordType);
                } else {
                    systemRecordType = (UserRecordDTO)recordDTO;
                    object2 = (User)ObjectHelper.defaultValue((Object)((User)this.conversionHandler.convert(User.class, systemRecordType.getUser())), (Object)sessionData.getLoggedUser());
                    UserRecordType userRecordType = (UserRecordType)recordType;
                    booleanPropertiesHolder = sessionData.isLoggedIn() && sessionData.getLoggedUser().equals(object2) ? sessionData.getProducts().product().getMyRecordFields(userRecordType) : sessionData.getProducts().userManagement().getUserRecordFields(userRecordType);
                }
                systemRecordType = QProductRecordField.productRecordField;
                object2 = booleanPropertiesHolder.keysSet((Path)(record.isTransient() ? systemRecordType.create : systemRecordType.edit));
                this.customFieldValueHandler.setCustomValues((SimpleEntity)record, (Collection)this.recordFieldHandler.getAllFields(recordType), (Collection)object2, (Collection)recordDTO.getCustomValues());
                objectArray = ArrayUtils.add((Object[])objectArray, (Object)BasicAdDTO.CUSTOM_VALUES);
            }
        }
        super.fill(object, record, objectArray, conversionContext);
    }
}

