/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import java.util.Set;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.users.RecordCustomField;
import org.cyclos.impl.EntityLogDescriptor;
import org.cyclos.impl.system.BaseCustomFieldEntityLogHandlerImpl;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.model.CRUDOperation;
import org.cyclos.model.Property;
import org.cyclos.model.system.entitylogs.EntityLogType;
import org.cyclos.model.system.entitylogs.EntityPropertyLogQuery;
import org.cyclos.model.users.UsersKeys;
import org.cyclos.model.users.recordfields.RecordCustomFieldDTO;
import org.cyclos.security.users.RecordCustomFieldServiceSecurity;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class RecordCustomFieldEntityLogHandlerImpl
extends BaseCustomFieldEntityLogHandlerImpl<RecordCustomField, RecordCustomFieldDTO> {
    @Autowired
    @Lazy
    private RecordCustomFieldServiceSecurity recordCustomFieldServiceSecurity;

    public Class<RecordCustomField> getEntityClass() {
        return RecordCustomField.class;
    }

    public EntityLogType getType() {
        return EntityLogType.RECORD_CUSTOM_FIELD;
    }

    @Override
    public EntityLogDescriptor<RecordCustomFieldDTO> resolveLogDescriptor(RecordCustomField recordCustomField) {
        return super.resolveLogDescriptor(recordCustomField).property((Property)RecordCustomFieldDTO.COLSPAN, UsersKeys.RecordFields.COLSPAN).property((Property)RecordCustomFieldDTO.SHOW_IN_LIST, UsersKeys.RecordFields.SHOW_IN_LIST).property((Property)RecordCustomFieldDTO.SHOW_IN_SEARCH, UsersKeys.RecordFields.SHOW_IN_SEARCH).ignore((Property)RecordCustomFieldDTO.RECORD_TYPE);
    }

    @Override
    protected Pair<Boolean, Set<EntityLogType>> doApplyLogFilters(DBQuery<?> dBQuery, long l, EntityPropertyLogQuery entityPropertyLogQuery) {
        return new Pair((Object)true, (Object)CollectionHelper.asSet((Object[])new EntityLogType[]{EntityLogType.RECORD_CUSTOM_FIELD_POSSIBLE_VALUE}));
    }

    @Override
    protected RecordCustomField getEntityToViewLog(long l) {
        RecordCustomField recordCustomField = this.find(RecordCustomField.class, l);
        if (this.recordCustomFieldServiceSecurity.canPerformOperation((SimpleEntity)recordCustomField, CRUDOperation.READ)) {
            return recordCustomField;
        }
        return null;
    }

    @Override
    protected Class<RecordCustomFieldDTO> resolveDtoType(RecordCustomField recordCustomField) {
        return RecordCustomFieldDTO.class;
    }
}

