/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import com.querydsl.core.types.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.cyclos.entities.users.AdminProduct;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.Product;
import org.cyclos.entities.users.ProductMyRecordType;
import org.cyclos.entities.users.ProductRecordField;
import org.cyclos.entities.users.ProductRecordType;
import org.cyclos.entities.users.ProductSystemRecordType;
import org.cyclos.entities.users.ProductUserRecordType;
import org.cyclos.entities.users.QProductMyRecordType;
import org.cyclos.entities.users.QProductRecordField;
import org.cyclos.entities.users.RecordCustomField;
import org.cyclos.entities.users.RecordCustomFieldValue;
import org.cyclos.entities.users.RecordSection;
import org.cyclos.entities.users.RecordType;
import org.cyclos.entities.users.RecordTypeSharedRecordField;
import org.cyclos.entities.users.SystemRecordType;
import org.cyclos.entities.users.User;
import org.cyclos.entities.users.UserManagementProduct;
import org.cyclos.entities.users.UserRecordType;
import org.cyclos.impl.BaseNetworkedHandlerImpl;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.users.ProductServiceLocal;
import org.cyclos.impl.users.ProductsAccessor;
import org.cyclos.impl.users.RecordCustomFieldServiceLocal;
import org.cyclos.impl.users.RecordFieldHandler;
import org.cyclos.impl.users.RecordTypeServiceLocal;
import org.cyclos.impl.utils.BooleanPropertiesHolder;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.IInternalNamedEntity;
import org.cyclos.model.system.fields.CustomFieldVO;
import org.cyclos.model.users.products.AdminProductDTO;
import org.cyclos.model.users.products.ProductData;
import org.cyclos.model.users.products.ProductMyRecordFieldDTO;
import org.cyclos.model.users.products.ProductRecordFieldDTO;
import org.cyclos.model.users.recordfields.RecordFieldAction;
import org.cyclos.model.users.records.RecordQuery;
import org.cyclos.model.users.records.UserRecordQuery;
import org.cyclos.model.users.recordtypes.RecordTypeVO;
import org.cyclos.server.utils.ClassHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.Pair;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RecordFieldHandlerImpl
extends BaseNetworkedHandlerImpl
implements RecordFieldHandler {
    @Autowired
    private RecordTypeServiceLocal recordTypeService;
    @Autowired
    private ProductServiceLocal productService;
    @Autowired
    private RecordCustomFieldServiceLocal recordCustomFieldService;
    private final Comparator<OrderedRecordField> FIELDS_COMPARATOR = Comparator.comparing(object -> ((OrderedRecordField)object).getSection(), Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(object -> ((OrderedRecordField)object).getOrder(), Comparator.nullsFirst(Comparator.naturalOrder()));
    @Autowired
    private InvokerHandler invokerHandler;

    public void assignAllPermissionsToRecordField(RecordType recordType, RecordCustomField recordCustomField, AdminProduct adminProduct) {
        Class clazz = recordType instanceof SystemRecordType ? ProductSystemRecordType.class : ProductUserRecordType.class;
        Pair pair = (Pair)this.invokerHandler.runAs(SessionDataFactory.system(), () -> {
            AdminProductDTO adminProductDTO = (AdminProductDTO)((ProductData)this.productService.getData(adminProduct.getId())).getDto();
            return Pair.create(this.getProductRecordFields((Product)adminProduct, (Class<? extends ProductRecordType>)clazz), (Object)adminProductDTO);
        });
        List list = (List)pair.getFirst();
        AdminProductDTO adminProductDTO = (AdminProductDTO)pair.getSecond();
        list.stream().filter(productRecordFieldDTO -> productRecordFieldDTO.getRecordType().getId().equals(recordType.getId()) && productRecordFieldDTO.getCustomField().getId().equals(recordCustomField.getId())).forEach(productRecordFieldDTO -> {
            productRecordFieldDTO.setView(true);
            productRecordFieldDTO.setEdit(true);
            productRecordFieldDTO.setCreate(true);
            productRecordFieldDTO.setRemove(true);
        });
        if (recordType instanceof SystemRecordType) {
            adminProductDTO.setSystemRecordTypeFields(list);
        } else {
            adminProductDTO.setUserRecordTypeFields(list);
        }
        this.productService.save((EntityDTO)adminProductDTO);
    }

    public RecordCustomField findField(RecordType recordType, CustomFieldVO customFieldVO) {
        String string;
        Long l = customFieldVO == null ? null : customFieldVO.getId();
        String string2 = string = customFieldVO == null ? null : customFieldVO.getInternalName();
        if (l == null && StringHelper.isBlank((Object)string)) {
            throw new EntityNotFoundException(RecordCustomField.class);
        }
        for (RecordCustomField recordCustomField : this.getAllFields(recordType)) {
            if (recordCustomField.getId().equals(l)) {
                return recordCustomField;
            }
            if (string == null || !string.equals(recordCustomField.getInternalName()) && !string.equals(this.entityManagerHandler.getQualifiedInternalName((IInternalNamedEntity)recordCustomField))) continue;
            return recordCustomField;
        }
        Object object = new EntityNotFoundException(RecordCustomField.class);
        object.setId(l);
        object.setKey(string);
        throw object;
    }

    public List<RecordCustomField> getAllFields(RecordType recordType) {
        ArrayList<OrderedRecordField> arrayList = new ArrayList<OrderedRecordField>();
        for (RecordTypeSharedRecordField recordTypeSharedRecordField : recordType.getSharedFields()) {
            arrayList.add(new OrderedRecordField(recordType, recordTypeSharedRecordField.getRecordField()));
        }
        for (RecordTypeSharedRecordField recordTypeSharedRecordField : recordType.getFields()) {
            arrayList.add(new OrderedRecordField(recordType, (RecordCustomField)recordTypeSharedRecordField));
        }
        arrayList.sort(this.FIELDS_COMPARATOR);
        return arrayList.stream().map(OrderedRecordField::getField).collect(Collectors.toList());
    }

    public List<RecordCustomField> getAllVisibleCustomFieldsForQuery(RecordQuery recordQuery) {
        User user = null;
        UserRecordQuery userRecordQuery = null;
        boolean bl = recordQuery instanceof UserRecordQuery;
        RecordType recordType = (RecordType)this.conversionHandler.convert(RecordType.class, (Object)recordQuery.getType());
        if (bl) {
            userRecordQuery = (UserRecordQuery)recordQuery;
            user = (User)this.conversionHandler.convert(User.class, (Object)userRecordQuery.getUser());
        }
        List list = null;
        list = recordType == null ? this.conversionHandler.convertList(RecordCustomField.class, (Iterable)this.recordCustomFieldService.listShared()) : this.getAllFields(recordType);
        if (bl && recordType != null) {
            list.retainAll(this.getFieldsByAction((UserRecordType)recordType, (BasicUser)user, RecordFieldAction.VIEW));
        } else if (!bl) {
            list.retainAll(this.getSystemFieldsByAction((SystemRecordType)recordType, RecordFieldAction.VIEW));
        }
        return list;
    }

    public Set<RecordFieldAction> getFieldActions(RecordType recordType, User user, RecordCustomField recordCustomField) {
        UserRecordType userRecordType;
        BooleanPropertiesHolder booleanPropertiesHolder;
        SessionData sessionData = this.getSessionData();
        ProductsAccessor productsAccessor = sessionData.getProducts();
        if (recordType instanceof SystemRecordType) {
            booleanPropertiesHolder = productsAccessor.admin().getSystemRecordFields((SystemRecordType)recordType);
        } else {
            if (user == null) {
                return Collections.emptySet();
            }
            userRecordType = (UserRecordType)recordType;
            boolean bl = this.productsHandler.getAccessor((BasicUser)user).product().getMyRecordTypes().isSet((Object)userRecordType, (Path)QProductMyRecordType.productMyRecordType.enabled);
            if (!bl) {
                return Collections.emptySet();
            }
            booleanPropertiesHolder = user.equals((Object)sessionData.getLoggedUser()) ? productsAccessor.product().getMyRecordFields(userRecordType) : productsAccessor.userManagement().getUserRecordFields(userRecordType);
        }
        userRecordType = booleanPropertiesHolder.get((Object)recordCustomField);
        EnumSet<RecordFieldAction> enumSet = EnumSet.noneOf(RecordFieldAction.class);
        if (userRecordType.isSet((Path)QProductRecordField.productRecordField.view)) {
            enumSet.add(RecordFieldAction.VIEW);
        }
        if (userRecordType.isSet((Path)QProductRecordField.productRecordField.create)) {
            enumSet.add(RecordFieldAction.CREATE);
        }
        if (userRecordType.isSet((Path)QProductRecordField.productRecordField.edit)) {
            enumSet.add(RecordFieldAction.EDIT);
        }
        return enumSet;
    }

    public List<RecordCustomField> getFieldsByAction(UserRecordType userRecordType, BasicUser basicUser, RecordFieldAction recordFieldAction) {
        BooleanPropertiesHolder booleanPropertiesHolder;
        boolean bl;
        boolean bl2;
        boolean bl3;
        SessionData sessionData = this.getSessionData();
        if (basicUser != null && recordFieldAction != RecordFieldAction.VIEW && !this.productsHandler.getAccessor(basicUser).product().getMyRecordTypes().isSet((Object)userRecordType, (Path)QProductMyRecordType.productMyRecordType.enabled)) {
            return Collections.emptyList();
        }
        if (sessionData.isSystem()) {
            return this.getAllFields((RecordType)userRecordType);
        }
        if (basicUser == null) {
            bl3 = sessionData.isMemberOnly() || sessionData.isOperator();
            bl2 = sessionData.isUserManager();
            bl = false;
        } else {
            bl3 = basicUser.getUser().equals((Object)sessionData.getLoggedUser());
            bl2 = false;
            bl = sessionData.isManagerOf(basicUser);
        }
        if (bl3) {
            booleanPropertiesHolder = this.getProducts().product().getMyRecordFields(userRecordType);
        } else if (bl2 || bl) {
            booleanPropertiesHolder = this.getProducts().userManagement().getUserRecordFields(userRecordType);
        } else {
            return Collections.emptyList();
        }
        QProductRecordField qProductRecordField = QProductRecordField.productRecordField;
        Set set = null;
        switch (recordFieldAction) {
            case CREATE: {
                set = booleanPropertiesHolder.keysSet((Path)qProductRecordField.create);
                break;
            }
            case EDIT: {
                set = booleanPropertiesHolder.keysSet((Path)qProductRecordField.edit);
                break;
            }
            case VIEW: {
                set = booleanPropertiesHolder.keysSet((Path)qProductRecordField.view);
            }
        }
        return CollectionHelper.sort((Collection)set, (Comparator)new RecordFieldComparator((RecordType)userRecordType));
    }

    public List<ProductRecordFieldDTO> getProductRecordFields(Product product, Class<? extends ProductRecordType> clazz) {
        Set set;
        List list;
        boolean bl = clazz.equals(ProductSystemRecordType.class);
        boolean bl2 = clazz.equals(ProductMyRecordType.class);
        boolean bl3 = clazz.equals(ProductUserRecordType.class);
        if (bl) {
            list = this.recordTypeService.listRecordTypes().stream().filter(recordType -> recordType instanceof SystemRecordType).collect(Collectors.toList());
            set = ((AdminProduct)product).getSystemRecordTypes();
        } else {
            list = this.recordTypeService.listRecordTypes().stream().filter(recordType -> recordType instanceof UserRecordType).collect(Collectors.toList());
            if (bl2) {
                set = product.getMyRecordTypes();
            } else if (bl3) {
                set = ((UserManagementProduct)product).getUserRecordTypes();
            } else {
                throw new IllegalArgumentException();
            }
        }
        ArrayList<ProductRecordFieldDTO> arrayList = new ArrayList<ProductRecordFieldDTO>();
        for (RecordType recordType2 : list) {
            if (this.getAllFields(recordType2).isEmpty()) continue;
            ProductRecordType productRecordType2 = set.stream().filter(productRecordType -> productRecordType.getRecordType().equals((Object)recordType2)).findFirst().orElse(null);
            RecordTypeVO recordTypeVO = (RecordTypeVO)this.conversionHandler.convert(RecordTypeVO.class, (Object)recordType2);
            this.getAllFields(recordType2).forEach(recordCustomField -> {
                ProductRecordField productRecordField2 = null;
                if (productRecordType2 != null) {
                    productRecordField2 = productRecordType2.getProductRecordCustomFields().stream().filter(productRecordField -> productRecordField.getCustomField().equals(recordCustomField)).findFirst().orElse(null);
                }
                ProductMyRecordFieldDTO productMyRecordFieldDTO = bl2 ? new ProductMyRecordFieldDTO() : new ProductRecordFieldDTO();
                productMyRecordFieldDTO.setRecordType(recordTypeVO);
                productMyRecordFieldDTO.setCustomField((CustomFieldVO)this.conversionHandler.convert(CustomFieldVO.class, recordCustomField));
                if (productRecordField2 != null) {
                    productMyRecordFieldDTO.setCreate(productRecordField2.isCreate());
                    productMyRecordFieldDTO.setEdit(productRecordField2.isEdit());
                    productMyRecordFieldDTO.setView(productRecordField2.isView());
                }
                if (productRecordType2 != null) {
                    productMyRecordFieldDTO.setRemove(productRecordType2.isRemove());
                    if (bl2) {
                        productMyRecordFieldDTO.setEnabled(((ProductMyRecordType)productRecordType2).isEnabled());
                    }
                }
                arrayList.add((ProductRecordFieldDTO)productMyRecordFieldDTO);
            });
        }
        return arrayList;
    }

    public List<ProductRecordFieldDTO> getProductRecordFields(ProductsAccessor productsAccessor, Class<? extends ProductRecordType> clazz) {
        BooleanPropertiesHolder booleanPropertiesHolder;
        List list;
        boolean bl = clazz.equals(ProductSystemRecordType.class);
        boolean bl2 = clazz.equals(ProductMyRecordType.class);
        boolean bl3 = clazz.equals(ProductUserRecordType.class);
        if (bl) {
            list = this.recordTypeService.listRecordTypes().stream().filter(recordType -> recordType instanceof SystemRecordType).collect(Collectors.toList());
            booleanPropertiesHolder = productsAccessor.admin().getSystemRecordTypes();
        } else {
            list = this.recordTypeService.listRecordTypes().stream().filter(recordType -> recordType instanceof UserRecordType).collect(Collectors.toList());
            if (bl2) {
                booleanPropertiesHolder = productsAccessor.product().getMyRecordTypes();
            } else if (bl3) {
                booleanPropertiesHolder = productsAccessor.userManagement().getUserRecordTypes();
            } else {
                throw new IllegalArgumentException();
            }
        }
        QProductMyRecordType qProductMyRecordType = QProductMyRecordType.productMyRecordType;
        QProductRecordField qProductRecordField = QProductRecordField.productRecordField;
        ArrayList<ProductRecordFieldDTO> arrayList = new ArrayList<ProductRecordFieldDTO>();
        for (RecordType recordType2 : list) {
            RecordTypeVO recordTypeVO = (RecordTypeVO)this.conversionHandler.convert(RecordTypeVO.class, (Object)recordType2);
            BooleanPropertiesHolder booleanPropertiesHolder2 = bl ? productsAccessor.admin().getSystemRecordFields((SystemRecordType)recordType2) : (bl2 ? productsAccessor.product().getMyRecordFields((UserRecordType)recordType2) : productsAccessor.userManagement().getUserRecordFields((UserRecordType)recordType2));
            this.getAllFields(recordType2).forEach(recordCustomField -> {
                CustomFieldVO customFieldVO = (CustomFieldVO)this.conversionHandler.convert(CustomFieldVO.class, recordCustomField);
                ProductMyRecordFieldDTO productMyRecordFieldDTO = bl2 ? new ProductMyRecordFieldDTO() : new ProductRecordFieldDTO();
                productMyRecordFieldDTO.setRecordType(recordTypeVO);
                productMyRecordFieldDTO.setCustomField(customFieldVO);
                if (bl2) {
                    productMyRecordFieldDTO.setEnabled(booleanPropertiesHolder.isSet((Object)recordType2, (Path)qProductMyRecordType.enabled));
                }
                productMyRecordFieldDTO.setView(booleanPropertiesHolder2.isSet(recordCustomField, (Path)qProductRecordField.view));
                productMyRecordFieldDTO.setCreate(booleanPropertiesHolder2.isSet(recordCustomField, (Path)qProductRecordField.create));
                productMyRecordFieldDTO.setEdit(booleanPropertiesHolder2.isSet(recordCustomField, (Path)qProductRecordField.edit));
                productMyRecordFieldDTO.setRemove(booleanPropertiesHolder.isSet((Object)recordType2, (Path)qProductMyRecordType.remove));
                arrayList.add((ProductRecordFieldDTO)productMyRecordFieldDTO);
            });
        }
        return arrayList;
    }

    public List<RecordCustomField> getSystemFieldsByAction(SystemRecordType systemRecordType, RecordFieldAction recordFieldAction) {
        QProductRecordField qProductRecordField = QProductRecordField.productRecordField;
        BooleanPropertiesHolder booleanPropertiesHolder = this.getProducts().admin().getSystemRecordFields(systemRecordType);
        Set set = null;
        switch (recordFieldAction) {
            case CREATE: {
                set = booleanPropertiesHolder.keysSet((Path)qProductRecordField.create);
                break;
            }
            case EDIT: {
                set = booleanPropertiesHolder.keysSet((Path)qProductRecordField.edit);
                break;
            }
            case VIEW: {
                set = booleanPropertiesHolder.keysSet((Path)qProductRecordField.view);
            }
        }
        return CollectionHelper.sort((Collection)set, (Comparator)new RecordFieldComparator((RecordType)systemRecordType));
    }

    public void sortFieldValues(RecordType recordType, List<RecordCustomFieldValue> list) {
        if (CollectionHelper.isNotEmpty(list)) {
            list.sort(Comparator.comparing(recordCustomFieldValue -> new OrderedRecordField(recordType, recordCustomFieldValue.getField()), this.FIELDS_COMPARATOR));
        }
    }

    public <PRT extends ProductRecordType> void toEntityProductRecordTypes(Product product, Collection<PRT> collection, Collection<? extends ProductRecordFieldDTO> collection2, Class<PRT> clazz) {
        Object object;
        HashMap<RecordType, RecordTypeOperation> hashMap = new HashMap<RecordType, RecordTypeOperation>();
        if (collection2 != null) {
            for (ProductRecordFieldDTO productRecordFieldDTO : collection2) {
                ProductRecordField productRecordField2;
                object = (RecordType)this.conversionHandler.convert(RecordType.class, (Object)productRecordFieldDTO.getRecordType());
                RecordTypeOperation recordTypeOperation = (RecordTypeOperation)hashMap.get(object);
                if (recordTypeOperation == null) {
                    recordTypeOperation = new RecordTypeOperation();
                    hashMap.put((RecordType)object, recordTypeOperation);
                }
                RecordCustomField recordCustomField = (RecordCustomField)this.conversionHandler.convert(RecordCustomField.class, (Object)productRecordFieldDTO.getCustomField());
                ProductRecordType productRecordType = collection.stream().filter(arg_0 -> RecordFieldHandlerImpl.lambda$toEntityProductRecordTypes$14((RecordType)object, arg_0)).findFirst().orElse(null);
                if (productRecordType == null) {
                    productRecordType = (ProductRecordType)ClassHelper.instantiate(clazz);
                    productRecordType.setRecordType(object);
                    productRecordType.setProduct(product);
                    collection.add(productRecordType);
                }
                if ((productRecordField2 = (ProductRecordField)productRecordType.getProductRecordCustomFields().stream().filter(productRecordField -> productRecordField.getCustomField().equals((Object)recordCustomField)).findFirst().orElse(null)) == null) {
                    productRecordField2 = new ProductRecordField();
                    productRecordField2.setProductRecordType(productRecordType);
                    productRecordField2.setCustomField(recordCustomField);
                    productRecordType.getProductRecordCustomFields().add(productRecordField2);
                }
                productRecordField2.setCreate(productRecordFieldDTO.isCreate());
                productRecordField2.setEdit(productRecordFieldDTO.isEdit());
                productRecordField2.setView(productRecordFieldDTO.isView());
                recordTypeOperation.update(productRecordFieldDTO);
            }
        }
        for (ProductRecordType productRecordType : collection) {
            object = null;
            if (CollectionHelper.isNotEmpty((Iterable)productRecordType.getProductRecordCustomFields())) {
                object = (RecordTypeOperation)hashMap.get(productRecordType.getRecordType());
            }
            if (object == null) {
                object = new RecordTypeOperation();
            }
            object.updateProduct(productRecordType);
        }
    }

    private static /* synthetic */ boolean lambda$toEntityProductRecordTypes$14(RecordType recordType, ProductRecordType productRecordType) {
        return productRecordType.getRecordType().equals((Object)recordType);
    }

    private class OrderedRecordField {
        private RecordType type;
        private RecordCustomField field;

        public OrderedRecordField(RecordType recordType, RecordCustomField recordCustomField) {
            this.field = recordCustomField;
            this.type = recordType;
        }

        public RecordCustomField getField() {
            return this.field;
        }

        private Integer getOrder() {
            return this.type.getOrder(this.field);
        }

        private RecordSection getSection() {
            return this.type.getSection(this.field);
        }
    }

    private static class RecordFieldComparator
    implements Comparator<RecordCustomField> {
        private final RecordType recordType;

        public RecordFieldComparator(RecordType recordType) {
            this.recordType = recordType;
        }

        @Override
        public int compare(RecordCustomField recordCustomField, RecordCustomField recordCustomField2) {
            Integer n = this.recordType.getOrder(recordCustomField);
            Integer n2 = this.recordType.getOrder(recordCustomField2);
            return n == null && n2 == null ? 0 : (n == null ? 1 : (n2 == null ? -1 : n.compareTo(n2)));
        }
    }

    protected class RecordTypeOperation {
        private boolean enabled = false;
        private boolean view = false;
        private boolean create = false;
        private boolean edit = false;
        private boolean remove = false;

        protected RecordTypeOperation() {
        }

        public void update(ProductRecordFieldDTO productRecordFieldDTO) {
            if (productRecordFieldDTO instanceof ProductMyRecordFieldDTO) {
                this.enabled |= ((ProductMyRecordFieldDTO)productRecordFieldDTO).isEnabled();
            }
            this.view |= productRecordFieldDTO.isView();
            this.create |= productRecordFieldDTO.isCreate();
            this.edit |= productRecordFieldDTO.isEdit();
            this.remove |= productRecordFieldDTO.isRemove();
        }

        public void updateProduct(ProductRecordType productRecordType) {
            if (productRecordType instanceof ProductMyRecordType) {
                ((ProductMyRecordType)productRecordType).setEnabled(this.enabled);
            } else {
                this.enabled = true;
            }
            productRecordType.setView(this.enabled && this.view);
            productRecordType.setEdit(this.enabled && this.view && this.edit);
            productRecordType.setCreate(this.enabled && this.view && this.create);
            productRecordType.setRemove(this.enabled && this.view && this.remove);
        }
    }
}

