/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import com.mysema.commons.lang.CloseableIterator;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.EntityPathBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;
import org.cyclos.entities.NetworkedEntity;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.system.CustomField;
import org.cyclos.entities.system.EntityWithCustomValues;
import org.cyclos.entities.system.ExportFormat;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.Group;
import org.cyclos.entities.users.QProductMyRecordType;
import org.cyclos.entities.users.QProductSystemRecordType;
import org.cyclos.entities.users.QRecord;
import org.cyclos.entities.users.QRecordCustomFieldValue;
import org.cyclos.entities.users.QSystemRecord;
import org.cyclos.entities.users.QUserRecord;
import org.cyclos.entities.users.QUserRecordType;
import org.cyclos.entities.users.Record;
import org.cyclos.entities.users.RecordCustomField;
import org.cyclos.entities.users.RecordCustomFieldValue;
import org.cyclos.entities.users.RecordType;
import org.cyclos.entities.users.SystemRecord;
import org.cyclos.entities.users.SystemRecordType;
import org.cyclos.entities.users.User;
import org.cyclos.entities.users.UserRecord;
import org.cyclos.entities.users.UserRecordType;
import org.cyclos.impl.BeanHandler;
import org.cyclos.impl.CRUDServiceImpl;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.banking.LocateAccountOwnerResult;
import org.cyclos.impl.search.RecordCountResult;
import org.cyclos.impl.search.RecordSearchHandler;
import org.cyclos.impl.system.CustomFieldValueHandler;
import org.cyclos.impl.system.CustomOperationServiceLocal;
import org.cyclos.impl.system.ExportFormatServiceLocal;
import org.cyclos.impl.system.ExtensionPointAccessor;
import org.cyclos.impl.system.ExtensionPointFilter;
import org.cyclos.impl.users.GroupListView;
import org.cyclos.impl.users.ProfileFieldSearchContext;
import org.cyclos.impl.users.RecordCustomFieldServiceLocal;
import org.cyclos.impl.users.RecordFieldHandler;
import org.cyclos.impl.users.RecordServiceLocal;
import org.cyclos.impl.users.RecordTypeServiceLocal;
import org.cyclos.impl.users.UserStatusServiceLocal;
import org.cyclos.impl.utils.BooleanPropertiesHolder;
import org.cyclos.impl.utils.QueryHelper;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.model.CRUDOperation;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.Property;
import org.cyclos.model.QueryParameters;
import org.cyclos.model.QueryParseException;
import org.cyclos.model.access.CredentialUsage;
import org.cyclos.model.access.devices.CreateDeviceConfirmationParams;
import org.cyclos.model.access.passwords.ICredentialInputDTO;
import org.cyclos.model.banking.accounts.AccountOwner;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.system.exportformats.ExportFormatContext;
import org.cyclos.model.system.exportformats.ExportFormatVO;
import org.cyclos.model.system.extensionpoints.ExtensionPointEvent;
import org.cyclos.model.system.extensionpoints.RecordExtensionPointEvent;
import org.cyclos.model.system.fields.CustomFieldDetailedVO;
import org.cyclos.model.system.fields.ModelWithCustomValues;
import org.cyclos.model.system.scripts.LoadValuesScriptFunction;
import org.cyclos.model.users.UsersKeys;
import org.cyclos.model.users.recordfields.RecordFieldAction;
import org.cyclos.model.users.records.ManageRecordConfirmationField;
import org.cyclos.model.users.records.RecordDTO;
import org.cyclos.model.users.records.RecordData;
import org.cyclos.model.users.records.RecordDataParams;
import org.cyclos.model.users.records.RecordQuery;
import org.cyclos.model.users.records.RecordSearchData;
import org.cyclos.model.users.records.RecordVO;
import org.cyclos.model.users.records.SharedRecordFieldsSearchData;
import org.cyclos.model.users.records.SystemRecordDTO;
import org.cyclos.model.users.records.SystemRecordQuery;
import org.cyclos.model.users.records.SystemRecordSearchData;
import org.cyclos.model.users.records.SystemRecordVO;
import org.cyclos.model.users.records.TiledRecordsData;
import org.cyclos.model.users.records.UserRecordDTO;
import org.cyclos.model.users.records.UserRecordQuery;
import org.cyclos.model.users.records.UserRecordSearchData;
import org.cyclos.model.users.records.UserRecordVO;
import org.cyclos.model.users.recordtypes.RecordTypeCountVO;
import org.cyclos.model.users.recordtypes.RecordTypeDetailedVO;
import org.cyclos.model.users.recordtypes.RecordTypeVO;
import org.cyclos.model.users.users.BasicProfileField;
import org.cyclos.model.users.users.DataWithBasicProfileFields;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.utils.FileInfo;
import org.cyclos.server.utils.DataIterator;
import org.cyclos.server.utils.DateHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.Page;
import org.cyclos.utils.Pair;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RecordServiceImpl
extends CRUDServiceImpl<Record, QRecord, RecordDTO, RecordData, RecordDataParams>
implements RecordServiceLocal {
    private static final BidiMap<Class<? extends Record>, Class<? extends RecordDTO>> SUBCLASS_MAPPINGS = new DualHashBidiMap();
    @Autowired
    private CustomFieldValueHandler customFieldValueHandler;
    @Autowired
    private RecordTypeServiceLocal recordTypeService;
    @Autowired
    private RecordCustomFieldServiceLocal recordCustomFieldService;
    @Autowired
    private RecordFieldHandler recordFieldHandler;
    @Autowired
    private RecordSearchHandler recordSearchHandler;
    @Autowired
    protected CustomOperationServiceLocal customOperationService;
    @Autowired
    private BeanHandler beanHandler;
    @Autowired
    private ExportFormatServiceLocal exportFormatService;
    @Autowired
    private UserStatusServiceLocal userStatusService;

    public RecordServiceImpl() {
        super(Record.class, QRecord.record, RecordDTO.class);
    }

    public boolean canChangeToSingleForm(RecordType recordType) {
        if (recordType instanceof UserRecordType) {
            QUserRecord qUserRecord = QUserRecord.userRecord;
            QUserRecord qUserRecord2 = new QUserRecord("ur2");
            return ((DBQuery)this.from(new EntityPath[]{qUserRecord, qUserRecord2}).where(new Predicate[]{qUserRecord.type().eq((Expression)qUserRecord2.type()), qUserRecord.type().eq((Object)recordType), qUserRecord.user().eq((Expression)qUserRecord2.user()), qUserRecord.ne((Expression)qUserRecord2)})).hasEmptyResults();
        }
        QRecord qRecord = QRecord.record;
        int n = ((DBQuery)this.from(new EntityPath[]{qRecord}).where((Predicate)qRecord.type().eq((Object)recordType))).count(qRecord.id);
        return n < 2;
    }

    public FileInfo exportRecords(@NotNull ExportFormatVO exportFormatVO, @NotNull RecordQuery recordQuery) {
        UserRecordQuery userRecordQuery;
        ExportFormatContext exportFormatContext;
        if (recordQuery instanceof SystemRecordQuery) {
            exportFormatContext = ExportFormatContext.RECORDS_SEARCH;
        } else if (recordQuery instanceof UserRecordQuery) {
            userRecordQuery = (UserRecordQuery)recordQuery;
            exportFormatContext = userRecordQuery.isSharedRecordFieldSearch() ? ExportFormatContext.SHARED_FIELDS_RECORDS_SEARCH : (userRecordQuery.getUser() == null ? ExportFormatContext.RECORDS_OVERVIEW : ExportFormatContext.RECORDS_SEARCH);
        } else {
            throw new IllegalActionException("Invalid record query: " + String.valueOf(recordQuery));
        }
        userRecordQuery = this.recordSearchHandler.exportEntities((QueryParameters)recordQuery);
        ExportFormat exportFormat = (ExportFormat)this.conversionHandler.convert(ExportFormat.class, (Object)exportFormatVO);
        return this.exportFormatService.exportMultiple(exportFormat, exportFormatContext, (QueryParameters)recordQuery, (DataIterator)userRecordQuery);
    }

    public int getRecordsCount(SystemRecordType systemRecordType) {
        return ((DBQuery)this.from().where((Predicate)((QRecord)this.$).type().eq((Object)systemRecordType))).count(((QRecord)this.$).id);
    }

    public int getRecordsCount(UserRecordType userRecordType, User user) {
        QUserRecord qUserRecord = QUserRecord.userRecord;
        return ((DBQuery)this.from(new EntityPath[]{qUserRecord}).where(new Predicate[]{qUserRecord.type().eq((Object)userRecordType), qUserRecord.user().eq((Object)user)})).count(qUserRecord.id);
    }

    public List<RecordTypeCountVO> getRecordTypeCount(InternalAccountOwner internalAccountOwner) throws FrameworkException {
        LocateAccountOwnerResult locateAccountOwnerResult = this.accountHandler.locate((AccountOwner)internalAccountOwner);
        if (locateAccountOwnerResult.isSystem()) {
            return this.getSystemRecordTypeCount();
        }
        if (locateAccountOwnerResult.isUser()) {
            return this.getRecordTypeCount(locateAccountOwnerResult.getUser());
        }
        throw new IllegalActionException();
    }

    public List<RecordTypeCountVO> getRecordTypeCount(User user) {
        QProductMyRecordType qProductMyRecordType = QProductMyRecordType.productMyRecordType;
        SessionData sessionData = this.getSessionData();
        List list = this.recordTypeService.listEnabled(user);
        boolean bl = user.equals((Object)sessionData.getLoggedUser());
        BooleanPropertiesHolder booleanPropertiesHolder = bl ? sessionData.getProducts().product().getMyRecordTypes() : sessionData.getProducts().userManagement().getUserRecordTypes();
        list.retainAll(booleanPropertiesHolder.keysSet((Path)qProductMyRecordType.view));
        Map<Long, RecordCountResult> map = this.recordSearchHandler.counts(user).stream().collect(Collectors.toMap(RecordCountResult::getTypeId, recordCountResult -> recordCountResult));
        boolean bl2 = sessionData.manages((BasicUser)user);
        ArrayList<RecordTypeCountVO> arrayList = new ArrayList<RecordTypeCountVO>();
        for (UserRecordType userRecordType : CollectionHelper.sort((Collection)list)) {
            RecordTypeCountVO recordTypeCountVO = new RecordTypeCountVO();
            recordTypeCountVO.setType((RecordTypeVO)this.conversionHandler.convert(RecordTypeVO.class, (Object)userRecordType));
            recordTypeCountVO.setCanCreateNew(bl2 && booleanPropertiesHolder.isSet((Object)userRecordType, (Path)qProductMyRecordType.create));
            recordTypeCountVO.setCanEdit(bl2 && booleanPropertiesHolder.isSet((Object)userRecordType, (Path)qProductMyRecordType.edit));
            recordTypeCountVO.setCanRemove(bl2 && booleanPropertiesHolder.isSet((Object)userRecordType, (Path)qProductMyRecordType.remove));
            RecordCountResult recordCountResult2 = map.get(userRecordType.getId());
            if (userRecordType.getResultsLayout().isAllowMultiple()) {
                recordTypeCountVO.setCount(recordCountResult2 == null ? 0 : (int)recordCountResult2.getCount());
            } else {
                Long l = recordCountResult2 == null ? null : recordCountResult2.getMaxId();
                recordTypeCountVO.setCount(l == null ? 0 : 1);
                recordTypeCountVO.setSingleRecordId(l);
            }
            arrayList.add(recordTypeCountVO);
        }
        return arrayList;
    }

    public RecordSearchData getSearchData(RecordTypeVO recordTypeVO, UserLocatorVO userLocatorVO) {
        UserRecordSearchData userRecordSearchData;
        UserRecordType userRecordType2;
        Object object;
        SystemRecordSearchData systemRecordSearchData;
        User user = (User)this.conversionHandler.convert(User.class, (Object)userLocatorVO);
        RecordType recordType = (RecordType)this.conversionHandler.convert(RecordType.class, (Object)recordTypeVO);
        if (recordType == null) {
            throw new EntityNotFoundException(RecordType.class);
        }
        List list = null;
        Set set = null;
        boolean bl = false;
        if (recordType instanceof SystemRecordType) {
            systemRecordSearchData = new SystemRecordSearchData();
            list = this.recordFieldHandler.getSystemFieldsByAction((SystemRecordType)recordType, RecordFieldAction.VIEW);
        } else {
            bl = user == null;
            object = this.getSessionData();
            userRecordType2 = (UserRecordType)recordType;
            userRecordSearchData = new UserRecordSearchData();
            systemRecordSearchData = userRecordSearchData;
            list = this.recordFieldHandler.getFieldsByAction((UserRecordType)recordType, (BasicUser)user, RecordFieldAction.VIEW);
            this.profileFieldHandler.fill((DataWithBasicProfileFields)userRecordSearchData);
            systemRecordSearchData.setHideKeywordsSearch(userRecordType2.isHideKeywordsSearch());
            if (bl) {
                systemRecordSearchData.setUserStatuses(this.userStatusService.getStatusesForUserSearch(object.isBroker()));
                GroupListView groupListView = this.groupsHandler.visibles().accessibles().basic();
                userRecordSearchData.setGroups(groupListView.sorted());
                set = groupListView.defaultFilter();
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("user", user);
                hashMap.put("recordType", recordType);
                boolean bl2 = object.isBroker() && !object.getLoggedUser().equals((Object)user);
                List list2 = this.profileFieldHandler.getSearchFilters(ProfileFieldSearchContext.RECORD_FILTER, bl2, hashMap);
                userRecordSearchData.setProfileFields(list2);
                if (list2.contains(BasicProfileField.ADDRESS)) {
                    userRecordSearchData.setAddressFields(this.profileFieldHandler.getAddressQueryFields());
                }
            }
        }
        systemRecordSearchData.setType((RecordTypeVO)this.conversionHandler.convert(RecordTypeVO.class, (Object)recordType));
        systemRecordSearchData.setFieldsForSearch(new ArrayList());
        systemRecordSearchData.setHideDateOnList(recordType.isHideDateOnList());
        systemRecordSearchData.setFieldsForList(new ArrayList());
        for (UserRecordType userRecordType2 : list) {
            if (userRecordType2.isShowInSearch()) {
                systemRecordSearchData.getFieldsForSearch().add((CustomFieldDetailedVO)this.conversionHandler.convert(CustomFieldDetailedVO.class, (Object)userRecordType2));
            }
            if (!userRecordType2.isShowInList()) continue;
            systemRecordSearchData.getFieldsForList().add((CustomFieldDetailedVO)this.conversionHandler.convert(CustomFieldDetailedVO.class, (Object)userRecordType2));
        }
        object = new HashMap();
        object.put("recordType", recordType);
        object.put("user", user);
        this.customFieldValueHandler.fillValuesFromScript(RecordCustomField.class, LoadValuesScriptFunction.FILTER, (Map)object, (Collection)systemRecordSearchData.getFieldsForSearch());
        systemRecordSearchData.setExportFormats(this.conversionHandler.convertList(ExportFormatVO.class, (Iterable)this.exportFormatService.listByContext(bl ? ExportFormatContext.RECORDS_OVERVIEW : ExportFormatContext.RECORDS_SEARCH)));
        if (recordType instanceof SystemRecordType) {
            userRecordType2 = (RecordQuery)QueryHelper.newQuery(SystemRecordQuery.class);
        } else {
            userRecordSearchData = (UserRecordQuery)QueryHelper.newQuery(UserRecordQuery.class);
            if (user == null) {
                userRecordSearchData.setGroups(set);
            } else {
                systemRecordSearchData.setOwner((UserVO)this.conversionHandler.convert(UserVO.class, (Object)user));
                userRecordSearchData.setUser(new UserVO(user.getId()));
            }
            userRecordType2 = userRecordSearchData;
        }
        userRecordType2.setCustomValues(this.customFieldValueHandler.resolveDefaultSearchValues((Collection)systemRecordSearchData.getFieldsForSearch()));
        userRecordType2.setType(systemRecordSearchData.getType());
        systemRecordSearchData.setQuery((QueryParameters)userRecordType2);
        return systemRecordSearchData;
    }

    public SharedRecordFieldsSearchData getSharedFieldsSearchData() {
        SharedRecordFieldsSearchData sharedRecordFieldsSearchData = new SharedRecordFieldsSearchData();
        sharedRecordFieldsSearchData.setFieldsForSearch(new ArrayList());
        sharedRecordFieldsSearchData.setFieldsForList(new ArrayList());
        sharedRecordFieldsSearchData.setTypes(new ArrayList());
        List<UserRecordType> list = this.getSharedSearchableRecordTypes();
        HashSet hashSet = new HashSet();
        for (UserRecordType userRecordType : list) {
            hashSet.addAll(this.recordFieldHandler.getFieldsByAction(userRecordType, null, RecordFieldAction.VIEW));
            sharedRecordFieldsSearchData.getTypes().add((RecordTypeVO)this.conversionHandler.convert(RecordTypeVO.class, (Object)userRecordType));
        }
        for (UserRecordType userRecordType : this.recordCustomFieldService.listAllShared()) {
            if (!hashSet.contains(userRecordType) || !userRecordType.isShowInSearch() && !userRecordType.isShowInList()) continue;
            CustomFieldDetailedVO customFieldDetailedVO = (CustomFieldDetailedVO)this.conversionHandler.convert(CustomFieldDetailedVO.class, (Object)userRecordType);
            if (userRecordType.isShowInSearch()) {
                sharedRecordFieldsSearchData.getFieldsForSearch().add(customFieldDetailedVO);
            }
            if (!userRecordType.isShowInList()) continue;
            sharedRecordFieldsSearchData.getFieldsForList().add(customFieldDetailedVO);
        }
        this.customFieldValueHandler.fillValuesFromScript(RecordCustomField.class, LoadValuesScriptFunction.FILTER, Collections.emptyMap(), (Collection)sharedRecordFieldsSearchData.getFieldsForSearch());
        sharedRecordFieldsSearchData.setExportFormats(this.conversionHandler.convertList(ExportFormatVO.class, (Iterable)this.exportFormatService.listByContext(ExportFormatContext.SHARED_FIELDS_RECORDS_SEARCH)));
        Iterator<Object> iterator = (UserRecordQuery)QueryHelper.newQuery(UserRecordQuery.class);
        iterator.setSharedRecordFieldSearch(true);
        sharedRecordFieldsSearchData.setQuery(iterator);
        return sharedRecordFieldsSearchData;
    }

    public List<UserRecordType> getSharedSearchableRecordTypes() {
        ArrayList<UserRecordType> arrayList = new ArrayList<UserRecordType>();
        List list = this.recordTypeService.listVisibleUserTypes();
        for (UserRecordType userRecordType : list) {
            if (userRecordType.getSharedFields().isEmpty()) continue;
            arrayList.add(userRecordType);
        }
        return arrayList;
    }

    public SystemRecord getSingleFormRecord(SystemRecordType systemRecordType) {
        if (systemRecordType == null) {
            return null;
        }
        QSystemRecord qSystemRecord = QSystemRecord.systemRecord;
        return (SystemRecord)((DBQuery)this.from(new EntityPath[]{qSystemRecord}).where((Predicate)qSystemRecord.type().eq((Object)systemRecordType))).singleResult((Expression)qSystemRecord);
    }

    public UserRecord getSingleFormRecord(UserRecordType userRecordType, User user) {
        if (userRecordType == null || user == null) {
            return null;
        }
        QUserRecord qUserRecord = QUserRecord.userRecord;
        return (UserRecord)((DBQuery)this.from(new EntityPath[]{qUserRecord}).where(new Predicate[]{qUserRecord.type().eq((Object)userRecordType), qUserRecord.user().eq((Object)user)})).singleResult((Expression)qUserRecord);
    }

    public List<RecordTypeCountVO> getSystemRecordTypeCount() {
        QProductSystemRecordType qProductSystemRecordType = QProductSystemRecordType.productSystemRecordType;
        BooleanPropertiesHolder booleanPropertiesHolder = this.getSessionData().getProducts().admin().getSystemRecordTypes();
        List list = this.recordTypeService.listVisibleSystemTypes();
        ArrayList<RecordTypeCountVO> arrayList = new ArrayList<RecordTypeCountVO>();
        for (SystemRecordType systemRecordType : list) {
            RecordTypeCountVO recordTypeCountVO = new RecordTypeCountVO();
            recordTypeCountVO.setType((RecordTypeVO)this.conversionHandler.convert(RecordTypeVO.class, (Object)systemRecordType));
            recordTypeCountVO.setCanCreateNew(booleanPropertiesHolder.isSet((Object)systemRecordType, (Path)qProductSystemRecordType.create));
            recordTypeCountVO.setCanEdit(booleanPropertiesHolder.isSet((Object)systemRecordType, (Path)qProductSystemRecordType.edit));
            recordTypeCountVO.setCanRemove(booleanPropertiesHolder.isSet((Object)systemRecordType, (Path)qProductSystemRecordType.remove));
            if (systemRecordType.getResultsLayout().isAllowMultiple()) {
                recordTypeCountVO.setCount(this.getRecordsCount(systemRecordType));
            } else {
                SystemRecord systemRecord = this.getFirst(systemRecordType);
                recordTypeCountVO.setCount(systemRecord == null ? 0 : 1);
                recordTypeCountVO.setSingleRecordId(systemRecord == null ? null : systemRecord.getId());
            }
            arrayList.add(recordTypeCountVO);
        }
        return arrayList;
    }

    public TiledRecordsData getTiledRecordsData(RecordTypeVO recordTypeVO, UserLocatorVO userLocatorVO) {
        SystemRecord systemRecord;
        SystemRecordQuery systemRecordQuery;
        User user;
        RecordType recordType = (RecordType)this.conversionHandler.convert(RecordType.class, (Object)recordTypeVO);
        User user2 = user = userLocatorVO == null ? null : this.userLocatorHandler.locate(userLocatorVO).getUser();
        if (recordType instanceof SystemRecordType) {
            systemRecordQuery = new SystemRecordQuery();
            systemRecord = new SystemRecord();
        } else {
            systemRecordQuery = new UserRecordQuery();
            systemRecord = new UserRecord();
            ((UserRecord)systemRecord).setUser(user);
            ((UserRecordQuery)systemRecordQuery).setUser((UserVO)userLocatorVO);
        }
        systemRecordQuery.setType(recordTypeVO);
        systemRecordQuery.setUnlimited();
        systemRecord.setType(recordType);
        TiledRecordsData tiledRecordsData = this.getData((Record)systemRecord, new TiledRecordsData());
        tiledRecordsData.setResults(this.search((RecordQuery)systemRecordQuery).getPageItems());
        tiledRecordsData.setConfirmationPasswordInput((ICredentialInputDTO)this.passwordHandler.accessor(CredentialUsage.CONFIRMATION).getCredentialInput());
        return tiledRecordsData;
    }

    public boolean hasRecordCustomFieldValue(RecordType recordType, RecordCustomField recordCustomField) {
        QRecordCustomFieldValue qRecordCustomFieldValue = QRecordCustomFieldValue.recordCustomFieldValue;
        return ((DBQuery)this.from(new EntityPath[]{qRecordCustomFieldValue}).where((Predicate)qRecordCustomFieldValue.owner().type().eq((Object)recordType).and((Predicate)qRecordCustomFieldValue.field().eq((Object)recordCustomField)))).hasResults();
    }

    public List<SystemRecord> listSystem(SystemRecordType systemRecordType) {
        QSystemRecord qSystemRecord = QSystemRecord.systemRecord;
        return ((DBQuery)((DBQuery)this.from(new EntityPath[]{qSystemRecord}).where((Predicate)qSystemRecord.type().eq((Object)systemRecordType))).orderBy(qSystemRecord.lastModifiedDate.desc())).list((Expression)qSystemRecord);
    }

    public List<UserRecord> listUser(UserRecordType userRecordType, User user) {
        QUserRecord qUserRecord = QUserRecord.userRecord;
        return ((DBQuery)((DBQuery)this.from(new EntityPath[]{qUserRecord}).where(new Predicate[]{qUserRecord.type().eq((Object)userRecordType), user != null ? qUserRecord.user().eq((Object)user) : qUserRecord.id.isNotNull()})).orderBy(qUserRecord.lastModifiedDate.desc())).list((Expression)qUserRecord);
    }

    public RecordVO loadVO(Long l) throws FrameworkException {
        Record record = (Record)this.find(l);
        if (record instanceof UserRecord) {
            return (RecordVO)this.conversionHandler.convert(UserRecordVO.class, (Object)record);
        }
        return (RecordVO)this.conversionHandler.convert(SystemRecordVO.class, (Object)record);
    }

    @Override
    public Record newEntity(RecordDataParams recordDataParams) {
        SystemRecord systemRecord;
        RecordType recordType = (RecordType)this.conversionHandler.convert(RecordType.class, (Object)recordDataParams.getRecordType());
        if (recordType instanceof SystemRecordType) {
            SystemRecord systemRecord2;
            if (!recordType.getResultsLayout().isAllowMultiple() && (systemRecord2 = this.getFirst((SystemRecordType)recordType)) != null) {
                return systemRecord2;
            }
            systemRecord = new SystemRecord();
        } else if (recordType instanceof UserRecordType) {
            UserRecord userRecord;
            User user;
            User user2 = user = recordDataParams.getUser() == null ? this.getLoggedUser() : (User)this.conversionHandler.convert(User.class, (Object)recordDataParams.getUser());
            if (!recordType.getResultsLayout().isAllowMultiple() && (userRecord = this.getFirst((UserRecordType)recordType, user)) != null) {
                return userRecord;
            }
            userRecord = new UserRecord();
            userRecord.setUser(user);
            systemRecord = userRecord;
        } else {
            throw new IllegalStateException("Unhandled type: " + String.valueOf(recordType));
        }
        systemRecord.setType(recordType);
        return systemRecord;
    }

    public void purgeAll(User user) {
        QUserRecord qUserRecord = QUserRecord.userRecord;
        QUserRecordType qUserRecordType = QUserRecordType.userRecordType;
        CloseableIterator closeableIterator = ((DBQuery)((DBQuery)this.from(new EntityPath[]{qUserRecord}).innerJoin((EntityPath)qUserRecord.type(), (Path)qUserRecordType._super)).where(new Predicate[]{qUserRecord.user().eq((Object)user), qUserRecordType.purgeRecords.isTrue()})).iterate((Expression)qUserRecord);
        this.processBatch(closeableIterator, this::remove);
    }

    public Page<RecordVO> search(RecordQuery recordQuery) throws QueryParseException {
        return this.recordSearchHandler.search((QueryParameters)recordQuery);
    }

    @Override
    public RecordDTO toDTO(Record record) {
        RecordDTO recordDTO = (RecordDTO)super.toDTO(record);
        if (record instanceof UserRecord) {
            boolean bl;
            User user = ((UserRecord)record).getUser();
            UserRecordType userRecordType = (UserRecordType)record.getType();
            SessionData sessionData = this.getSessionData();
            boolean bl2 = bl = userRecordType.isShowUpdateToUsers() || sessionData.isSystem() || sessionData.isManagerOf((BasicUser)user);
            if (!bl) {
                recordDTO.setCreatedBy(null);
                recordDTO.setCreationDate(null);
                recordDTO.setModifiedBy(null);
                recordDTO.setLastModifiedDate(null);
            }
        }
        return recordDTO;
    }

    @Override
    protected void doRemove(Record record, boolean bl) {
        this.customFieldValueHandler.removeAll((EntityWithCustomValues)record);
        super.doRemove(record, bl);
        this.recordSearchHandler.remove(record.getId());
    }

    @Override
    protected RecordData getData(Record record) {
        return this.getData(record, new RecordData());
    }

    @Override
    protected CreateDeviceConfirmationParams getDeviceConfirmationParams(RecordDTO recordDTO, Record record, CRUDOperation cRUDOperation) {
        Object object = recordDTO == null ? new RecordTypeVO(record.getType().getId()) : recordDTO.getType();
        return ManageRecordConfirmationField.confirmation((RecordTypeVO)object);
    }

    @Override
    protected void onAfterSave(Record record, Record record2, Object object) {
        this.customFieldValueHandler.processAfterSave((EntityWithCustomValues)record);
        this.recordSearchHandler.index((NetworkedEntity)record);
    }

    @Override
    protected Object onBeforeSave(Record record, Record record2) {
        Date date = DateHelper.now();
        if (record2 == null) {
            Object object;
            if (!record.getType().getResultsLayout().isAllowMultiple() && (object = record instanceof SystemRecord ? this.getFirst((SystemRecordType)record.getType()) : this.getFirst((UserRecordType)record.getType(), ((UserRecord)record).getUser())) != null) {
                throw new IllegalActionException();
            }
            if (record.getCreatedBy() == null) {
                record.setCreatedBy(this.getLoggedUser());
            }
            if (record.getCreationDate() == null) {
                record.setCreationDate(date);
            }
        } else {
            record.setModifiedBy(this.getLoggedUser());
            record.setLastModifiedDate(date);
        }
        return null;
    }

    @Override
    protected void preProcessCurrentCopy(RecordDTO recordDTO, Record record) {
        record.getCustomValues().size();
        if (CollectionHelper.isNotEmpty((Iterable)record.getCustomValues())) {
            for (RecordCustomFieldValue recordCustomFieldValue : record.getCustomValues()) {
                recordCustomFieldValue.getEnumeratedValues().size();
                recordCustomFieldValue.getImageValues().size();
                recordCustomFieldValue.getFileValues().size();
            }
        }
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(((QRecord)this.$).type().network());
    }

    @Override
    protected ExtensionPointAccessor resolveExtensionPointAccessor(CRUDOperation cRUDOperation, Record record) {
        RecordExtensionPointEvent recordExtensionPointEvent;
        try {
            recordExtensionPointEvent = RecordExtensionPointEvent.valueOf((String)cRUDOperation.name());
        }
        catch (Exception exception) {
            return null;
        }
        Group group = null;
        if (record instanceof UserRecord) {
            group = ((UserRecord)record).getUser().getGroup();
        }
        return this.extensionPointService.newAccessor((ExtensionPointEvent)recordExtensionPointEvent, new ExtensionPointFilter(group, record.getType())).attribute("record", (Object)record);
    }

    @Override
    protected Validator resolveValidator(RecordDTO recordDTO) {
        RecordFieldAction recordFieldAction;
        RecordType recordType;
        Record record;
        Validator validator = new Validator();
        User user = null;
        if (recordDTO.isPersistent()) {
            record = (Record)this.find(recordDTO.getId());
            recordType = record.getType();
            if (record instanceof UserRecord) {
                user = ((UserRecord)record).getUser();
            }
            recordDTO.setType(new RecordTypeDetailedVO(recordType.getId()));
            recordFieldAction = RecordFieldAction.EDIT;
        } else {
            validator.property((Property)RecordDTO.TYPE, UsersKeys.Records.TYPE).required();
            recordType = (RecordType)this.conversionHandler.convert(RecordType.class, (Object)recordDTO.getType());
            record = (Record)this.beanHandler.instantiate((Class)this.subClassMappings().getKey(recordDTO.getClass()));
            record.setType(recordType);
            if (recordDTO instanceof UserRecordDTO) {
                validator.property((Property)UserRecordDTO.USER, UsersKeys.Records.USER).required();
                user = (User)this.conversionHandler.convert(User.class, (Object)((UserRecordDTO)recordDTO).getUser());
                ((UserRecord)record).setUser(user);
            }
            recordFieldAction = RecordFieldAction.CREATE;
        }
        List list = null;
        if (recordType instanceof SystemRecordType) {
            list = this.recordFieldHandler.getSystemFieldsByAction((SystemRecordType)recordType, recordFieldAction);
        } else if (recordType instanceof UserRecordType && user != null) {
            list = this.recordFieldHandler.getFieldsByAction((UserRecordType)recordType, (BasicUser)user, recordFieldAction);
        }
        if (CollectionHelper.isNotEmpty(list)) {
            Map<String, Record> map = Collections.singletonMap("record", record);
            for (RecordCustomField recordCustomField : list) {
                this.customFieldValueHandler.addValueValidation(validator, (CustomField)recordCustomField, (EntityPathBase)QRecordCustomFieldValue.recordCustomFieldValue, map);
            }
        }
        return validator;
    }

    @Override
    protected boolean shouldCheckConfirmationPassword(Record record, CRUDOperation cRUDOperation) {
        return record.getType().isRequireConfirmationForManage();
    }

    @Override
    protected BidiMap<Class<? extends Record>, Class<? extends RecordDTO>> subClassMappings() {
        return SUBCLASS_MAPPINGS;
    }

    private <T extends RecordData> T getData(Record record, T t) {
        Set set;
        Set set2;
        Object object;
        RecordFieldAction recordFieldAction;
        RecordType recordType = record.getType();
        RecordFieldAction recordFieldAction2 = recordFieldAction = record.isTransient() ? RecordFieldAction.CREATE : RecordFieldAction.EDIT;
        if (record instanceof UserRecord) {
            object = (UserRecord)record;
            User user = object.getUser();
            set2 = this.recordFieldHandler.getFieldsByAction((UserRecordType)object.getType(), (BasicUser)user, recordFieldAction).stream().map(SimpleEntity::getId).collect(Collectors.toSet());
            set = this.recordFieldHandler.getFieldsByAction((UserRecordType)object.getType(), (BasicUser)user, RecordFieldAction.VIEW).stream().map(recordCustomField -> Pair.create((Object)recordCustomField.getId(), (Object)recordCustomField.getInternalName())).collect(Collectors.toSet());
        } else {
            set2 = this.recordFieldHandler.getSystemFieldsByAction((SystemRecordType)record.getType(), recordFieldAction).stream().map(SimpleEntity::getId).collect(Collectors.toSet());
            set = this.recordFieldHandler.getSystemFieldsByAction((SystemRecordType)record.getType(), RecordFieldAction.VIEW).stream().map(recordCustomField -> Pair.create((Object)recordCustomField.getId(), (Object)recordCustomField.getInternalName())).collect(Collectors.toSet());
        }
        object = this.recordCustomFieldService.listDetailed(recordType);
        object.removeIf(recordCustomFieldDetailedVO -> set.stream().map(Pair::getFirst).noneMatch(l -> l.equals(recordCustomFieldDetailedVO.getId())));
        int n = recordType.getFieldColumns();
        object.forEach(recordCustomFieldDetailedVO -> {
            if (recordCustomFieldDetailedVO.getColspan() > n) {
                recordCustomFieldDetailedVO.setColspan(n);
            }
        });
        HashMap<String, Record> hashMap = new HashMap<String, Record>();
        hashMap.put("record", record);
        this.customFieldValueHandler.fillValuesFromScript(RecordCustomField.class, LoadValuesScriptFunction.ENTITY, hashMap, (Collection)object);
        if (record.isPersistent() && StringHelper.isNotBlank((Object)recordType.getDisplayTemplate())) {
            t.setDisplay(this.getFormatter().format(record));
        }
        t.setFields((List)object);
        t.setEditableFieldIds(set2);
        if (record.isPersistent()) {
            t.setCustomOperations(this.customOperationService.getRunnableOperationsForRecord(new RecordVO(record.getId())));
        }
        t.setDto((EntityDTO)this.toDTO(record));
        List list = ((RecordDTO)t.getDto()).getType().getSections();
        list.forEach(recordSectionDetailedVO -> recordSectionDetailedVO.getFieldInternalNames().removeIf(string -> set.stream().map(Pair::getSecond).noneMatch(string2 -> string2.equals(string))));
        list.removeIf(recordSectionDetailedVO -> recordSectionDetailedVO.getFieldInternalNames().isEmpty());
        this.customFieldValueHandler.setDefaultValues((List)object, (ModelWithCustomValues)t.getDto());
        return t;
    }

    private SystemRecord getFirst(SystemRecordType systemRecordType) {
        QSystemRecord qSystemRecord = QSystemRecord.systemRecord;
        return (SystemRecord)((DBQuery)((DBQuery)this.from(new EntityPath[]{qSystemRecord}).where((Predicate)qSystemRecord.type().eq((Object)systemRecordType))).orderBy(qSystemRecord.lastModifiedDate.desc())).singleResult((Expression)qSystemRecord);
    }

    private UserRecord getFirst(UserRecordType userRecordType, User user) {
        QUserRecord qUserRecord = QUserRecord.userRecord;
        return (UserRecord)((DBQuery)((DBQuery)this.from(new EntityPath[]{qUserRecord}).where(new Predicate[]{qUserRecord.type().eq((Object)userRecordType), qUserRecord.user().eq((Object)user)})).orderBy(qUserRecord.lastModifiedDate.desc())).singleResult((Expression)qUserRecord);
    }

    static {
        SUBCLASS_MAPPINGS.put(SystemRecord.class, SystemRecordDTO.class);
        SUBCLASS_MAPPINGS.put(UserRecord.class, UserRecordDTO.class);
    }
}

