/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.Record;
import org.cyclos.entities.users.SystemRecord;
import org.cyclos.entities.users.SystemRecordType;
import org.cyclos.entities.users.UserRecord;
import org.cyclos.entities.users.UserRecordType;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.users.RecordFieldHandler;
import org.cyclos.impl.utils.conversion.EntityVOConverter;
import org.cyclos.model.system.fields.CustomFieldValueVO;
import org.cyclos.model.users.recordfields.RecordFieldAction;
import org.cyclos.model.users.records.RecordVO;
import org.cyclos.model.users.records.SystemRecordVO;
import org.cyclos.model.users.records.UserRecordVO;
import org.cyclos.server.utils.PropertyHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RecordVOConverter
extends EntityVOConverter<RecordVO> {
    @Autowired
    private RecordFieldHandler recordFieldHandler;

    public RecordVOConverter() {
        super(RecordVO.class);
        this.registerMapping(SystemRecord.class, SystemRecordVO.class);
        this.registerMapping(UserRecord.class, UserRecordVO.class);
    }

    @Override
    protected void fill(Object object, RecordVO recordVO, Object[] objectArray, InvocationContext.ConversionContext conversionContext) {
        if (object instanceof Record) {
            List list;
            Record record = (Record)object;
            recordVO.setDisplay(this.getFormatter().format(record));
            if (object instanceof UserRecord) {
                UserRecord userRecord = (UserRecord)object;
                list = this.recordFieldHandler.getFieldsByAction((UserRecordType)userRecord.getType(), (BasicUser)userRecord.getUser(), RecordFieldAction.VIEW);
            } else {
                list = object instanceof SystemRecord ? this.recordFieldHandler.getSystemFieldsByAction((SystemRecordType)record.getType(), RecordFieldAction.VIEW) : Collections.emptyList();
            }
            if (list.isEmpty()) {
                recordVO.setId(record.getId());
            } else {
                boolean bl = Stream.of(objectArray).map(PropertyHelper::getPropertyName).anyMatch(string -> RecordVO.CUSTOM_VALUES.getName().equals(string));
                objectArray = ArrayUtils.add((Object[])objectArray, (Object)RecordVO.CUSTOM_VALUES);
                super.fill(object, recordVO, objectArray, conversionContext);
                if (!bl) {
                    List list2 = record.getCustomValues().stream().filter(recordCustomFieldValue -> list.contains(recordCustomFieldValue.getField()) && recordCustomFieldValue.getField().isShowInList()).collect(Collectors.toList());
                    this.recordFieldHandler.sortFieldValues(record.getType(), list2);
                    recordVO.setCustomValues(this.conversionHandler.convertList(CustomFieldValueVO.class, list2));
                }
            }
        } else {
            super.fill(object, recordVO, objectArray, conversionContext);
        }
    }
}

