/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import com.querydsl.core.types.Predicate;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.system.EntityLog;
import org.cyclos.entities.users.Record;
import org.cyclos.entities.users.SystemRecord;
import org.cyclos.entities.users.SystemRecordType;
import org.cyclos.impl.EntityLogDescriptor;
import org.cyclos.impl.system.CustomFieldValueHandler;
import org.cyclos.impl.users.BaseRecordEntityLogHandlerImpl;
import org.cyclos.impl.users.RecordFieldHandler;
import org.cyclos.impl.users.RecordTypeServiceLocal;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.model.system.entitylogs.EntityLogType;
import org.cyclos.model.system.entitylogs.EntityPropertyLogQuery;
import org.cyclos.model.users.recordfields.RecordFieldAction;
import org.cyclos.model.users.records.SystemRecordDTO;
import org.cyclos.security.users.RecordServiceSecurity;
import org.cyclos.utils.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class SystemRecordEntityLogHandlerImpl
extends BaseRecordEntityLogHandlerImpl<SystemRecord, SystemRecordDTO> {
    @Autowired
    @Lazy
    private CustomFieldValueHandler customFieldValueHandler;
    @Autowired
    @Lazy
    private RecordFieldHandler recordFieldHandler;
    @Autowired
    @Lazy
    private RecordServiceSecurity recordServiceSecurity;
    @Autowired
    @Lazy
    private RecordTypeServiceLocal recordTypeServiceLocal;

    @Override
    public boolean canViewPropertiesLog(EntityLog entityLog) {
        if (super.canViewPropertiesLog(entityLog)) {
            return true;
        }
        return this.recordTypeServiceLocal.listVisibleSystemTypes().contains(this.find(SystemRecordType.class, entityLog.getRelatedEntityId()));
    }

    @Override
    public Pair<Boolean, Set<EntityLogType>> doApplyLogFilters(DBQuery<?> dBQuery, long l, EntityPropertyLogQuery entityPropertyLogQuery) {
        SystemRecord systemRecord = this.find(SystemRecord.class, l);
        SystemRecordType systemRecordType = (SystemRecordType)systemRecord.getType();
        List list = this.recordFieldHandler.getSystemFieldsByAction(systemRecordType, RecordFieldAction.VIEW);
        if (list.isEmpty()) {
            dBQuery.where((Predicate)SystemRecordEntityLogHandlerImpl.$.customFieldId.isNull());
        } else {
            dBQuery.where((Predicate)SystemRecordEntityLogHandlerImpl.$.customFieldId.isNull().or((Predicate)SystemRecordEntityLogHandlerImpl.$.customFieldId.in((Collection)SimpleEntity.uniqueIds((Collection)list))));
        }
        return null;
    }

    public Class<SystemRecord> getEntityClass() {
        return SystemRecord.class;
    }

    @Override
    public Long getRelatedEntityId(Record record) {
        return record.getType().getId();
    }

    public EntityLogType getType() {
        return EntityLogType.SYSTEM_RECORD;
    }

    @Override
    public EntityLogDescriptor<SystemRecordDTO> resolveLogDescriptor(SystemRecord systemRecord) {
        EntityLogDescriptor entityLogDescriptor = super.resolveLogDescriptor(systemRecord);
        RecordFieldAction recordFieldAction = systemRecord.isTransient() ? RecordFieldAction.CREATE : RecordFieldAction.EDIT;
        entityLogDescriptor.customFields((Iterable)this.recordFieldHandler.getSystemFieldsByAction((SystemRecordType)systemRecord.getType(), recordFieldAction), this.customFieldValueHandler);
        return entityLogDescriptor;
    }

    @Override
    protected Class<SystemRecordDTO> resolveDtoType() {
        return SystemRecordDTO.class;
    }
}

