/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import com.querydsl.core.types.dsl.NumberPath;
import java.util.Date;
import org.cyclos.entities.banking.BasePayment;
import org.cyclos.entities.banking.QBasePayment;
import org.cyclos.entities.banking.QPaymentTransferType;
import org.cyclos.entities.banking.Transaction;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.impl.users.AbstractTransactionFeedbackNotificationRecurringTask;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.server.utils.DateHelper;
import org.cyclos.utils.MessageKey;
import org.springframework.stereotype.Component;

@Component
public class TransactionFeedbackExpirationReminderRecurringTask
extends AbstractTransactionFeedbackNotificationRecurringTask {
    public TransactionFeedbackExpirationReminderRecurringTask() {
        super((NumberPath<Integer>)QPaymentTransferType.paymentTransferType.feedbackExpirationReminderDays, QBasePayment.basePayment.feedbackExpirationReminderNotified);
    }

    public MessageKey getMessageKey() {
        return SystemKeys.RecurringTasks.TRANSACTION_FEEDBACK_EXPIRATION_REMINDER;
    }

    @Override
    protected void finish(BasePayment basePayment, Throwable throwable) throws Throwable {
        basePayment.setFeedbackExpirationReminderNotified(Boolean.valueOf(true));
    }

    @Override
    protected void notifyTransactionProcessed(BasePayment basePayment, Date date) {
        if (!DateHelper.now().after(date)) {
            this.notificationHandler.user((BasicUser)basePayment.getFromUser()).feedbackAndReference().feedbackExpirationReminder((Transaction)basePayment, basePayment.getToUser(), date);
        }
    }
}

