/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.cyclos.entities.BaseEntity;
import org.cyclos.entities.system.QEntityLog;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.QBasicUser;
import org.cyclos.entities.users.QPhone;
import org.cyclos.entities.users.QUserAddress;
import org.cyclos.entities.users.User;
import org.cyclos.impl.EntityLogDescriptor;
import org.cyclos.impl.system.BaseEntityLogHandlerImpl;
import org.cyclos.impl.system.CustomFieldValueHandler;
import org.cyclos.impl.system.EntityLogServiceLocal;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.validation.EntityPropertyAccess;
import org.cyclos.impl.utils.validation.PropertyAccess;
import org.cyclos.model.Property;
import org.cyclos.model.access.Permission;
import org.cyclos.model.system.entitylogs.EntityLogEvent;
import org.cyclos.model.system.entitylogs.EntityLogType;
import org.cyclos.model.system.entitylogs.EntityLogTypeFilter;
import org.cyclos.model.system.entitylogs.EntityPropertyLogQuery;
import org.cyclos.model.users.UsersKeys;
import org.cyclos.model.users.users.AbstractSimpleUserRegistrationDTO;
import org.cyclos.model.users.users.AbstractUserRegistrationDTO;
import org.cyclos.model.users.users.BasicProfileField;
import org.cyclos.model.users.users.ProfileField;
import org.cyclos.model.users.users.ProfileFieldAction;
import org.cyclos.model.users.users.PublicRegistrationDTO;
import org.cyclos.model.users.users.UserDTO;
import org.cyclos.model.users.users.UserRegistrationByMemberDTO;
import org.cyclos.model.users.users.UserRegistrationDTO;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class UserEntityLogHandlerImpl
extends BaseEntityLogHandlerImpl<User, UserDTO> {
    @Autowired
    @Lazy
    private CustomFieldValueHandler customFieldValueHandler;

    @Override
    public Pair<Boolean, Set<EntityLogType>> doApplyLogFilters(DBQuery<?> dBQuery, long l, EntityPropertyLogQuery entityPropertyLogQuery) {
        User user = this.find(User.class, l);
        EnumSet<EntityLogType> enumSet = CollectionHelper.isEmpty((Iterable)entityPropertyLogQuery.getTypeFilters()) ? EnumSet.of(EntityLogType.ADDRESS, EntityLogType.PHONE) : entityPropertyLogQuery.getTypeFilters().stream().map(EntityLogTypeFilter::getEntityLogType).filter(entityLogType -> entityLogType == EntityLogType.ADDRESS || entityLogType == EntityLogType.PHONE).collect(Collectors.toSet());
        ArrayList<Long> arrayList = new ArrayList<Long>();
        List list = this.profileFieldHandler.getFieldsByAction((BasicUser)user, ProfileFieldAction.VIEW);
        HashSet<BasicProfileField> hashSet = new HashSet<BasicProfileField>(Arrays.asList(BasicProfileField.values()));
        for (ProfileField profileField : list) {
            if (profileField instanceof BasicProfileField) {
                hashSet.remove(profileField);
                continue;
            }
            arrayList.add(((BaseEntity)profileField).getId());
        }
        block6: for (BasicProfileField basicProfileField2 : BasicProfileField.values()) {
            switch (basicProfileField2) {
                case ADDRESS: 
                case PHONE: {
                    if (hashSet.contains(basicProfileField2)) {
                        enumSet.remove(basicProfileField2 == BasicProfileField.ADDRESS ? EntityLogType.ADDRESS : EntityLogType.PHONE);
                    }
                    hashSet.remove(basicProfileField2);
                    continue block6;
                }
                case EMAIL: 
                case FULL_NAME: 
                case LOGIN_NAME: {
                    continue block6;
                }
                case ACCOUNT_NUMBER: 
                case IMAGE: {
                    hashSet.remove(basicProfileField2);
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException("Unknown basic profile field: " + String.valueOf(basicProfileField2));
                }
            }
        }
        dBQuery.where((Predicate)UserEntityLogHandlerImpl.el.type.ne((Object)EntityLogType.USER).or((Predicate)UserEntityLogHandlerImpl.$.customFieldId.isNull()).or((Predicate)UserEntityLogHandlerImpl.$.customFieldId.in(arrayList)));
        if (CollectionHelper.isNotEmpty(hashSet)) {
            dBQuery.where((Predicate)UserEntityLogHandlerImpl.el.type.ne((Object)EntityLogType.USER).or((Predicate)UserEntityLogHandlerImpl.$.propertyName.notIn(CollectionUtils.collect(hashSet, basicProfileField -> basicProfileField.property().getName()))).or((Predicate)UserEntityLogHandlerImpl.$.propertyName.isNull()));
        }
        if (!this.getSessionData().hasPermission(Permission.USERS_VIEW_HIDDEN_FIELDS)) {
            BasicProfileField basicProfileField2;
            QPhone qPhone = QPhone.phone;
            DBQuery dBQuery2 = (DBQuery)this.subQuery(new EntityPath[]{qPhone}).where((Predicate)qPhone.hidden.isTrue().and((Predicate)qPhone.id.eq((Expression)UserEntityLogHandlerImpl.el.entityId)));
            dBQuery.where((Predicate)UserEntityLogHandlerImpl.el.type.ne((Object)EntityLogType.PHONE).or((Predicate)UserEntityLogHandlerImpl.el.type.eq((Object)EntityLogType.PHONE).and((Predicate)dBQuery2.notExists())));
            QUserAddress qUserAddress = QUserAddress.userAddress;
            basicProfileField2 = (DBQuery)this.subQuery(new EntityPath[]{qUserAddress}).where((Predicate)qUserAddress.hidden.isTrue().and((Predicate)qUserAddress.id.eq((Expression)UserEntityLogHandlerImpl.el.entityId)));
            dBQuery.where((Predicate)UserEntityLogHandlerImpl.el.type.ne((Object)EntityLogType.ADDRESS).or((Predicate)UserEntityLogHandlerImpl.el.type.eq((Object)EntityLogType.ADDRESS).and((Predicate)basicProfileField2.notExists())));
            QEntityLog qEntityLog = new QEntityLog("el2");
            DBQuery dBQuery3 = (DBQuery)this.subQuery(new EntityPath[]{qEntityLog}).where((Predicate)qEntityLog.privateEntity.isTrue().and((Predicate)qEntityLog.entityId.eq((Expression)UserEntityLogHandlerImpl.el.entityId)));
            dBQuery.where((Predicate)dBQuery3.notExists());
        }
        EntityLogServiceLocal.applyUserActionsFilters((EntityPropertyLogQuery)entityPropertyLogQuery, dBQuery);
        boolean bl = CollectionHelper.isEmpty((Iterable)entityPropertyLogQuery.getTypeFilters()) || entityPropertyLogQuery.getTypeFilters().contains(EntityLogTypeFilter.USER_ACTIONS) || entityPropertyLogQuery.getTypeFilters().contains(EntityLogTypeFilter.USER_FIELDS);
        return new Pair((Object)bl, enumSet);
    }

    public Class<User> getEntityClass() {
        return User.class;
    }

    @Override
    public String getEntityLogName(User user, User user2, EntityLogEvent entityLogEvent) {
        return this.getFormatter().format((BasicUser)ObjectHelper.defaultValue((Object)user2, (Object)user));
    }

    @Override
    public BasicUser getRelatedUser(User user) {
        return user;
    }

    public EntityLogType getType() {
        return EntityLogType.USER;
    }

    @Override
    public boolean isAsManager(User user) {
        return !user.equals((Object)this.getLoggedUser());
    }

    public EntityLogDescriptor<? extends UserDTO> resolveLogDescriptor(User user) {
        Class<? extends UserDTO> clazz = this.resolveDTOType(user);
        List list = this.profileFieldHandler.getEnabledProfileFields((BasicUser)user);
        EntityLogDescriptor entityLogDescriptor = new EntityLogDescriptor(clazz).propertyOrIgnore(UserDTO.NAME, UsersKeys.Users.NAME, list.contains(BasicProfileField.FULL_NAME)).propertyOrIgnore((Property)UserDTO.USERNAME, UsersKeys.Users.USERNAME, list.contains(BasicProfileField.LOGIN_NAME)).propertyOrIgnore((Property)UserDTO.EMAIL, UsersKeys.Users.EMAIL, list.contains(BasicProfileField.EMAIL)).propertyOrIgnore((Property)UserDTO.HIDE_EMAIL, UsersKeys.Users.HIDDEN_EMAIL, list.contains(BasicProfileField.EMAIL)).property((Property)UserDTO.GROUP, UsersKeys.Users.GROUP).property((PropertyAccess)new EntityPropertyAccess((Path)QBasicUser.basicUser.creationDate), UsersKeys.Users.CREATION_DATE).ignore((Property)UserDTO.CUSTOM_VALUES);
        if (AbstractSimpleUserRegistrationDTO.class.isAssignableFrom(clazz)) {
            entityLogDescriptor.cast().ignore((Property)AbstractSimpleUserRegistrationDTO.ADDRESSES).ignore((Property)AbstractSimpleUserRegistrationDTO.LAND_LINE_PHONES).ignore((Property)AbstractSimpleUserRegistrationDTO.MOBILE_PHONES).ignore((Property)AbstractSimpleUserRegistrationDTO.NFC_TOKEN).ignore((Property)AbstractSimpleUserRegistrationDTO.UPLOADED_IMAGES);
            if (AbstractUserRegistrationDTO.class.isAssignableFrom(clazz)) {
                entityLogDescriptor.cast().ignore((Property)AbstractUserRegistrationDTO.PASSWORDS).ignore((Property)AbstractUserRegistrationDTO.CONTACT_INFOS).ignore((Property)AbstractUserRegistrationDTO.SECURITY_ANSWER).ignore((Property)AbstractUserRegistrationDTO.SECURITY_QUESTION);
                if (PublicRegistrationDTO.class.isAssignableFrom(clazz)) {
                    entityLogDescriptor.cast().ignore((Property)PublicRegistrationDTO.AGREEMENT).ignore((Property)PublicRegistrationDTO.CAPTCHA_RESPONSE).ignore((Property)PublicRegistrationDTO.SECURITY_QUESTION).ignore((Property)PublicRegistrationDTO.SECURITY_ANSWER);
                } else if (UserRegistrationDTO.class.isAssignableFrom(clazz)) {
                    entityLogDescriptor.cast().ignore((Property)UserRegistrationDTO.ACCOUNT_CONFIGURATIONS).ignore((Property)UserRegistrationDTO.SKIP_ACTIVATION_EMAIL).ignore((Property)UserRegistrationDTO.BROKER);
                }
            }
        }
        List list2 = this.profileFieldHandler.getCustomFields((Collection)list);
        entityLogDescriptor.customFields((Iterable)list2, this.customFieldValueHandler);
        return entityLogDescriptor;
    }

    @Override
    protected User getEntityToViewLog(long l) {
        return this.find(User.class, l);
    }

    private Class<? extends UserDTO> resolveDTOType(User user) {
        if (user.isTransient()) {
            switch (user.getRegistrationType()) {
                case POPULATOR: 
                case ADMIN: 
                case BROKER: {
                    return UserRegistrationDTO.class;
                }
                case MEMBER: {
                    return UserRegistrationByMemberDTO.class;
                }
                case PUBLIC: {
                    return PublicRegistrationDTO.class;
                }
            }
            throw new IllegalArgumentException("Invalid user registration when resolving UserDTO subclass: " + String.valueOf(user.getRegistrationType()));
        }
        return UserDTO.class;
    }
}

