/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import com.querydsl.core.types.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.cyclos.entities.access.AccessClientPrincipalType;
import org.cyclos.entities.access.PrincipalType;
import org.cyclos.entities.access.TokenPrincipalType;
import org.cyclos.entities.banking.PaymentTransferType;
import org.cyclos.entities.banking.UserAccountType;
import org.cyclos.entities.marketplace.AdCustomField;
import org.cyclos.entities.users.ContactCustomField;
import org.cyclos.entities.users.Product;
import org.cyclos.entities.users.ProductUserAccessClient;
import org.cyclos.entities.users.ProductUserAdField;
import org.cyclos.entities.users.ProductUserContactField;
import org.cyclos.entities.users.ProductUserRecordType;
import org.cyclos.entities.users.ProductUserTokenType;
import org.cyclos.entities.users.QUserManagementProduct;
import org.cyclos.entities.users.UserManagementProduct;
import org.cyclos.impl.marketplace.AdCustomFieldServiceLocal;
import org.cyclos.impl.users.BooleanPermissionHandlerImpl;
import org.cyclos.impl.users.CollectionPermissionHandlerImpl;
import org.cyclos.impl.users.OperationPermissionHandlerImpl;
import org.cyclos.impl.users.PermissionHandler;
import org.cyclos.impl.users.ProductConversionHandlerImpl;
import org.cyclos.impl.users.ViewManagePermissionHandlerImpl;
import org.cyclos.model.Property;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.passwordtypes.PasswordTypeVO;
import org.cyclos.model.access.principaltypes.AccessClientPrincipalTypeVO;
import org.cyclos.model.access.principaltypes.PrincipalTypeNature;
import org.cyclos.model.access.principaltypes.TokenPrincipalTypeVO;
import org.cyclos.model.banking.transfertypes.TransferTypeDirection;
import org.cyclos.model.system.fields.CustomFieldVO;
import org.cyclos.model.users.UsersKeys;
import org.cyclos.model.users.products.ActiveAdminProductsData;
import org.cyclos.model.users.products.ActiveProductsData;
import org.cyclos.model.users.products.ActiveUserProductsData;
import org.cyclos.model.users.products.ExternalPaymentOperation;
import org.cyclos.model.users.products.PaymentRequestOperation;
import org.cyclos.model.users.products.ProductUserAccessClientDTO;
import org.cyclos.model.users.products.ProductUserAdFieldDTO;
import org.cyclos.model.users.products.ProductUserContactFieldDTO;
import org.cyclos.model.users.products.ProductUserTokenTypeDTO;
import org.cyclos.model.users.products.ScheduledPaymentsOperation;
import org.cyclos.model.users.products.TicketsOperation;
import org.cyclos.model.users.products.UserManagementProductDTO;
import org.cyclos.model.users.products.UserProductPasswordActionDTO;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.MessageKey;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class UserManagementProductConversionHandlerImpl<P extends UserManagementProduct, DTO extends UserManagementProductDTO, AD extends ActiveProductsData>
extends ProductConversionHandlerImpl<P, DTO, AD> {
    @Autowired
    private AdCustomFieldServiceLocal adCustomFieldService;

    public UserManagementProductConversionHandlerImpl(Class<P> clazz, Class<DTO> clazz2, Class<AD> clazz3) {
        super(clazz, clazz2, clazz3);
    }

    @Override
    public void registerHandlers() {
        super.registerHandlers();
        this.registerPropertyMapping((Property<?, ?>)UserManagementProductDTO.SYSTEM_PAYMENTS_AS_USER, (Path<?>)QUserManagementProduct.userManagementProduct.paymentsAsUser);
        this.registerPropertyMapping((Property<?, ?>)UserManagementProductDTO.USER_PAYMENTS_AS_USER, (Path<?>)QUserManagementProduct.userManagementProduct.paymentsAsUser);
        this.registerPropertyMapping((Property<?, ?>)UserManagementProductDTO.SELF_PAYMENTS_AS_USER, (Path<?>)QUserManagementProduct.userManagementProduct.paymentsAsUser);
        this.registerPropertyMapping((Property<?, ?>)UserManagementProductDTO.USER_PAYMENT_REQUESTS_SEND_TO_SYSTEM, (Path<?>)QUserManagementProduct.userManagementProduct.requestPaymentsAsUser);
        this.registerPropertyMapping((Property<?, ?>)UserManagementProductDTO.USER_PAYMENT_REQUESTS_SEND_TO_USER, (Path<?>)QUserManagementProduct.userManagementProduct.requestPaymentsAsUser);
        this.registerPropertyMapping((Property<?, ?>)UserManagementProductDTO.EXTERNAL_PAYMENTS_AS_USER, (Path<?>)QUserManagementProduct.userManagementProduct.externalPaymentsAsUser);
        this.register(new BooleanPermissionHandlerImpl(Permission.USERS_VIEW_HIDDEN_FIELDS, UserManagementProductDTO.VIEW_HIDDEN_PROFILE_FIELDS, ActiveAdminProductsData.VIEW_HIDDEN_PROFILE_FIELDS, UsersKeys.Products.VIEW_HIDDEN_PROFILE_FIELDS));
        this.register(new ViewManagePermissionHandlerImpl(Permission.USER_PRIVACY_SETTINGS_VIEW, Permission.USER_PRIVACY_SETTINGS_MANAGE, UserManagementProductDTO.USER_PRIVACY_SETTINGS, ActiveProductsData.USER_PRIVACY_SETTINGS, UsersKeys.Products.USER_PRIVACY_SETTINGS));
        this.register(new ViewManagePermissionHandlerImpl(Permission.MAILINGS_VIEW, Permission.MAILINGS_MANAGE, UserManagementProductDTO.MAILING_LISTS, ActiveProductsData.MAILING_LISTS, UsersKeys.Products.MAILING_LISTS));
        this.register(new ViewManagePermissionHandlerImpl(Permission.BULK_ACTIONS_VIEW, Permission.BULK_ACTIONS_MANAGE, UserManagementProductDTO.BULK_ACTIONS, ActiveAdminProductsData.BULK_ACTIONS, UsersKeys.Products.BULK_ACTIONS));
        this.register(new ViewManagePermissionHandlerImpl(Permission.USER_CHANNELS_ACCESS_VIEW, Permission.USER_CHANNELS_ACCESS_MANAGE, UserManagementProductDTO.USER_CHANNELS_ACCESS, ActiveProductsData.USER_CHANNELS_ACCESS, UsersKeys.Products.USER_CHANNELS_ACCESS));
        this.register(new ViewManagePermissionHandlerImpl(Permission.USER_OIDC_AUTHORIZATIONS_VIEW, Permission.USER_OIDC_AUTHORIZATIONS_MANAGE, UserManagementProductDTO.USER_OIDC_AUTHORIZATIONS, ActiveProductsData.USER_OIDC_AUTHORIZATIONS, UsersKeys.Products.USER_OIDC_AUTHORIZATIONS));
        this.register(new ViewManagePermissionHandlerImpl(Permission.USER_IDENTITY_PROVIDERS_VIEW, Permission.USER_IDENTITY_PROVIDERS_MANAGE, UserManagementProductDTO.USER_IDENTITY_PROVIDERS, ActiveProductsData.USER_IDENTITY_PROVIDERS, UsersKeys.Products.USER_IDENTITY_PROVIDERS));
        this.register(new ViewManagePermissionHandlerImpl(Permission.USER_QUICK_ACCESS_SETTINGS_VIEW, Permission.USER_QUICK_ACCESS_SETTINGS_MANAGE, UserManagementProductDTO.USER_QUICK_ACCESS_SETTINGS, ActiveProductsData.USER_QUICK_ACCESS_SETTINGS, UsersKeys.Products.USER_QUICK_ACCESS_SETTINGS));
        this.register(new BooleanPermissionHandlerImpl(Permission.BLOCKED_USERS_MANAGE, UserManagementProductDTO.BLOCKED_USERS_MANAGE, ActiveAdminProductsData.BLOCKED_USERS_MANAGE, UsersKeys.Products.BLOCKED_USERS_MANAGE));
        this.register(new ViewManagePermissionHandlerImpl(Permission.DISABLED_USERS_VIEW, Permission.DISABLED_USERS_MANAGE, UserManagementProductDTO.DISABLED_USERS, ActiveAdminProductsData.DISABLED_USERS, UsersKeys.Products.DISABLED_USERS));
        this.register(new ViewManagePermissionHandlerImpl(Permission.REMOVED_USERS_VIEW, Permission.REMOVED_USERS_MANAGE, UserManagementProductDTO.REMOVED_USERS, ActiveAdminProductsData.REMOVED_USERS, UsersKeys.Products.REMOVED_USERS));
        this.register(new ViewManagePermissionHandlerImpl(Permission.PURGED_USERS_VIEW, Permission.PURGED_USERS_MANAGE, UserManagementProductDTO.PURGED_USERS, ActiveAdminProductsData.PURGED_USERS, UsersKeys.Products.PURGED_USERS));
        this.register(new ViewManagePermissionHandlerImpl(Permission.PENDING_USERS_VIEW, Permission.PENDING_USERS_MANAGE, UserManagementProductDTO.PENDING_USERS, ActiveProductsData.PENDING_USERS, UsersKeys.Products.PENDING_USERS));
        this.register(new ViewManagePermissionHandlerImpl(Permission.CONNECTED_USERS_VIEW, Permission.CONNECTED_USERS_MANAGE, UserManagementProductDTO.CONNECTED_USERS, ActiveProductsData.CONNECTED_USERS, UsersKeys.Products.CONNECTED_USERS));
        this.register(new CollectionPermissionHandlerImpl(Permission.USER_ACCOUNTS_VIEW, UserManagementProductDTO.USER_ACCOUNTS_ACCESS, UsersKeys.Products.USER_ACCOUNTS_ACCESS));
        this.register(new CollectionPermissionHandlerImpl(Permission.USER_PAYMENT_REQUESTS_SEND_TO_SYSTEM, UserManagementProductDTO.USER_PAYMENT_REQUESTS_SEND_TO_SYSTEM, UsersKeys.Products.USER_PAYMENT_REQUESTS_SEND_TO_SYSTEM));
        this.register(new CollectionPermissionHandlerImpl(Permission.USER_PAYMENT_REQUESTS_SEND_TO_USER, UserManagementProductDTO.USER_PAYMENT_REQUESTS_SEND_TO_USER, UsersKeys.Products.USER_PAYMENT_REQUESTS_SEND_TO_USER));
        this.register(new OperationPermissionHandlerImpl(UserManagementProductDTO.USER_EXTERNAL_PAYMENTS, ActiveUserProductsData.USER_EXTERNAL_PAYMENTS, UsersKeys.Products.USER_EXTERNAL_PAYMENTS).master(ExternalPaymentOperation.VIEW, Permission.USER_EXTERNAL_PAYMENTS_VIEW).map(ExternalPaymentOperation.CANCEL, Permission.USER_EXTERNAL_PAYMENTS_CANCEL));
        this.register(new OperationPermissionHandlerImpl(UserManagementProductDTO.USER_TICKETS, ActiveUserProductsData.USER_TICKETS, UsersKeys.Products.USER_TICKETS).master(TicketsOperation.VIEW, Permission.USER_PAYMENT_TICKETS_VIEW).map(TicketsOperation.CANCEL, Permission.USER_PAYMENT_TICKETS_CANCEL));
        this.register(new OperationPermissionHandlerImpl(UserManagementProductDTO.USER_PAYMENT_REQUESTS, ActiveUserProductsData.USER_PAYMENT_REQUESTS, UsersKeys.Products.USER_PAYMENT_REQUESTS).master(PaymentRequestOperation.VIEW, Permission.USER_PAYMENT_REQUESTS_VIEW).map(PaymentRequestOperation.ACCEPT, Permission.USER_PAYMENT_REQUESTS_ACCEPT).map(PaymentRequestOperation.CANCEL, Permission.USER_PAYMENT_REQUESTS_CANCEL).map(PaymentRequestOperation.CHANGE_EXPIRATION_DATE, Permission.USER_PAYMENT_REQUESTS_CHANGE_EXPIRATION_DATE));
        this.register(new OperationPermissionHandlerImpl(UserManagementProductDTO.USER_SCHEDULED_PAYMENTS, ActiveProductsData.USER_SCHEDULED_PAYMENTS, UsersKeys.Products.USER_SCHEDULED_PAYMENTS).master(ScheduledPaymentsOperation.VIEW, Permission.USER_SCHEDULED_PAYMENTS_VIEW).map(ScheduledPaymentsOperation.CANCEL, Permission.USER_SCHEDULED_PAYMENTS_CANCEL).map(ScheduledPaymentsOperation.MODIFY, Permission.USER_SCHEDULED_PAYMENTS_MODIFY).map(ScheduledPaymentsOperation.BLOCK, Permission.USER_SCHEDULED_PAYMENTS_BLOCK).map(ScheduledPaymentsOperation.UNBLOCK, Permission.USER_SCHEDULED_PAYMENTS_UNBLOCK).map(ScheduledPaymentsOperation.PROCESS_INSTALLMENT, Permission.USER_SCHEDULED_PAYMENTS_PROCESS_INSTALLMENT).map(ScheduledPaymentsOperation.SETTLE_INSTALLMENT, Permission.USER_SCHEDULED_PAYMENTS_SETTLE_INSTALLMENT));
        this.register(new ViewManagePermissionHandlerImpl(Permission.USER_ACCOUNT_LIMIT_VIEW, Permission.USER_ACCOUNT_LIMIT_MANAGE, UserManagementProductDTO.USER_BALANCE_LIMIT, ActiveProductsData.USER_BALANCE_LIMIT, UsersKeys.Products.USER_BALANCE_LIMIT));
        this.register(new ViewManagePermissionHandlerImpl(Permission.USER_ACCOUNT_PAYMENT_LIMIT_VIEW, Permission.USER_ACCOUNT_PAYMENT_LIMIT_MANAGE, UserManagementProductDTO.USER_PAYMENT_LIMIT, ActiveProductsData.USER_PAYMENT_LIMIT, UsersKeys.Products.USER_PAYMENT_LIMIT));
        this.register(new BooleanPermissionHandlerImpl(Permission.USER_AUTHORIZED_PAYMENTS_CANCEL, UserManagementProductDTO.USER_AUTHORIZED_PAYMENTS_CANCEL, ActiveProductsData.USER_AUTHORIZED_PAYMENTS_CANCEL, UsersKeys.Products.USER_AUTHORIZED_PAYMENTS_CANCEL));
        this.register(new CollectionPermissionHandlerImpl(Permission.USER_PAYMENTS_PAY_TO_USER, UserManagementProductDTO.USER_PAYMENTS_AS_USER, UsersKeys.Products.USER_PAYMENTS_AS_USER));
        this.register(new CollectionPermissionHandlerImpl(Permission.USER_PAYMENT_TICKETS_CREATE, UserManagementProductDTO.CREATE_TICKETS_AS_USER, UsersKeys.Products.CREATE_TICKETS_AS_USER));
        this.register(new CollectionPermissionHandlerImpl(Permission.USER_EXTERNAL_PAYMENTS_PAY_TO_USER, UserManagementProductDTO.EXTERNAL_PAYMENTS_AS_USER, UsersKeys.Products.EXTERNAL_PAYMENTS_AS_USER));
        this.register(new CollectionPermissionHandlerImpl(Permission.USER_PAYMENTS_PAY_TO_SYSTEM, UserManagementProductDTO.SYSTEM_PAYMENTS_AS_USER, UsersKeys.Products.SYSTEM_PAYMENTS_AS_USER));
        this.register(new CollectionPermissionHandlerImpl(Permission.USER_PAYMENTS_PAY_TO_SELF, UserManagementProductDTO.SELF_PAYMENTS_AS_USER, UsersKeys.Products.SELF_PAYMENTS_AS_USER));
        this.register(new CollectionPermissionHandlerImpl(Permission.USER_PAYMENTS_CHARGEBACK, UserManagementProductDTO.CHARGEBACK_PAYMENTS_TO_USER, UsersKeys.Products.CHARGEBACK_PAYMENTS_TO_USER));
        this.register(new ViewManagePermissionHandlerImpl(Permission.USER_IMPORTED_PAYMENTS_VIEW, Permission.USER_IMPORTED_PAYMENTS_MANAGE, UserManagementProductDTO.USER_IMPORTED_PAYMENTS, ActiveProductsData.USER_IMPORTED_PAYMENTS, UsersKeys.Products.USER_IMPORTED_PAYMENTS));
        this.register(new ViewManagePermissionHandlerImpl(Permission.USER_VOUCHERS_BATCH_SEND_VIEW, Permission.USER_VOUCHERS_BATCH_SEND_MANAGE, UserManagementProductDTO.USER_VOUCHERS_BATCH_SEND, ActiveProductsData.USER_VOUCHERS_BATCH_SEND, UsersKeys.Products.USER_VOUCHERS_BATCH_SEND));
        this.register(new BooleanPermissionHandlerImpl(Permission.USER_REFERENCES_MANAGE, UserManagementProductDTO.MANAGE_REFERENCES, ActiveProductsData.MANAGE_REFERENCES, UsersKeys.Products.MANAGE_REFERENCES));
        this.register(new BooleanPermissionHandlerImpl(Permission.USER_CONTACT_INFO_MANAGE, UserManagementProductDTO.USER_CONTACT_INFO_MANAGE, ActiveProductsData.USER_CONTACT_INFO_MANAGE, UsersKeys.Products.USER_CONTACT_INFO_MANAGE));
        this.register(new BooleanPermissionHandlerImpl(Permission.USER_TRANSACTION_FEEDBACKS_MANAGE, UserManagementProductDTO.MANAGE_TRANSACTION_FEEDBACKS, ActiveProductsData.MANAGE_TRANSACTION_FEEDBACKS, UsersKeys.Products.MANAGE_TRANSACTION_FEEDBACKS));
        this.register(new BooleanPermissionHandlerImpl(Permission.USER_AGREEMENT_LOG_VIEW, UserManagementProductDTO.USER_AGREEMENT_LOG, ActiveProductsData.USER_AGREEMENT_LOG, UsersKeys.Products.USER_AGREEMENT_LOG));
        this.register(new ViewManagePermissionHandlerImpl(Permission.USER_DOCUMENTS_VIEW, Permission.USER_DOCUMENTS_MANAGE, UserManagementProductDTO.USER_DOCUMENTS, ActiveProductsData.USER_DOCUMENTS, UsersKeys.Products.USER_DOCUMENTS));
        this.register(new ViewManagePermissionHandlerImpl(Permission.USER_CONTACTS_VIEW, Permission.USER_CONTACTS_MANAGE, UserManagementProductDTO.USER_CONTACTS, ActiveProductsData.USER_CONTACTS, UsersKeys.Products.USER_CONTACTS));
        this.register(new ViewManagePermissionHandlerImpl(Permission.USER_NOTIFICATION_SETTINGS_VIEW, Permission.USER_NOTIFICATION_SETTINGS_MANAGE, UserManagementProductDTO.USER_NOTIFICATION_SETTINGS, ActiveProductsData.USER_NOTIFICATION_SETTINGS, UsersKeys.Products.USER_NOTIFICATION_SETTINGS));
        this.register(new ViewManagePermissionHandlerImpl(Permission.USER_ADS_VIEW, Permission.USER_ADS_MANAGE, UserManagementProductDTO.USER_ADVERTISEMENTS, ActiveProductsData.USER_ADVERTISEMENTS, UsersKeys.Products.USER_ADVERTISEMENTS));
        this.register(new ViewManagePermissionHandlerImpl(Permission.USER_WEB_SHOP_VIEW, Permission.USER_WEB_SHOP_MANAGE, UserManagementProductDTO.USER_WEB_SHOP, ActiveProductsData.USER_WEB_SHOP, UsersKeys.Products.USER_WEB_SHOP));
        this.register(new ViewManagePermissionHandlerImpl(Permission.USER_WEB_SHOP_SETTINGS_VIEW, Permission.USER_WEB_SHOP_SETTINGS_MANAGE, UserManagementProductDTO.USER_WEB_SHOP_SETTINGS, ActiveProductsData.USER_WEB_SHOP_SETTINGS, UsersKeys.Products.USER_WEB_SHOP_SETTINGS));
        this.register(new ViewManagePermissionHandlerImpl(Permission.USER_WEB_SHOP_PURCHASES_VIEW, Permission.USER_WEB_SHOP_PURCHASES_MANAGE, UserManagementProductDTO.USER_WEB_SHOP_PURCHASES, ActiveProductsData.USER_WEB_SHOP_PURCHASES, UsersKeys.Products.USER_WEB_SHOP_PURCHASES));
        this.register(new ViewManagePermissionHandlerImpl(Permission.USER_WEB_SHOP_SALES_VIEW, Permission.USER_WEB_SHOP_SALES_MANAGE, UserManagementProductDTO.USER_WEB_SHOP_SALES, ActiveProductsData.USER_WEB_SHOP_SALES, UsersKeys.Products.USER_WEB_SHOP_SALES));
        this.register(new ViewManagePermissionHandlerImpl(Permission.USER_PENDING_ADS_VIEW, Permission.USER_PENDING_ADS_MANAGE, UserManagementProductDTO.USER_PENDING_ADS, ActiveProductsData.USER_PENDING_ADS, UsersKeys.Products.USER_PENDING_ADS));
        this.register(new ViewManagePermissionHandlerImpl(Permission.USER_PENDING_WEB_SHOP_VIEW, Permission.USER_PENDING_WEB_SHOP_MANAGE, UserManagementProductDTO.USER_PENDING_WEB_SHOP, ActiveProductsData.USER_PENDING_WEB_SHOP, UsersKeys.Products.USER_PENDING_WEB_SHOP));
        this.register(new ViewManagePermissionHandlerImpl(Permission.USER_AD_INTERESTS_VIEW, Permission.USER_AD_INTERESTS_MANAGE, UserManagementProductDTO.USER_AD_INTERESTS, ActiveProductsData.USER_AD_INTERESTS, UsersKeys.Products.USER_AD_INTERESTS));
        this.register(new BooleanPermissionHandlerImpl(Permission.USER_FAVORITE_ADS_VIEW, UserManagementProductDTO.USER_FAVORITE_ADS, ActiveProductsData.USER_FAVORITE_ADS, UsersKeys.Products.USER_FAVORITE_ADS));
        this.register(new ViewManagePermissionHandlerImpl(Permission.USER_BROKER_VIEW, Permission.USER_BROKER_MANAGE, UserManagementProductDTO.USER_BROKERS, ActiveProductsData.USER_BROKERS, UsersKeys.Products.USER_BROKERS));
        this.register(new BooleanPermissionHandlerImpl(Permission.USER_CUSTOM_IMAGES_MANAGE, UserManagementProductDTO.USER_CUSTOM_IMAGES, ActiveProductsData.USER_CUSTOM_IMAGES, UsersKeys.Products.USER_CUSTOM_IMAGES));
        this.register(new CollectionPermissionHandlerImpl(Permission.DOCUMENTS_VIEW, UserManagementProductDTO.DOCUMENT_CATEGORY_VIEW, UsersKeys.Products.DOCUMENT_CATEGORY_VIEW));
        this.register(new ViewManagePermissionHandlerImpl(Permission.USER_OPERATORS_VIEW, Permission.USER_OPERATORS_MANAGE, UserManagementProductDTO.USER_OPERATORS, ActiveProductsData.USER_OPERATORS, UsersKeys.Products.USER_OPERATORS));
        this.register(new ViewManagePermissionHandlerImpl(Permission.USER_TRUSTED_DEVICES_VIEW, Permission.USER_TRUSTED_DEVICES_MANAGE, UserManagementProductDTO.USER_TRUSTED_DEVICES, ActiveProductsData.USER_TRUSTED_DEVICES, UsersKeys.Products.USER_TRUSTED_DEVICES));
        this.register(new ViewManagePermissionHandlerImpl(Permission.USER_PINS_VIEW, Permission.USER_PINS_MANAGE, UserManagementProductDTO.USER_PINS, ActiveProductsData.USER_PINS, UsersKeys.Products.USER_PINS));
        this.register(new ViewManagePermissionHandlerImpl(Permission.USER_TOTP_VIEW, Permission.USER_TOTP_MANAGE, UserManagementProductDTO.USER_TOTPS, ActiveProductsData.USER_TOTPS, UsersKeys.Products.USER_TOTPS));
        this.register(new PermissionHandler<DTO, AD>(){

            public Property<?, ? super UserManagementProductDTO> getDTOProperty() {
                return UserManagementProductDTO.USER_PASSWORD_ACTIONS;
            }

            public MessageKey getKey() {
                return UsersKeys.Products.USER_PASSWORD_ACTIONS;
            }

            public List<Permission> getPermissions() {
                return Collections.singletonList(Permission.USER_PASSWORDS_MANAGE);
            }

            public void writePermissions(DTO DTO, Collection<Permission> collection) {
                CollectionHelper.addOrRemove(collection, (Object)Permission.USER_PASSWORDS_MANAGE, (boolean)UserManagementProductConversionHandlerImpl.this.hasPasswordActions(DTO.getUserPasswordActions()));
            }
        });
        this.register(new BooleanPermissionHandlerImpl(Permission.USERS_ACTIVE_CONFIGURATION_AND_PRODUCTS, UserManagementProductDTO.USER_ACTIVE_CONFIGURATION_AND_PRODUCTS, ActiveProductsData.USER_ACTIVE_CONFIGURATION_AND_PRODUCTS, UsersKeys.Products.USER_ACTIVE_CONFIGURATION_AND_PRODUCTS));
        this.register(new ViewManagePermissionHandlerImpl(Permission.USER_ACCOUNT_VISIBILITY_VIEW, Permission.USER_ACCOUNT_VISIBILITY_MANAGE, UserManagementProductDTO.USER_ACCOUNTS_VISIBILITY, ActiveProductsData.USER_ACCOUNTS_VISIBILITY, UsersKeys.Products.USER_ACCOUNTS_VISIBILITY));
    }

    @Override
    public DTO toDTO(P p) {
        UserManagementProductDTO userManagementProductDTO = (UserManagementProductDTO)super.toDTO(p);
        this.ensureUserPasswordActions(p, userManagementProductDTO);
        this.ensureUserRecordTypes(p, userManagementProductDTO);
        this.ensureUserAccessClients(p, userManagementProductDTO);
        this.ensureUserTokenTypes(p, userManagementProductDTO);
        this.ensureUserAdFields(p, userManagementProductDTO);
        this.ensureUserContactFields(p, userManagementProductDTO);
        return (DTO)userManagementProductDTO;
    }

    @Override
    public P toEntity(DTO DTO) {
        Set set = this.conversionHandler.convertSet(UserAccountType.class, (Iterable)DTO.getUserAccountsAccess());
        DTO.setSystemPaymentsAsUser(this.filterPaymentTypesByFromAccount(DTO.getSystemPaymentsAsUser(), set, TransferTypeDirection.USER_TO_SYSTEM));
        DTO.setUserPaymentsAsUser(this.filterPaymentTypesByFromAccount(DTO.getUserPaymentsAsUser(), set, TransferTypeDirection.USER_TO_USER));
        DTO.setSelfPaymentsAsUser(this.filterPaymentTypesByFromAccount(DTO.getSelfPaymentsAsUser(), set, TransferTypeDirection.USER_TO_SELF));
        DTO.setChargebackPaymentsToUser(this.filterPaymentTypesByToAccount(DTO.getChargebackPaymentsToUser(), set, TransferTypeDirection.USER_TO_USER, TransferTypeDirection.SYSTEM_TO_USER, TransferTypeDirection.USER_TO_SELF));
        DTO.setUserTransferFilters(this.filterTransferFilters(DTO.getUserTransferFilters(), set));
        DTO.setExternalPaymentsAsUser(this.filterPaymentTypesByFromAccount(DTO.getExternalPaymentsAsUser(), set, TransferTypeDirection.USER_TO_USER));
        DTO.setCreateTicketsAsUser(this.filterPaymentTypesByToAccount(DTO.getCreateTicketsAsUser(), set, TransferTypeDirection.USER_TO_USER));
        DTO.setUserPaymentRequestsSendToUser(this.filterPaymentTypesByToAccount(DTO.getUserPaymentRequestsSendToUser(), set, TransferTypeDirection.USER_TO_USER));
        DTO.setUserPaymentRequestsSendToSystem(this.filterPaymentTypesByToAccount(DTO.getUserPaymentRequestsSendToSystem(), set, TransferTypeDirection.SYSTEM_TO_USER));
        UserManagementProduct userManagementProduct = (UserManagementProduct)super.toEntity(DTO);
        if (CollectionHelper.isNotEmpty((Iterable)set)) {
            Object object3;
            Object object22;
            HashSet hashSet = new HashSet();
            for (Object object22 : set) {
                hashSet.addAll(object22.getFromTransferTypes());
            }
            HashSet hashSet2 = new HashSet(DTO.getSystemPaymentsAsUser());
            hashSet2.addAll(DTO.getUserPaymentsAsUser());
            hashSet2.addAll(DTO.getSelfPaymentsAsUser());
            object22 = this.conversionHandler.convertSet(PaymentTransferType.class, (Iterable)hashSet2);
            object22.retainAll(hashSet);
            userManagementProduct.setPaymentsAsUser((Set)object22);
            HashSet hashSet3 = new HashSet();
            for (Object object3 : set) {
                hashSet3.addAll(object3.getToTransferTypes());
            }
            HashSet hashSet4 = new HashSet();
            hashSet4.addAll(DTO.getUserPaymentRequestsSendToSystem());
            hashSet4.addAll(DTO.getUserPaymentRequestsSendToUser());
            object3 = this.conversionHandler.convertSet(PaymentTransferType.class, (Iterable)hashSet4);
            object3.retainAll(hashSet3);
            userManagementProduct.setRequestPaymentsAsUser((Set)object3);
        } else {
            userManagementProduct.setPaymentsAsUser(null);
            userManagementProduct.setRequestPaymentsAsUser(null);
        }
        this.recordFieldHandler.toEntityProductRecordTypes((Product)userManagementProduct, (Collection)userManagementProduct.getUserRecordTypes(), (Collection)DTO.getUserRecordTypeFields(), ProductUserRecordType.class);
        if (!userManagementProduct.getPermissions().contains(Permission.USER_CONTACTS_VIEW)) {
            userManagementProduct.getMyContactFields().clear();
        }
        return (P)userManagementProduct;
    }

    private void ensureUserAccessClients(P p, DTO DTO) {
        DTO.setUserAccessClients(new ArrayList());
        List list = this.principalTypeService.listAccessClients();
        for (AccessClientPrincipalType accessClientPrincipalType : list) {
            ProductUserAccessClientDTO productUserAccessClientDTO = this.getProductUserAccessClientDTO(accessClientPrincipalType, p);
            if (productUserAccessClientDTO == null) {
                productUserAccessClientDTO = new ProductUserAccessClientDTO();
                productUserAccessClientDTO.setAccessClientType((AccessClientPrincipalTypeVO)this.conversionHandler.convert(AccessClientPrincipalTypeVO.class, (Object)accessClientPrincipalType));
            }
            DTO.getUserAccessClients().add(productUserAccessClientDTO);
        }
    }

    private void ensureUserAdFields(P p, DTO DTO) {
        DTO.setUserAdFields(new ArrayList());
        List list = this.adCustomFieldService.listAll();
        for (AdCustomField adCustomField : list) {
            ProductUserAdFieldDTO productUserAdFieldDTO = this.getProductUserAdFieldDTO(adCustomField, p);
            if (productUserAdFieldDTO == null) {
                productUserAdFieldDTO = new ProductUserAdFieldDTO();
                productUserAdFieldDTO.setCustomField((CustomFieldVO)this.conversionHandler.convert(CustomFieldVO.class, (Object)adCustomField));
            }
            DTO.getUserAdFields().add(productUserAdFieldDTO);
        }
    }

    private void ensureUserContactFields(P p, DTO DTO) {
        DTO.setUserContactFields(new ArrayList());
        List list = this.contactCustomFieldService.listAll();
        for (ContactCustomField contactCustomField : list) {
            ProductUserContactFieldDTO productUserContactFieldDTO = this.getProductUserContactFieldDTO(contactCustomField, p);
            if (productUserContactFieldDTO == null) {
                productUserContactFieldDTO = new ProductUserContactFieldDTO();
                productUserContactFieldDTO.setCustomField((CustomFieldVO)this.conversionHandler.convert(CustomFieldVO.class, (Object)contactCustomField));
            }
            DTO.getUserContactFields().add(productUserContactFieldDTO);
        }
    }

    private void ensureUserPasswordActions(P p, DTO DTO) {
        if (DTO.getUserPasswordActions() == null) {
            DTO.setUserPasswordActions(new HashSet());
        }
        this.ensureUserPasswordActions(p, DTO.getUserPasswordActions());
    }

    private void ensureUserPasswordActions(P p, Set<UserProductPasswordActionDTO> set) {
        List list = this.passwordTypeService.list();
        if (CollectionHelper.isNotEmpty((Iterable)list)) {
            for (PasswordTypeVO passwordTypeVO : list) {
                UserProductPasswordActionDTO userProductPasswordActionDTO;
                if (!passwordTypeVO.getPasswordMode().allowActions() || (userProductPasswordActionDTO = this.findUserPasswordDTO(set, passwordTypeVO)) != null) continue;
                userProductPasswordActionDTO = new UserProductPasswordActionDTO();
                userProductPasswordActionDTO.setPasswordType(passwordTypeVO);
                set.add(userProductPasswordActionDTO);
            }
        }
    }

    private void ensureUserRecordTypes(P p, DTO DTO) {
        DTO.setUserRecordTypeFields(this.recordFieldHandler.getProductRecordFields(p, ProductUserRecordType.class));
    }

    private void ensureUserTokenTypes(P p, DTO DTO) {
        DTO.setUserTokenTypes(new ArrayList());
        List list = this.principalTypeService.listByNatures(new PrincipalTypeNature[]{PrincipalTypeNature.TOKEN, PrincipalTypeNature.NFC_TOKEN});
        for (PrincipalType principalType : list) {
            TokenPrincipalType tokenPrincipalType = (TokenPrincipalType)principalType;
            ProductUserTokenTypeDTO productUserTokenTypeDTO = this.getProductUserTokenTypeDTO(tokenPrincipalType, p);
            if (productUserTokenTypeDTO == null) {
                productUserTokenTypeDTO = new ProductUserTokenTypeDTO();
                productUserTokenTypeDTO.setTokenType((TokenPrincipalTypeVO)this.conversionHandler.convert(TokenPrincipalTypeVO.class, (Object)tokenPrincipalType));
            }
            DTO.getUserTokenTypes().add(productUserTokenTypeDTO);
        }
    }

    private UserProductPasswordActionDTO findUserPasswordDTO(Collection<UserProductPasswordActionDTO> collection, PasswordTypeVO passwordTypeVO) {
        for (UserProductPasswordActionDTO userProductPasswordActionDTO : collection) {
            if (!passwordTypeVO.getId().equals(userProductPasswordActionDTO.getPasswordType().getId())) continue;
            return userProductPasswordActionDTO;
        }
        return null;
    }

    private ProductUserAccessClientDTO getProductUserAccessClientDTO(AccessClientPrincipalType accessClientPrincipalType, P p) {
        for (ProductUserAccessClient productUserAccessClient : p.getUserAccessClients()) {
            if (!productUserAccessClient.getAccessClientType().equals((Object)accessClientPrincipalType)) continue;
            return (ProductUserAccessClientDTO)this.conversionHandler.convert(ProductUserAccessClientDTO.class, (Object)productUserAccessClient);
        }
        return null;
    }

    private ProductUserAdFieldDTO getProductUserAdFieldDTO(AdCustomField adCustomField, P p) {
        for (ProductUserAdField productUserAdField : p.getUserAdFields()) {
            if (!productUserAdField.getCustomField().equals((Object)adCustomField)) continue;
            return (ProductUserAdFieldDTO)this.conversionHandler.convert(ProductUserAdFieldDTO.class, (Object)productUserAdField);
        }
        return null;
    }

    private ProductUserContactFieldDTO getProductUserContactFieldDTO(ContactCustomField contactCustomField, P p) {
        for (ProductUserContactField productUserContactField : p.getUserContactFields()) {
            if (!productUserContactField.getCustomField().equals((Object)contactCustomField)) continue;
            return (ProductUserContactFieldDTO)this.conversionHandler.convert(ProductUserContactFieldDTO.class, (Object)productUserContactField);
        }
        return null;
    }

    private ProductUserTokenTypeDTO getProductUserTokenTypeDTO(TokenPrincipalType tokenPrincipalType, P p) {
        for (ProductUserTokenType productUserTokenType : p.getUserTokenTypes()) {
            if (!productUserTokenType.getTokenType().equals((Object)tokenPrincipalType)) continue;
            return (ProductUserTokenTypeDTO)this.conversionHandler.convert(ProductUserTokenTypeDTO.class, (Object)productUserTokenType);
        }
        return null;
    }
}

