/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import com.google.common.collect.Iterables;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.validation.constraints.NotNull;
import org.cyclos.entities.ConfigurationEntity;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.access.TokenPrincipalType;
import org.cyclos.entities.system.CustomOperation;
import org.cyclos.entities.system.CustomWizard;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.QUserQuickAccess;
import org.cyclos.entities.users.QuickAccess;
import org.cyclos.entities.users.RecordType;
import org.cyclos.entities.users.RoleContainer;
import org.cyclos.entities.users.UserQuickAccess;
import org.cyclos.impl.BaseServiceImpl;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.access.InitializationServiceLocal;
import org.cyclos.impl.access.PrincipalTypeServiceLocal;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.system.CustomOperationServiceLocal;
import org.cyclos.impl.system.CustomWizardServiceLocal;
import org.cyclos.impl.users.InternalBasicUserServiceLocal;
import org.cyclos.impl.users.ProductsAccessor;
import org.cyclos.impl.users.QuickAccessHandler;
import org.cyclos.impl.users.RecordTypeServiceLocal;
import org.cyclos.impl.users.UserQuickAccessServiceLocal;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IEntity;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.Role;
import org.cyclos.model.system.configurations.Frontend;
import org.cyclos.model.system.configurations.UserSearchInMenuMode;
import org.cyclos.model.users.dashboard.QuickAccessType;
import org.cyclos.model.users.dashboardsettings.UserQuickAccessDTO;
import org.cyclos.model.users.dashboardsettings.UserQuickAccessData;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.utils.QuickAccessDTO;
import org.cyclos.utils.CollectionHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserQuickAccessServiceImpl
extends BaseServiceImpl
implements UserQuickAccessServiceLocal {
    private static final QUserQuickAccess $ = QUserQuickAccess.userQuickAccess;
    private Map<QuickAccessType, QuickAccessResolver> mapping = new EnumMap<QuickAccessType, QuickAccessResolver>(QuickAccessType.class);
    private Map<QuickAccessType, Class<? extends ConfigurationEntity>> entityTypeMapping;
    @Autowired
    private CustomOperationServiceLocal customOperationService;
    @Autowired
    private PrincipalTypeServiceLocal principalTypeService;
    @Autowired
    private CustomWizardServiceLocal customWizardService;
    @Autowired
    private InternalBasicUserServiceLocal internalBasicUserService;
    @Autowired
    private RecordTypeServiceLocal recordTypeService;
    @Autowired
    private InvokerHandler invokerHandler;
    @Autowired
    private InitializationServiceLocal initializationService;
    @Autowired
    private QuickAccessHandler quickAccessHandler;

    public UserQuickAccessServiceImpl() {
        this.mapCustom(QuickAccessType.ACCOUNT, sessionData -> sessionData.isAdmin() ? sessionData.hasPermission(Permission.SYSTEM_ACCOUNTS_VIEW) : sessionData.getProducts().member().isViewMyAccounts());
        this.mapPermissions(QuickAccessType.SCHEDULED_PAYMENTS, Permission.SYSTEM_SCHEDULED_PAYMENTS_VIEW, Permission.USER_SCHEDULED_PAYMENTS_VIEW, Permission.MY_SCHEDULED_PAYMENTS_VIEW);
        this.mapPermissions(QuickAccessType.TRANSFERS_OVERVIEW, Permission.SYSTEM_ACCOUNTS_VIEW, Permission.USER_ACCOUNTS_VIEW);
        this.mapPermissions(QuickAccessType.PAY_USER, Permission.MY_PAYMENTS_PAY_TO_USER, Permission.SYSTEM_PAYMENTS_PAY_TO_USER);
        this.mapPermissions(QuickAccessType.PAY_SYSTEM, Permission.MY_PAYMENTS_PAY_TO_SYSTEM, Permission.SYSTEM_PAYMENTS_PAY_TO_SYSTEM);
        this.mapPermissions(QuickAccessType.PAY_SELF, Permission.MY_PAYMENTS_PAY_TO_SELF);
        this.mapPermissions(QuickAccessType.POS, Permission.MY_PAYMENTS_RECEIVE);
        this.mapPermissions(QuickAccessType.RECEIVE_QR_PAYMENT, Permission.MY_PAYMENT_TICKETS_CREATE);
        this.mapPermissions(QuickAccessType.TRANSACTION_FEEDBACKS, Permission.MY_TRANSACTION_FEEDBACKS_GIVE, Permission.MY_TRANSACTION_FEEDBACKS_RECEIVE);
        this.mapPermissions(QuickAccessType.PAYMENT_REQUESTS, Permission.MY_PAYMENT_REQUESTS_VIEW, Permission.SYSTEM_PAYMENT_REQUESTS_VIEW);
        this.mapPermissions(QuickAccessType.REQUEST_PAYMENT_FROM_USER, Permission.MY_PAYMENT_REQUESTS_SEND_TO_USER, Permission.SYSTEM_PAYMENT_REQUESTS_SEND_TO_USER);
        this.mapPermissions(QuickAccessType.REQUEST_PAYMENT_FROM_SYSTEM, Permission.MY_PAYMENT_REQUESTS_SEND_TO_SYSTEM);
        this.mapPermissions(QuickAccessType.EXTERNAL_PAYMENTS, Permission.MY_EXTERNAL_PAYMENTS_VIEW, Permission.SYSTEM_EXTERNAL_PAYMENTS_VIEW);
        this.mapPermissions(QuickAccessType.PAY_EXTERNAL_USER, Permission.MY_EXTERNAL_PAYMENTS_PAY_TO_USER, Permission.SYSTEM_EXTERNAL_PAYMENTS_PAY_TO_USER);
        this.mapTokens();
        this.mapCustomOperations();
        this.mapCustomWizards();
        this.mapPermissions(QuickAccessType.VOUCHERS, Permission.VOUCHERS_VIEW, Permission.MY_VOUCHERS_VIEW_VOUCHERS);
        this.mapPermissions(QuickAccessType.BUY_VOUCHER, Permission.MY_VOUCHERS_BUY);
        this.mapPermissions(QuickAccessType.SEND_VOUCHER, Permission.MY_VOUCHERS_SEND);
        this.mapPermissions(QuickAccessType.VOUCHER_TRANSACTIONS, Permission.MY_VOUCHERS_VIEW_TRANSACTIONS);
        this.mapPermissions(QuickAccessType.REDEEM_VOUCHER, Permission.MY_VOUCHERS_REDEEM);
        this.mapPermissions(QuickAccessType.TOP_UP_VOUCHER, Permission.MY_VOUCHERS_TOP_UP);
        this.mapCustom(QuickAccessType.SEARCH_USERS, sessionData -> !this.initializationService.isHideUserSearchInMenu());
        this.mapPermissions(QuickAccessType.BALANCES_OVERVIEW, Permission.USER_ACCOUNTS_VIEW);
        this.mapCustom(QuickAccessType.PENDING_USERS, sessionData -> sessionData.hasPermission(Permission.PENDING_USERS_VIEW) && sessionData.getConfiguration().getUserSearchInMenuMode() != UserSearchInMenuMode.NONE);
        this.mapPermissions(QuickAccessType.CONTACTS, Permission.MY_CONTACTS_ENABLE);
        this.mapCustom(QuickAccessType.BROKERED_USERS, RoleContainer::isBroker);
        this.mapPermissions(QuickAccessType.REGISTER_USER, Permission.USERS_REGISTER);
        this.mapPermissions(QuickAccessType.INVITE_USER, Permission.USER_INVITE);
        this.mapPermissions(QuickAccessType.SEARCH_ADS, Permission.USER_ADS_VIEW);
        this.mapPermissions(QuickAccessType.AD_INTERESTS, Permission.MY_AD_INTERESTS_ENABLE);
        this.mapPermissions(QuickAccessType.PURCHASES, Permission.USER_WEB_SHOP_PURCHASE);
        this.mapPermissions(QuickAccessType.MY_ADS, Permission.MY_ADS_ENABLE);
        this.mapPermissions(QuickAccessType.CREATE_AD, Permission.MY_ADS_MANAGE);
        this.mapPermissions(QuickAccessType.MY_WEBSHOP, Permission.MY_WEB_SHOP_ENABLE);
        this.mapPermissions(QuickAccessType.CREATE_WEBSHOP_AD, Permission.MY_WEB_SHOP_MANAGE);
        this.mapPermissions(QuickAccessType.SALES, Permission.MY_WEB_SHOP_ENABLE);
        this.mapCustom(QuickAccessType.EDIT_PROFILE, sessionData -> this.internalBasicUserService.canEditProfile(sessionData.getLoggedBasicUser()));
        this.mapPermissions(QuickAccessType.PASSWORDS, Permission.MY_PASSWORDS_MANAGE);
        this.mapPermissions(QuickAccessType.REFERENCES, Permission.MY_REFERENCES_RECEIVE);
        this.mapPermissions(QuickAccessType.MESSAGES, Permission.MY_MESSAGES_VIEW);
        this.mapPermissions(QuickAccessType.SEND_MESSAGE, Permission.MY_MESSAGES_SEND_TO_USER, Permission.MY_MESSAGES_SEND_TO_SYSTEM, Permission.MY_MESSAGES_SEND_TO_BROKERED_USERS);
        this.mapPermissions(QuickAccessType.DOCUMENTS, Permission.MY_INDIVIDUAL_DOCUMENTS_VIEW, Permission.MY_SHARED_DOCUMENTS_VIEW, Permission.DOCUMENTS_VIEW);
        this.mapRecords();
        this.mapAlways(QuickAccessType.SETTINGS);
        this.mapPermissions(QuickAccessType.NOTIFICATIONS, Permission.MY_NOTIFICATIONS_ENABLE);
        this.mapAlways(QuickAccessType.HELP);
        this.mapCustom(QuickAccessType.SWITCH_FRONTEND, sessionData -> sessionData.getConfiguration().isAllowFrontendSwitching());
        this.mapAlways(QuickAccessType.SWITCH_THEME);
        if (this.mapping.size() != QuickAccessType.values().length) {
            throw new IllegalStateException("Some quick access item was not mapped");
        }
        this.entityTypeMapping = new EnumMap<QuickAccessType, Class<? extends ConfigurationEntity>>(QuickAccessType.class);
        this.entityTypeMapping.put(QuickAccessType.OPERATION, CustomOperation.class);
        this.entityTypeMapping.put(QuickAccessType.WIZARD, CustomWizard.class);
        this.entityTypeMapping.put(QuickAccessType.RECORD, RecordType.class);
        this.entityTypeMapping.put(QuickAccessType.TOKEN, TokenPrincipalType.class);
        long l = Stream.of(QuickAccessType.values()).filter(QuickAccessType::hasEntity).count();
        if ((long)this.entityTypeMapping.size() != l) {
            throw new IllegalStateException("Some quick access type with entity was not mapped");
        }
    }

    public UserQuickAccessData getData(UserLocatorVO userLocatorVO) throws FrameworkException {
        BasicUser basicUser = this.userLocatorHandler.toBasicUserOrCurrent((BasicUserVO)userLocatorVO);
        List<UserQuickAccess> list = this.list(basicUser);
        UserQuickAccessData userQuickAccessData = new UserQuickAccessData();
        userQuickAccessData.setUser((BasicUserVO)this.conversionHandler.convert(BasicUserVO.class, (Object)basicUser));
        userQuickAccessData.setQuickAccess(this.conversionHandler.convertList(UserQuickAccessDTO.class, list));
        list.sort(QuickAccess.COMPARATOR);
        for (UserQuickAccessDTO userQuickAccessDTO : userQuickAccessData.getQuickAccess()) {
            int n = Iterables.indexOf(list, userQuickAccess -> this.quickAccessHandler.matches((QuickAccessDTO)userQuickAccessDTO, (QuickAccess)userQuickAccess));
            userQuickAccessDTO.setOriginalOrder(n);
        }
        return userQuickAccessData;
    }

    public List<UserQuickAccess> list(BasicUser basicUser) {
        return this.runInUserSession(basicUser, sessionData -> {
            Frontend frontend = sessionData.isRest() ? Frontend.NEW : Frontend.CLASSIC;
            ProductsAccessor productsAccessor = this.productsHandler.getAccessor(basicUser);
            List list = ((DBQuery)this.from(new EntityPath[]{$}).where((com.querydsl.core.types.Predicate)$.user().eq((Object)basicUser))).list((Expression)$);
            List list2 = this.mapping.entrySet().stream().flatMap(entry -> ((QuickAccessResolver)entry.getValue()).resolve((SessionData)sessionData, list).stream()).filter(userQuickAccess -> userQuickAccess.getType().showIn(frontend)).sorted().collect(Collectors.toList());
            if (list.isEmpty()) {
                List list3 = productsAccessor.product().getDefaultQuickAccess();
                for (QuickAccess quickAccess : list3) {
                    list2.stream().filter(userQuickAccess -> userQuickAccess.matches((IEntity)quickAccess)).forEach(userQuickAccess -> userQuickAccess.setEnabled(true));
                }
            }
            return list2;
        });
    }

    public List<QuickAccess> listEnabled() {
        SessionData sessionData = this.getSessionData();
        Frontend frontend = sessionData.isRest() ? Frontend.NEW : Frontend.CLASSIC;
        BasicUser basicUser = sessionData.getLoggedBasicUser();
        if (basicUser == null || basicUser.isGlobal()) {
            return Collections.emptyList();
        }
        List list = ((DBQuery)((DBQuery)this.from(new EntityPath[]{$}).where((com.querydsl.core.types.Predicate)$.user().eq((Object)basicUser))).orderBy(UserQuickAccessServiceImpl.$.order.asc())).list((Expression)$);
        List<QuickAccess> list2 = list.stream().filter(UserQuickAccess::isEnabled).map(QuickAccess.class::cast).collect(Collectors.toList());
        if (!list.isEmpty() && list2.isEmpty()) {
            return Collections.emptyList();
        }
        if (list.isEmpty()) {
            list2 = new ArrayList(sessionData.getProducts().product().getDefaultQuickAccess());
        }
        Set set = list2.stream().map(QuickAccess::getType).filter(quickAccessType -> quickAccessType.showIn(frontend)).collect(Collectors.toSet());
        List list3 = this.mapping.entrySet().stream().filter(entry -> set.contains(entry.getKey()) && ((QuickAccessType)entry.getKey()).showIn(frontend)).flatMap(entry -> ((QuickAccessResolver)entry.getValue()).resolve(sessionData, list).stream()).collect(Collectors.toList());
        list2.removeIf(quickAccess -> !list3.stream().anyMatch(userQuickAccess -> quickAccess.matches((IEntity)userQuickAccess)));
        return list2;
    }

    public void removeAll(BasicUser basicUser) {
        HashSet<Object> hashSet = new HashSet<Object>();
        hashSet.add(basicUser);
        hashSet.add(basicUser.getUser());
        this.delete((EntityPath<?>)$).where(new com.querydsl.core.types.Predicate[]{$.user().in(hashSet)}).execute();
    }

    public void restoreDefaults(UserLocatorVO userLocatorVO) throws FrameworkException {
        BasicUser basicUser = this.userLocatorHandler.toBasicUserOrCurrent((BasicUserVO)userLocatorVO);
        this.removeAll(basicUser);
    }

    public void save(UserLocatorVO userLocatorVO, @NotNull List<UserQuickAccessDTO> list) throws FrameworkException {
        BasicUser basicUser = this.userLocatorHandler.toBasicUserOrCurrent((BasicUserVO)userLocatorVO);
        List<UserQuickAccess> list2 = this.list(basicUser);
        for (int i = 0; i < list.size(); ++i) {
            ConfigurationEntity configurationEntity;
            UserQuickAccessDTO userQuickAccessDTO = list.get(i);
            QuickAccessType quickAccessType = userQuickAccessDTO.getType();
            ConfigurationEntity configurationEntity2 = configurationEntity = quickAccessType.hasEntity() ? (ConfigurationEntity)this.conversionHandler.convert(this.entityTypeMapping.get(quickAccessType), (Object)userQuickAccessDTO.getEntity()) : null;
            if (quickAccessType.hasEntity() && configurationEntity == null) {
                throw new ValidationException("Missing entity for quick access of type " + String.valueOf(quickAccessType));
            }
            UserQuickAccess userQuickAccess2 = list2.stream().filter(userQuickAccess -> userQuickAccess.matches(quickAccessType, configurationEntity)).findFirst().orElseThrow(IllegalActionException::new);
            userQuickAccess2.setOrder(Integer.valueOf(i));
            userQuickAccess2.setEnabled(userQuickAccessDTO.isEnabled());
        }
        List<UserQuickAccess> list3 = list2.stream().filter(SimpleEntity::isTransient).collect(Collectors.toList());
        list3.forEach(iEntity -> this.persist((IEntity)iEntity));
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register($.user().network());
    }

    private final UserQuickAccess findOrNew(BasicUser basicUser, QuickAccessType quickAccessType, ConfigurationEntity configurationEntity, List<UserQuickAccess> list) {
        if (quickAccessType.hasEntity() != (configurationEntity != null)) {
            throw new IllegalArgumentException("Quick access type " + String.valueOf(quickAccessType) + (quickAccessType.hasEntity() ? " requires " : " doesn't use ") + " an entity");
        }
        return list.stream().filter(userQuickAccess -> userQuickAccess.matches(quickAccessType, configurationEntity)).findAny().orElseGet(() -> new UserQuickAccess(basicUser, quickAccessType, configurationEntity));
    }

    private void mapAlways(QuickAccessType quickAccessType) {
        this.mapping.put(quickAccessType, (sessionData, list) -> this.roleMatch(sessionData, quickAccessType) ? Collections.singletonList(this.findOrNew(sessionData.getLoggedBasicUser(), quickAccessType, null, list)) : Collections.emptyList());
    }

    private void mapCustom(QuickAccessType quickAccessType, Predicate<SessionData> predicate) {
        this.mapping.put(quickAccessType, (sessionData, list) -> {
            if (this.roleMatch(sessionData, quickAccessType) && predicate.test(sessionData)) {
                BasicUser basicUser = sessionData.getLoggedBasicUser();
                return Collections.singletonList(this.findOrNew(basicUser, quickAccessType, null, list));
            }
            return Collections.emptyList();
        });
    }

    private void mapCustomOperations() {
        this.mapping.put(QuickAccessType.OPERATION, (sessionData, list) -> this.customOperationService.listAllowedToRun().stream().map(customOperation -> this.findOrNew(sessionData.getLoggedBasicUser(), QuickAccessType.OPERATION, (ConfigurationEntity)customOperation, list)).collect(Collectors.toList()));
    }

    private void mapCustomWizards() {
        this.mapping.put(QuickAccessType.WIZARD, (sessionData, list) -> {
            BasicUser basicUser = sessionData.getLoggedBasicUser();
            List list2 = basicUser.isAdmin() ? this.customWizardService.listSystemForRun() : this.customWizardService.listForRun(basicUser.getUser());
            return list2.stream().map(directWizard -> this.findOrNew(basicUser, QuickAccessType.WIZARD, (ConfigurationEntity)directWizard, list)).collect(Collectors.toList());
        });
    }

    private void mapPermissions(QuickAccessType quickAccessType, Permission ... permissionArray) {
        if (CollectionHelper.isEmpty((Object[])permissionArray)) {
            throw new IllegalStateException("Missing permissions for type " + String.valueOf(quickAccessType));
        }
        this.mapping.put(quickAccessType, (sessionData, list) -> {
            if (this.roleMatch(sessionData, quickAccessType) && sessionData.hasPermission(permissionArray)) {
                BasicUser basicUser = sessionData.getLoggedBasicUser();
                return Collections.singletonList(this.findOrNew(basicUser, quickAccessType, null, list));
            }
            return Collections.emptyList();
        });
    }

    private void mapRecords() {
        this.mapping.put(QuickAccessType.RECORD, (sessionData, list) -> {
            List list2 = sessionData.isAdmin() ? this.recordTypeService.listVisibleSystemTypes() : this.recordTypeService.listVisibleMyTypes();
            BasicUser basicUser = sessionData.getLoggedBasicUser();
            return list2.stream().map(recordType -> this.findOrNew(basicUser, QuickAccessType.RECORD, (ConfigurationEntity)recordType, list)).collect(Collectors.toList());
        });
    }

    private void mapTokens() {
        this.mapping.put(QuickAccessType.TOKEN, (sessionData, list) -> {
            BasicUser basicUser = sessionData.getLoggedBasicUser();
            return this.principalTypeService.listEnabledTokenTypes(basicUser).stream().map(tokenPrincipalType -> this.findOrNew(basicUser, QuickAccessType.TOKEN, (ConfigurationEntity)tokenPrincipalType, list)).collect(Collectors.toList());
        });
    }

    private boolean roleMatch(SessionData sessionData, QuickAccessType quickAccessType) {
        BasicUser basicUser = sessionData.getLoggedBasicUser();
        if (basicUser == null) {
            return false;
        }
        Role role = basicUser.getMainRole();
        if (quickAccessType.allows(role)) {
            return true;
        }
        return Arrays.asList(Role.BROKER, Role.OPERATOR).contains(role) && quickAccessType.allows(Role.MEMBER);
    }

    private <T> T runInUserSession(BasicUser basicUser, Function<SessionData, T> function) {
        SessionData sessionData = this.getSessionData();
        if (basicUser.equals((Object)sessionData.getLoggedBasicUser())) {
            return function.apply(sessionData);
        }
        return (T)this.invokerHandler.runAs(SessionDataFactory.user((BasicUser)basicUser), () -> function.apply(this.getSessionData()));
    }

    @FunctionalInterface
    private static interface QuickAccessResolver {
        public List<UserQuickAccess> resolve(SessionData var1, List<UserQuickAccess> var2);
    }
}

