/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import java.util.Set;
import java.util.TreeSet;
import org.cyclos.entities.system.Language;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.impl.BaseServiceImpl;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.users.UserRegionalSettingsServiceLocal;
import org.cyclos.impl.utils.ToStringComparator;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.system.languages.BuiltinLanguage;
import org.cyclos.model.users.users.RegionalSettingsDTO;
import org.cyclos.model.utils.LocaleVO;
import org.cyclos.model.utils.LocalesData;
import org.cyclos.server.utils.LocaleHelper;
import org.springframework.stereotype.Service;

@Service
public class UserRegionalSettingsServiceImpl
extends BaseServiceImpl
implements UserRegionalSettingsServiceLocal {
    public RegionalSettingsDTO get() throws FrameworkException {
        BasicUser basicUser = this.getLoggedBasicUser();
        if (basicUser == null) {
            throw new IllegalActionException();
        }
        RegionalSettingsDTO regionalSettingsDTO = new RegionalSettingsDTO();
        regionalSettingsDTO.setLocale(basicUser.getLocale());
        return regionalSettingsDTO == null ? new RegionalSettingsDTO() : regionalSettingsDTO;
    }

    public LocalesData getLocalesData() throws FrameworkException {
        ConfigurationAccessor configurationAccessor = this.getSessionData().getConfiguration();
        TreeSet treeSet = new TreeSet(ToStringComparator.instance());
        treeSet.add(LocaleHelper.mapLocale((BuiltinLanguage)configurationAccessor.getDefaultLanguage().getTemplate()));
        Set set = configurationAccessor.getAllowedLanguages();
        for (Language language : set) {
            treeSet.add(LocaleHelper.mapLocale((BuiltinLanguage)language.getTemplate()));
        }
        LocalesData localesData = new LocalesData();
        localesData.setDefaultLocale((LocaleVO)this.conversionHandler.convert(LocaleVO.class, (Object)configurationAccessor.getDefaultLanguage()));
        localesData.setCurrentLocale((LocaleVO)this.conversionHandler.convert(LocaleVO.class, (Object)configurationAccessor.getLanguage()));
        localesData.setAllowedLocales(this.conversionHandler.convertList(LocaleVO.class, treeSet));
        return localesData;
    }

    public void save(RegionalSettingsDTO regionalSettingsDTO) throws FrameworkException {
        BasicUser basicUser = this.getLoggedBasicUser();
        if (basicUser == null) {
            throw new IllegalActionException();
        }
        basicUser.setLocale(regionalSettingsDTO.getLocale());
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
    }
}

