/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import com.mysema.commons.lang.CloseableIterator;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections4.CollectionUtils;
import org.cyclos.entities.BaseEntity;
import org.cyclos.entities.NetworkedEntity;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.access.Agreement;
import org.cyclos.entities.access.BuiltInPrincipalType;
import org.cyclos.entities.access.Channel;
import org.cyclos.entities.access.CustomFieldPrincipalType;
import org.cyclos.entities.access.PasswordType;
import org.cyclos.entities.access.PrincipalType;
import org.cyclos.entities.access.UserAgent;
import org.cyclos.entities.banking.AccountType;
import org.cyclos.entities.banking.ExternalPayment;
import org.cyclos.entities.banking.PaymentTransferType;
import org.cyclos.entities.banking.PendingUserAccount;
import org.cyclos.entities.banking.UserAccount;
import org.cyclos.entities.banking.UserAccountType;
import org.cyclos.entities.messaging.MailContext;
import org.cyclos.entities.system.AccountNumberConfiguration;
import org.cyclos.entities.system.CaptchaConfiguration;
import org.cyclos.entities.system.ChannelConfiguration;
import org.cyclos.entities.system.EntityWithCustomValues;
import org.cyclos.entities.system.ExportFormat;
import org.cyclos.entities.users.AdminGroup;
import org.cyclos.entities.users.BasicGroup;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.Contact;
import org.cyclos.entities.users.Group;
import org.cyclos.entities.users.GroupSet;
import org.cyclos.entities.users.InviteToken;
import org.cyclos.entities.users.MobilePhone;
import org.cyclos.entities.users.Operator;
import org.cyclos.entities.users.Phone;
import org.cyclos.entities.users.QAdminProductNotification;
import org.cyclos.entities.users.QBasicUser;
import org.cyclos.entities.users.QPhone;
import org.cyclos.entities.users.QProductMyProfileField;
import org.cyclos.entities.users.QUser;
import org.cyclos.entities.users.QUserActivity;
import org.cyclos.entities.users.QUserImage;
import org.cyclos.entities.users.User;
import org.cyclos.entities.users.UserAddress;
import org.cyclos.entities.users.UserCustomField;
import org.cyclos.entities.users.UserCustomFieldValue;
import org.cyclos.entities.users.UserGroup;
import org.cyclos.entities.users.UserImage;
import org.cyclos.entities.utils.StoredFile;
import org.cyclos.impl.CRUDServiceImpl;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.access.AgreementLogServiceLocal;
import org.cyclos.impl.access.AgreementServiceLocal;
import org.cyclos.impl.access.ChannelServiceLocal;
import org.cyclos.impl.access.GuestSessionData;
import org.cyclos.impl.access.IdentityProviderServiceLocal;
import org.cyclos.impl.access.InternalIdentityProviderServiceLocal;
import org.cyclos.impl.access.LoginServiceLocal;
import org.cyclos.impl.access.PasswordServiceLocal;
import org.cyclos.impl.access.PrincipalTypeServiceLocal;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.access.TokenServiceLocal;
import org.cyclos.impl.access.UserChannelServiceLocal;
import org.cyclos.impl.banking.AccountServiceLocal;
import org.cyclos.impl.banking.AccountTypeServiceLocal;
import org.cyclos.impl.banking.ExternalPaymentServiceLocal;
import org.cyclos.impl.banking.TransferTypeServiceLocal;
import org.cyclos.impl.banking.VoucherConfigurationServiceLocal;
import org.cyclos.impl.contentmanagement.DocumentServiceLocal;
import org.cyclos.impl.marketplace.AdServiceLocal;
import org.cyclos.impl.marketplace.OrderServiceLocal;
import org.cyclos.impl.messaging.InviteServiceLocal;
import org.cyclos.impl.messaging.NotificationSettingsServiceLocal;
import org.cyclos.impl.search.UserSearchHandler;
import org.cyclos.impl.storage.StoredFileHandler;
import org.cyclos.impl.system.CaptchaServiceLocal;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.system.ConfigurationServiceLocal;
import org.cyclos.impl.system.CustomOperationServiceLocal;
import org.cyclos.impl.system.CustomWizardExecutionStorage;
import org.cyclos.impl.system.CustomWizardServiceLocal;
import org.cyclos.impl.system.EntityLogServiceLocal;
import org.cyclos.impl.system.ExportFormatServiceLocal;
import org.cyclos.impl.system.ExtensionPointAccessor;
import org.cyclos.impl.system.ExtensionPointFilter;
import org.cyclos.impl.system.ExtensionPointServiceLocal;
import org.cyclos.impl.system.ImportServiceLocal;
import org.cyclos.impl.system.LicenseHandler;
import org.cyclos.impl.users.AdminProductAccessor;
import org.cyclos.impl.users.BasicUserServiceLocal;
import org.cyclos.impl.users.BrokeringServiceLocal;
import org.cyclos.impl.users.ConnectedUserServiceLocal;
import org.cyclos.impl.users.ContactInfoServiceLocal;
import org.cyclos.impl.users.ContactServiceLocal;
import org.cyclos.impl.users.GeneralReferenceServiceLocal;
import org.cyclos.impl.users.LocateUserResult;
import org.cyclos.impl.users.MemberProductAccessor;
import org.cyclos.impl.users.OperatorServiceLocal;
import org.cyclos.impl.users.PhoneServiceLocal;
import org.cyclos.impl.users.ProductAccessor;
import org.cyclos.impl.users.ProductServiceLocal;
import org.cyclos.impl.users.ProductsAccessor;
import org.cyclos.impl.users.ProfileFieldSearchContext;
import org.cyclos.impl.users.RecordServiceLocal;
import org.cyclos.impl.users.RegisterUserBySmsParams;
import org.cyclos.impl.users.RegisterUserBySmsResult;
import org.cyclos.impl.users.RegisterUserByWizardResult;
import org.cyclos.impl.users.TransactionFeedbackServiceLocal;
import org.cyclos.impl.users.UserAddressServiceLocal;
import org.cyclos.impl.users.UserGroupServiceLocal;
import org.cyclos.impl.users.UserImageServiceLocal;
import org.cyclos.impl.users.UserServiceLocal;
import org.cyclos.impl.users.UserStatusServiceLocal;
import org.cyclos.impl.users.UserValidationFields;
import org.cyclos.impl.utils.BooleanPropertiesHolder;
import org.cyclos.impl.utils.PhoneNumberDescriptor;
import org.cyclos.impl.utils.QueryHelper;
import org.cyclos.impl.utils.notifications.MailContentProducer;
import org.cyclos.impl.utils.notifications.MailHandler;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.impl.utils.validation.Property;
import org.cyclos.impl.utils.validation.ValidationError;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.model.CRUDOperation;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IEntity;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.NamedEntityVO;
import org.cyclos.model.QueryParameters;
import org.cyclos.model.QueryParseException;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.AccessKeys;
import org.cyclos.model.access.CaptchaInputDTO;
import org.cyclos.model.access.PasswordException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.RequestData;
import org.cyclos.model.access.Role;
import org.cyclos.model.access.SecurityQuestion;
import org.cyclos.model.access.agreements.AgreementVO;
import org.cyclos.model.access.channels.ChannelVO;
import org.cyclos.model.access.devices.CreateDeviceConfirmationParams;
import org.cyclos.model.access.identityproviders.IdentityProviderVO;
import org.cyclos.model.access.passwords.SetSecurityQuestionDTO;
import org.cyclos.model.access.passwords.SetSecurityQuestionData;
import org.cyclos.model.access.passwordtypes.PasswordMode;
import org.cyclos.model.access.passwordtypes.PasswordTypeVO;
import org.cyclos.model.access.principaltypes.ExistingBuiltInPrincipalType;
import org.cyclos.model.access.principaltypes.PrincipalTypeNature;
import org.cyclos.model.access.principaltypes.PrincipalTypeVO;
import org.cyclos.model.access.principaltypes.TokenPermissionsVO;
import org.cyclos.model.access.tokens.NFCTagWithChallengeDTO;
import org.cyclos.model.banking.BankingKeys;
import org.cyclos.model.banking.accounts.AccountOwner;
import org.cyclos.model.banking.accounts.AccountWithCurrencyVO;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.banking.accounts.UserRegistrationAccountConfigurationDTO;
import org.cyclos.model.banking.accounttypes.AccountTypeNature;
import org.cyclos.model.banking.transfertypes.TransferTypeDirection;
import org.cyclos.model.banking.transfertypes.TransferTypeQuery;
import org.cyclos.model.banking.transfertypes.TransferTypeVO;
import org.cyclos.model.banking.voucherconfigurations.VoucherConfigurationVO;
import org.cyclos.model.contentmanagement.ContentManagementKeys;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.marketplace.advertisements.AdType;
import org.cyclos.model.messaging.messagecategories.MessageCategoryVO;
import org.cyclos.model.messaging.notifications.AdminNotificationType;
import org.cyclos.model.messaging.notifications.INotificationType;
import org.cyclos.model.messaging.notificationsettings.AdminNotificationSettingsDTO;
import org.cyclos.model.messaging.notificationsettings.AdminNotificationSettingsData;
import org.cyclos.model.messaging.notificationsettings.NotificationSettingsDTO;
import org.cyclos.model.messaging.notificationsettings.NotificationTypeSettingsDTO;
import org.cyclos.model.system.configurations.ActiveConfigurationData;
import org.cyclos.model.system.configurations.ConfigurationVO;
import org.cyclos.model.system.configurations.ForgotPasswordMode;
import org.cyclos.model.system.configurations.ResultType;
import org.cyclos.model.system.entitylogs.EntityActionLog;
import org.cyclos.model.system.exportformats.ExportFormatContext;
import org.cyclos.model.system.exportformats.ExportFormatVO;
import org.cyclos.model.system.extensionpoints.ExtensionPointEvent;
import org.cyclos.model.system.extensionpoints.UserExtensionPointEvent;
import org.cyclos.model.system.fields.CustomFieldDetailedVO;
import org.cyclos.model.system.fields.CustomFieldType;
import org.cyclos.model.system.fields.CustomFieldVO;
import org.cyclos.model.system.fields.ICustomField;
import org.cyclos.model.system.fields.ICustomFieldValue;
import org.cyclos.model.system.fields.ModelWithCustomValues;
import org.cyclos.model.system.images.ImageVO;
import org.cyclos.model.system.operations.RunnableCustomOperationVO;
import org.cyclos.model.system.scripts.LoadValuesScriptFunction;
import org.cyclos.model.system.wizards.CustomWizardVO;
import org.cyclos.model.users.UsersKeys;
import org.cyclos.model.users.addresses.UserAddressDTO;
import org.cyclos.model.users.addresses.UserAddressData;
import org.cyclos.model.users.addresses.UserAddressDataParams;
import org.cyclos.model.users.addresses.UserAddressResult;
import org.cyclos.model.users.addresses.UserAddressVO;
import org.cyclos.model.users.brokering.BrokeringVO;
import org.cyclos.model.users.contactinfos.ContactInfoDTO;
import org.cyclos.model.users.contacts.ContactData;
import org.cyclos.model.users.fields.UserCustomFieldValueDTO;
import org.cyclos.model.users.groups.BasicGroupNature;
import org.cyclos.model.users.groups.GroupSetVO;
import org.cyclos.model.users.groups.GroupVO;
import org.cyclos.model.users.groups.InitialGroupVO;
import org.cyclos.model.users.groups.UserGroupVO;
import org.cyclos.model.users.phones.LandLinePhoneDTO;
import org.cyclos.model.users.phones.MobilePhoneDTO;
import org.cyclos.model.users.phones.MobilePhoneData;
import org.cyclos.model.users.phones.PhoneDTO;
import org.cyclos.model.users.phones.PhoneNature;
import org.cyclos.model.users.products.BrokerVisibility;
import org.cyclos.model.users.products.ProductLevel;
import org.cyclos.model.users.products.ProductLevelData;
import org.cyclos.model.users.products.ProductVO;
import org.cyclos.model.users.products.ProductWithUserAccountVO;
import org.cyclos.model.users.products.UserBasicFieldActions;
import org.cyclos.model.users.products.UserCustomFieldActions;
import org.cyclos.model.users.products.UserProfileActivity;
import org.cyclos.model.users.products.UserProfileFieldActions;
import org.cyclos.model.users.references.ReferencePeriodStatisticsVO;
import org.cyclos.model.users.references.ReferenceStatisticsParams;
import org.cyclos.model.users.references.ReferenceType;
import org.cyclos.model.users.users.AbstractRegistrationData;
import org.cyclos.model.users.users.AbstractSimpleRegistrationData;
import org.cyclos.model.users.users.AbstractSimpleUserRegistrationDTO;
import org.cyclos.model.users.users.AbstractUserRegistrationDTO;
import org.cyclos.model.users.users.AbstractUserSearchData;
import org.cyclos.model.users.users.AbstractViewProfileData;
import org.cyclos.model.users.users.ActivitiesData;
import org.cyclos.model.users.users.BasicProfileField;
import org.cyclos.model.users.users.BasicUserDTO;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.DataWithBasicProfileFields;
import org.cyclos.model.users.users.EditProfileConfirmationField;
import org.cyclos.model.users.users.EditProfileData;
import org.cyclos.model.users.users.EmailValidation;
import org.cyclos.model.users.users.GroupVisibility;
import org.cyclos.model.users.users.PasswordRegistrationDTO;
import org.cyclos.model.users.users.ProfileActionsData;
import org.cyclos.model.users.users.ProfileField;
import org.cyclos.model.users.users.ProfileFieldAction;
import org.cyclos.model.users.users.ProfileTransactionActionsData;
import org.cyclos.model.users.users.PublicRegistrationDTO;
import org.cyclos.model.users.users.PublicRegistrationData;
import org.cyclos.model.users.users.SecurityAnswerStatus;
import org.cyclos.model.users.users.SimpleBasicUserRegistrationDTO;
import org.cyclos.model.users.users.SimpleBasicUserRegistrationData;
import org.cyclos.model.users.users.UserActivitiesData;
import org.cyclos.model.users.users.UserDTO;
import org.cyclos.model.users.users.UserData;
import org.cyclos.model.users.users.UserDataParams;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserMapDirectoryData;
import org.cyclos.model.users.users.UserOrderBy;
import org.cyclos.model.users.users.UserQuery;
import org.cyclos.model.users.users.UserRegistration;
import org.cyclos.model.users.users.UserRegistrationByMemberDTO;
import org.cyclos.model.users.users.UserRegistrationByMemberData;
import org.cyclos.model.users.users.UserRegistrationDTO;
import org.cyclos.model.users.users.UserRegistrationData;
import org.cyclos.model.users.users.UserRegistrationResult;
import org.cyclos.model.users.users.UserSearchContext;
import org.cyclos.model.users.users.UserSearchData;
import org.cyclos.model.users.users.UserStatus;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.users.users.UserWithFieldsVO;
import org.cyclos.model.users.users.UserWithRolesVO;
import org.cyclos.model.users.users.ValidateRegistrationFieldParams;
import org.cyclos.model.users.users.ViewProfileData;
import org.cyclos.model.utils.DatePeriodDTO;
import org.cyclos.model.utils.DistanceDTO;
import org.cyclos.model.utils.FieldSelector;
import org.cyclos.model.utils.FileInfo;
import org.cyclos.model.utils.LatLongDTO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.security.messaging.MessageServiceSecurity;
import org.cyclos.security.users.ProductsUserServiceSecurity;
import org.cyclos.security.users.UserServiceSecurity;
import org.cyclos.server.utils.ClassHelper;
import org.cyclos.server.utils.DataIterator;
import org.cyclos.server.utils.DateHelper;
import org.cyclos.server.utils.SortHelper;
import org.cyclos.server.utils.UserAgentHandler;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.CustomFieldHelper;
import org.cyclos.utils.HasMessageKey;
import org.cyclos.utils.MaskHelper;
import org.cyclos.utils.Page;
import org.cyclos.utils.Pair;
import org.cyclos.utils.StringHelper;
import org.cyclos.utils.ValidationResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserServiceImpl
extends CRUDServiceImpl<User, QUser, UserDTO, UserData, UserDataParams>
implements UserServiceLocal {
    private static final String CONTACT = "contact";
    private static final String BROKERS = "brokers";
    private static final String PERMISSIONS = "permissions";
    private static final Object[] EXCLUDED_PROPERTIES_TO_ENTITY = new Object[]{AbstractSimpleUserRegistrationDTO.ADDRESSES, AbstractSimpleUserRegistrationDTO.LAND_LINE_PHONES, AbstractSimpleUserRegistrationDTO.MOBILE_PHONES, AbstractUserRegistrationDTO.PASSWORDS, AbstractUserRegistrationDTO.CONTACT_INFOS};
    @Autowired
    private BasicUserServiceLocal basicUserService;
    @Autowired
    private RawEntityManagerHandler rawEntityManagerHandler;
    @Autowired
    private MessageServiceSecurity messageServiceSecurity;
    @Autowired
    private AgreementLogServiceLocal agreementLogService;
    @Autowired
    private PrincipalTypeServiceLocal principalTypeService;
    @Autowired
    private UserAddressServiceLocal addressService;
    @Autowired
    private CustomOperationServiceLocal customOperationService;
    @Autowired
    private CustomWizardServiceLocal customWizardService;
    @Autowired
    private PhoneServiceLocal phoneService;
    @Autowired
    private ContactInfoServiceLocal contactInfoService;
    @Autowired
    private ContactServiceLocal contactService;
    @Autowired
    private BrokeringServiceLocal brokeringService;
    @Autowired
    private AccountServiceLocal accountService;
    @Autowired
    private ProductServiceLocal productService;
    @Autowired
    private DocumentServiceLocal documentService;
    @Autowired
    private RecordServiceLocal recordService;
    @Autowired
    private GeneralReferenceServiceLocal generalReferenceService;
    @Autowired
    private TransactionFeedbackServiceLocal transactionFeedbackService;
    @Autowired
    private AdServiceLocal adService;
    @Autowired
    private UserImageServiceLocal userImageService;
    @Autowired
    private ExternalPaymentServiceLocal externalPaymentService;
    @Autowired
    private UserGroupServiceLocal userGroupService;
    @Autowired
    private OrderServiceLocal orderService;
    @Autowired
    private ConnectedUserServiceLocal connectedUserService;
    @Autowired
    private UserSearchHandler userSearchHandler;
    @Autowired
    private UserAgentHandler userAgentHandler;
    @Autowired
    private ConfigurationServiceLocal configurationService;
    @Autowired
    private TransferTypeServiceLocal transferTypeService;
    @Autowired
    private CaptchaServiceLocal captchaService;
    @Autowired
    private UserStatusServiceLocal userStatusService;
    @Autowired
    private TokenServiceLocal tokenService;
    @Autowired
    private UserChannelServiceLocal userChannelService;
    @Autowired
    private ChannelServiceLocal channelService;
    @Autowired
    private LicenseHandler licenseHandler;
    @Autowired
    private ExtensionPointServiceLocal extensionPointService;
    @Autowired
    private ProductsUserServiceSecurity productsUserServiceSecurity;
    @Autowired
    private PasswordServiceLocal passwordService;
    @Autowired
    private LoginServiceLocal loginService;
    @Autowired
    private OperatorServiceLocal operatorService;
    @Autowired
    private MailHandler mailHandler;
    @Autowired
    private ExportFormatServiceLocal exportFormatService;
    @Autowired
    private NotificationSettingsServiceLocal notificationSettingsService;
    @Autowired
    private InvokerHandler invokerHandler;
    @Autowired
    private IdentityProviderServiceLocal identityProviderService;
    @Autowired
    private InternalIdentityProviderServiceLocal internalIdentityProviderService;
    @Autowired
    private InviteServiceLocal inviteService;
    @Autowired
    private AgreementServiceLocal agreementService;
    @Autowired
    private VoucherConfigurationServiceLocal voucherConfigurationService;
    @Autowired
    private ImportServiceLocal importService;
    @Autowired
    private StoredFileHandler storedFileHandler;
    @Autowired
    private AccountTypeServiceLocal accountTypeService;
    @Autowired
    private UserServiceSecurity userServiceSecurity;
    @Autowired
    private EntityLogServiceLocal entityLogService;

    public UserServiceImpl() {
        super(User.class, QUser.user, UserDTO.class);
    }

    public void activateUserIfNeeded(User user) {
        this.activateUserIfNeeded(user, true);
    }

    public int countTotalUsers() {
        return ((DBQuery)this.rawEntityManagerHandler.from(new EntityPath[]{this.$}).where(new Predicate[]{((QUser)this.$).group().nature.in((Object[])new BasicGroupNature[]{BasicGroupNature.MEMBER_GROUP, BasicGroupNature.BROKER_GROUP}), ((QUser)this.$).status.notIn((Object[])new UserStatus[]{UserStatus.REMOVED, UserStatus.PURGED})})).count(((QUser)this.$).id);
    }

    public int countUsersInGroups(Collection<? extends Group> collection, UserStatus ... userStatusArray) {
        return ((DBQuery)this.from(this.$).where(new Predicate[]{((QUser)this.$).group().in(collection), CollectionHelper.isNotEmpty((Object[])userStatusArray) ? ((QUser)this.$).status.in((Object[])userStatusArray) : ((QUser)this.$).status.in((Object[])new UserStatus[]{UserStatus.ACTIVE, UserStatus.BLOCKED, UserStatus.DISABLED})})).count(((QUser)this.$).id);
    }

    public boolean existsUserWithEmail(String string) {
        if (StringHelper.isBlank((Object)string)) {
            return false;
        }
        return ((DBQuery)this.from(this.$).where(new Predicate[]{((QUser)this.$).email.eq((Object)string), ((QUser)this.$).status.notIn((Object[])new UserStatus[]{UserStatus.REMOVED, UserStatus.PURGED})})).hasResults();
    }

    public boolean existsUserWithMobilePhone(PhoneNumberDescriptor phoneNumberDescriptor) {
        if (phoneNumberDescriptor == null) {
            return false;
        }
        QPhone qPhone = QPhone.phone;
        return ((DBQuery)((DBQuery)((DBQuery)this.from(this.$).leftJoin((EntityPath)qPhone)).on((Predicate)((QUser)this.$).eq((Expression)qPhone.user()))).where((Predicate)((QUser)this.$).phones.contains((Expression)qPhone).and((Predicate)qPhone.normalizedNumber.eq((Object)phoneNumberDescriptor.toE164())))).hasResults();
    }

    public FileInfo exportUsers(@NotNull ExportFormatVO exportFormatVO, @NotNull UserQuery userQuery) throws FrameworkException {
        DataIterator dataIterator = this.userSearchHandler.exportEntities((QueryParameters)userQuery);
        ExportFormat exportFormat = (ExportFormat)this.conversionHandler.convert(ExportFormat.class, (Object)exportFormatVO);
        return this.exportFormatService.exportMultiple(exportFormat, ExportFormatContext.USERS_SEARCH, (QueryParameters)userQuery, dataIterator);
    }

    public void fetchCollections(User user) {
        user.getCustomValues().size();
        if (CollectionHelper.isNotEmpty((Iterable)user.getCustomValues())) {
            for (UserCustomFieldValue userCustomFieldValue : user.getCustomValues()) {
                userCustomFieldValue.getEnumeratedValues().size();
                userCustomFieldValue.getFileValues().size();
                userCustomFieldValue.getImageValues().size();
            }
        }
    }

    public void fill(AbstractUserSearchData abstractUserSearchData, boolean bl) throws FrameworkException {
        this.doFill(abstractUserSearchData, bl, ProfileFieldSearchContext.USER_FILTER);
    }

    public ActiveConfigurationData getActiveConfiguration(UserLocatorVO userLocatorVO) throws EntityNotFoundException {
        User user = this.userLocatorHandler.locate(userLocatorVO).getUser();
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor((BasicUser)user);
        return this.configurationService.toActiveConfiguration(ActiveConfigurationData.class, configurationAccessor);
    }

    public UserWithRolesVO getCurrentUser() throws FrameworkException {
        return (UserWithRolesVO)this.conversionHandler.convert(UserWithRolesVO.class, (Object)this.getLoggedBasicUser());
    }

    public Object[] getExcludedPropertiesToEntity() {
        return EXCLUDED_PROPERTIES_TO_ENTITY;
    }

    public ProfileTransactionActionsData getProfileTransactionActionsData(User user) {
        MemberProductAccessor memberProductAccessor;
        SessionData sessionData = this.getSessionData();
        ProductsAccessor productsAccessor = sessionData.getProducts();
        BasicUser basicUser = sessionData.getLoggedBasicUser();
        boolean bl = user.equals((Object)sessionData.getLoggedUser());
        boolean bl2 = sessionData.isManagerOf((BasicUser)user);
        ProfileTransactionActionsData profileTransactionActionsData = new ProfileTransactionActionsData();
        if (sessionData.isSystem()) {
            profileTransactionActionsData.properties().forEach(property -> {
                if (Boolean.class.equals((Object)property.getType()) || Boolean.TYPE.equals(property.getType())) {
                    profileTransactionActionsData.set(property, (Object)true);
                }
            });
        } else if (bl) {
            memberProductAccessor = productsAccessor.member();
            profileTransactionActionsData.setPaymentSelfToUser(sessionData.hasPermission(Permission.MY_PAYMENTS_PAY_TO_USER) && this.hasTransferTypes(user, AccountTypeNature.USER, TransferTypeDirection.USER_TO_USER, memberProductAccessor.getUserPayments()));
            profileTransactionActionsData.setPaymentSelfToSystem(sessionData.hasPermission(Permission.MY_PAYMENTS_PAY_TO_SYSTEM) && this.hasTransferTypes(user, AccountTypeNature.SYSTEM, TransferTypeDirection.USER_TO_SYSTEM, memberProductAccessor.getSystemPayments()));
            profileTransactionActionsData.setPaymentSelfToSelf(sessionData.hasPermission(Permission.MY_PAYMENTS_PAY_TO_SELF) && this.hasTransferTypes(user, user, TransferTypeDirection.USER_TO_SELF, memberProductAccessor.getSelfPayments()));
            profileTransactionActionsData.setViewTickets(sessionData.hasPermission(Permission.MY_PAYMENT_TICKETS_VIEW));
            profileTransactionActionsData.setRequestPaymentSelfToUser(sessionData.hasPermission(Permission.MY_PAYMENT_REQUESTS_SEND_TO_USER) && this.hasTransferTypes(AccountTypeNature.USER, user, TransferTypeDirection.USER_TO_USER, memberProductAccessor.getMyPaymentRequestsSendToUser()));
            profileTransactionActionsData.setRequestPaymentSelfToSystem(sessionData.hasPermission(Permission.MY_PAYMENT_REQUESTS_SEND_TO_SYSTEM) && this.hasTransferTypes(AccountTypeNature.SYSTEM, user, TransferTypeDirection.SYSTEM_TO_USER, memberProductAccessor.getMyPaymentRequestsSendToSystem()));
            profileTransactionActionsData.setViewPaymentRequests(sessionData.hasPermission(Permission.MY_PAYMENT_REQUESTS_VIEW));
            profileTransactionActionsData.setExternalPaymentAsSelf(sessionData.hasPermission(Permission.MY_EXTERNAL_PAYMENTS_PAY_TO_USER) && this.hasTransferTypes(user, AccountTypeNature.USER, TransferTypeDirection.USER_TO_USER, memberProductAccessor.getMyExternalPaymentTypes()));
            profileTransactionActionsData.setViewExternalPayments(sessionData.hasPermission(Permission.MY_EXTERNAL_PAYMENTS_VIEW));
        } else if (bl2) {
            memberProductAccessor = productsAccessor.userManagement();
            AdminProductAccessor adminProductAccessor = productsAccessor.admin();
            boolean bl3 = this.accountTypeService.hasAccessible((InternalAccountOwner)user);
            profileTransactionActionsData.setPaymentSystemToUser(sessionData.hasPermission(Permission.SYSTEM_PAYMENTS_PAY_TO_USER) && this.hasTransferTypes(AccountTypeNature.SYSTEM, user, TransferTypeDirection.SYSTEM_TO_USER, adminProductAccessor.getSystemToUserPayments()));
            profileTransactionActionsData.setPaymentAsUserToUser(sessionData.hasPermission(Permission.USER_PAYMENTS_PAY_TO_USER) && this.hasTransferTypes(user, AccountTypeNature.USER, TransferTypeDirection.USER_TO_USER, memberProductAccessor.getUserPaymentsAsUser()));
            profileTransactionActionsData.setPaymentAsUserToSystem(sessionData.hasPermission(Permission.USER_PAYMENTS_PAY_TO_SYSTEM) && this.hasTransferTypes(user, AccountTypeNature.SYSTEM, TransferTypeDirection.USER_TO_SYSTEM, memberProductAccessor.getSystemPaymentsAsUser()));
            profileTransactionActionsData.setPaymentAsUserToSelf(sessionData.hasPermission(Permission.USER_PAYMENTS_PAY_TO_SELF) && this.hasTransferTypes(user, user, TransferTypeDirection.USER_TO_SELF, memberProductAccessor.getSelfPaymentsAsUser()));
            profileTransactionActionsData.setRequestPaymentSystemToUser(sessionData.hasPermission(Permission.SYSTEM_PAYMENT_REQUESTS_SEND_TO_USER) && this.hasTransferTypes(user, AccountTypeNature.SYSTEM, TransferTypeDirection.USER_TO_SYSTEM, adminProductAccessor.getSystemPaymentRequestsSendToUser()));
            profileTransactionActionsData.setRequestPaymentAsUserToUser(sessionData.hasPermission(Permission.USER_PAYMENT_REQUESTS_SEND_TO_USER) && this.hasTransferTypes(AccountTypeNature.USER, user, TransferTypeDirection.USER_TO_USER, memberProductAccessor.getUserPaymentRequestsSendToUser()));
            profileTransactionActionsData.setRequestPaymentAsUserToSystem(sessionData.hasPermission(Permission.USER_PAYMENT_REQUESTS_SEND_TO_SYSTEM) && this.hasTransferTypes(AccountTypeNature.SYSTEM, user, TransferTypeDirection.SYSTEM_TO_USER, memberProductAccessor.getUserPaymentRequestsSendToSystem()));
            profileTransactionActionsData.setViewPaymentRequests(bl3 && sessionData.hasPermission(Permission.USER_PAYMENT_REQUESTS_VIEW));
            profileTransactionActionsData.setViewTickets(bl3 && sessionData.hasPermission(Permission.USER_PAYMENT_TICKETS_VIEW));
            profileTransactionActionsData.setExternalPaymentAsUser(sessionData.hasPermission(Permission.USER_EXTERNAL_PAYMENTS_PAY_TO_USER) && this.hasTransferTypes(user, AccountTypeNature.USER, TransferTypeDirection.USER_TO_USER, memberProductAccessor.getExternalPaymentsAsUser()));
            profileTransactionActionsData.setViewExternalPayments(bl3 && sessionData.hasPermission(Permission.USER_EXTERNAL_PAYMENTS_VIEW));
            profileTransactionActionsData.setViewScheduledPayments(bl3 && sessionData.hasPermission(Permission.USER_SCHEDULED_PAYMENTS_VIEW));
            profileTransactionActionsData.setViewPendingTransactions(bl3 && (sessionData.hasPermission(Permission.BROKER_AUTHORIZED_PAYMENTS_VIEW) || sessionData.hasPermission(Permission.ADMIN_AUTHORIZATIONS_VIEW)));
        }
        if (basicUser != null && basicUser.isMember()) {
            memberProductAccessor = productsAccessor.member();
            boolean bl4 = true;
            if (basicUser.isRestrictedOperator()) {
                Operator operator = (Operator)basicUser;
                Set set = operator.getGroup().getRestrictPaymentsToUsers();
                bl4 = CollectionHelper.isEmpty((Iterable)set) || set.contains(user);
            }
            profileTransactionActionsData.setPaymentUserToUser(bl4 && sessionData.hasPermission(Permission.MY_PAYMENTS_PAY_TO_USER) && this.hasTransferTypes(basicUser, user, TransferTypeDirection.USER_TO_USER, memberProductAccessor.getUserPayments()));
            profileTransactionActionsData.setRequestPaymentUserToUser(sessionData.hasPermission(Permission.MY_PAYMENT_REQUESTS_SEND_TO_USER) && this.hasTransferTypes(basicUser, user, TransferTypeDirection.USER_TO_USER, memberProductAccessor.getMyPaymentRequestsSendToUser()));
        }
        return profileTransactionActionsData;
    }

    public PublicRegistrationData getPublicRegistrationData(InitialGroupVO initialGroupVO, String string, String string2) throws FrameworkException {
        UserDataParams userDataParams = new UserDataParams();
        GroupVO groupVO = new GroupVO();
        groupVO.setId(initialGroupVO.getId());
        groupVO.setInternalName(initialGroupVO.getInternalName());
        userDataParams.setGroup(groupVO);
        userDataParams.setInviteToken(string);
        userDataParams.setExternalPaymentToken(string2);
        SessionData sessionData = this.getSessionData();
        SessionData sessionData2 = SessionDataFactory.guest((RequestData)sessionData.getRequestData(), (String)sessionData.getChannelName());
        return (PublicRegistrationData)this.invokerHandler.runAs(sessionData2, () -> (PublicRegistrationData)this.getDataForNew(userDataParams));
    }

    public List<InitialGroupVO> getPublicRegistrationGroups() throws FrameworkException {
        return this.groupsHandler.getPossiblePublicInitialGroups();
    }

    public UserSearchData getSearchData(UserSearchContext userSearchContext, UserLocatorVO userLocatorVO) throws FrameworkException {
        Object object;
        Object object2;
        GroupVisibility groupVisibility;
        Set set;
        if (userSearchContext == null) {
            userSearchContext = UserSearchContext.REGULAR;
        }
        SessionData sessionData = this.getSessionData();
        boolean bl = sessionData.isBroker();
        boolean bl2 = userSearchContext == UserSearchContext.MAP_DIRECTORY;
        boolean bl3 = userSearchContext == UserSearchContext.BROKERED || userSearchContext == UserSearchContext.BULK_ACTION && bl;
        boolean bl4 = userSearchContext == UserSearchContext.CONTACTS;
        UserMapDirectoryData userMapDirectoryData = bl2 ? new UserMapDirectoryData() : new UserSearchData();
        ProfileFieldSearchContext profileFieldSearchContext = userSearchContext == UserSearchContext.MAP_DIRECTORY ? ProfileFieldSearchContext.MAP_DIRECTORY_FILTER : ProfileFieldSearchContext.USER_FILTER;
        this.doFill((AbstractUserSearchData)userMapDirectoryData, bl3, profileFieldSearchContext);
        User user = null;
        if (bl3) {
            user = this.userLocatorHandler.toUserOrCurrent((BasicUserVO)userLocatorVO);
            if (bl3 && (user == null || !user.isBroker())) {
                throw new IllegalActionException("Invalid broker: " + String.valueOf(user));
            }
            userMapDirectoryData.setBroker((UserVO)this.conversionHandler.convert(UserVO.class, (Object)user));
        }
        ConfigurationAccessor configurationAccessor = sessionData.getConfiguration();
        if ((userSearchContext == UserSearchContext.REGULAR || userSearchContext == UserSearchContext.MENU) && sessionData.isAdmin() || bl3) {
            set = this.groupsHandler.getPossibleRegistrationGroups(false, false);
            groupVisibility = this.groupsHandler.getGroupVisibility(bl3);
            if (groupVisibility != GroupVisibility.NONE) {
                object2 = new HashSet();
                for (Group group : set) {
                    GroupSet groupSet;
                    object2.add(group);
                    if (!(group instanceof UserGroup) || (groupSet = ((UserGroup)group).getGroupSet()) == null) continue;
                    object2.add(groupSet);
                }
            } else {
                object2 = new HashSet(set);
            }
            if (user != null && sessionData.isAdmin()) {
                if (sessionData.hasPermission(Permission.USER_BROKER_MANAGE)) {
                    object2.removeIf(AdminGroup.class::isInstance);
                } else {
                    object2 = Collections.emptySet();
                }
            }
            userMapDirectoryData.setInitialGroups(this.groupsHandler.viewFactory((Collection)object2).basic().sorted());
            if (groupVisibility == GroupVisibility.NONE) {
                userMapDirectoryData.getInitialGroups().stream().filter(UserGroupVO.class::isInstance).forEach(basicGroupVO -> ((UserGroupVO)basicGroupVO).setGroupSet(null));
            }
            userMapDirectoryData.setCanCreateNew(this.hasPermission(Permission.USERS_REGISTER) && CollectionHelper.isNotEmpty((Iterable)object2));
        }
        set = null;
        if (userSearchContext.allowFilterByGroup()) {
            object2 = this.groupsHandler.visibles();
            switch (userSearchContext) {
                case MAP_DIRECTORY: {
                    groupVisibility = object2.directory().basic();
                    break;
                }
                case MENU: {
                    groupVisibility = object2.menu().basic();
                    break;
                }
                default: {
                    groupVisibility = object2.users().basic();
                }
            }
            userMapDirectoryData.setGroups(groupVisibility.sorted());
            if (userSearchContext != UserSearchContext.BROKERED) {
                set = groupVisibility.defaultFilter();
            }
        }
        userMapDirectoryData.setStatuses(this.userStatusService.getStatusesForUserSearch(bl3));
        object2 = bl2 ? this.profileFieldHandler.getFieldsInMapResult(bl3) : this.profileFieldHandler.getFieldsInUserList(bl3);
        userMapDirectoryData.setProfileFieldsInList(this.profileFieldHandler.toVOs((Collection)object2));
        if (userMapDirectoryData instanceof UserMapDirectoryData) {
            groupVisibility = userMapDirectoryData;
            object = configurationAccessor.getMapDirectoryField();
            userMapDirectoryData.setResultType(ResultType.MAP);
            if (object != null) {
                Group group;
                groupVisibility.setMapDirectoryField((CustomFieldDetailedVO)this.conversionHandler.convert(CustomFieldDetailedVO.class, object));
                group = userMapDirectoryData.getSimpleProfileFields().stream().filter(arg_0 -> UserServiceImpl.lambda$getSearchData$3((UserCustomField)object, arg_0)).findFirst().orElse(null);
                if (group == null) {
                    group = userMapDirectoryData.getAdvancedProfileFields().stream().filter(arg_0 -> UserServiceImpl.lambda$getSearchData$4((UserCustomField)object, arg_0)).findFirst().orElse(null);
                    if (group != null) {
                        userMapDirectoryData.getAdvancedProfileFields().remove(group);
                    }
                } else {
                    userMapDirectoryData.getSimpleProfileFields().remove(group);
                }
                if (group == null) {
                    group = (ProfileField)this.conversionHandler.convert(CustomFieldDetailedVO.class, object);
                }
                userMapDirectoryData.getSimpleProfileFields().add(0, group);
            }
            groupVisibility.setDefaultMapLocation((LatLongDTO)this.conversionHandler.convert(LatLongDTO.class, (Object)configurationAccessor.getDefaultMapLocation()));
            groupVisibility.setDefaultMapZoomWeb(configurationAccessor.getDefaultMapZoomWeb());
            groupVisibility.setDefaultMapZoomMobile(configurationAccessor.getDefaultMapZoomMobile());
        } else {
            userMapDirectoryData.setResultType(configurationAccessor.getUsersResultType());
            if (sessionData.isAdmin() || bl3) {
                userMapDirectoryData.setExportFormats(this.conversionHandler.convertList(ExportFormatVO.class, (Iterable)this.exportFormatService.listByContext(ExportFormatContext.USERS_SEARCH)));
            }
        }
        groupVisibility = (UserQuery)QueryHelper.newQuery(UserQuery.class);
        if (bl2) {
            groupVisibility.setPageSize(Integer.valueOf(configurationAccessor.getMaxResultsOnMap()));
        }
        groupVisibility.setMapDirectory(bl2);
        groupVisibility.setFromMenu(userSearchContext == UserSearchContext.MENU);
        groupVisibility.setOnlyContacts(bl4);
        groupVisibility.setOrderBy(bl4 ? UserOrderBy.ALPHABETICALLY_ASC : configurationAccessor.getUsersSortOrder());
        object = new HashSet();
        userMapDirectoryData.getSimpleProfileFields().forEach(arg_0 -> UserServiceImpl.lambda$getSearchData$5((HashSet)object, arg_0));
        userMapDirectoryData.getAdvancedProfileFields().forEach(arg_0 -> UserServiceImpl.lambda$getSearchData$6((HashSet)object, arg_0));
        groupVisibility.setProfileFields(new HashSet(this.customFieldValueHandler.resolveDefaultSearchValues((Collection)object)));
        if (userSearchContext == UserSearchContext.PENDING) {
            groupVisibility.setUserStatus(EnumSet.of(UserStatus.PENDING));
        } else {
            groupVisibility.setUserStatus(EnumSet.of(UserStatus.ACTIVE, UserStatus.BLOCKED));
        }
        if (bl && bl3) {
            groupVisibility.setBrokers(CollectionHelper.asSet((Object[])new UserVO[]{(UserVO)this.conversionHandler.convert(UserVO.class, (Object)sessionData.getLoggedUser())}));
        }
        groupVisibility.setGroups(set);
        userMapDirectoryData.setQuery((QueryParameters)groupVisibility);
        return userMapDirectoryData;
    }

    public List<InitialGroupVO> getUserRegistrationGroups(boolean bl) {
        List list = this.groupsHandler.getPossibleRegistrationInitialGroups(bl);
        list.sort(Comparator.comparing(NamedEntityVO::getName));
        return list;
    }

    public ViewProfileData getViewProfileData(UserLocatorVO userLocatorVO) {
        UserActivitiesData userActivitiesData;
        Object object;
        Object object2;
        Contact contact;
        User user = this.userLocatorHandler.locate(userLocatorVO).getUser();
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor((BasicUser)user);
        ProductsAccessor productsAccessor = this.productsHandler.getAccessor((BasicUser)user);
        ProductAccessor productAccessor = productsAccessor.product();
        SessionData sessionData = this.getSessionData();
        FieldSelector fieldSelector = sessionData.getRequestData().getFields();
        boolean bl = sessionData.manages((BasicUser)user);
        boolean bl2 = sessionData.isBrokerOf((BasicUser)user);
        boolean bl3 = sessionData.isAdminOf((BasicUser)user);
        boolean bl4 = sessionData.isUserManager();
        boolean bl5 = this.profileFieldHandler.getVisibleProfileFields((BasicUser)user).size() > 0;
        boolean bl6 = sessionData.isSelf((BasicUser)user);
        ViewProfileData viewProfileData = new ViewProfileData();
        viewProfileData.setNameLabel(this.getNameLabelByConfiguration(configurationAccessor));
        viewProfileData.setDisplay(this.getFormatter().format((BasicUser)user));
        viewProfileData.setId(user.getId());
        viewProfileData.setAdmin(user.isAdmin());
        viewProfileData.setBroker(user.isBroker());
        if (fieldSelector.includes(ViewProfileData.ENABLED_PROFILE_FIELDS.getName())) {
            viewProfileData.setEnabledProfileFields(this.profileFieldHandler.toBasicVOs((Collection)this.profileFieldHandler.getEnabledProfileFields((BasicUser)user)));
        }
        if (sessionData.isLoggedIn() && fieldSelector.includes(ViewProfileData.RELATIONSHIP.getName())) {
            viewProfileData.setRelationship(this.authHandler.getRelationship(sessionData.getLoggedBasicUser(), (BasicUser)user));
        }
        if (fieldSelector.includes(CONTACT) && sessionData.hasPermission(Permission.MY_CONTACTS_ENABLE) && (contact = this.contactService.getByOwnerAndContact(sessionData.getLoggedUser(), user)) != null) {
            viewProfileData.setContactData((ContactData)this.contactService.getData(contact.getId()));
        }
        if (sessionData.isManagerOf((BasicUser)user)) {
            viewProfileData.setInvitedBy((BasicUserVO)this.conversionHandler.convert(BasicUserVO.class, (Object)user.getInvitedBy()));
        }
        if (this.canRemovePendingUser(user)) {
            viewProfileData.setCanPhysicallyRemove(true);
        }
        GroupSet groupSet = (contact = user.getGroup()) instanceof UserGroup ? ((UserGroup)contact).getGroupSet() : null;
        GroupVisibility groupVisibility = this.groupsHandler.getGroupVisibility(bl2);
        if (groupVisibility == GroupVisibility.GROUP) {
            viewProfileData.setGroup((GroupVO)this.conversionHandler.convert(GroupVO.class, (Object)contact));
        }
        if (groupVisibility != GroupVisibility.NONE) {
            viewProfileData.setGroupSet((GroupSetVO)this.conversionHandler.convert(GroupSetVO.class, (Object)groupSet));
        }
        if (bl4 && sessionData.hasPermission(new Permission[]{Permission.BLOCKED_USERS_MANAGE, Permission.DISABLED_USERS_VIEW, Permission.REMOVED_USERS_VIEW, Permission.PURGED_USERS_VIEW})) {
            viewProfileData.setStatus(user.getStatus());
        }
        this.basicUserService.fillProfileFields((BasicUser)user, (AbstractViewProfileData)viewProfileData);
        if (productsAccessor.member().getMaxContactInfos() > 0) {
            object2 = this.contactInfoService.getContactInfoListData(userLocatorVO, true);
            if (bl4 && !bl5) {
                object2.setContactInfos(null);
            }
            viewProfileData.setContactInfoListData(object2);
        }
        object2 = Collections.emptyList();
        if (sessionData.manages((BasicUser)user) && user.isMember() && sessionData.hasPermission(Permission.USER_ACCOUNTS_VIEW)) {
            object2 = this.accountService.listVisible((InternalAccountOwner)user);
        }
        if (fieldSelector.includes(PERMISSIONS)) {
            int n;
            viewProfileData.setActions(this.getProfileActionsData(viewProfileData, user, (List<UserAccount>)object2));
            if (this.productsUserServiceSecurity.canViewActiveProducts(user) && !user.isAdmin() && !sessionData.isRest() && (n = user.getProducts().size() + contact.getProducts().size() + (groupSet == null ? 0 : groupSet.getProducts().size())) <= 50) {
                ProductLevelData productLevelData = new ProductLevelData();
                List list = this.conversionHandler.convertList(ProductWithUserAccountVO.class, (Iterable)user.getProducts());
                productLevelData.setLevel(ProductLevel.INDIVIDUAL);
                productLevelData.setThisLevelsProducts(CollectionHelper.sort((Collection)list));
                object = this.conversionHandler.convertList(ProductWithUserAccountVO.class, (Iterable)contact.getProducts());
                object.removeAll(list);
                userActivitiesData = new ProductLevelData();
                userActivitiesData.setLevel(ProductLevel.GROUP);
                userActivitiesData.setThisLevelsProducts(CollectionHelper.sort((Collection)object));
                productLevelData.setLevelUp((ProductLevelData)userActivitiesData);
                if (groupSet != null) {
                    List list2 = this.conversionHandler.convertList(ProductWithUserAccountVO.class, (Iterable)groupSet.getProducts());
                    list2.removeAll((Collection<?>)object);
                    list2.removeAll(list);
                    ProductLevelData productLevelData2 = new ProductLevelData();
                    productLevelData2.setLevel(ProductLevel.GROUP_SET);
                    productLevelData2.setThisLevelsProducts(CollectionHelper.sort((Collection)list2));
                    userActivitiesData.setLevelUp(productLevelData2);
                }
                viewProfileData.setProducts(productLevelData);
            }
        }
        viewProfileData.setCanManage(bl);
        viewProfileData.setHasVisibleDocuments(this.documentService.hasDocuments(user));
        if (fieldSelector.includes(BROKERS)) {
            this.setBrokersData(user, productsAccessor, sessionData, bl, viewProfileData);
        }
        if (this.userServiceSecurity.canViewActiveConfiguration(user)) {
            List list = this.configurationService.getConfigurationTreePath(configurationAccessor.getConfiguration());
            viewProfileData.setConfigurationHierarchy(this.conversionHandler.convertList(ConfigurationVO.class, (Iterable)list));
        }
        if (bl && (bl6 || bl5)) {
            viewProfileData.setUserCreationDate(this.toDateTime(user.getCreationDate()));
            if (!user.isRemoved()) {
                viewProfileData.setPendingAgreements(this.conversionHandler.convertList(AgreementVO.class, (Iterable)this.agreementLogService.getUserPendingAgreements(user)));
                viewProfileData.setSecurityAnswerStatus(this.getSecurityAnswerStatus(user));
            }
        }
        if (!(this.isGuest() || user.isPendingValidation() || user.isPurged())) {
            boolean bl7;
            boolean bl8;
            List list = productsAccessor.member().getShowActivitiesInProfile();
            boolean bl9 = bl8 = bl && sessionData.hasPermission(Permission.CONNECTED_USERS_VIEW);
            boolean bl10 = bl ? bl6 || bl5 : (bl7 = list.contains(UserProfileActivity.ACTIVATION_DATE));
            if (user.isAdmin()) {
                object = new ActivitiesData();
            } else {
                boolean bl11;
                boolean bl12;
                boolean bl13;
                boolean bl14;
                userActivitiesData = new UserActivitiesData();
                object = userActivitiesData;
                boolean bl15 = false;
                boolean bl16 = false;
                if (bl6) {
                    bl14 = this.hasPermission(Permission.MY_REFERENCES_VIEW, Permission.MY_REFERENCES_RECEIVE);
                    bl13 = this.hasPermission(Permission.MY_TRANSACTION_FEEDBACKS_VIEW, Permission.MY_TRANSACTION_FEEDBACKS_RECEIVE);
                    bl12 = sessionData.hasPermission(Permission.MY_ADS_ENABLE);
                    bl11 = sessionData.hasPermission(Permission.MY_WEB_SHOP_ENABLE);
                } else if (bl) {
                    bl14 = sessionData.hasPermission(Permission.USER_REFERENCES_MANAGE) && productAccessor.hasPermission(Permission.MY_REFERENCES_RECEIVE);
                    bl13 = sessionData.hasPermission(Permission.USER_TRANSACTION_FEEDBACKS_MANAGE) && productAccessor.hasPermission(Permission.MY_TRANSACTION_FEEDBACKS_RECEIVE);
                    bl12 = sessionData.hasPermission(Permission.USER_ADS_VIEW) && productAccessor.hasPermission(Permission.MY_ADS_ENABLE);
                    bl11 = sessionData.hasPermission(Permission.USER_WEB_SHOP_VIEW) && productAccessor.hasPermission(Permission.MY_WEB_SHOP_ENABLE);
                } else {
                    bl14 = sessionData.hasPermission(Permission.MY_REFERENCES_VIEW) && productAccessor.hasPermission(Permission.MY_REFERENCES_RECEIVE) && list.contains(UserProfileActivity.REFERENCES);
                    bl13 = sessionData.hasPermission(Permission.MY_TRANSACTION_FEEDBACKS_VIEW) && productAccessor.hasPermission(Permission.MY_TRANSACTION_FEEDBACKS_RECEIVE) && list.contains(UserProfileActivity.PAYMENT_FEEDBACK);
                    bl12 = sessionData.hasPermission(Permission.USER_ADS_VIEW) && this.isMember() && productAccessor.hasPermission(Permission.MY_ADS_ENABLE) && list.contains(UserProfileActivity.ADVERTISEMENTS);
                    bl11 = sessionData.hasPermission(Permission.USER_WEB_SHOP_VIEW) && this.isMember() && productAccessor.hasPermission(Permission.MY_WEB_SHOP_ENABLE) && list.contains(UserProfileActivity.WEBSHOP_PRODUCTS);
                }
                viewProfileData.setAccountsData(this.accountService.getUserAccountsData(user));
                if (bl3) {
                    Set set = SimpleEntity.uniqueIds((Collection)object2);
                    viewProfileData.getAccountsData().removeIf(userAccountData -> !set.contains(userAccountData.getAccount().getId()));
                }
                if (bl14) {
                    userActivitiesData.setReferenceStatisticsVisible(true);
                    userActivitiesData.setReferenceStatistics(this.getGeneralReferenceStatisticsVO(user.getId()));
                    boolean bl17 = bl15 = userActivitiesData.getReferenceStatistics().getTotal() > 0;
                }
                if (bl13) {
                    userActivitiesData.setFeedbackStatisticsVisible(true);
                    userActivitiesData.setFeedbackStatistics(this.getTransactionFeedbackStatisticsVO(user.getId()));
                    boolean bl18 = bl16 = userActivitiesData.getFeedbackStatistics().getTotal() > 0;
                }
                if (bl12) {
                    userActivitiesData.setAdvertisementsVisible(true);
                    userActivitiesData.setAdvertisements(this.adService.getAdvertisementsCount(user, AdType.ADVERTISEMENT));
                }
                if (bl11) {
                    userActivitiesData.setWebshopProductsVisible(true);
                    userActivitiesData.setWebshopProducts(this.adService.getAdvertisementsCount(user, AdType.WEB_SHOP));
                }
                userActivitiesData.setHidden(!bl7 && !bl8 && !bl15 && !bl16 && !bl12 && !bl11);
            }
            if (bl7) {
                object.setUserActivationDateVisible(true);
                object.setUserActivationDate(this.toDateTime(user.getActivationDate()));
            }
            if (bl8) {
                object.setLastLoginVisible(true);
                object.setOnline(this.connectedUserService.isOnline((BasicUser)user));
                userActivitiesData = this.loginService.getFirstAndLastLogin((BasicUser)user);
                if (userActivitiesData != null) {
                    object.setFirstLogin(this.toDateTime(userActivitiesData.getMin()));
                    object.setLastLogin(this.toDateTime(userActivitiesData.getMax()));
                }
            }
            viewProfileData.setActivities((ActivitiesData)object);
        }
        return viewProfileData;
    }

    public User importUser(UserRegistrationDTO userRegistrationDTO) {
        return this.doRegister((AbstractSimpleUserRegistrationDTO)userRegistrationDTO, UserRegistration.IMPORT, null).endRegistration(RegistrationResultAccessor::user);
    }

    public boolean isBuiltinRegistrationEnabled() {
        ConfigurationAccessor configurationAccessor = this.getSessionData().getConfiguration();
        return configurationAccessor.getLargeScreenRegistrationWizard() == null || configurationAccessor.getMediumScreenRegistrationWizard() == null || configurationAccessor.getSmallScreenRegistrationWizard() == null;
    }

    public CloseableIterator<Long> iterateIds(UserQuery userQuery) throws QueryParseException {
        return this.userSearchHandler.iterateIds((QueryParameters)userQuery);
    }

    public UserVO locate(UserLocatorVO userLocatorVO) throws FrameworkException {
        User user = this.userLocatorHandler.locate(userLocatorVO).getUser();
        return (UserVO)this.conversionHandler.convert(UserVO.class, (Object)user);
    }

    @Override
    public User newEntity(UserDataParams userDataParams) {
        InviteToken inviteToken;
        User user;
        SessionData sessionData = this.getSessionData();
        Group group = (Group)this.conversionHandler.convert(Group.class, (Object)userDataParams.getGroup());
        User user2 = new User(group);
        User user3 = userDataParams.isAsMember() ? null : (user = sessionData.isBroker() ? sessionData.getLoggedUser() : (User)this.conversionHandler.convert(User.class, (Object)userDataParams.getBroker()));
        if (user != null) {
            user2.setBrokers(Collections.singleton(user));
        }
        user2.setRegistrationType(this.resolveUserRegistration(userDataParams.isAsMember()));
        this.fillExternalPaymentInfo(userDataParams, user2);
        if (sessionData.isGuest() && (inviteToken = this.inviteService.inviteToken(userDataParams.getInviteToken())) != null) {
            user2.setInviteToken(inviteToken.getToken());
            user2.setEmail(inviteToken.getEmail());
        }
        return user2;
    }

    public void onRegistrationValidation(User user) throws FrameworkException {
        InvocationContext.ensure().addBeforeEndListener(() -> this.agreementLogService.triggerActivatedExtensionPoints(user));
        this.activateUserIfNeeded(user, false);
        if (user.getRegistrationType() != UserRegistration.IMPORT) {
            this.notificationHandler.admin().userRegistration(user);
        }
    }

    public UserRegistrationResult publicRegister(PublicRegistrationDTO publicRegistrationDTO) throws FrameworkException {
        RegistrationResultAccessor registrationResultAccessor = this.doPublicRegister(publicRegistrationDTO, null);
        return this.basicUserService.buildRegistrationResult((BasicUser)registrationResultAccessor.user(), registrationResultAccessor.generatedPasswords().keySet());
    }

    public UserRegistrationResult register(UserRegistrationDTO userRegistrationDTO) throws PasswordException {
        UserRegistration userRegistration;
        if (this.isBroker()) {
            userRegistration = UserRegistration.BROKER;
        } else if (this.isAdmin()) {
            userRegistration = UserRegistration.ADMIN;
        } else if (this.isSystem()) {
            userRegistration = UserRegistration.POPULATOR;
        } else {
            throw new IllegalStateException("Unexpected context for registering a user");
        }
        return this.doRegister((AbstractSimpleUserRegistrationDTO)userRegistrationDTO, userRegistration, null).additionalActions(registrationResultAccessor -> {
            List list;
            User user = registrationResultAccessor.user();
            if (!this.isLoggedIn() && CollectionHelper.isNotEmpty((Iterable)(list = this.productsHandler.getAccessor((BasicUser)user).product().getAgreements()))) {
                for (Agreement agreement : list) {
                    this.agreementLogService.accept(agreement, user);
                }
            }
        }).endRegistration(registrationResultAccessor -> this.basicUserService.buildRegistrationResult((BasicUser)registrationResultAccessor.user(), registrationResultAccessor.generatedPasswords().keySet()));
    }

    public UserRegistrationResult registerByMember(UserRegistrationByMemberDTO userRegistrationByMemberDTO) throws FrameworkException {
        return this.doRegister((AbstractSimpleUserRegistrationDTO)userRegistrationByMemberDTO, UserRegistration.MEMBER, null).endRegistration(registrationResultAccessor -> this.basicUserService.buildRegistrationResult((BasicUser)registrationResultAccessor.user(), null));
    }

    public User registerByPopulator(UserRegistrationDTO userRegistrationDTO) throws FrameworkException {
        return this.doRegister((AbstractSimpleUserRegistrationDTO)userRegistrationDTO, UserRegistration.POPULATOR, null).endRegistration(RegistrationResultAccessor::user);
    }

    public RegisterUserBySmsResult registerBySms(RegisterUserBySmsParams registerUserBySmsParams) throws FrameworkException {
        PasswordRegistrationDTO passwordRegistrationDTO;
        Channel channel = this.channelService.getSms();
        PasswordType passwordType = this.configurationHandler.getAccessor((BasicGroup)registerUserBySmsParams.getGroup()).getChannelConfiguration(channel).getAccessPassword();
        UserRegistrationDTO userRegistrationDTO = new UserRegistrationDTO();
        if (passwordType.getPasswordMode() == PasswordMode.MANUAL) {
            passwordRegistrationDTO = new PasswordRegistrationDTO();
            passwordRegistrationDTO.setAssign(true);
            passwordRegistrationDTO.setValue(registerUserBySmsParams.getPassword());
            passwordRegistrationDTO.setType(new PasswordTypeVO(passwordType.getId()));
            passwordRegistrationDTO.setConfirmationValue(passwordRegistrationDTO.getValue());
            userRegistrationDTO.setPasswords(Arrays.asList(passwordRegistrationDTO));
        }
        userRegistrationDTO.setGroup(new GroupVO(SimpleEntity.id((SimpleEntity)registerUserBySmsParams.getGroup())));
        userRegistrationDTO.setUsername(registerUserBySmsParams.getUsername());
        userRegistrationDTO.setName(registerUserBySmsParams.getName());
        userRegistrationDTO.setSkipActivationEmail(true);
        passwordRegistrationDTO = new MobilePhoneDTO();
        passwordRegistrationDTO.setName(this.message(UsersKeys.Phones.MOBILE_DEFAULT_NAME, 1));
        passwordRegistrationDTO.setRawNumber(registerUserBySmsParams.getPhoneNumber());
        userRegistrationDTO.setMobilePhones(Arrays.asList(passwordRegistrationDTO));
        UserValidationFields userValidationFields = new UserValidationFields(false);
        userValidationFields.setProfileFields(Arrays.asList(BasicProfileField.FULL_NAME, BasicProfileField.FULL_NAME, BasicProfileField.PHONE));
        userValidationFields.setPhoneNatures(EnumSet.of(PhoneNature.MOBILE));
        return this.doRegister((AbstractSimpleUserRegistrationDTO)userRegistrationDTO, UserRegistration.SMS, userValidationFields).additionalActions(registrationResultAccessor -> {
            User user = registrationResultAccessor.user();
            this.userChannelService.enableChannel(user, channel);
            MobilePhone mobilePhone = (MobilePhone)CollectionHelper.first((Iterable)user.getPhones());
            this.phoneService.verifyAndEnableForSms(mobilePhone);
        }).endRegistration(registrationResultAccessor -> {
            RegisterUserBySmsResult registerUserBySmsResult = new RegisterUserBySmsResult();
            registerUserBySmsResult.setResult(this.basicUserService.buildRegistrationResult((BasicUser)registrationResultAccessor.user(), registrationResultAccessor.generatedPasswords().keySet()));
            registerUserBySmsResult.setGeneratedPassword(registrationResultAccessor.generatedPasswords().get(passwordType));
            return registerUserBySmsResult;
        });
    }

    public RegisterUserByWizardResult registerByWizard(PublicRegistrationDTO publicRegistrationDTO) {
        String string;
        Object object;
        CustomWizardExecutionStorage customWizardExecutionStorage = this.customWizardService.getStorage(publicRegistrationDTO);
        if (customWizardExecutionStorage == null) {
            throw new IllegalActionException("The parameter isn't valid for a registration by wizard");
        }
        String string2 = customWizardExecutionStorage.getExternalPaymentToken();
        if (string2 != null) {
            publicRegistrationDTO.setExternalPaymentToken(string2);
            object = this.externalPaymentService.findByToken(string2);
            string = object.getToPrincipalType().getInternalName();
            if (string.equals(ExistingBuiltInPrincipalType.EMAIL.getInternalName())) {
                customWizardExecutionStorage.setVerifiedEmail(object.getToPrincipalValue());
            } else if (string.equals(ExistingBuiltInPrincipalType.MOBILE_PHONE.getInternalName())) {
                customWizardExecutionStorage.setVerifiedSms(object.getToPrincipalValue());
            }
        }
        object = this.doPublicRegister(publicRegistrationDTO, new UserValidationFields(false));
        string = new RegisterUserByWizardResult();
        string.setUser(object.user());
        string.setGeneratedPasswords(object.generatedPasswords().keySet());
        return string;
    }

    public Page<UserWithFieldsVO> search(UserQuery userQuery) {
        if (userQuery.isLocateFirst() && StringHelper.isNotBlank((Object)userQuery.getKeywords())) {
            UserLocatorVO userLocatorVO = new UserLocatorVO((org.cyclos.model.Property)UserLocatorVO.PRINCIPAL, (Object)userQuery.getKeywords());
            try {
                LocateUserResult locateUserResult = this.userLocatorHandler.locate(userLocatorVO);
                if (locateUserResult.getBasicUser() instanceof User) {
                    Set set;
                    User user = locateUserResult.getUser();
                    boolean bl = true;
                    if (CollectionHelper.isNotEmpty((Iterable)userQuery.getUsersToInclude())) {
                        set = this.conversionHandler.convertSet(User.class, (Iterable)userQuery.getUsersToInclude());
                        bl = set.contains(user);
                    }
                    if (CollectionHelper.isNotEmpty((Iterable)userQuery.getUsersToExclude())) {
                        set = this.conversionHandler.convertSet(User.class, (Iterable)userQuery.getUsersToExclude());
                        boolean bl2 = bl = !set.contains(user);
                    }
                    if (bl) {
                        userQuery.setUsersToInclude(CollectionHelper.asSet((Object[])new UserVO[]{new UserVO(user.getId())}));
                        userQuery.setKeywords(null);
                    }
                }
            }
            catch (EntityNotFoundException entityNotFoundException) {
                // empty catch block
            }
        }
        if (userQuery.getAddressResult() == UserAddressResult.NEAREST_ADDRESS && !ModelHelper.isValid((DistanceDTO)userQuery.getDistance())) {
            userQuery.setAddressResult(UserAddressResult.DEFAULT_ADDRESS);
        } else if (userQuery.isMapDirectory() && userQuery.getAddressResult() == null) {
            userQuery.setAddressResult(UserAddressResult.ALL_LOCATED_ADDRESSES);
        }
        if (userQuery.isMapDirectory() || userQuery.getAddressResult() == UserAddressResult.ALL_LOCATED_ADDRESSES) {
            QueryHelper.applyMaxResultsOnMap((QueryParameters)userQuery);
        }
        return this.userSearchHandler.search((QueryParameters)userQuery);
    }

    @Override
    public UserDTO toDTO(User user) {
        Object object2;
        if (user == null) {
            return null;
        }
        Class<? extends UserDTO> clazz = this.resolveDTOType(user);
        HashSet<Object> hashSet = new HashSet<Object>();
        SessionData sessionData = this.getSessionData();
        boolean bl = false;
        if (sessionData.isAdmin() || sessionData.isSystem()) {
            bl = true;
        } else if (sessionData.isGuest()) {
            bl = sessionData.getConfiguration().getPossibleInitialGroups().contains(user.getGroup());
        } else {
            boolean bl2 = sessionData.manages((BasicUser)user);
            if (user.equals((Object)sessionData.getLoggedUser()) || !bl2) {
                bl = sessionData.getProducts().member().getGroupVisibility() == GroupVisibility.GROUP;
            } else if (bl2) {
                bl = user.isPersistent() ? sessionData.getProducts().broker().getGroupVisibility() == GroupVisibility.GROUP : true;
            }
        }
        if (!bl) {
            hashSet.add(UserDTO.GROUP);
        }
        List list = this.profileFieldHandler.getFieldsByAction((BasicUser)user, ProfileFieldAction.VIEW);
        for (Object object2 : BasicProfileField.simple()) {
            if (list.contains(object2)) continue;
            hashSet.add(object2.property());
        }
        hashSet.add(UserDTO.CUSTOM_VALUES);
        hashSet.addAll(CollectionHelper.asSet((Object[])this.getExcludedPropertiesToDTO(user)));
        List list2 = this.profileFieldHandler.getFieldsByAction((BasicUser)user, ProfileFieldAction.EDIT);
        if (user.isTransient() && list2.contains(BasicProfileField.EMAIL)) {
            user.setHideEmail(this.profileFieldHandler.isDefaultHidden(user.getGroup(), (ProfileField)BasicProfileField.EMAIL));
        }
        object2 = new ArrayList();
        this.profileFieldHandler.getCustomFields((Collection)list).stream().map(userCustomField -> (UserCustomFieldValue)CustomFieldHelper.findValue((ICustomField)userCustomField, (Collection)user.getCustomValues())).filter(userCustomFieldValue -> userCustomFieldValue != null).forEach(arg_0 -> UserServiceImpl.lambda$toDTO$16((Collection)object2, arg_0));
        UserDTO userDTO = (UserDTO)this.conversionHandler.convertExcluding(clazz, (Object)user, hashSet.toArray());
        userDTO.setCustomValues(this.conversionHandler.convertList(UserCustomFieldValueDTO.class, (Iterable)object2));
        if (sessionData.isAdmin() && userDTO instanceof UserRegistrationDTO) {
            UserRegistrationDTO userRegistrationDTO = (UserRegistrationDTO)userDTO;
            User user2 = (User)CollectionHelper.first((Iterable)user.getBrokers());
            userRegistrationDTO.setBroker((UserVO)this.conversionHandler.convert(UserVO.class, (Object)user2));
        }
        return userDTO;
    }

    public <VO extends UserVO> VO toUserVO(Class<VO> clazz, SessionData sessionData, Long l, String string, String string2, String string3, ImageVO imageVO) {
        UserVO userVO = (UserVO)ClassHelper.instantiate(clazz);
        userVO.setId(l);
        if (string != null || string2 != null) {
            String string4 = StringHelper.trimToNull((Object)QueryHelper.getUserDisplay((SessionData)sessionData, (Long)l, (String)string3, (String)string, (String)string2));
            userVO.setDisplay(string4 == null ? this.message(GeneralKeys.Ui.USER, new Object[0]) : string4);
        }
        if (this.profileFieldHandler.isVisible((ProfileField)BasicProfileField.IMAGE, string3)) {
            userVO.setImage(imageVO);
        }
        return (VO)userVO;
    }

    public UserVO toUserVO(SessionData sessionData, Long l, String string, String string2, String string3, ImageVO imageVO) {
        return this.toUserVO(UserVO.class, sessionData, l, string, string2, string3, imageVO);
    }

    public void validate(UserDTO userDTO, UserRegistration userRegistration, UserValidationFields userValidationFields) {
        this.validate(this.resolveValidator(userDTO, userRegistration, userValidationFields), userDTO, "userDTO");
    }

    public String validateRegistrationField(ValidateRegistrationFieldParams validateRegistrationFieldParams) throws FrameworkException {
        List list;
        ValidationResult validationResult;
        List list2;
        UserRegistration userRegistration;
        PublicRegistrationDTO publicRegistrationDTO;
        Validator validator = new Validator();
        validator.property((org.cyclos.model.Property)ValidateRegistrationFieldParams.GROUP, UsersKeys.Users.GROUP).required();
        validator.property((org.cyclos.model.Property)ValidateRegistrationFieldParams.FIELD, GeneralKeys.Ui.FIELD).required();
        validator.property((org.cyclos.model.Property)ValidateRegistrationFieldParams.VALUE, GeneralKeys.Ui.VALUE).required();
        this.validate(validator, validateRegistrationFieldParams, "validateRegistrationField");
        SessionData sessionData = this.getSessionData();
        if (sessionData.isLoggedIn()) {
            if (validateRegistrationFieldParams.isAsMember()) {
                publicRegistrationDTO = new UserRegistrationByMemberDTO();
                userRegistration = UserRegistration.MEMBER;
            } else {
                publicRegistrationDTO = new UserRegistrationDTO();
                userRegistration = sessionData.isAdmin() ? UserRegistration.ADMIN : UserRegistration.BROKER;
            }
        } else {
            publicRegistrationDTO = new PublicRegistrationDTO();
            userRegistration = UserRegistration.PUBLIC;
        }
        publicRegistrationDTO.setGroup(validateRegistrationFieldParams.getGroup());
        Group group = (Group)this.conversionHandler.convert(Group.class, (Object)validateRegistrationFieldParams.getGroup());
        ProductsAccessor productsAccessor = this.productsHandler.getAccessor((BasicGroup)group);
        List list3 = this.profileFieldHandler.getMatchingFields(productsAccessor.product().getMyProfileFields(), QProductMyProfileField.productMyProfileField.editableAtRegistration);
        String string = validateRegistrationFieldParams.getField();
        String string2 = validateRegistrationFieldParams.getValue();
        String string3 = null;
        boolean bl = false;
        UserValidationFields userValidationFields = new UserValidationFields();
        if (AbstractSimpleUserRegistrationDTO.NAME.getName().equals(string)) {
            bl = list3.contains(BasicProfileField.FULL_NAME);
            string3 = AbstractSimpleUserRegistrationDTO.NAME.getName();
            publicRegistrationDTO.setName(string2);
            userValidationFields.addProfileField((ProfileField)BasicProfileField.FULL_NAME);
        } else if (AbstractSimpleUserRegistrationDTO.USERNAME.getName().equals(string)) {
            bl = list3.contains(BasicProfileField.LOGIN_NAME) && !this.configurationHandler.getAccessor((BasicGroup)group).isGeneratedUsername();
            string3 = AbstractSimpleUserRegistrationDTO.USERNAME.getName();
            publicRegistrationDTO.setUsername(string2);
            userValidationFields.addProfileField((ProfileField)BasicProfileField.LOGIN_NAME);
        } else if (AbstractSimpleUserRegistrationDTO.EMAIL.getName().equals(string)) {
            bl = list3.contains(BasicProfileField.EMAIL);
            string3 = AbstractSimpleUserRegistrationDTO.EMAIL.getName();
            userValidationFields.addProfileField((ProfileField)BasicProfileField.EMAIL);
            publicRegistrationDTO.setEmail(string2);
        } else if ("landLinePhone".equals(string)) {
            bl = list3.contains(BasicProfileField.PHONE);
            string3 = "landLinePhones.number";
            userValidationFields.addProfileField((ProfileField)BasicProfileField.PHONE);
            userValidationFields.addPhoneNature(PhoneNature.LANDLINE);
            list2 = new LandLinePhoneDTO();
            list2.setName("temp");
            list2.setRawNumber(string2);
            publicRegistrationDTO.setLandLinePhones(Arrays.asList(list2));
        } else if ("mobilePhone".equals(string)) {
            bl = list3.contains(BasicProfileField.PHONE);
            string3 = "mobilePhones.number";
            userValidationFields.addProfileField((ProfileField)BasicProfileField.PHONE);
            userValidationFields.addPhoneNature(PhoneNature.MOBILE);
            list2 = new MobilePhoneDTO();
            list2.setName("temp");
            list2.setRawNumber(string2);
            publicRegistrationDTO.setMobilePhones(Arrays.asList(list2));
        } else {
            list2 = this.profileFieldHandler.getCustomFields((Collection)list3);
            validationResult = list2.stream().filter(userCustomField -> userCustomField.getInternalName().equals(string)).findFirst().orElse(null);
            bl = list2.contains(validationResult);
            if (validationResult != null) {
                list = new UserCustomFieldValueDTO();
                list.setField(new CustomFieldVO(validationResult.getId()));
                list.setReferenceValue(string2);
                publicRegistrationDTO.setCustomValues(Arrays.asList(list));
                userValidationFields.addProfileField((ProfileField)validationResult);
            }
        }
        if (!bl) {
            throw new ValidationException(ValidateRegistrationFieldParams.FIELD.getName(), this.message(GeneralKeys.Errors.INVALID, GeneralKeys.Ui.FIELD));
        }
        try {
            this.validate((UserDTO)publicRegistrationDTO, userRegistration, userValidationFields);
            return null;
        }
        catch (ValidationException validationException) {
            validationResult = validationException.getValidation();
            list = CollectionHelper.isNotEmpty((Iterable)publicRegistrationDTO.getCustomValues()) ? validationResult.getCustomFieldErrors(string) : validationResult.getPropertyErrors(string3);
            return (String)CollectionHelper.first((Iterable)list);
        }
    }

    @Override
    protected void addCustomNameValidations(Property property, UserDTO userDTO) {
        this.basicUserService.addNameValidations(property, (BasicUserDTO)userDTO);
    }

    @Override
    protected void doRemove(User user, boolean bl) {
        user.setPhysicallyRemoving(true);
        this.userImageService.removeAll((BaseEntity)user);
        this.customFieldValueHandler.removeAll((EntityWithCustomValues)user);
        this.addressService.removeAll(user);
        this.contactInfoService.removeAll(user);
        this.userSearchHandler.remove(user.getId());
        this.entityLogService.removeAll((BasicUser)user);
        this.entityLogService.log((SimpleEntity)user, this.message(UsersKeys.Users.STATUS, new Object[0]), "status", this.getFormatter().format((HasMessageKey)UserStatus.PENDING), this.getFormatter().format((HasMessageKey)UserStatus.PURGED), EntityActionLog.CHANGE_USER_STATUS);
        super.doRemove(user, bl);
    }

    protected void fillExternalPaymentInfo(UserDataParams userDataParams, User user) {
        block2: {
            PrincipalType principalType;
            ExternalPayment externalPayment;
            block3: {
                BuiltInPrincipalType builtInPrincipalType;
                block4: {
                    if (userDataParams.getExternalPaymentToken() == null) break block2;
                    externalPayment = this.externalPaymentService.findByToken(userDataParams.getExternalPaymentToken());
                    user.setExternalPayment(externalPayment);
                    principalType = externalPayment.getToPrincipalType();
                    if (principalType.getNature() != PrincipalTypeNature.BUILT_IN) break block3;
                    builtInPrincipalType = (BuiltInPrincipalType)principalType;
                    if (builtInPrincipalType.getBuiltInType() != ExistingBuiltInPrincipalType.MOBILE_PHONE) break block4;
                    MobilePhone mobilePhone = new MobilePhone();
                    mobilePhone.setRawNumber(externalPayment.getToPrincipalValue());
                    user.getPhones().add(mobilePhone);
                    break block2;
                }
                if (builtInPrincipalType.getBuiltInType() != ExistingBuiltInPrincipalType.EMAIL) break block2;
                user.setEmail(externalPayment.getToPrincipalValue());
                break block2;
            }
            if (principalType.getNature() == PrincipalTypeNature.CUSTOM_FIELD) {
                CustomFieldPrincipalType customFieldPrincipalType = (CustomFieldPrincipalType)principalType;
                UserCustomField userCustomField = customFieldPrincipalType.getCustomField();
                Set set = user.getCustomValues();
                for (UserCustomFieldValue userCustomFieldValue : set) {
                    if (!userCustomFieldValue.getField().equals((Object)userCustomField)) continue;
                    CustomFieldHelper.setCustomFieldValue((ICustomFieldValue)userCustomFieldValue, (Object)externalPayment.getToPrincipalValue());
                    break;
                }
            }
        }
    }

    protected void fillFirstMobilePhone(User user, MobilePhoneData mobilePhoneData) {
        Set set = user.getPhones();
        for (Phone phone : set) {
            if (!(phone instanceof MobilePhone)) continue;
            ((PhoneDTO)mobilePhoneData.getDto()).setRawNumber(phone.getRawNumber());
            break;
        }
    }

    @Override
    protected boolean generateLogOnRemove() {
        return false;
    }

    @Override
    protected UserData getData(User user) {
        if (user.isPersistent()) {
            return this.getEditProfileData(user);
        }
        switch (user.getRegistrationType()) {
            case POPULATOR: 
            case ADMIN: 
            case BROKER: {
                return this.getUserRegistrationData(user);
            }
            case MEMBER: {
                return this.getUserRegistrationByMemberData(user);
            }
            case PUBLIC: {
                return this.getPublicRegistrationData(user);
            }
        }
        throw new IllegalArgumentException("Invalid user registration when getting UserData: " + String.valueOf(user.getRegistrationType()));
    }

    @Override
    protected CreateDeviceConfirmationParams getDeviceConfirmationParams(UserDTO userDTO, User user, CRUDOperation cRUDOperation) {
        return EditProfileConfirmationField.confirmation();
    }

    @Override
    protected Object[] getExcludedPropertiesToEntity(UserDTO userDTO) {
        return this.getExcludedPropertiesToEntity();
    }

    @Override
    protected String getNameLabel(UserDTO userDTO) {
        return this.getNameLabelByConfiguration(this.configurationHandler.getAccessor((BasicGroup)this.conversionHandler.convert(Group.class, (Object)userDTO.getGroup())));
    }

    @Override
    protected Pair<DBQuery<?>, String> getUniqueNameQuery(UserDTO userDTO) {
        return null;
    }

    @Override
    protected boolean isNameRequired(UserDTO userDTO) {
        return this.basicUserService.isNameRequired((BasicUserDTO)userDTO);
    }

    @Override
    protected void onAfterSave(User user, User user2, Object object) {
        if (user2 == null) {
            throw new IllegalActionException("Cannot persist users with the save() methd");
        }
        this.customFieldValueHandler.processAfterSave((EntityWithCustomValues)user);
        this.basicUserService.reindex((BasicUser)user);
        this.userSearchHandler.updateUserFields(user, false);
    }

    @Override
    protected void onBeforeRemove(User user) {
        if (!user.isPendingValidation()) {
            throw new IllegalActionException();
        }
    }

    @Override
    protected Object onBeforeSave(User user, User user2) {
        if (user.isTransient()) {
            throw new IllegalActionException("This method only supports updating a user. For new users, use the register() method");
        }
        this.basicUserService.updateDisplay((BasicUser)user);
        if (!user.isPendingValidation() && !Objects.equals(user.getEmail(), user2.getEmail())) {
            if (this.basicUserService.requiresEmailChangeValidation((BasicUser)user)) {
                this.basicUserService.setEmailChangeValidation((BasicUser)user, user2.getEmail());
            } else if (StringHelper.isNotBlank((Object)user.getEmail())) {
                user.setEmailVerified(false);
                if (StringHelper.isNotBlank((Object)user2.getEmail())) {
                    this.mailHandler.send(null, (BasicUser)user2, MailContext.EMAIL_CHANGE, (MailContentProducer)this.mailContentBuilder().subject(ContentManagementKeys.Emails.CHANGE_OF_EMAIL_NOTIFICATION_SUBJECT, new Object[0]).body(ContentManagementKeys.Emails.CHANGE_OF_EMAIL_NOTIFICATION_BODY, new Object[]{user.getEmail()}), new FileInfo[0]);
                }
            }
        }
        this.externalPaymentService.processExternalPayments(user);
        return null;
    }

    @Override
    protected void preProcessCurrentCopy(UserDTO userDTO, User user) {
        this.fetchCollections(user);
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(QBasicUser.basicUser.network(), true);
        networkPathRegistry.register(QUserActivity.userActivity.basicUser().network(), true);
    }

    @Override
    protected Class<? extends UserDTO> resolveDTOType(User user) {
        if (user.isTransient()) {
            switch (user.getRegistrationType()) {
                case POPULATOR: 
                case ADMIN: 
                case BROKER: {
                    return UserRegistrationDTO.class;
                }
                case MEMBER: {
                    return UserRegistrationByMemberDTO.class;
                }
                case PUBLIC: {
                    return PublicRegistrationDTO.class;
                }
            }
            throw new IllegalArgumentException("Invalid user registration when resolving UserDTO subclass: " + String.valueOf(user.getRegistrationType()));
        }
        return UserDTO.class;
    }

    @Override
    protected ExtensionPointAccessor resolveExtensionPointAccessor(CRUDOperation cRUDOperation, User user) {
        if (cRUDOperation != CRUDOperation.CREATE && cRUDOperation != CRUDOperation.UPDATE) {
            return null;
        }
        UserExtensionPointEvent userExtensionPointEvent = cRUDOperation == CRUDOperation.CREATE ? UserExtensionPointEvent.CREATE : UserExtensionPointEvent.UPDATE;
        return this.extensionPointService.newAccessor((ExtensionPointEvent)userExtensionPointEvent, new ExtensionPointFilter(user.getGroup())).attribute("user", (Object)user);
    }

    @Override
    protected Validator resolveValidator(UserDTO userDTO) {
        if (userDTO.isTransient()) {
            throw new IllegalActionException("This method only supports updating a user. For new users, use the register(), registerByMmber() or publicRegister() methods");
        }
        return this.resolveValidator(userDTO, null, null);
    }

    @Override
    protected boolean shouldCheckConfirmationPassword(User user, CRUDOperation cRUDOperation) {
        return this.basicUserService.shouldCheckConfirmationPassword((BasicUser)user, cRUDOperation);
    }

    private void activateUserIfNeeded(User user, boolean bl) {
        Date date;
        if (!user.isPendingValidation()) {
            this.accountService.adjustAccounts(user, true);
            this.externalPaymentService.processExternalPayments(user);
        }
        if (user.isActive() && (date = user.getActivationDate()) == null) {
            this.tokenService.generateOnRegistrationTokens((BasicUser)user);
            ExtensionPointAccessor extensionPointAccessor = this.extensionPointService.newAccessor((ExtensionPointEvent)UserExtensionPointEvent.ACTIVATE, new ExtensionPointFilter(user.getGroup())).attribute("user", (Object)user);
            extensionPointAccessor.fireValidated();
            if (user.getRegistrationType() == UserRegistration.IMPORT) {
                user.setActivationDate(user.getCreationDate());
            } else {
                user.setActivationDate(DateHelper.now());
            }
            if (bl) {
                this.basicUserService.finishActivation((BasicUser)user);
            }
            InvocationContext.ensure().addBeforeEndListener(() -> ((ExtensionPointAccessor)extensionPointAccessor).fireSaved());
        }
    }

    private void addAccountNumberValidations(UserDTO userDTO, Validator validator, ConfigurationAccessor configurationAccessor) {
        List list = ((UserRegistrationDTO)userDTO).getAccountConfigurations();
        if (list == null) {
            return;
        }
        AccountNumberConfiguration accountNumberConfiguration = configurationAccessor.getAccountNumberConfiguration();
        String string = accountNumberConfiguration == null ? null : accountNumberConfiguration.getMask();
        for (UserRegistrationAccountConfigurationDTO userRegistrationAccountConfigurationDTO : list) {
            if (userRegistrationAccountConfigurationDTO.getAccountNumber() == null) continue;
            validator.general(object -> {
                String string2 = userRegistrationAccountConfigurationDTO.getAccountNumber();
                if (string != null && !MaskHelper.isValidMaskedValue((String)string, (String)string2)) {
                    string2 = MaskHelper.applyMask((String)string, (String)string2);
                }
                if (accountNumberConfiguration == null || !accountNumberConfiguration.isEnabled() || string != null && !MaskHelper.isValidMaskedValue((String)string, (String)string2)) {
                    return new ValidationError(BankingKeys.Accounts.ERROR_INVALID_ACCOUNT_NUMBER);
                }
                if (this.accountService.accountNumberExistsOrIsReserved(accountNumberConfiguration, string2 = MaskHelper.removeMask((String)string, (String)string2))) {
                    return new ValidationError(BankingKeys.Accounts.ERROR_ACCOUNT_NUMBER_EXISTS);
                }
                return null;
            });
        }
    }

    private <T> void applyDefaultsNotifications(NotificationTypeSettingsDTO notificationTypeSettingsDTO, BooleanPropertiesHolder<AdminNotificationType> booleanPropertiesHolder, Collection<T> collection, Collection<T> collection2, Consumer<Set<T>> consumer) {
        Object object;
        boolean bl = true;
        if (consumer != null) {
            object = CollectionHelper.asSet((Iterable)CollectionUtils.intersection((Iterable)CollectionHelper.orEmpty(collection), (Iterable)CollectionHelper.orEmpty(collection2)));
            if (CollectionHelper.isNotEmpty((Iterable)object)) {
                consumer.accept((Set<QAdminProductNotification>)object);
            } else {
                bl = false;
            }
        }
        if (bl) {
            object = QAdminProductNotification.adminProductNotification;
            boolean bl2 = booleanPropertiesHolder.get((Object)((AdminNotificationType)notificationTypeSettingsDTO.getType())).isSet((Path)object.defaultMail);
            boolean bl3 = booleanPropertiesHolder.get((Object)((AdminNotificationType)notificationTypeSettingsDTO.getType())).isSet((Path)object.defaultSms);
            notificationTypeSettingsDTO.setNotifyByEmail(Boolean.valueOf(bl2));
            notificationTypeSettingsDTO.setNotifyBySms(Boolean.valueOf(bl3));
            notificationTypeSettingsDTO.setNotifyByInternal(Boolean.valueOf(bl));
        }
    }

    private boolean canRemovePendingUser(User user) {
        SessionData sessionData = this.getSessionData();
        if (!sessionData.manages((BasicUser)user)) {
            return false;
        }
        return sessionData.hasPermission(Permission.PENDING_USERS_MANAGE) && user.isPendingValidation();
    }

    private void createAdminNotificationSettings(User user) {
        AdminNotificationSettingsData adminNotificationSettingsData = (AdminNotificationSettingsData)this.invokerHandler.runAs(SessionDataFactory.user((BasicUser)user), () -> this.notificationSettingsService.getData(new UserLocatorVO(user.getId())));
        if (CollectionHelper.isEmpty((Iterable)adminNotificationSettingsData.getNotificationSettings().getNotificationTypeSettings())) {
            return;
        }
        AdminProductAccessor adminProductAccessor = this.productsHandler.getAccessor((BasicUser)user).admin();
        AdminNotificationSettingsDTO adminNotificationSettingsDTO = adminNotificationSettingsData.getNotificationSettings();
        Set set = this.conversionHandler.convertSet(MessageCategoryVO.class, (Iterable)adminProductAccessor.getFwdMessageCategoriesToEmailToNotify());
        adminNotificationSettingsDTO.setFwdMessageCategoriesToEmail(CollectionHelper.asSet((Iterable)CollectionUtils.intersection((Iterable)set, (Iterable)adminNotificationSettingsData.getMessageCategories())));
        Map<INotificationType, NotificationTypeSettingsDTO> map = adminNotificationSettingsDTO.getNotificationTypeSettings().stream().collect(Collectors.toMap(NotificationTypeSettingsDTO::getType, notificationTypeSettingsDTO -> notificationTypeSettingsDTO));
        BooleanPropertiesHolder booleanPropertiesHolder = adminProductAccessor.getDefaultNotifications();
        booleanPropertiesHolder.keys().stream().filter(adminNotificationType -> map.containsKey(adminNotificationType)).forEach(adminNotificationType -> {
            NotificationTypeSettingsDTO notificationTypeSettingsDTO = (NotificationTypeSettingsDTO)map.get(adminNotificationType);
            switch (adminNotificationType) {
                case AD_PENDING_AUTHORIZATION: 
                case APPLICATION_ERROR: {
                    this.applyDefaultsNotifications(notificationTypeSettingsDTO, (BooleanPropertiesHolder<AdminNotificationType>)booleanPropertiesHolder, null, null, null);
                    break;
                }
                case EXTERNAL_PAYMENT_EXPIRED: {
                    Set set2 = this.conversionHandler.convertSet(TransferTypeVO.class, (Iterable)adminProductAccessor.getExternalPaymentsExpiredToNotify());
                    this.applyDefaultsNotifications(notificationTypeSettingsDTO, (BooleanPropertiesHolder<AdminNotificationType>)booleanPropertiesHolder, set2, adminNotificationSettingsData.getExternalPayments(), set -> adminNotificationSettingsDTO.setExternalPaymentsExpired(set));
                    break;
                }
                case EXTERNAL_PAYMENT_PERFORMED_FAILED: {
                    Set set3 = this.conversionHandler.convertSet(TransferTypeVO.class, (Iterable)adminProductAccessor.getExternalPaymentsFailedToNotify());
                    this.applyDefaultsNotifications(notificationTypeSettingsDTO, (BooleanPropertiesHolder<AdminNotificationType>)booleanPropertiesHolder, set3, adminNotificationSettingsData.getExternalPayments(), set -> adminNotificationSettingsDTO.setExternalPaymentsFailed(set));
                    break;
                }
                case GENERATED_VOUCHERS_EXPIRED: {
                    Set set4 = this.conversionHandler.convertSet(VoucherConfigurationVO.class, (Iterable)adminProductAccessor.getVoucherConfigurationsToNotify());
                    this.applyDefaultsNotifications(notificationTypeSettingsDTO, (BooleanPropertiesHolder<AdminNotificationType>)booleanPropertiesHolder, set4, adminNotificationSettingsData.getVoucherConfigurations(), set -> adminNotificationSettingsDTO.setVoucherConfigurations(set));
                    break;
                }
                case PAYMENT_AWAITING_AUTHORIZATION: {
                    Set set5 = this.conversionHandler.convertSet(TransferTypeVO.class, (Iterable)adminProductAccessor.getAuthorizablePaymentsToNotify());
                    this.applyDefaultsNotifications(notificationTypeSettingsDTO, (BooleanPropertiesHolder<AdminNotificationType>)booleanPropertiesHolder, set5, adminNotificationSettingsData.getNewPendingPayments(), set -> adminNotificationSettingsDTO.setAuthorizablePayments(set));
                    break;
                }
                case PAYMENT_PERFORMED: {
                    Set set6 = this.conversionHandler.convertSet(TransferTypeVO.class, (Iterable)adminProductAccessor.getPaymentsToNotify());
                    this.applyDefaultsNotifications(notificationTypeSettingsDTO, (BooleanPropertiesHolder<AdminNotificationType>)booleanPropertiesHolder, set6, adminNotificationSettingsData.getPayments(), set -> adminNotificationSettingsDTO.setPayments(set));
                    break;
                }
                case SYSTEM_ALERT: {
                    this.applyDefaultsNotifications(notificationTypeSettingsDTO, (BooleanPropertiesHolder<AdminNotificationType>)booleanPropertiesHolder, adminProductAccessor.getSystemAlertsToNotify(), adminNotificationSettingsData.getSystemAlerts(), set -> adminNotificationSettingsDTO.setSystemAlerts(set));
                    break;
                }
                case USER_ALERT: {
                    this.applyDefaultsNotifications(notificationTypeSettingsDTO, (BooleanPropertiesHolder<AdminNotificationType>)booleanPropertiesHolder, adminProductAccessor.getUserAlertsToNotify(), adminNotificationSettingsData.getUserAlerts(), set -> adminNotificationSettingsDTO.setUserAlerts(set));
                    break;
                }
                case USER_REGISTRATION: {
                    Set set7 = this.conversionHandler.convertSet(GroupVO.class, (Iterable)adminProductAccessor.getUserGroupsToNotify());
                    this.applyDefaultsNotifications(notificationTypeSettingsDTO, (BooleanPropertiesHolder<AdminNotificationType>)booleanPropertiesHolder, set7, adminNotificationSettingsData.getNewUsers(), set -> adminNotificationSettingsDTO.setUserGroups(set));
                    break;
                }
                case VOUCHER_BUYING_ABOUT_TO_EXPIRE: {
                    Set set8 = this.conversionHandler.convertSet(VoucherConfigurationVO.class, (Iterable)adminProductAccessor.getVoucherConfigurationsBuyingToNotify());
                    this.applyDefaultsNotifications(notificationTypeSettingsDTO, (BooleanPropertiesHolder<AdminNotificationType>)booleanPropertiesHolder, set8, adminNotificationSettingsData.getVoucherConfigurations(), set -> adminNotificationSettingsDTO.setVoucherConfigurationsBuying(set));
                    break;
                }
            }
        });
        this.notificationSettingsService.save((NotificationSettingsDTO)adminNotificationSettingsDTO);
    }

    private void doFill(AbstractUserSearchData abstractUserSearchData, boolean bl, ProfileFieldSearchContext profileFieldSearchContext) {
        Object object;
        SessionData sessionData = this.getSessionData();
        this.profileFieldHandler.fill((DataWithBasicProfileFields)abstractUserSearchData);
        List list = this.profileFieldHandler.getSearchFilters(ProfileFieldSearchContext.USER_KEYWORDS, bl, null);
        abstractUserSearchData.setAllowKeywords(CollectionHelper.isNotEmpty((Iterable)list));
        abstractUserSearchData.setCanViewImages(this.profileFieldHandler.isVisible((ProfileField)BasicProfileField.IMAGE, bl));
        abstractUserSearchData.setBrokersExist(this.groupsHandler.accessibles().brokers().isNotEmpty());
        abstractUserSearchData.setSearchByDistanceData(this.addressService.getSearchByDistanceData());
        if (sessionData.isAdmin()) {
            object = new ArrayList();
            if (sessionData.hasPermission(Permission.USER_CONFIGURATION_VIEW)) {
                object = this.productService.listByRoles(EnumSet.of(Role.MEMBER, Role.BROKER));
            } else if (sessionData.hasPermission(Permission.PRODUCTS_ASSIGN_TO_USER)) {
                object = this.productsHandler.getAccessor((BasicUser)this.getLoggedUser()).admin().getManageIndividualProducts();
            }
            abstractUserSearchData.setProducts(this.conversionHandler.convertList(ProductVO.class, (Iterable)object));
        }
        if (sessionData.hasPermission(Permission.USER_AGREEMENT_LOG_VIEW) && (sessionData.isAdmin() || sessionData.isBroker() && bl)) {
            abstractUserSearchData.setAgreements(this.agreementService.list());
        }
        object = this.profileFieldHandler.getSimpleAndAdvancedSearchFilters(profileFieldSearchContext, bl, Collections.emptyMap());
        abstractUserSearchData.setSimpleProfileFields((List)object.getFirst());
        abstractUserSearchData.setAdvancedProfileFields((List)object.getSecond());
        if (((List)object.getFirst()).contains(BasicProfileField.ADDRESS) || ((List)object.getSecond()).contains(BasicProfileField.ADDRESS)) {
            abstractUserSearchData.setAddressFields(this.profileFieldHandler.getAddressQueryFields());
        }
    }

    private RegistrationResultAccessor doPublicRegister(PublicRegistrationDTO publicRegistrationDTO, UserValidationFields userValidationFields) {
        ExternalPayment externalPayment;
        InviteToken inviteToken;
        InviteToken inviteToken2 = inviteToken = StringHelper.isNotBlank((Object)publicRegistrationDTO.getInviteToken()) ? this.inviteService.inviteToken(publicRegistrationDTO.getInviteToken()) : null;
        if (publicRegistrationDTO.getExternalPaymentToken() != null) {
            externalPayment = this.externalPaymentService.findByToken(publicRegistrationDTO.getExternalPaymentToken());
            String string = externalPayment.getToPrincipalType().getInternalName();
            if (string.equals(ExistingBuiltInPrincipalType.EMAIL.getInternalName())) {
                publicRegistrationDTO.setEmail(externalPayment.getToPrincipalValue());
            } else if (string.equals(ExistingBuiltInPrincipalType.MOBILE_PHONE.getInternalName())) {
                MobilePhoneDTO mobilePhoneDTO2 = CollectionHelper.orEmpty((List)publicRegistrationDTO.getMobilePhones()).stream().filter(mobilePhoneDTO -> mobilePhoneDTO.getRawNumber().equals(externalPayment.getToPrincipalValue())).findFirst().orElse(new MobilePhoneDTO());
                mobilePhoneDTO2.setVerified(true);
                mobilePhoneDTO2.setRawNumber(externalPayment.getToPrincipalValue());
                publicRegistrationDTO.setMobilePhones(Arrays.asList(mobilePhoneDTO2));
            }
        }
        externalPayment = publicRegistrationDTO.getAttribute("storage") == null ? UserRegistration.PUBLIC : UserRegistration.WIZARD;
        return this.doRegister((AbstractSimpleUserRegistrationDTO)publicRegistrationDTO, (UserRegistration)externalPayment, userValidationFields).additionalActions(registrationResultAccessor -> {
            Collection collection;
            User user = registrationResultAccessor.user();
            ProductsAccessor productsAccessor = this.productsHandler.getAccessor((BasicUser)user);
            List list = productsAccessor.product().getAgreements();
            if (CollectionHelper.isNotEmpty((Iterable)list)) {
                if (publicRegistrationDTO.isAgreement()) {
                    collection = list;
                } else {
                    collection = this.conversionHandler.convertSet(Agreement.class, (Iterable)publicRegistrationDTO.getAgreements());
                    collection.retainAll(list);
                }
                for (Agreement agreement : collection) {
                    this.agreementLogService.accept(agreement, user);
                }
            }
            this.internalIdentityProviderService.finishRegistration(user, publicRegistrationDTO);
            if (inviteToken != null) {
                user.setInvitedBy(inviteToken.getBy());
                if (inviteToken.getBroker() != null) {
                    this.brokeringService.addBroker(user, inviteToken.getBroker(), true, true);
                }
                this.remove(inviteToken);
            }
            if (StringHelper.isNotBlank((Object)publicRegistrationDTO.getUserAgentId())) {
                collection = this.userAgentHandler.parse(this.getSessionData().getRequestData().getRequestInfo());
                UserAgent userAgent = new UserAgent();
                userAgent.setUser((BasicUser)user);
                userAgent.setAgentId(publicRegistrationDTO.getUserAgentId());
                userAgent.setDeviceType(collection.getDeviceType());
                userAgent.setDevice(collection.getDevice());
                userAgent.setOperatingSystem(collection.getOperatingSystem());
                userAgent.setAgent(collection.getAgent());
                userAgent.setUserRegistration(true);
                this.persist((IEntity)userAgent);
            }
        }).endRegistration(registrationResultAccessor -> registrationResultAccessor);
    }

    private RegistrationHandler doRegister(AbstractSimpleUserRegistrationDTO abstractSimpleUserRegistrationDTO, UserRegistration userRegistration, UserValidationFields userValidationFields) {
        SecurityQuestion securityQuestion;
        Object object;
        SessionData sessionData = this.getSessionData();
        this.validate(this.resolveValidator((UserDTO)abstractSimpleUserRegistrationDTO, userRegistration, userValidationFields), abstractSimpleUserRegistrationDTO, "doRegister");
        User user = (User)this.basicUserService.preProcessRegistration((SimpleBasicUserRegistrationDTO)abstractSimpleUserRegistrationDTO, userRegistration);
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor((BasicUser)user);
        ExtensionPointAccessor extensionPointAccessor = this.resolveExtensionPointAccessor(CRUDOperation.CREATE, user);
        extensionPointAccessor.fireValidated();
        List list = this.profileFieldHandler.getFieldsByAction((BasicUser)user, ProfileFieldAction.EDIT);
        this.persist((IEntity)user);
        if (abstractSimpleUserRegistrationDTO instanceof AbstractUserRegistrationDTO && configurationAccessor.getForgotPasswordMode() == ForgotPasswordMode.SECURITY_QUESTION) {
            object = (AbstractUserRegistrationDTO)abstractSimpleUserRegistrationDTO;
            securityQuestion = object.getSecurityQuestion();
            String string = object.getSecurityAnswer();
            if (securityQuestion != null && StringHelper.isNotBlank((Object)string)) {
                SetSecurityQuestionDTO setSecurityQuestionDTO = new SetSecurityQuestionDTO();
                setSecurityQuestionDTO.setSecurityQuestion(securityQuestion);
                setSecurityQuestionDTO.setSecurityAnswer(string);
                this.passwordService.setSecurityQuestion((BasicUser)user, setSecurityQuestionDTO);
                this.flush();
            }
        }
        this.customFieldValueHandler.processAfterSave((EntityWithCustomValues)user);
        if (abstractSimpleUserRegistrationDTO instanceof UserRegistrationDTO) {
            object = (UserRegistrationDTO)abstractSimpleUserRegistrationDTO;
            User user2 = securityQuestion = sessionData.isBroker() ? sessionData.getLoggedUser() : (User)this.conversionHandler.convert(User.class, (Object)object.getBroker());
            if (securityQuestion != null) {
                this.brokeringService.addBroker(user, (User)securityQuestion, true, false);
            }
        }
        this.refresh(user);
        sessionData.ifWraps(GuestSessionData.class, guestSessionData -> guestSessionData.setPublicRegisteredUserId(user.getId()));
        this.basicUserService.persistAdditionalRegistrationData((BasicUser)user, (SimpleBasicUserRegistrationDTO)abstractSimpleUserRegistrationDTO, list);
        this.persistAdditionalRegistrationData(abstractSimpleUserRegistrationDTO, user, list);
        object = this.basicUserService.processRegistration((BasicUser)user, (SimpleBasicUserRegistrationDTO)abstractSimpleUserRegistrationDTO);
        if (user.getImage() == null && configurationAccessor.getDefaultUserImage() != null) {
            securityQuestion = new UserImage();
            securityQuestion.setCategory(user);
            this.storedFileHandler.copy((StoredFile)configurationAccessor.getDefaultUserImage(), (StoredFile)securityQuestion);
            this.userImageService.addImage(user, (UserImage)securityQuestion);
        }
        return new RegistrationHandler(user, (Map<PasswordType, String>)object, extensionPointAccessor);
    }

    private void fill(UserData userData, User user, ProductsAccessor productsAccessor) {
        GroupSet groupSet;
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor((BasicUser)user);
        SessionData sessionData = this.getSessionData();
        userData.setDto((EntityDTO)this.toDTO(user));
        Group group = user.getGroup();
        GroupSet groupSet2 = groupSet = group instanceof UserGroup ? ((UserGroup)group).getGroupSet() : null;
        if (groupSet != null) {
            boolean bl = sessionData.isAdmin();
            if (!bl) {
                if (user.equals((Object)sessionData.getLoggedUser())) {
                    bl = sessionData.getProducts().member().getGroupVisibility() != GroupVisibility.NONE;
                } else {
                    boolean bl2 = bl = sessionData.getProducts().broker().getGroupVisibility() != GroupVisibility.NONE;
                }
            }
            if (bl) {
                userData.setGroupSet((GroupSetVO)this.conversionHandler.convert(GroupSetVO.class, (Object)groupSet));
            }
        }
        userData.setEmailRequired(configurationAccessor.isEmailRequired());
        userData.setNameLabel(this.getNameLabelByConfiguration(configurationAccessor));
        userData.setImageRequired(configurationAccessor.isProfileImageRequired());
        List list = this.profileFieldHandler.getFieldActions((BasicUser)user);
        userData.setProfileFieldActions(list);
        userData.setEnablePrivacy(this.profileFieldHandler.enablePrivacy((BasicUser)user));
        Set set = CollectionHelper.filterByType(list.stream(), UserBasicFieldActions.class).filter(UserProfileFieldActions::isView).map(UserBasicFieldActions::getBasicField).collect(Collectors.toSet());
        List list2 = CollectionHelper.filterByType(list.stream(), UserCustomFieldActions.class).map(UserCustomFieldActions::getCustomField).collect(Collectors.toList());
        HashMap<String, User> hashMap = new HashMap<String, User>();
        hashMap.put("user", user);
        hashMap.put("operator", null);
        this.customFieldValueHandler.fillValuesFromScript(UserCustomField.class, LoadValuesScriptFunction.ENTITY, hashMap, list2);
        this.customFieldValueHandler.setDefaultValues(list2, (ModelWithCustomValues)userData.getDto(), customFieldDetailedVO -> new UserCustomFieldValueDTO((org.cyclos.model.Property)UserCustomFieldValueDTO.FIELD, customFieldDetailedVO));
        List list3 = SortHelper.sortBy((Collection)user.getImages(), (Path)QUserImage.userImage.order);
        userData.setImages(this.conversionHandler.convertList(ImageVO.class, (Iterable)list3));
        if (user.isPersistent()) {
            EditProfileData editProfileData = (EditProfileData)userData;
            UserLocatorVO userLocatorVO = new UserLocatorVO(user.getId());
            if (set.contains(BasicProfileField.EMAIL)) {
                editProfileData.setEmailPendingValidation(user.getNewEmail());
            }
            if (set.contains(BasicProfileField.ADDRESS)) {
                editProfileData.setAddressListData(this.addressService.getAddressListData(userLocatorVO));
            }
            if (set.contains(BasicProfileField.PHONE)) {
                editProfileData.setPhoneListData(this.phoneService.getPhoneListData(userLocatorVO));
            }
            if (this.productsHandler.getAccessor((BasicUser)user).member().getMaxContactInfos() > 0) {
                editProfileData.setContactInfoListData(this.contactInfoService.getContactInfoListData(userLocatorVO, false));
            }
        }
        if (set.contains(BasicProfileField.ADDRESS)) {
            userData.setAddressConfiguration(this.configurationService.toAddressConfiguration(configurationAccessor));
        }
        if (set.contains(BasicProfileField.PHONE)) {
            userData.setPhoneConfiguration(this.configurationService.toPhoneConfiguration(configurationAccessor));
        }
        if (set.contains(BasicProfileField.IMAGE)) {
            userData.setMaxImages(productsAccessor.product().getMaxProfileImages());
        }
    }

    private void fillRegistrationData(AbstractSimpleRegistrationData abstractSimpleRegistrationData, User user, UserRegistration userRegistration) {
        int n;
        AbstractRegistrationData abstractRegistrationData;
        int n2;
        SessionData sessionData = this.getSessionData();
        Group group = user.getGroup();
        ProductsAccessor productsAccessor = this.productsHandler.getAccessor((BasicGroup)group);
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor((BasicGroup)group);
        ProductAccessor productAccessor = productsAccessor.product();
        abstractSimpleRegistrationData.setGroup(this.groupsHandler.toInitialGroupVO(group));
        this.fill((UserData)abstractSimpleRegistrationData, user, productsAccessor);
        UserProfileFieldActions userProfileFieldActions = CustomFieldHelper.findActions((ProfileField)BasicProfileField.ADDRESS, (Iterable)abstractSimpleRegistrationData.getProfileFieldActions());
        UserProfileFieldActions userProfileFieldActions2 = CustomFieldHelper.findActions((ProfileField)BasicProfileField.IMAGE, (Iterable)abstractSimpleRegistrationData.getProfileFieldActions());
        int n3 = n2 = sessionData.isGuest() ? sessionData.getConfiguration().getMaxGuestTempImages() : sessionData.getConfiguration().getMaxUserTempImages();
        if (n2 <= 0 && userProfileFieldActions2 != null) {
            userProfileFieldActions2.setEdit(false);
        }
        this.basicUserService.fillRegistrationData((SimpleBasicUserRegistrationData)abstractSimpleRegistrationData, userRegistration, (BasicUser)user);
        boolean bl = userProfileFieldActions != null && userProfileFieldActions.isEdit() && productAccessor.getMaxAddresses() > 0;
        abstractSimpleRegistrationData.setCanCreateAddress(bl);
        abstractSimpleRegistrationData.setMaxAddresses(productsAccessor.product().getMaxAddresses());
        GroupVO groupVO = new GroupVO(group.getId());
        if (bl) {
            UserAddressDataParams userAddressDataParams = new UserAddressDataParams();
            userAddressDataParams.setGroup(groupVO);
            userAddressDataParams.setSuggestAddressName(true);
            abstractRegistrationData = (UserAddressData)this.addressService.getDataForNew((Object)userAddressDataParams);
            ((UserAddressDTO)abstractRegistrationData.getDto()).setDefaultAddress(true);
            abstractSimpleRegistrationData.setAddressData((UserAddressData)abstractRegistrationData);
        }
        if (abstractSimpleRegistrationData.isCanCreateMobilePhone()) {
            this.fillFirstMobilePhone(user, abstractSimpleRegistrationData.getMobilePhoneData());
        }
        if ((n = productsAccessor.member().getMaxContactInfos()) > 0 && abstractSimpleRegistrationData instanceof AbstractRegistrationData) {
            abstractRegistrationData = (AbstractRegistrationData)abstractSimpleRegistrationData;
            abstractRegistrationData.setCanCreateContactInfos(n > 0);
            abstractRegistrationData.setMaxContactInfos(n);
            abstractRegistrationData.setContactInfoData(this.contactInfoService.getDataForNew(group));
            if (abstractRegistrationData instanceof PublicRegistrationData) {
                abstractRegistrationData.getContactInfoData().getCustomFields().removeIf(customFieldDetailedVO -> customFieldDetailedVO.getType() == CustomFieldType.LINKED_ENTITY);
                ((ContactInfoDTO)abstractRegistrationData.getContactInfoData().getDto()).getCustomValues().removeIf(customFieldValueDTO -> customFieldValueDTO.getField().getType() == CustomFieldType.LINKED_ENTITY);
                if (bl) {
                    abstractRegistrationData.getAddressData().getContactInfoFields().removeIf(customFieldDetailedVO -> customFieldDetailedVO.getType() == CustomFieldType.LINKED_ENTITY);
                    ((UserAddressDTO)abstractRegistrationData.getAddressData().getDto()).getContactInfo().getCustomValues().removeIf(customFieldValueDTO -> customFieldValueDTO.getField().getType() == CustomFieldType.LINKED_ENTITY);
                }
            }
        } else if (bl) {
            abstractSimpleRegistrationData.getAddressData().setContactInfoEnabled(false);
            abstractSimpleRegistrationData.getAddressData().setContactInfoFields(null);
            if (abstractSimpleRegistrationData.getAddressData().getDto() != null) {
                ((UserAddressDTO)abstractSimpleRegistrationData.getAddressData().getDto()).setContactInfo(null);
            }
        }
        boolean bl2 = userProfileFieldActions2 != null && userProfileFieldActions2.isEdit() && productAccessor.getMaxProfileImages() > 0;
        abstractSimpleRegistrationData.setCanCreateImages(bl2);
        if (user.isMember()) {
            boolean bl3 = abstractSimpleRegistrationData instanceof UserRegistrationByMemberData;
            List list = this.principalTypeService.listUserTokenPermissions((UserGroup)group, bl3);
            abstractSimpleRegistrationData.setNfcTokenTypes(list.stream().filter(tokenPermissionsVO -> tokenPermissionsVO.getType().getTokenType().isNFCTag() && tokenPermissionsVO.isActivate()).map(TokenPermissionsVO::getType).collect(Collectors.toList()));
        }
        if (abstractSimpleRegistrationData instanceof AbstractRegistrationData && configurationAccessor.getForgotPasswordMode() == ForgotPasswordMode.SECURITY_QUESTION) {
            SetSecurityQuestionData setSecurityQuestionData = this.passwordService.getSetSecurityQuestionData();
            ((AbstractRegistrationData)abstractSimpleRegistrationData).setSecurityQuestions(setSecurityQuestionData.getSecurityQuestions());
            ((AbstractRegistrationData)abstractSimpleRegistrationData).setRequireSecurityQuestion(configurationAccessor.isRequireSecurityQuestionOnRegistration());
        }
    }

    private EditProfileData getEditProfileData(User user) {
        EditProfileData editProfileData = new EditProfileData();
        this.fill((UserData)editProfileData, user, this.productsHandler.getAccessor((BasicUser)user));
        editProfileData.setDisplay(this.getFormatter().format((BasicUser)user));
        return editProfileData;
    }

    private ReferencePeriodStatisticsVO getGeneralReferenceStatisticsVO(Long l) {
        ReferenceStatisticsParams referenceStatisticsParams = new ReferenceStatisticsParams();
        referenceStatisticsParams.setOwner(new UserLocatorVO(l));
        referenceStatisticsParams.setReferenceType(ReferenceType.RECEIVED);
        referenceStatisticsParams.setPeriods(Arrays.asList(new DatePeriodDTO[]{null}));
        return (ReferencePeriodStatisticsVO)CollectionHelper.first((Iterable)this.generalReferenceService.getStatistics(referenceStatisticsParams).getPeriods());
    }

    private String getNameLabelByConfiguration(ConfigurationAccessor configurationAccessor) {
        String string = configurationAccessor.getNameLabel();
        return StringHelper.isBlank((Object)string) ? this.message(UsersKeys.Users.NAME, new Object[0]) : string;
    }

    private ProfileActionsData getProfileActionsData(ViewProfileData viewProfileData, User user, List<UserAccount> list) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        ProfileActionsData profileActionsData = new ProfileActionsData();
        SessionData sessionData = this.getSessionData();
        boolean bl5 = sessionData.manages((BasicUser)user);
        boolean bl6 = user.isRemoved();
        boolean bl7 = user.equals((Object)sessionData.getLoggedUser());
        if (user.isPendingValidation() && sessionData.hasPermission(Permission.PENDING_USERS_MANAGE)) {
            profileActionsData.setResendRegistrationValidationEmail(true);
            profileActionsData.setManuallyValidateRegistration(true);
        }
        if (user.isTransient() || sessionData.isGuest() || bl7) {
            return profileActionsData;
        }
        if (!bl6) {
            profileActionsData.setCustomOperations(this.conversionHandler.convertList(RunnableCustomOperationVO.class, (Iterable)this.customOperationService.getRunnableOperationsForUser(user)));
            profileActionsData.setWizards(this.conversionHandler.convertList(CustomWizardVO.class, (Iterable)this.customWizardService.listForRun(user)));
        }
        if (user.isPendingValidation()) {
            return profileActionsData;
        }
        ProductsAccessor productsAccessor = sessionData.getProducts();
        ProductsAccessor productsAccessor2 = this.productsHandler.getAccessor((BasicUser)user);
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor((BasicUser)user);
        ProductAccessor productAccessor = productsAccessor2.product();
        profileActionsData.setViewHistoryLog(bl7 || this.profileFieldHandler.getVisibleProfileFields((BasicUser)user).size() > 0);
        if (!bl6) {
            if (bl5) {
                profileActionsData.setManageAddresses(this.profileFieldHandler.isAllowed((BasicUser)user, (ProfileField)BasicProfileField.ADDRESS, ProfileFieldAction.EDIT));
                profileActionsData.setManagePhones(this.profileFieldHandler.isAllowed((BasicUser)user, (ProfileField)BasicProfileField.PHONE, ProfileFieldAction.EDIT));
                profileActionsData.setManageUserImages(this.profileFieldHandler.isAllowed((BasicUser)user, (ProfileField)BasicProfileField.IMAGE, ProfileFieldAction.EDIT));
                profileActionsData.setViewChannelsAccess(sessionData.hasPermission(Permission.USER_CHANNELS_ACCESS_VIEW));
                profileActionsData.setViewPrivacySettings(sessionData.hasPermission(Permission.USER_PRIVACY_SETTINGS_VIEW));
                profileActionsData.setViewQuickAccess(sessionData.hasPermission(Permission.USER_QUICK_ACCESS_SETTINGS_VIEW));
                profileActionsData.setImportTypes(this.importService.importsWithPermission(user));
            }
            if (sessionData.getNetwork() != null && sessionData.hasPermission(Permission.MY_CONTACTS_ENABLE) && (user.isActive() || user.isBlocked())) {
                bl4 = viewProfileData.getContactData() != null;
                profileActionsData.setAddToContactList(!bl4);
                profileActionsData.setRemoveFromContactList(bl4);
            }
            profileActionsData.setSendMessage(this.messageServiceSecurity.canSendMessageToUser(user));
            profileActionsData.setTransactions(this.getProfileTransactionActionsData(user));
            bl4 = sessionData.hasPermission(Permission.USER_ADS_VIEW) && productAccessor.hasPermission(Permission.MY_ADS_ENABLE);
            bl3 = sessionData.hasPermission(Permission.USER_WEB_SHOP_VIEW) && productAccessor.hasPermission(Permission.MY_WEB_SHOP_ENABLE);
            profileActionsData.setViewAds(bl4);
            profileActionsData.setViewWebShop(bl3);
            profileActionsData.setViewUserAds(bl4 || bl3);
            bl2 = sessionData.hasPermission(Permission.USER_FAVORITE_ADS_VIEW) && (bl4 || bl3);
            profileActionsData.setViewFavoriteAds(bl2);
            profileActionsData.setAccessClientTypes(this.conversionHandler.convertList(PrincipalTypeVO.class, (Iterable)this.principalTypeService.listVisibleAccessClients(user)));
            bl = CollectionUtils.intersection((Iterable)this.voucherConfigurationService.listEnabled(user), (Iterable)this.voucherConfigurationService.listVisible(this.getLoggedUser())).stream().anyMatch(voucherConfiguration -> voucherConfiguration.getTopUpType() != null);
            profileActionsData.setVoucherTopUpEnabled(bl);
        }
        bl4 = !user.isPurged() && productAccessor.hasPermission(Permission.MY_REFERENCES_RECEIVE);
        boolean bl8 = bl3 = !user.isPurged() && productAccessor.hasPermission(Permission.MY_TRANSACTION_FEEDBACKS_RECEIVE);
        if (bl5) {
            profileActionsData.setViewReferences(sessionData.hasPermission(Permission.USER_REFERENCES_MANAGE) && bl4);
            profileActionsData.setViewTransactionFeedbacks(sessionData.hasPermission(Permission.USER_TRANSACTION_FEEDBACKS_MANAGE) && bl3);
            profileActionsData.setDisconnect(this.connectedUserService.isOnline((BasicUser)user) && this.hasPermission(Permission.CONNECTED_USERS_MANAGE));
            if (user.isMember() && sessionData.hasPermission(Permission.USER_OPERATORS_VIEW)) {
                profileActionsData.setViewOperators(!user.isRemoved() && productsAccessor2.memberOrBroker().hasPermission(Permission.MY_OPERATORS_ENABLE) || user.isRemoved() && this.operatorService.hasOperators(user));
            }
        } else {
            profileActionsData.setViewReferences(sessionData.hasPermission(Permission.MY_REFERENCES_VIEW) && bl4);
            profileActionsData.setViewTransactionFeedbacks(sessionData.hasPermission(Permission.MY_TRANSACTION_FEEDBACKS_VIEW) && bl3);
        }
        if (bl5 && !bl6) {
            profileActionsData.setViewProducts(this.productsUserServiceSecurity.canViewActiveProducts(user));
            profileActionsData.setViewConfiguration(this.userServiceSecurity.canViewActiveConfiguration(user));
            profileActionsData.setManagePasswords(sessionData.hasPermission(Permission.USER_PASSWORDS_MANAGE));
            profileActionsData.setViewTotpSecret(sessionData.hasPermission(Permission.USER_TOTP_VIEW));
            profileActionsData.setViewTrustedDevices(sessionData.hasPermission(Permission.USER_TRUSTED_DEVICES_VIEW));
            profileActionsData.setResetSecurityQuestion(profileActionsData.isManagePasswords() && configurationAccessor.getForgotPasswordMode() == ForgotPasswordMode.SECURITY_QUESTION);
            if (user.isPendingNewEmailValidation()) {
                profileActionsData.setResendEmailChangeEmail(true);
                bl2 = this.profileFieldHandler.isAllowed((BasicUser)user, (ProfileField)BasicProfileField.EMAIL, ProfileFieldAction.EDIT);
                profileActionsData.setManuallyValidateEmail(bl2);
            }
        }
        profileActionsData.setViewGroupHistory(sessionData.hasPermission(Permission.USER_GROUP_VIEW));
        profileActionsData.setViewOidcAuthorizations(sessionData.hasPermission(Permission.USER_OIDC_AUTHORIZATIONS_VIEW));
        profileActionsData.setViewIdentityProviders(sessionData.hasPermission(Permission.USER_IDENTITY_PROVIDERS_VIEW));
        profileActionsData.setViewStatusHistory(sessionData.hasPermission(Permission.BLOCKED_USERS_MANAGE) || sessionData.hasPermission(Permission.DISABLED_USERS_VIEW) || sessionData.hasPermission(Permission.REMOVED_USERS_VIEW) || sessionData.hasPermission(Permission.PURGED_USERS_VIEW));
        profileActionsData.setPossibleNewStatuses(this.userStatusService.getPossibleNewStatuses((BasicUser)user));
        profileActionsData.setViewRecordTypes(this.recordService.getRecordTypeCount(user));
        if (bl5 && !user.isAdmin()) {
            bl2 = !list.isEmpty();
            profileActionsData.setViewAccounts(bl2);
            profileActionsData.setAccounts(this.conversionHandler.convertList(AccountWithCurrencyVO.class, list));
            profileActionsData.setViewAccountsVisibilitySettings(sessionData.hasPermission(Permission.USER_ACCOUNT_VISIBILITY_VIEW));
            profileActionsData.setViewVouchers(sessionData.hasPermission(Permission.USER_VOUCHERS_VIEW_VOUCHERS));
            profileActionsData.setViewVoucherTransactions(bl2 && sessionData.hasPermission(Permission.USER_VOUCHERS_VIEW_TRANSACTIONS));
            if (!bl6) {
                profileActionsData.setViewCreditLimit(bl2 && sessionData.hasPermission(Permission.USER_ACCOUNT_LIMIT_VIEW));
                profileActionsData.setViewPaymentLimits(bl2 && sessionData.hasPermission(Permission.USER_ACCOUNT_PAYMENT_LIMIT_VIEW));
                profileActionsData.setBuyVouchers(bl2 && sessionData.hasPermission(Permission.USER_VOUCHERS_BUY));
                profileActionsData.setSendVoucher(bl2 && sessionData.hasPermission(Permission.USER_VOUCHERS_SEND));
                profileActionsData.setRedeemVoucher(bl2 && sessionData.hasPermission(Permission.USER_VOUCHERS_REDEEM));
                profileActionsData.setTopUpVoucher(bl2 && sessionData.hasPermission(Permission.USER_VOUCHERS_TOP_UP));
                profileActionsData.setViewNotificationSettings((productAccessor.hasPermission(Permission.MY_NOTIFICATIONS_ENABLE) || productAccessor.hasPermission(Permission.MY_MESSAGES_FORWARD_TO_EMAIL)) && sessionData.hasPermission(Permission.USER_NOTIFICATION_SETTINGS_VIEW));
                profileActionsData.setManageProducts(sessionData.hasPermission(Permission.PRODUCTS_ASSIGN_TO_USER));
            }
            profileActionsData.setTokens(this.principalTypeService.listUserTokenPermissions((BasicUser)user));
            bl = false;
            boolean bl9 = false;
            if (!bl6) {
                List list2 = productsAccessor.product().getDocumentCategoryView();
                list2.retainAll(productAccessor.getDocumentCategoryView());
                bl = sessionData.hasPermission(Permission.DOCUMENTS_VIEW) && CollectionHelper.isNotEmpty((Iterable)list2);
                bl9 = sessionData.hasPermission(Permission.USER_DOCUMENTS_VIEW) && productAccessor.hasPermission(Permission.MY_INDIVIDUAL_DOCUMENTS_VIEW);
                profileActionsData.setViewWebShopSettings(sessionData.hasPermission(Permission.USER_WEB_SHOP_SETTINGS_VIEW) && productAccessor.hasPermission(Permission.MY_WEB_SHOP_ENABLE));
                profileActionsData.setViewBrokers(sessionData.hasPermission(Permission.USER_BROKER_VIEW));
                profileActionsData.setViewBrokeredUsers(user.isBroker() && sessionData.isAdmin());
                profileActionsData.setManageWebShopSettings(sessionData.hasPermission(Permission.USER_WEB_SHOP_SETTINGS_MANAGE) && productAccessor.hasPermission(Permission.MY_WEB_SHOP_ENABLE));
                profileActionsData.setManageAds(sessionData.hasPermission(Permission.USER_ADS_MANAGE) && productAccessor.hasPermission(Permission.MY_ADS_ENABLE));
                profileActionsData.setManagePendingAds(sessionData.hasPermission(Permission.USER_PENDING_ADS_MANAGE) && productsAccessor2.member().isAdsRequireAuthorization());
                profileActionsData.setViewPendingAds(sessionData.hasPermission(Permission.USER_PENDING_ADS_VIEW) && productsAccessor2.member().isAdsRequireAuthorization());
                profileActionsData.setManageWebShop(sessionData.hasPermission(Permission.USER_WEB_SHOP_MANAGE) && productAccessor.hasPermission(Permission.MY_WEB_SHOP_ENABLE));
                profileActionsData.setManagePendingWebShop(sessionData.hasPermission(Permission.USER_PENDING_WEB_SHOP_MANAGE) && productsAccessor2.member().isWebShopAdsRequireAuthorization());
                profileActionsData.setViewPendingWebShop(sessionData.hasPermission(Permission.USER_PENDING_ADS_VIEW) && productsAccessor2.member().isWebShopAdsRequireAuthorization());
                profileActionsData.setPurchase(sessionData.hasPermission(Permission.USER_WEB_SHOP_PURCHASE) && productAccessor.hasPermission(Permission.MY_WEB_SHOP_ENABLE));
                profileActionsData.setViewPurchases(sessionData.hasPermission(Permission.USER_WEB_SHOP_PURCHASES_VIEW) && productAccessor.hasPermission(Permission.USER_WEB_SHOP_VIEW));
                profileActionsData.setViewSales(sessionData.hasPermission(Permission.USER_WEB_SHOP_SALES_VIEW) && productAccessor.hasPermission(Permission.MY_WEB_SHOP_ENABLE));
                profileActionsData.setViewAdInterests(sessionData.hasPermission(Permission.USER_AD_INTERESTS_VIEW) && productAccessor.hasPermission(Permission.MY_AD_INTERESTS_ENABLE));
                profileActionsData.setManageAdInterests(sessionData.hasPermission(Permission.USER_AD_INTERESTS_MANAGE) && productAccessor.hasPermission(Permission.MY_AD_INTERESTS_ENABLE));
                profileActionsData.setViewContacts(sessionData.hasPermission(Permission.USER_CONTACTS_VIEW) && productAccessor.hasPermission(Permission.MY_CONTACTS_ENABLE) && (user.isActive() || user.isBlocked()));
            } else {
                bl = sessionData.hasPermission(Permission.DOCUMENTS_VIEW) && this.documentService.hasSharedDocuments(user);
                bl9 = sessionData.hasPermission(Permission.USER_DOCUMENTS_VIEW) && this.documentService.hasIndividualDocuments(user);
                profileActionsData.setViewDocuments(bl || bl9);
                profileActionsData.setViewPurchases(sessionData.hasPermission(Permission.USER_WEB_SHOP_PURCHASES_VIEW) && this.orderService.hasPurchases(user));
                profileActionsData.setViewSales(sessionData.hasPermission(Permission.USER_WEB_SHOP_SALES_VIEW) && this.orderService.hasSales(user));
            }
            if (bl || bl9) {
                profileActionsData.setViewDocuments(true);
                profileActionsData.setDocumentCount(this.documentService.getDocumentCount(user));
            }
            profileActionsData.setViewAgreementLog(sessionData.hasPermission(Permission.USER_AGREEMENT_LOG_VIEW));
            profileActionsData.setManageUserCustomImages(sessionData.hasPermission(Permission.USER_CUSTOM_IMAGES_MANAGE));
        }
        return profileActionsData;
    }

    private PublicRegistrationData getPublicRegistrationData(User user) {
        ChannelConfiguration channelConfiguration;
        boolean bl = user.getExternalPayment() != null;
        PublicRegistrationData publicRegistrationData = new PublicRegistrationData();
        this.fillRegistrationData((AbstractSimpleRegistrationData)publicRegistrationData, user, UserRegistration.PUBLIC);
        InviteToken inviteToken = this.inviteService.inviteToken(user.getInviteToken());
        if (inviteToken != null) {
            publicRegistrationData.setBroker((UserVO)this.conversionHandler.convert(UserVO.class, (Object)inviteToken.getBroker()));
        }
        ProductsAccessor productsAccessor = this.productsHandler.getAccessor((BasicUser)user);
        publicRegistrationData.setAgreements(this.conversionHandler.convertList(AgreementVO.class, (Iterable)productsAccessor.product().getAgreements()));
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor((BasicUser)user);
        CaptchaConfiguration captchaConfiguration = configurationAccessor.getCaptchaConfiguration();
        if (captchaConfiguration.isUseOnPublicRegistration() && !bl) {
            publicRegistrationData.setCaptchaInput((CaptchaInputDTO)this.conversionHandler.convert(CaptchaInputDTO.class, (Object)captchaConfiguration));
        }
        if ((channelConfiguration = configurationAccessor.getChannelConfiguration(this.getSessionData().getChannel())).getRegistrationWithIdentityProviders().enabled()) {
            publicRegistrationData.setIdentityProviders(this.conversionHandler.convertList(IdentityProviderVO.class, (Iterable)this.identityProviderService.listEnabled((BasicUser)user)));
        }
        if (bl) {
            String string = user.getExternalPayment().getToPrincipalType().getInternalName();
            UserProfileFieldActions userProfileFieldActions = null;
            BasicProfileField basicProfileField = null;
            if (string.equals(ExistingBuiltInPrincipalType.EMAIL.getInternalName())) {
                userProfileFieldActions = CustomFieldHelper.findActions((ProfileField)BasicProfileField.EMAIL, (Iterable)publicRegistrationData.getProfileFieldActions());
                basicProfileField = BasicProfileField.EMAIL;
                publicRegistrationData.setEmailRequired(false);
            } else if (string.equals(ExistingBuiltInPrincipalType.MOBILE_PHONE.getInternalName())) {
                userProfileFieldActions = CustomFieldHelper.findActions((ProfileField)BasicProfileField.PHONE, (Iterable)publicRegistrationData.getProfileFieldActions());
                basicProfileField = BasicProfileField.PHONE;
                publicRegistrationData.setMobileRequired(false);
            }
            if (userProfileFieldActions != null) {
                userProfileFieldActions.setEdit(false);
            } else {
                throw new ValidationException(this.message(UsersKeys.Users.ERROR_PRINCIPAL_REQUIRED_FOR_REGISTRATION, this.message(basicProfileField.getMessageKey(), new Object[0])));
            }
        }
        return publicRegistrationData;
    }

    private SecurityAnswerStatus getSecurityAnswerStatus(User user) {
        Group group = user.getGroup();
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor((BasicGroup)group);
        if (configurationAccessor.getForgotPasswordMode() != ForgotPasswordMode.SECURITY_QUESTION) {
            return SecurityAnswerStatus.NOT_USED;
        }
        return StringHelper.isBlank((Object)user.getSecurityAnswer()) ? SecurityAnswerStatus.PENDING : SecurityAnswerStatus.ACTIVE;
    }

    private ReferencePeriodStatisticsVO getTransactionFeedbackStatisticsVO(Long l) {
        ReferenceStatisticsParams referenceStatisticsParams = new ReferenceStatisticsParams();
        referenceStatisticsParams.setOwner(new UserLocatorVO(l));
        referenceStatisticsParams.setReferenceType(ReferenceType.RECEIVED);
        referenceStatisticsParams.setPeriods(Arrays.asList(new DatePeriodDTO[]{null}));
        return (ReferencePeriodStatisticsVO)CollectionHelper.first((Iterable)this.transactionFeedbackService.getStatistics(referenceStatisticsParams).getPeriods());
    }

    private UserRegistrationByMemberData getUserRegistrationByMemberData(User user) {
        UserRegistrationByMemberData userRegistrationByMemberData = new UserRegistrationByMemberData();
        this.fillRegistrationData((AbstractSimpleRegistrationData)userRegistrationByMemberData, user, UserRegistration.MEMBER);
        return userRegistrationByMemberData;
    }

    private UserRegistrationData getUserRegistrationData(User user) {
        SessionData sessionData = this.getSessionData();
        boolean bl = sessionData.isAdmin();
        boolean bl2 = sessionData.isBroker();
        Set set = this.configurationHandler.getAccessor((BasicUser)user).getEmailValidation();
        boolean bl3 = bl && set.contains(EmailValidation.REGISTRATION_BY_ADMIN) || bl2 && set.contains(EmailValidation.REGISTRATION_BY_BROKER);
        UserRegistrationData userRegistrationData = new UserRegistrationData();
        this.fillRegistrationData((AbstractSimpleRegistrationData)userRegistrationData, user, bl ? UserRegistration.ADMIN : UserRegistration.BROKER);
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor((BasicGroup)user.getGroup());
        boolean bl4 = this.profileFieldHandler.isEnabled((BasicUser)user, (ProfileField)BasicProfileField.EMAIL) && StringHelper.isNotBlank((Object)configurationAccessor.getSmtpConfiguration().getHost());
        userRegistrationData.setAllowSetSendActivationEmail(!bl3 && bl4);
        return userRegistrationData;
    }

    private boolean hasTransferTypes(Object object, Object object2, TransferTypeDirection transferTypeDirection, Collection<PaymentTransferType> collection) {
        TransferTypeQuery transferTypeQuery = new TransferTypeQuery();
        transferTypeQuery.setCountOnly();
        if (object instanceof AccountOwner) {
            transferTypeQuery.setFromOwner((InternalAccountOwner)object);
        } else if (object instanceof AccountTypeNature) {
            transferTypeQuery.setFromNature((AccountTypeNature)object);
        } else if (object != null) {
            throw new IllegalArgumentException("Invalid from argument: " + String.valueOf(object));
        }
        if (object2 instanceof AccountOwner) {
            transferTypeQuery.setToOwner((AccountOwner)((InternalAccountOwner)object2));
        } else if (object2 instanceof AccountTypeNature) {
            transferTypeQuery.setToNature((AccountTypeNature)object2);
        } else if (object2 != null) {
            throw new IllegalArgumentException("Invalid to argument: " + String.valueOf(object2));
        }
        transferTypeQuery.setDirection(transferTypeDirection);
        transferTypeQuery.setChannel(new ChannelVO(this.getSessionData().getChannel().getId()));
        transferTypeQuery.setPossibleTransferTypes(this.conversionHandler.convertSet(TransferTypeVO.class, collection));
        return this.transferTypeService.search(transferTypeQuery).getTotalCount() > 0;
    }

    private void persistAdditionalRegistrationData(AbstractSimpleUserRegistrationDTO abstractSimpleUserRegistrationDTO, User user, List<ProfileField> list) {
        Long l;
        UserAddressDTO userAddressDTO;
        NFCTagWithChallengeDTO nFCTagWithChallengeDTO;
        UserVO userVO = new UserVO(user.getId());
        if (list.contains(BasicProfileField.ADDRESS) && CollectionHelper.isNotEmpty((Iterable)abstractSimpleUserRegistrationDTO.getAddresses())) {
            boolean bl = abstractSimpleUserRegistrationDTO instanceof UserRegistrationByMemberDTO;
            nFCTagWithChallengeDTO = abstractSimpleUserRegistrationDTO.getAddresses().iterator();
            while (nFCTagWithChallengeDTO.hasNext()) {
                userAddressDTO = (UserAddressDTO)nFCTagWithChallengeDTO.next();
                userAddressDTO.setUser(userVO);
                if (bl) {
                    userAddressDTO.setContactInfo(null);
                }
                l = this.addressService.save((EntityDTO)userAddressDTO);
                UserAddress userAddress = (UserAddress)this.rawEntityManagerHandler.find(UserAddress.class, l);
                user.getAddresses().add(userAddress);
            }
        }
        if (abstractSimpleUserRegistrationDTO instanceof AbstractUserRegistrationDTO) {
            AbstractUserRegistrationDTO abstractUserRegistrationDTO = (AbstractUserRegistrationDTO)abstractSimpleUserRegistrationDTO;
            if (this.productsHandler.getAccessor((BasicUser)user).member().getMaxContactInfos() > 0 && CollectionHelper.isNotEmpty((Iterable)abstractUserRegistrationDTO.getContactInfos())) {
                nFCTagWithChallengeDTO = abstractUserRegistrationDTO.getContactInfos().iterator();
                while (nFCTagWithChallengeDTO.hasNext()) {
                    userAddressDTO = (ContactInfoDTO)nFCTagWithChallengeDTO.next();
                    userAddressDTO.setUser(userVO);
                    l = (UserAddress)CollectionHelper.first((Iterable)user.getAddresses());
                    if (l != null) {
                        userAddressDTO.setAddress(new UserAddressVO(l.getId()));
                    }
                    this.contactInfoService.save((EntityDTO)userAddressDTO);
                }
            }
        }
        CaptchaConfiguration captchaConfiguration = this.configurationHandler.getAccessor((BasicUser)user).getCaptchaConfiguration();
        if (user.isAdmin()) {
            this.createAdminNotificationSettings(user);
        }
        if (abstractSimpleUserRegistrationDTO instanceof PublicRegistrationDTO) {
            this.captchaService.removeInternalCaptcha(captchaConfiguration, ((PublicRegistrationDTO)abstractSimpleUserRegistrationDTO).getCaptchaResponse());
        } else if (abstractSimpleUserRegistrationDTO instanceof UserRegistrationDTO) {
            this.saveAccountConfigurations((AbstractUserRegistrationDTO)((UserRegistrationDTO)abstractSimpleUserRegistrationDTO), user);
        }
        if (list.contains(BasicProfileField.IMAGE)) {
            this.userImageService.importTempImages((BaseEntity)user, user.getUploadedImages());
        }
        if ((nFCTagWithChallengeDTO = abstractSimpleUserRegistrationDTO.getNfcToken()) != null) {
            this.tokenService.personalizeNFCTag(nFCTagWithChallengeDTO, (BasicUser)user);
        }
        this.logEntity(null, user);
        this.userGroupService.createInitialGroupHistoryLog(user);
        this.userStatusService.createStatusLog((BasicUser)user);
    }

    private UserRegistration resolveUserRegistration(boolean bl) {
        SessionData sessionData = this.getSessionData();
        if (sessionData.isSystem()) {
            return UserRegistration.POPULATOR;
        }
        if (sessionData.isGuest()) {
            return UserRegistration.PUBLIC;
        }
        if (sessionData.isAdmin()) {
            return UserRegistration.ADMIN;
        }
        if (sessionData.isBroker()) {
            return bl ? UserRegistration.MEMBER : UserRegistration.BROKER;
        }
        if (sessionData.isMember()) {
            return UserRegistration.MEMBER;
        }
        throw new IllegalArgumentException();
    }

    private Validator resolveValidator(UserDTO userDTO, UserRegistration userRegistration, UserValidationFields userValidationFields) {
        User user;
        if (userValidationFields == null) {
            userValidationFields = new UserValidationFields();
        }
        if (userDTO.isPersistent()) {
            user = (User)this.find(userDTO.getId());
            Group group = user.getGroup();
            userDTO.setGroup(new GroupVO(group.getId()));
        } else {
            Group group = (Group)this.conversionHandler.convert(Group.class, (Object)userDTO.getGroup());
            if (group == null) {
                Validator validator = new Validator();
                validator.property((org.cyclos.model.Property)UserDTO.GROUP, UsersKeys.Users.GROUP).required();
                return validator;
            }
            if (group instanceof UserGroup) {
                this.licenseHandler.checkUserRegistration();
            }
            user = new User(group);
            user.setEmail(userDTO.getEmail());
            user.setUsername(userDTO.getUsername());
            user.setRegistrationType(userRegistration);
        }
        Validator validator = new Validator();
        ProductsAccessor productsAccessor = this.productsHandler.getAccessor((BasicUser)user);
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor((BasicUser)user);
        this.basicUserService.addValidations(validator, (BasicUserDTO)userDTO, (BasicUser)user, userValidationFields);
        if (userDTO instanceof AbstractSimpleUserRegistrationDTO) {
            AbstractSimpleUserRegistrationDTO abstractSimpleUserRegistrationDTO = (AbstractSimpleUserRegistrationDTO)userDTO;
            this.basicUserService.addRegistrationValidations(validator, (SimpleBasicUserRegistrationDTO)abstractSimpleUserRegistrationDTO, userRegistration, (BasicUser)user, userValidationFields);
            if (abstractSimpleUserRegistrationDTO instanceof AbstractUserRegistrationDTO) {
                AbstractUserRegistrationDTO abstractUserRegistrationDTO = (AbstractUserRegistrationDTO)abstractSimpleUserRegistrationDTO;
                if (configurationAccessor.getForgotPasswordMode() == ForgotPasswordMode.SECURITY_QUESTION && abstractUserRegistrationDTO.getSecurityQuestion() != null) {
                    validator.property((org.cyclos.model.Property)PublicRegistrationDTO.SECURITY_ANSWER, UsersKeys.Users.PUBLIC_REGISTRATION_SECURITY_QUESTION_ANSWER).required();
                }
                if (userValidationFields.has((ProfileField)BasicProfileField.IMAGE) && configurationAccessor.isProfileImageRequired()) {
                    validator.property((org.cyclos.model.Property)AbstractUserRegistrationDTO.UPLOADED_IMAGES, UsersKeys.Users.IMAGES).required();
                }
                if (abstractSimpleUserRegistrationDTO instanceof PublicRegistrationDTO) {
                    boolean bl;
                    Object object;
                    PublicRegistrationDTO publicRegistrationDTO = (PublicRegistrationDTO)abstractSimpleUserRegistrationDTO;
                    CustomWizardExecutionStorage customWizardExecutionStorage = this.customWizardService.getStorage(publicRegistrationDTO);
                    boolean bl2 = this.internalIdentityProviderService.getRegistrationProfile(publicRegistrationDTO) != null;
                    boolean bl3 = bl2;
                    if (!bl3) {
                        boolean bl4 = bl3 = customWizardExecutionStorage != null && customWizardExecutionStorage.getIdentityProviderId() != null;
                    }
                    if (userValidationFields.isAgreements() && !bl2 && userValidationFields.isAgreements() && !(object = productsAccessor.product().getAgreements()).isEmpty() && !publicRegistrationDTO.isAgreement()) {
                        this.agreementLogService.appendValidations(validator, (List)object, (Collection)publicRegistrationDTO.getAgreements());
                    }
                    object = configurationAccessor.getCaptchaConfiguration();
                    boolean bl5 = bl = customWizardExecutionStorage != null && customWizardExecutionStorage.isCaptchaValidated();
                    if (userValidationFields.isCaptcha() && object.isUseOnPublicRegistration() && !bl3 && !bl && publicRegistrationDTO.getExternalPaymentToken() == null) {
                        validator.property((org.cyclos.model.Property)PublicRegistrationDTO.CAPTCHA_RESPONSE, AccessKeys.Passwords.CAPTCHA).captcha((CaptchaConfiguration)object);
                    }
                } else if (userDTO instanceof UserRegistrationDTO) {
                    this.addAccountNumberValidations(userDTO, validator, configurationAccessor);
                }
            }
        }
        return validator;
    }

    private void saveAccountConfigurations(AbstractUserRegistrationDTO abstractUserRegistrationDTO, User user) {
        List list;
        List list2 = list = abstractUserRegistrationDTO instanceof UserRegistrationDTO ? ((UserRegistrationDTO)abstractUserRegistrationDTO).getAccountConfigurations() : null;
        if (CollectionHelper.isNotEmpty((Iterable)list)) {
            ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor((BasicUser)user);
            AccountNumberConfiguration accountNumberConfiguration = configurationAccessor.getAccountNumberConfiguration();
            boolean bl = accountNumberConfiguration != null && accountNumberConfiguration.isEnabled();
            String string = accountNumberConfiguration.getMask();
            for (UserRegistrationAccountConfigurationDTO userRegistrationAccountConfigurationDTO : list) {
                UserAccountType userAccountType = (UserAccountType)this.conversionHandler.convert(UserAccountType.class, (Object)userRegistrationAccountConfigurationDTO.getAccountType());
                PendingUserAccount pendingUserAccount = new PendingUserAccount(user, userAccountType);
                if (bl) {
                    String string2 = MaskHelper.removeMask((String)string, (String)userRegistrationAccountConfigurationDTO.getAccountNumber());
                    if (string != null && string2 != null && MaskHelper.isValidMaskedValue((String)string, (String)string2)) {
                        string2 = MaskHelper.removeMask((String)string, (String)string2);
                    }
                    if (StringHelper.isBlank((Object)string2)) {
                        string2 = this.accountService.generateNumber((AccountType)userAccountType, (InternalAccountOwner)user);
                    }
                    pendingUserAccount.setNumber(string2);
                }
                pendingUserAccount.setCreditLimit(userRegistrationAccountConfigurationDTO.getCreditLimit());
                pendingUserAccount.setUpperCreditLimit(userRegistrationAccountConfigurationDTO.getUpperCreditLimit());
                pendingUserAccount.setUpperCreditLimitFromProduct(userRegistrationAccountConfigurationDTO.isUpperCreditLimitFromProduct());
                this.persist((IEntity)pendingUserAccount);
            }
        }
    }

    private void setBrokersData(User user, ProductsAccessor productsAccessor, SessionData sessionData, boolean bl, ViewProfileData viewProfileData) {
        User user3 = this.getLoggedUser();
        boolean bl2 = false;
        boolean bl3 = false;
        User user4 = user.getMainBroker();
        if (bl && user.isMember() && user4 != null) {
            Object object;
            Set set = user.getBrokers();
            if (user.equals((Object)user3)) {
                object = productsAccessor.member().getShowBrokers();
                bl2 = object == BrokerVisibility.ALL || object == BrokerVisibility.ONLY_MAIN;
                bl3 = object == BrokerVisibility.ALL;
            } else {
                bl2 = sessionData.hasPermission(Permission.USER_BROKER_VIEW) || user4 != null && user4.equals((Object)user3);
                bl3 = sessionData.hasPermission(Permission.USER_BROKER_VIEW);
            }
            if (bl2) {
                object = this.brokeringService.getActiveBrokering(user, user4);
                viewProfileData.setMainBroker((BrokeringVO)this.conversionHandler.convert(BrokeringVO.class, object));
            }
            object = null;
            if (bl3) {
                ArrayList arrayList = new ArrayList(set);
                if (user4 != null) {
                    arrayList.remove(user4);
                }
                object = this.conversionHandler.convertList(BrokeringVO.class, (Iterable)arrayList.stream().map(user2 -> this.brokeringService.getActiveBrokering(user, user2)).collect(Collectors.toList()));
            }
            if (object != null) {
                viewProfileData.setOtherBrokers(CollectionHelper.sort((Collection)object, Comparator.comparing(brokeringVO -> brokeringVO.getBroker().getDisplay())));
            }
        }
    }

    private static /* synthetic */ void lambda$toDTO$16(Collection collection, UserCustomFieldValue userCustomFieldValue) {
        collection.add(userCustomFieldValue);
    }

    private static /* synthetic */ void lambda$getSearchData$6(HashSet hashSet, ProfileField profileField) {
        if (profileField instanceof CustomFieldDetailedVO) {
            hashSet.add((CustomFieldDetailedVO)profileField);
        }
    }

    private static /* synthetic */ void lambda$getSearchData$5(HashSet hashSet, ProfileField profileField) {
        if (profileField instanceof CustomFieldDetailedVO) {
            hashSet.add((CustomFieldDetailedVO)profileField);
        }
    }

    private static /* synthetic */ boolean lambda$getSearchData$4(UserCustomField userCustomField, ProfileField profileField) {
        return profileField instanceof CustomFieldVO && userCustomField.getId().equals(((CustomFieldVO)profileField).getId());
    }

    private static /* synthetic */ boolean lambda$getSearchData$3(UserCustomField userCustomField, ProfileField profileField) {
        return profileField instanceof CustomFieldVO && userCustomField.getId().equals(((CustomFieldVO)profileField).getId());
    }

    private class RegistrationHandler {
        private Map<PasswordType, String> generatedPasswords;
        private User user;
        private Consumer<RegistrationResultAccessor> additionalActions;
        private ExtensionPointAccessor extensionPoints;

        RegistrationHandler(User user, Map<PasswordType, String> map, ExtensionPointAccessor extensionPointAccessor) {
            this.user = user;
            this.generatedPasswords = map;
            this.extensionPoints = extensionPointAccessor;
        }

        private RegistrationHandler additionalActions(Consumer<RegistrationResultAccessor> consumer) {
            this.additionalActions = consumer;
            return this;
        }

        <T> T endRegistration(Function<RegistrationResultAccessor, T> function) {
            RegistrationResultAccessor registrationResultAccessor = new RegistrationResultAccessor(){

                @Override
                public Map<PasswordType, String> generatedPasswords() {
                    return RegistrationHandler.this.generatedPasswords;
                }

                @Override
                public User user() {
                    return RegistrationHandler.this.user;
                }
            };
            if (this.additionalActions != null) {
                this.additionalActions.accept(registrationResultAccessor);
            }
            this.extensionPoints.fireSaved();
            UserServiceImpl.this.userSearchHandler.index((NetworkedEntity)this.user);
            return function.apply(registrationResultAccessor);
        }
    }

    private static interface RegistrationResultAccessor {
        public Map<PasswordType, String> generatedPasswords();

        public User user();
    }
}

