/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils;

import com.google.zxing.EncodeHintType;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.glxn.qrgen.core.image.ImageType;
import net.glxn.qrgen.javase.QRCode;
import org.cyclos.entities.utils.Dimensions;
import org.cyclos.impl.BaseNetworkedHandlerImpl;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.utils.BarcodeHandler;
import org.cyclos.impl.utils.BarcodeResolution;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.system.images.ImageSize;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.utils.StringHelper;
import org.krysalis.barcode4j.impl.code128.EAN128Bean;
import org.krysalis.barcode4j.output.CanvasProvider;
import org.krysalis.barcode4j.output.bitmap.BitmapCanvasProvider;
import org.springframework.stereotype.Component;

@Component
public class BarcodeHandlerImpl
extends BaseNetworkedHandlerImpl
implements BarcodeHandler {
    public SerializableInputStream barcode(String string, BarcodeResolution barcodeResolution) {
        EAN128Bean eAN128Bean = new EAN128Bean();
        eAN128Bean.setOmitBrackets(true);
        eAN128Bean.setFontSize(2.0);
        BitmapCanvasProvider bitmapCanvasProvider = new BitmapCanvasProvider(barcodeResolution.getResolution(), 12, false, 0);
        eAN128Bean.generateBarcode((CanvasProvider)bitmapCanvasProvider, StringHelper.numbersOnly((String)string));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)bitmapCanvasProvider.getBufferedImage(), ImageType.PNG.name(), byteArrayOutputStream);
        }
        catch (IOException iOException) {
            throw new IllegalActionException();
        }
        return new SerializableInputStream(byteArrayOutputStream.toByteArray());
    }

    public SerializableInputStream qrcode(String string, ImageSize imageSize) {
        if (string == null) {
            return null;
        }
        ConfigurationAccessor configurationAccessor = this.getConfiguration();
        Dimensions dimensions = null;
        switch (imageSize == null ? ImageSize.SMALL : imageSize) {
            case TINY: {
                dimensions = configurationAccessor.getMaxTinyThumbDimensions();
                break;
            }
            case SMALL: {
                dimensions = configurationAccessor.getMaxSmallThumbDimensions();
                break;
            }
            case MEDIUM: {
                dimensions = configurationAccessor.getMaxMediumThumbDimensions();
                break;
            }
            case LARGE: {
                dimensions = configurationAccessor.getMaxImageDimensions();
            }
        }
        if (dimensions == null) {
            return null;
        }
        int n = Math.min(dimensions.getWidth(), dimensions.getHeight());
        ByteArrayOutputStream byteArrayOutputStream = QRCode.from((String)string).to(ImageType.PNG).withCharset("UTF-8").withHint(EncodeHintType.MARGIN, (Object)1).withErrorCorrection(ErrorCorrectionLevel.Q).withSize(n, n).stream();
        return new SerializableInputStream(byteArrayOutputStream.toByteArray());
    }
}

