/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils;

import java.util.List;
import java.util.Map;
import org.cyclos.impl.system.ProfilingEntry;
import org.cyclos.impl.utils.cluster.ClusterHandler;
import org.cyclos.impl.utils.cluster.ClusterHostProfilingResult;
import org.cyclos.impl.utils.cluster.ClusterHostProfilingStats;
import org.cyclos.impl.utils.cluster.ClusterProfilingStats;
import org.cyclos.impl.utils.cluster.ClusterStopProfilingResult;
import org.cyclos.impl.utils.cluster.ProfilingManager;
import org.cyclos.impl.utils.conversion.ConversionHandler;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.system.profiling.StartProfilingParams;
import org.cyclos.server.utils.CyclosProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;

public abstract class BaseProfilingManagerImpl
implements ProfilingManager {
    @Autowired
    protected ClusterHandler clusterHandler;
    @Autowired
    @Lazy
    protected ConversionHandler conversionHandler;
    @Autowired
    protected CyclosProperties cyclosProperties;
    protected volatile ClusterHostProfilingResult profiling;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void collect(ProfilingEntry profilingEntry) {
        if (this.profiling != null) {
            ClusterHostProfilingResult clusterHostProfilingResult = this.profiling;
            synchronized (clusterHostProfilingResult) {
                List list = this.profiling.getEntries();
                if (list.size() >= this.cyclosProperties.getProfilingMaxEntries()) {
                    list.remove(0);
                    this.profiling.incrementDiscarded();
                }
                list.add(profilingEntry);
            }
        }
    }

    public final ClusterProfilingStats current() {
        StartProfilingParams startProfilingParams = this.getStartParams();
        if (startProfilingParams == null) {
            return null;
        }
        ClusterProfilingStats clusterProfilingStats = new ClusterProfilingStats();
        clusterProfilingStats.setParams(startProfilingParams);
        clusterProfilingStats.setStatsByHost(this.doGetStatsByHost());
        return clusterProfilingStats;
    }

    public ClusterHostProfilingResult getProfiling() {
        return this.profiling;
    }

    public final void start(StartProfilingParams startProfilingParams) {
        StartProfilingParams startProfilingParams2 = this.getStartParams();
        if (startProfilingParams2 != null) {
            throw new IllegalActionException("Profiling is already running");
        }
        this.storeStartParams(startProfilingParams);
    }

    public final ClusterStopProfilingResult stop() {
        StartProfilingParams startProfilingParams = this.getStartParams();
        if (startProfilingParams == null) {
            throw new IllegalActionException("Profiling not running");
        }
        ClusterStopProfilingResult clusterStopProfilingResult = new ClusterStopProfilingResult();
        clusterStopProfilingResult.setParams(startProfilingParams);
        clusterStopProfilingResult.setResultsByHost(this.doGetResultsByHost());
        this.storeStartParams(null);
        return clusterStopProfilingResult;
    }

    protected abstract Map<String, ClusterHostProfilingResult> doGetResultsByHost();

    protected abstract Map<String, ClusterHostProfilingStats> doGetStatsByHost();

    protected abstract void storeStartParams(StartProfilingParams var1);
}

