/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import org.cyclos.server.utils.ServerImageHelper;

public class CompressImages {
    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.out.println("Missing the directory where the images are stored");
            System.exit(1);
        }
        File file = new File(stringArray[0]);
        FileUtils.listFiles((File)file, (String[])new String[]{"png"}, (boolean)true).stream().forEach(CompressImages::compress);
    }

    private static void compress(File file) {
        File file2;
        block7: {
            BufferedImage bufferedImage;
            block6: {
                file2 = null;
                bufferedImage = ImageIO.read(file);
                if (bufferedImage != null) break block6;
                System.out.println("No image could be read from " + String.valueOf(file));
                FileUtils.deleteQuietly((File)file2);
                return;
            }
            try {
                file2 = File.createTempFile("image", ".png");
                ServerImageHelper.write((BufferedImage)bufferedImage, (ServerImageHelper.ImageType)ServerImageHelper.ImageType.PNG, (File)file2, (int)0);
                if (FileUtils.contentEquals((File)file, (File)file2)) {
                    System.out.println("The file " + String.valueOf(file) + " is already compressed");
                    break block7;
                }
                long l = file.length();
                file.delete();
                FileUtils.moveFile((File)file2, (File)file);
                long l2 = file.length();
                System.out.printf("The file %s has been compressed from %s (%d) to %s (%d)\n", file, FileUtils.byteCountToDisplaySize((long)l), l, FileUtils.byteCountToDisplaySize((long)l2), l2);
            }
            catch (IOException iOException) {
                try {
                    throw new UncheckedIOException(iOException);
                }
                catch (Throwable throwable) {
                    FileUtils.deleteQuietly(file2);
                    throw throwable;
                }
            }
        }
        FileUtils.deleteQuietly((File)file2);
    }
}

