/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class IdCipher {
    private List<Round> rounds = new ArrayList<Round>();

    public void addRound(long l, int n) {
        this.rounds.add(new Round(l, n));
    }

    public long cipher(long l) {
        for (Round round : this.rounds) {
            l = round.forward(l);
        }
        return l;
    }

    public long uncipher(long l) {
        ListIterator<Round> listIterator = this.rounds.listIterator(this.rounds.size());
        while (listIterator.hasPrevious()) {
            Round round = listIterator.previous();
            l = round.reverse(l);
        }
        return l;
    }

    private static class Round {
        private long mask;
        private int rotateBits;

        public Round(long l, int n) {
            this.mask = l;
            this.rotateBits = n;
        }

        public long forward(long l) {
            return Long.rotateRight(l, this.rotateBits) ^ this.mask;
        }

        public long reverse(long l) {
            return Long.rotateLeft(l ^ this.mask, this.rotateBits);
        }
    }
}

