/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils;

import com.querydsl.core.types.Path;
import java.util.Objects;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.system.InternetAddressList;
import org.cyclos.impl.BaseGlobalHandlerImpl;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.system.InternetAddressResolutionRecurringTask;
import org.cyclos.impl.system.IpAddressServiceLocal;
import org.cyclos.impl.utils.InternetAddressListHandler;
import org.cyclos.impl.utils.tasks.RecurringTaskHandler;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.IEntity;
import org.cyclos.model.system.ipaddresses.IpAddressStatus;
import org.cyclos.server.utils.InternetAddressHelper;
import org.cyclos.server.utils.PropertyHelper;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class InternetAddressListHandlerImpl
extends BaseGlobalHandlerImpl
implements InternetAddressListHandler {
    @Autowired
    private RecurringTaskHandler recurringTaskHandler;
    @Autowired
    private IpAddressServiceLocal ipAddressService;

    public boolean isWhitelisted(InternetAddressList internetAddressList, String string) {
        try {
            IpAddressStatus ipAddressStatus = this.ipAddressService.findByAddress(string).getStatus();
            return ipAddressStatus.allowsAccess();
        }
        catch (EntityNotFoundException entityNotFoundException) {
            if (internetAddressList == null) {
                return true;
            }
            String string2 = InternetAddressHelper.normalize((String)string);
            return string2 != null && internetAddressList.getResolvedAddresses().contains(string2);
        }
    }

    public InternetAddressList setInternetAddressList(SimpleEntity simpleEntity, Path<InternetAddressList> path, String string) {
        String string2;
        BeanWrapper beanWrapper = InvocationContext.wrap((Object)simpleEntity);
        String string3 = PropertyHelper.getPropertyName(path);
        InternetAddressList internetAddressList = (InternetAddressList)beanWrapper.getPropertyValue(string3);
        if (StringHelper.isBlank((Object)string)) {
            if (internetAddressList != null) {
                beanWrapper.setPropertyValue(string3, null);
                this.remove((IEntity)internetAddressList);
            }
            return null;
        }
        String string4 = string2 = internetAddressList == null ? null : internetAddressList.getAddresses();
        if (!Objects.equals(string, string2)) {
            if (internetAddressList == null) {
                internetAddressList = new InternetAddressList();
                internetAddressList.setAddresses(string);
                this.persist((IEntity)internetAddressList);
                beanWrapper.setPropertyValue(string3, (Object)internetAddressList);
            } else {
                internetAddressList.setAddresses(string);
                internetAddressList.setLastResolutionDate(null);
            }
            this.recurringTaskHandler.scheduleAwake(InternetAddressResolutionRecurringTask.class);
        }
        return internetAddressList;
    }
}

