/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils;

import com.google.common.cache.Cache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.cyclos.impl.utils.AbstractPushNotificationHandlerImpl;
import org.cyclos.impl.utils.PushNotificationEventContext;
import org.cyclos.impl.utils.PushNotificationSubscriptionMatcher;
import org.cyclos.impl.utils.cluster.PushNotificationSubscription;
import org.cyclos.model.utils.PushNotificationEvent;
import org.cyclos.utils.CollectionHelper;

public class NoClusterPushNotificationHandlerImpl
extends AbstractPushNotificationHandlerImpl<LocalPushNotificationSubscription> {
    private Cache<String, LocalPushNotificationSubscription> subscriptions;

    @Override
    public void close(String string) {
        this.subscriptions.invalidate((Object)string);
    }

    public void doDispatch(PushNotificationSubscription pushNotificationSubscription, PushNotificationEvent<?> pushNotificationEvent) {
        LocalPushNotificationSubscription localPushNotificationSubscription = pushNotificationSubscription instanceof LocalPushNotificationSubscription ? (LocalPushNotificationSubscription)pushNotificationSubscription : this.subscriptionForId(pushNotificationSubscription.getId());
        if (localPushNotificationSubscription != null) {
            localPushNotificationSubscription.getListener().accept(pushNotificationEvent);
        }
    }

    public LocalPushNotificationSubscription getLocalData(PushNotificationSubscription pushNotificationSubscription) {
        return (LocalPushNotificationSubscription)((Object)this.subscriptions.getIfPresent((Object)pushNotificationSubscription.getId()));
    }

    @PostConstruct
    public void initialize() {
        this.subscriptions = this.newCache();
    }

    public void invalidate(String string) {
        this.subscriptions.invalidate((Object)string);
    }

    @Override
    public LocalPushNotificationSubscription subscriptionForClientId(String string) {
        LocalPushNotificationSubscription localPushNotificationSubscription = (LocalPushNotificationSubscription)((Object)this.subscriptions.getIfPresent((Object)string));
        if (localPushNotificationSubscription == null) {
            localPushNotificationSubscription = this.subscriptions.asMap().entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(string + "@")).map(Map.Entry::getValue).findAny().orElse(null);
        }
        return localPushNotificationSubscription;
    }

    @Override
    public LocalPushNotificationSubscription subscriptionForId(String string) {
        return (LocalPushNotificationSubscription)((Object)this.subscriptions.getIfPresent((Object)string));
    }

    @Override
    protected void addMissedEvent(LocalPushNotificationSubscription localPushNotificationSubscription, PushNotificationEvent<?> pushNotificationEvent) {
        localPushNotificationSubscription.addMissedEvent(pushNotificationEvent);
    }

    @Override
    protected void connect(PushNotificationSubscription pushNotificationSubscription, Consumer<PushNotificationEvent<?>> consumer) {
        LocalPushNotificationSubscription localPushNotificationSubscription;
        if (pushNotificationSubscription instanceof LocalPushNotificationSubscription) {
            localPushNotificationSubscription = (LocalPushNotificationSubscription)pushNotificationSubscription;
            localPushNotificationSubscription.setListener(consumer);
        } else {
            localPushNotificationSubscription = new LocalPushNotificationSubscription(pushNotificationSubscription, consumer);
        }
        this.subscriptions.put((Object)pushNotificationSubscription.getId(), (Object)localPushNotificationSubscription);
    }

    @Override
    protected Long getCloseAfter(LocalPushNotificationSubscription localPushNotificationSubscription) {
        return localPushNotificationSubscription.getCloseAfter();
    }

    @Override
    protected AbstractPushNotificationHandlerImpl.SubscriptionMatchResult<LocalPushNotificationSubscription> matchingSubscriptions(PushNotificationEventContext<?> pushNotificationEventContext) {
        final List list = this.subscriptions.asMap().values().stream().filter(localPushNotificationSubscription -> localPushNotificationSubscription.matches(pushNotificationEventContext)).collect(Collectors.toList());
        return new AbstractPushNotificationHandlerImpl.SubscriptionMatchResult<LocalPushNotificationSubscription>(){

            @Override
            public Collection<LocalPushNotificationSubscription> getMatches() {
                return list;
            }

            @Override
            public void publish(PushNotificationEvent<?> pushNotificationEvent) {
                list.forEach(localPushNotificationSubscription -> NoClusterPushNotificationHandlerImpl.this.dispatch(localPushNotificationSubscription, pushNotificationEvent));
            }
        };
    }

    @Override
    protected LocalPushNotificationSubscription newSubscription(String string, String string2, PushNotificationSubscriptionMatcher pushNotificationSubscriptionMatcher) {
        return new LocalPushNotificationSubscription(string, string2, pushNotificationSubscriptionMatcher);
    }

    @Override
    protected void reconnect(LocalPushNotificationSubscription localPushNotificationSubscription, Consumer<PushNotificationEvent<?>> consumer) {
        localPushNotificationSubscription.setListener(consumer);
        List<PushNotificationEvent<?>> list = localPushNotificationSubscription.getAndClearMissedEvents();
        if (CollectionHelper.isNotEmpty(list)) {
            this.invokerHandler.getExecutorService().submit(() -> list.forEach(consumer::accept));
        }
    }

    @Override
    protected void setCloseAfter(LocalPushNotificationSubscription localPushNotificationSubscription, Long l) {
        localPushNotificationSubscription.setCloseAfter(l);
    }

    public static class LocalPushNotificationSubscription
    extends PushNotificationSubscription {
        private static final long serialVersionUID = 1L;
        private Consumer<PushNotificationEvent<?>> listener;
        private Long closeAfter;
        private volatile List<PushNotificationEvent<?>> missedEvents;

        public LocalPushNotificationSubscription(PushNotificationSubscription pushNotificationSubscription, Consumer<PushNotificationEvent<?>> consumer) {
            this(pushNotificationSubscription.getId(), pushNotificationSubscription.getClientId(), pushNotificationSubscription.getMatcher());
            this.listener = consumer;
        }

        public LocalPushNotificationSubscription(String string, String string2, PushNotificationSubscriptionMatcher pushNotificationSubscriptionMatcher) {
            super(string, string2, pushNotificationSubscriptionMatcher);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addMissedEvent(PushNotificationEvent<?> pushNotificationEvent) {
            if (this.missedEvents == null) {
                LocalPushNotificationSubscription localPushNotificationSubscription = this;
                synchronized (localPushNotificationSubscription) {
                    if (this.missedEvents == null) {
                        this.missedEvents = Collections.synchronizedList(new ArrayList());
                    }
                }
            }
            this.missedEvents.add(pushNotificationEvent);
        }

        public synchronized List<PushNotificationEvent<?>> getAndClearMissedEvents() {
            List<PushNotificationEvent<?>> list = this.missedEvents;
            this.missedEvents = null;
            return CollectionHelper.orEmpty(list);
        }

        public Long getCloseAfter() {
            return this.closeAfter;
        }

        public Consumer<PushNotificationEvent<?>> getListener() {
            return this.listener;
        }

        public boolean isTimedOut() {
            return this.closeAfter != null;
        }

        public void setCloseAfter(Long l) {
            this.closeAfter = l;
        }

        public void setListener(Consumer<PushNotificationEvent<?>> consumer) {
            this.listener = consumer;
        }
    }
}

