/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils;

import java.util.Collection;
import java.util.Set;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.users.Group;
import org.cyclos.entities.users.User;
import org.cyclos.impl.search.opensearch.QueryAccessor;
import org.cyclos.impl.utils.AbstractUserVisibilityApplier;
import org.cyclos.model.users.users.UserWithFieldsVO;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;

public class OpenSearchUserVisibilityApplier
extends AbstractUserVisibilityApplier {
    private QueryAccessor query;

    public OpenSearchUserVisibilityApplier(QueryAccessor queryAccessor) {
        this.query = queryAccessor;
    }

    @Override
    protected void applyBrokerOrSelf(User user) {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.should(this.brokerBuilder(user));
        boolQueryBuilder.should(this.selfBuilder(user));
        this.query.filter((QueryBuilder)boolQueryBuilder);
    }

    @Override
    protected void applyGroups(Set<Group> set) {
        this.query.filter(this.groupsBuilder(set));
    }

    @Override
    protected void applyGroupsOrBrokerOrSelf(Set<Group> set, User user) {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.should(this.groupsBuilder(set));
        boolQueryBuilder.should(this.brokerBuilder(user));
        boolQueryBuilder.should(this.selfBuilder(user));
        this.query.filter((QueryBuilder)boolQueryBuilder);
    }

    @Override
    protected void applyGroupsOrSelf(Set<Group> set, User user) {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.should(this.groupsBuilder(set));
        boolQueryBuilder.should(this.selfBuilder(user));
        this.query.filter((QueryBuilder)boolQueryBuilder);
    }

    @Override
    protected void applySelf(User user) {
        this.query.filter(this.selfBuilder(user));
    }

    @Override
    protected void bogusCondition() {
        this.query.invalid();
    }

    private QueryBuilder brokerBuilder(User user) {
        Long l = user.getId();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)UserWithFieldsVO.MAIN_BROKER.getName(), (Object)l));
        boolQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"otherBrokers", (Object)l));
        return boolQueryBuilder;
    }

    private QueryBuilder groupsBuilder(Set<Group> set) {
        Set set2 = SimpleEntity.uniqueIds(set);
        return QueryBuilders.termsQuery((String)UserWithFieldsVO.GROUP.getName(), (Collection)set2);
    }

    private QueryBuilder selfBuilder(User user) {
        return QueryBuilders.termQuery((String)"owner", (String)user.getId().toString());
    }
}

