/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils;

import com.google.i18n.phonenumbers.NumberParseException;
import com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.google.i18n.phonenumbers.Phonenumber;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.cyclos.entities.system.CustomScriptConfiguration;
import org.cyclos.entities.users.Phone;
import org.cyclos.impl.BaseNetworkedHandlerImpl;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.system.CustomScriptServiceLocal;
import org.cyclos.impl.utils.PhoneNumberData;
import org.cyclos.impl.utils.PhoneNumberDescriptor;
import org.cyclos.impl.utils.PhoneNumberHandler;
import org.cyclos.model.system.scripts.CustomScriptException;
import org.cyclos.model.system.scripts.PhoneNumberHandlingScriptFunction;
import org.cyclos.model.system.scripts.ScriptFunction;
import org.cyclos.model.users.phones.PhoneNature;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.StringHelper;
import org.cyclos.utils.coercion.CoercionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PhoneNumberHandlerImpl
extends BaseNetworkedHandlerImpl
implements PhoneNumberHandler {
    private static final PhoneNumberUtil UTIL = PhoneNumberUtil.getInstance();
    private static final Map<String, String> COUNTRY_TO_REGION_MAP;
    private static final Pattern E164;
    @Autowired
    private CustomScriptServiceLocal customScriptService;

    private static String toRegionCode(String string) {
        String string2 = COUNTRY_TO_REGION_MAP.get(string);
        return string2 == null ? string : string2;
    }

    public int getCountryCode(String string) {
        String string2 = PhoneNumberHandlerImpl.toRegionCode(string);
        return UTIL.getCountryCodeForRegion(string2);
    }

    public String getExampleNumber(PhoneNature phoneNature, ConfigurationAccessor configurationAccessor) {
        Object object;
        String string = PhoneNumberHandlerImpl.toRegionCode(configurationAccessor.getCountry());
        CustomScriptConfiguration customScriptConfiguration = configurationAccessor.getPhoneNumberHandlingConfiguration();
        if (customScriptConfiguration != null && customScriptConfiguration.getScript() != null && (object = (String)this.customScriptService.newAccessor(customScriptConfiguration.getScript(), customScriptConfiguration.getScriptParameters()).bind("country", (Object)string).bind("mobile", (Object)(phoneNature == PhoneNature.MOBILE ? 1 : 0)).bind("landLine", (Object)(phoneNature == PhoneNature.LANDLINE ? 1 : 0)).run(String.class, (ScriptFunction)PhoneNumberHandlingScriptFunction.EXAMPLE)) != null) {
            return object;
        }
        object = phoneNature == PhoneNature.LANDLINE ? PhoneNumberUtil.PhoneNumberType.FIXED_LINE : PhoneNumberUtil.PhoneNumberType.MOBILE;
        Phonenumber.PhoneNumber phoneNumber = UTIL.getExampleNumberForType(string, object);
        return UTIL.format(phoneNumber, PhoneNumberUtil.PhoneNumberFormat.NATIONAL);
    }

    public PhoneNumberDescriptor parse(String string, ConfigurationAccessor configurationAccessor) throws CoercionException {
        Object object;
        if ((string = StringHelper.trimToNull((Object)string)) == null) {
            return null;
        }
        String string2 = PhoneNumberHandlerImpl.toRegionCode(configurationAccessor.getCountry());
        CustomScriptConfiguration customScriptConfiguration = configurationAccessor.getPhoneNumberHandlingConfiguration();
        if (customScriptConfiguration != null && customScriptConfiguration.getScript() != null) {
            object = this.customScriptService.newAccessor(customScriptConfiguration.getScript(), customScriptConfiguration.getScriptParameters()).bind("country", (Object)string2).bind("number", (Object)string).run((ScriptFunction)PhoneNumberHandlingScriptFunction.PARSE);
            if (Boolean.FALSE.equals(object)) {
                return null;
            }
            if (object instanceof PhoneNumberDescriptor) {
                return (PhoneNumberDescriptor)object;
            }
            if (object != null) {
                PhoneNumberData phoneNumberData = (PhoneNumberData)this.conversionHandler.convert(PhoneNumberData.class, object);
                String string3 = phoneNumberData.getE164();
                if (StringHelper.isBlank((Object)string3) || !E164.matcher(string3).matches()) {
                    throw new CustomScriptException("The script " + customScriptConfiguration.getScript().getName() + " returned a number without a valid E164 format");
                }
                if (!phoneNumberData.isLandLine() && !phoneNumberData.isMobile()) {
                    throw new CustomScriptException("The script " + customScriptConfiguration.getScript().getName() + " returned a number without data for landline / mobile");
                }
                if (StringHelper.isBlank((Object)phoneNumberData.getInternational())) {
                    phoneNumberData.setInternational(string3);
                }
                if (StringHelper.isBlank((Object)phoneNumberData.getNational())) {
                    phoneNumberData.setNational(phoneNumberData.getInternational());
                }
                return new PhoneNumberDescriptorDataImpl(phoneNumberData, string, UTIL.getCountryCodeForRegion(string2));
            }
        }
        object = null;
        try {
            object = UTIL.parse((CharSequence)string, string2);
            if (!UTIL.isValidNumber(object)) {
                object = null;
            }
        }
        catch (NumberParseException numberParseException) {
            object = null;
        }
        return object == null ? null : new PhoneNumberDescriptorLibImpl((Phonenumber.PhoneNumber)object, string);
    }

    public PhoneNumberDescriptor toDescriptor(Phone phone) {
        if (phone == null) {
            return null;
        }
        String string = (String)ObjectHelper.defaultValue((Object)phone.getNormalizedNumber(), (Object)phone.getRawNumber());
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor(phone.getUser());
        return this.parse(string, configurationAccessor);
    }

    static {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("AN", "BQ");
        hashMap.put("AQ", "NF");
        hashMap.put("BU", "MM");
        hashMap.put("BV", "NO");
        hashMap.put("CS", "RS");
        hashMap.put("GS", "FK");
        hashMap.put("HM", "NF");
        hashMap.put("PN", "NZ");
        hashMap.put("TF", "MQ");
        hashMap.put("TP", "TL");
        hashMap.put("UM", "US");
        hashMap.put("YU", "HR");
        COUNTRY_TO_REGION_MAP = Collections.unmodifiableMap(hashMap);
        E164 = Pattern.compile("\\+\\d{5,30}");
    }

    private class PhoneNumberDescriptorDataImpl
    implements PhoneNumberDescriptor {
        private final PhoneNumberData pojo;
        private final int countryCode;
        private final String rawNumber;

        public PhoneNumberDescriptorDataImpl(PhoneNumberData phoneNumberData, String string, int n) {
            this.pojo = phoneNumberData;
            this.rawNumber = string;
            this.countryCode = n;
        }

        public int getCountryCode() {
            return this.countryCode;
        }

        public String getRawNumber() {
            return this.rawNumber;
        }

        public boolean isCustom() {
            return true;
        }

        public boolean isLandLine() {
            return this.pojo.isLandLine();
        }

        public boolean isMobile() {
            return this.pojo.isMobile();
        }

        public String toE164() {
            return this.pojo.getE164();
        }

        public String toInternationalFormat() {
            return this.pojo.getInternational();
        }

        public String toNationalFormat() {
            return this.pojo.getNational();
        }

        public String toString() {
            return this.rawNumber;
        }
    }

    private class PhoneNumberDescriptorLibImpl
    implements PhoneNumberDescriptor {
        private final Phonenumber.PhoneNumber phoneNumber;
        private final String rawNumber;

        public PhoneNumberDescriptorLibImpl(Phonenumber.PhoneNumber phoneNumber, String string) {
            this.phoneNumber = phoneNumber;
            this.rawNumber = string;
        }

        public int getCountryCode() {
            return this.phoneNumber.getCountryCode();
        }

        public String getRawNumber() {
            return this.rawNumber;
        }

        public boolean isCustom() {
            return false;
        }

        public boolean isLandLine() {
            PhoneNumberUtil.PhoneNumberType phoneNumberType = UTIL.getNumberType(this.phoneNumber);
            return phoneNumberType != PhoneNumberUtil.PhoneNumberType.MOBILE;
        }

        public boolean isMobile() {
            PhoneNumberUtil.PhoneNumberType phoneNumberType = UTIL.getNumberType(this.phoneNumber);
            return ObjectHelper.isOneOf((Object)phoneNumberType, (Object[])new Object[]{PhoneNumberUtil.PhoneNumberType.MOBILE, PhoneNumberUtil.PhoneNumberType.FIXED_LINE_OR_MOBILE, PhoneNumberUtil.PhoneNumberType.UNKNOWN});
        }

        public String toE164() {
            return UTIL.format(this.phoneNumber, PhoneNumberUtil.PhoneNumberFormat.E164);
        }

        public String toInternationalFormat() {
            return UTIL.format(this.phoneNumber, PhoneNumberUtil.PhoneNumberFormat.INTERNATIONAL);
        }

        public String toNationalFormat() {
            return UTIL.format(this.phoneNumber, PhoneNumberUtil.PhoneNumberFormat.NATIONAL);
        }

        public String toString() {
            return this.rawNumber;
        }
    }
}

