/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.cyclos.model.access.RequestData;
import org.cyclos.model.utils.CookieInfo;
import org.cyclos.model.utils.RequestInfo;
import org.cyclos.model.utils.ResponseInfo;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.ParameterStorage;
import org.pac4j.core.context.Cookie;
import org.pac4j.core.context.WebContext;

public class RequestInfoWebContext
implements WebContext {
    private final RequestData requestData;
    private final RequestInfo request;
    private final ResponseInfo response;

    public RequestInfoWebContext(RequestData requestData, RequestInfo requestInfo, ResponseInfo responseInfo) {
        this.requestData = requestData;
        this.request = requestInfo;
        this.response = responseInfo;
    }

    public void addResponseCookie(Cookie cookie) {
        CookieInfo cookieInfo = new CookieInfo(cookie.getName(), cookie.getValue());
        cookieInfo.setDomain(cookie.getDomain());
        cookieInfo.setHttpOnly(cookie.isHttpOnly());
        cookieInfo.setMaxAge(cookie.getMaxAge());
        cookieInfo.setPath(cookie.getPath());
        cookieInfo.setSecure(cookie.isSecure());
        this.response.addCookie(cookieInfo);
    }

    public String getFullRequestURL() {
        return this.requestData.getBaseUrl() + "/" + this.requestData.getUri();
    }

    public String getPath() {
        return this.requestData.getUri();
    }

    public String getRemoteAddr() {
        return this.requestData.getRemoteAddress();
    }

    public RequestInfo getRequest() {
        return this.request;
    }

    public Optional<?> getRequestAttribute(String string) {
        return Optional.ofNullable(this.request.getAttribute(string));
    }

    public Collection<Cookie> getRequestCookies() {
        ParameterStorage parameterStorage = this.request.getCookies();
        return CollectionHelper.asStream((Iterator)parameterStorage.getNames()).map(string -> new Cookie(string, parameterStorage.getString(string))).collect(Collectors.toList());
    }

    public Optional<String> getRequestHeader(String string) {
        return Optional.ofNullable(this.request.getHeader(string));
    }

    public String getRequestMethod() {
        return this.request.getMethod();
    }

    public Optional<String> getRequestParameter(String string) {
        return Optional.ofNullable(this.request.getParameter(string));
    }

    public Map<String, String[]> getRequestParameters() {
        ParameterStorage parameterStorage = this.request.getParameters();
        String[] stringArray = new String[]{};
        return CollectionHelper.asStream((Iterator)parameterStorage.getNames()).collect(Collectors.toMap(string -> string, string -> parameterStorage.getStringList(string).toArray(stringArray)));
    }

    public Optional<String> getResponseHeader(String string) {
        return Optional.ofNullable(this.response.getHeaders().getString(string));
    }

    public String getScheme() {
        String string = this.requestData.getBaseUrl();
        int n = string.indexOf(":");
        return string.substring(0, n);
    }

    public String getServerName() {
        try {
            return new URL(this.requestData.getBaseUrl()).getHost();
        }
        catch (MalformedURLException malformedURLException) {
            return "localhost";
        }
    }

    public int getServerPort() {
        try {
            return new URL(this.requestData.getBaseUrl()).getPort();
        }
        catch (MalformedURLException malformedURLException) {
            return this.isSecure() ? 443 : 80;
        }
    }

    public boolean isSecure() {
        return this.requestData.isSecure();
    }

    public void setRequestAttribute(String string, Object object) {
        this.request.setAttribute(string, object);
    }

    public void setResponseContentType(String string) {
        this.response.setHeader("Content-Type", string);
    }

    public void setResponseHeader(String string, String string2) {
        this.response.setHeader(string, string2);
    }
}

