/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.cyclos.impl.utils.RestBeanPropertyMapping;
import org.cyclos.model.Bean;
import org.cyclos.model.Property;
import org.springframework.stereotype.Component;

@Component
public class RestBeanPropertyMappingImpl
implements RestBeanPropertyMapping {
    private Map<Property<?, ?>, Function<Bean, String>> mappings = new ConcurrentHashMap();

    public <B extends Bean> void register(Property<?, ? super B> property, Function<B, String> function) {
        this.mappings.put(property, function);
    }

    public void register(Property<?, ?> property, String string) {
        this.mappings.put(property, new DirectMapper(string));
    }

    public <B extends Bean> String restProperty(Property<?, ? super B> property, B b) {
        Function<Bean, String> function = this.mappings.get(property);
        return function == null ? property.getName() : function.apply(b);
    }

    private static class DirectMapper
    implements Function<Bean, String> {
        private final String restProperty;

        public DirectMapper(String string) {
            this.restProperty = string;
        }

        @Override
        public String apply(Bean bean) {
            return this.restProperty;
        }
    }
}

