/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.stream.Stream;

public class TabularPrinter {
    public static String formatAsTable(String[] stringArray, String[][] stringArray2) {
        return TabularPrinter.formatAsTable(stringArray, stringArray2, false);
    }

    public static String formatAsTable(String[] stringArray, String[][] stringArray2, boolean bl) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        TabularPrinter.formatAsTable(stringArray, stringArray2, bl, new PrintStream(byteArrayOutputStream, true));
        return byteArrayOutputStream.toString();
    }

    public static void formatAsTable(String[] stringArray3, String[][] stringArray4, boolean bl, PrintStream printStream) {
        String string4;
        if (stringArray3 == null || stringArray4 == null) {
            return;
        }
        if (Stream.of(stringArray4).anyMatch(stringArray2 -> ((String[])stringArray2).length != stringArray3.length)) {
            throw new IllegalArgumentException("Some rows and/or the header have different length");
        }
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        for (int i = 0; i < stringArray3.length; ++i) {
            string4 = stringArray3[i];
            if (hashMap.get(i) == null) {
                hashMap.put(i, 0);
            }
            if ((Integer)hashMap.get(i) >= string4.length()) continue;
            hashMap.put(i, string4.length());
        }
        Arrays.stream(stringArray4).forEach(stringArray -> Stream.iterate(0, n -> n < ((String[])stringArray).length, n -> {
            n = n + 1;
            return n;
        }).forEach(n -> {
            if (hashMap.get(n) == null) {
                hashMap.put((Integer)n, 0);
            }
            if ((Integer)hashMap.get(n) < stringArray[n].length()) {
                hashMap.put((Integer)n, stringArray[n].length());
            }
        }));
        StringBuilder stringBuilder = new StringBuilder("");
        string4 = bl ? "-" : "";
        hashMap.entrySet().stream().forEach(entry -> stringBuilder.append("| %" + string4 + String.valueOf(entry.getValue()) + "s "));
        stringBuilder.append("|" + System.lineSeparator());
        Object object = hashMap.entrySet().stream().reduce("", (string3, entry) -> {
            Object object = "+-";
            object = (String)object + Stream.iterate(0, n -> n < (Integer)entry.getValue(), n -> {
                n = n + 1;
                return n;
            }).reduce("", (string, n) -> string + "-", (string, string2) -> string + string2);
            object = (String)object + "-";
            return string3 + (String)object;
        }, (string, string2) -> string + string2);
        object = (String)object + "+" + System.lineSeparator();
        printStream.print((String)object);
        printStream.printf(stringBuilder.toString(), stringArray3);
        printStream.print((String)object);
        Stream.of(stringArray4).forEach(stringArray -> printStream.printf(stringBuilder.toString(), stringArray));
        printStream.print((String)object);
        printStream.print("Total: " + stringArray4.length);
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"id", "First Name", "Last Name", "Age"};
        String[][] stringArray3 = new String[][]{{"1", "John", "Johnson", "45"}, {"2", "Tom", "", "35"}, {"3", "Rose", "Johnson", "22"}, {"4", "Jimmy", "Kimmel", ""}};
        System.out.println(TabularPrinter.formatAsTable(stringArray2, stringArray3));
        System.out.println(TabularPrinter.formatAsTable(stringArray2, stringArray3, true));
    }
}

