/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.cluster;

import com.hazelcast.map.IMap;
import com.hazelcast.query.Predicate;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.cyclos.impl.utils.SerializableBiPredicate;
import org.cyclos.impl.utils.SharedStorage;
import org.cyclos.impl.utils.cluster.SharedStorageType;
import org.cyclos.utils.CollectionHelper;

public class HazelcastSharedStorage<K extends Serializable, V extends Serializable>
implements SharedStorage<K, V> {
    private final SharedStorageType<K, V> type;
    private final IMap<K, V> map;

    public HazelcastSharedStorage(SharedStorageType<K, V> sharedStorageType, IMap<K, V> iMap) {
        this.type = sharedStorageType;
        this.map = iMap;
    }

    public void clear() {
        this.map.clear();
    }

    public V get(K k) {
        return (V)((Serializable)this.map.get(k));
    }

    public Set<K> keys(SerializableBiPredicate<K, V> serializableBiPredicate) {
        return this.map.keySet(new HazelcastPredicateDelegate<K, V>(serializableBiPredicate));
    }

    public void remove(K k) {
        this.map.delete(k);
    }

    public void removeAll(Collection<K> collection) {
        if (CollectionHelper.isEmpty(collection)) {
            return;
        }
        if (!(collection instanceof Serializable)) {
            collection = new HashSet<K>(collection);
        }
        this.map.removeAll(new HazelcastKeysPredicate(collection));
    }

    public void removeIf(SerializableBiPredicate<K, V> serializableBiPredicate) {
        this.map.removeAll(new HazelcastPredicateDelegate<K, V>(serializableBiPredicate));
    }

    public void set(K k, V v) {
        this.map.set(k, v, this.type.getTtl(), this.type.getTtlUnit());
    }

    public static class HazelcastPredicateDelegate<K extends Serializable, V extends Serializable>
    implements Predicate<K, V> {
        private static final long serialVersionUID = 1L;
        private final SerializableBiPredicate<K, V> delegate;

        public HazelcastPredicateDelegate(SerializableBiPredicate<K, V> serializableBiPredicate) {
            this.delegate = serializableBiPredicate;
        }

        public boolean apply(Map.Entry<K, V> entry) {
            return this.delegate.test((Object)((Serializable)entry.getKey()), (Object)((Serializable)entry.getValue()));
        }
    }

    public static class HazelcastKeysPredicate<K extends Serializable, V extends Serializable>
    implements Predicate<K, V> {
        private static final long serialVersionUID = 1L;
        private final Collection<K> keys;

        public HazelcastKeysPredicate(Collection<K> collection) {
            this.keys = collection;
        }

        public boolean apply(Map.Entry<K, V> entry) {
            return this.keys.contains(entry.getKey());
        }
    }
}

