/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.cluster;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.cyclos.impl.CyclosThreadFactory;
import org.cyclos.impl.utils.tasks.AbstractRecurringTaskHandlerImpl;
import org.cyclos.impl.utils.tasks.RecurringTask;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.MutableObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

public class NoClusterRecurringTaskHandlerImpl
extends AbstractRecurringTaskHandlerImpl {
    private ThreadPoolTaskScheduler recurringTaskScheduler;
    @Autowired
    private CyclosProperties cyclosProperties;
    protected ConcurrentMap<Class<? extends RecurringTask>, ScheduledFuture<?>> recurringTaskFutures;
    protected Set<Class<? extends RecurringTask>> awokenTasks;
    private Timer awakeTasksTimer;

    public void awakeNow(RecurringTask recurringTask) {
        if (this.awokenTasks != null) {
            this.awokenTasks.add(recurringTask.getClass());
        }
    }

    public Map<String, Long> getTaskDelays() {
        return CollectionHelper.orEmpty(this.recurringTaskFutures).entrySet().stream().filter(entry -> !((ScheduledFuture)entry.getValue()).isDone()).collect(Collectors.toMap(entry -> ((Class)entry.getKey()).getName(), entry -> ((ScheduledFuture)entry.getValue()).getDelay(TimeUnit.SECONDS)));
    }

    public void scheduleTasks() {
        if (this.cyclosProperties.getMaxRecurringTasks() > 0) {
            this.recurringTaskFutures = new ConcurrentHashMap();
            this.logFirstExecution(this.forEachTask(recurringTask -> {
                ScheduledFuture<?> scheduledFuture = this.scheduleExecution((RecurringTask)recurringTask, false);
                return scheduledFuture.getDelay(TimeUnit.MILLISECONDS);
            }));
            this.awokenTasks = ConcurrentHashMap.newKeySet();
            this.awakeTasksTimer = new Timer("cy.recurring_tasks_awaking", true);
            this.awakeTasksTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    NoClusterRecurringTaskHandlerImpl.this.awakeTasks();
                }
            }, 1000L, 1000L);
        }
    }

    private void awakeTasks() {
        if (this.awokenTasks != null) {
            this.awokenTasks.forEach(clazz -> {
                ScheduledFuture scheduledFuture = (ScheduledFuture)this.recurringTaskFutures.get(clazz);
                if (scheduledFuture == null) {
                    this.scheduleExecution((RecurringTask)this.getTask(clazz), true);
                } else {
                    boolean bl = scheduledFuture.cancel(false);
                    if (bl) {
                        this.scheduleExecution((RecurringTask)this.getTask(clazz), true);
                    }
                }
            });
            this.awokenTasks.clear();
        }
    }

    @PreDestroy
    private void destroy() {
        if (this.recurringTaskFutures != null) {
            this.recurringTaskFutures.values().forEach(scheduledFuture -> {
                try {
                    scheduledFuture.cancel(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        if (this.recurringTaskScheduler != null) {
            try {
                this.recurringTaskScheduler.destroy();
            }
            catch (Exception exception) {
                this.getLogger().warn("Error destroying the recurring task scheduler", (Throwable)exception);
            }
        }
        if (this.awakeTasksTimer != null) {
            try {
                this.awakeTasksTimer.cancel();
            }
            catch (Exception exception) {
                this.getLogger().warn("Error canceling the awake tasks timer", (Throwable)exception);
            }
        }
    }

    private ScheduledFuture<?> doScheduleExecution(RecurringTask recurringTask, boolean bl, boolean bl2) {
        MutableBoolean mutableBoolean = new MutableBoolean(!bl2);
        MutableBoolean mutableBoolean2 = new MutableBoolean(bl);
        MutableObject mutableObject = new MutableObject();
        MutableObject mutableObject2 = new MutableObject();
        Trigger trigger = triggerContext -> {
            Date date;
            ScheduledFuture scheduledFuture = (ScheduledFuture)mutableObject2.get();
            if (scheduledFuture != null && scheduledFuture.isCancelled()) {
                return null;
            }
            if (mutableBoolean.booleanValue()) {
                date = this.getFirstExecution(recurringTask);
                this.getLogger().debug("Scheduled first execution of task {} at {}", (Object)recurringTask.getName(), (Object)LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault()));
            } else if (mutableBoolean2.booleanValue()) {
                date = new Date(System.currentTimeMillis());
                this.getLogger().debug("Scheduled awaking of task {} now", (Object)recurringTask.getName());
            } else {
                date = (Date)mutableObject.get();
                if (date == null) {
                    date = this.getNextExecution(recurringTask);
                    mutableObject.set((Object)date);
                }
                this.getLogger().debug("Scheduled next execution of task {} at {}", (Object)recurringTask.getName(), (Object)LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault()));
            }
            mutableBoolean.setFalse();
            mutableBoolean2.setFalse();
            return date;
        };
        Runnable runnable = () -> {
            Date date = this.getNextExecution(recurringTask);
            mutableObject.set((Object)date);
            this.getLogger().debug("Running recurring task '{}'", (Object)recurringTask.getName());
            recurringTask.run();
        };
        ScheduledFuture scheduledFuture = this.recurringTaskScheduler.schedule(runnable, trigger);
        mutableObject2.set((Object)scheduledFuture);
        return scheduledFuture;
    }

    @PostConstruct
    private void initialize() {
        CyclosThreadFactory cyclosThreadFactory = CyclosThreadFactory.CyclosThreadGroup.RECURRING_TASK.factory();
        this.recurringTaskScheduler = new ThreadPoolTaskScheduler();
        this.recurringTaskScheduler.setPoolSize(Math.max(1, this.cyclosProperties.getMaxRecurringTasks()));
        this.recurringTaskScheduler.setThreadGroup(cyclosThreadFactory.getGroup());
        this.recurringTaskScheduler.setThreadNamePrefix(cyclosThreadFactory.getGroup().getName() + "-");
        this.recurringTaskScheduler.initialize();
        this.logTaskWorkersInfo();
    }

    private ScheduledFuture<?> scheduleExecution(RecurringTask recurringTask, boolean bl) {
        ScheduledFuture scheduledFuture = (ScheduledFuture)this.recurringTaskFutures.get(recurringTask.getClass());
        if (scheduledFuture != null) {
            scheduledFuture.cancel(false);
        }
        ScheduledFuture<?> scheduledFuture2 = this.doScheduleExecution(recurringTask, bl, scheduledFuture != null);
        this.recurringTaskFutures.put(recurringTask.getClass(), scheduledFuture2);
        return scheduledFuture2;
    }
}

