/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.conversion;

import org.cyclos.entities.BaseEntity;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.impl.ApplicationHandler;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.utils.conversion.ObjectConverter;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.EntityVO;
import org.cyclos.model.IInternalNamedEntity;
import org.cyclos.model.StaleEntityException;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BaseEntityConverter<E extends SimpleEntity>
extends ObjectConverter<E> {
    @Autowired
    protected ApplicationHandler applicationHandler;

    public BaseEntityConverter() {
        super(SimpleEntity.class);
        if (!this.getClass().equals(BaseEntityConverter.class)) {
            throw new IllegalArgumentException("Subclasses are not meant to use the default constructor");
        }
    }

    public BaseEntityConverter(Class<E> clazz) {
        super(clazz);
    }

    @Override
    protected void fill(Object object, E e, Object[] objectArray, InvocationContext.ConversionContext conversionContext) {
        if (object instanceof EntityDTO || e.isTransient()) {
            super.fill(object, e, objectArray, conversionContext);
        }
    }

    protected E find(Class<E> clazz, Long l) {
        return (E)((SimpleEntity)this.entityManagerHandler.find(clazz, l));
    }

    @Override
    protected E instantiate(Class<E> clazz, Object object, InvocationContext.ConversionContext conversionContext) {
        Object object2;
        Long l = null;
        String string = null;
        boolean bl = false;
        Integer n = null;
        if (object instanceof EntityDTO) {
            object2 = (EntityDTO)object;
            l = object2.getId();
            if (BaseEntity.class.isAssignableFrom(clazz)) {
                n = object2.getVersion();
                if (l != null && n == null) {
                    throw new StaleEntityException();
                }
            }
        } else if (object instanceof EntityVO) {
            l = EntityVO.id((EntityVO)((EntityVO)object));
            if (l == null && object instanceof IInternalNamedEntity) {
                string = ((IInternalNamedEntity)object).getInternalName();
            }
            bl = true;
        } else if (object instanceof Number) {
            l = ((Number)object).longValue();
            bl = true;
        } else if (object instanceof String) {
            object2 = StringHelper.trimToNull((Object)object);
            if (object2 != null) {
                try {
                    l = Long.parseLong((String)object2);
                }
                catch (NumberFormatException numberFormatException) {
                    string = object2;
                }
            }
            bl = true;
        }
        if (string != null && !IInternalNamedEntity.class.isAssignableFrom(clazz)) {
            string = null;
        }
        if (l == null && string == null) {
            object2 = bl ? null : (SimpleEntity)this.beanHandler.instantiate(clazz);
        } else {
            object2 = l != null ? this.find(clazz, l) : (string != null ? (SimpleEntity)this.entityManagerHandler.find(clazz, string) : null);
            if (object2 instanceof BaseEntity && n != null && !n.equals(((BaseEntity)object2).getVersion())) {
                throw new StaleEntityException();
            }
        }
        return (E)object2;
    }
}

