/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.conversion;

import com.mysema.commons.lang.CloseableIterator;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.function.Function;
import javax.annotation.PostConstruct;
import javax.persistence.OneToMany;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.cyclos.entities.BaseEntity;
import org.cyclos.entities.ReadOnlyFromDTO;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.contentmanagement.HasContentScript;
import org.cyclos.entities.system.Language;
import org.cyclos.entities.users.User;
import org.cyclos.entities.utils.DecimalRange;
import org.cyclos.impl.BaseNetworkedHandlerImpl;
import org.cyclos.impl.BeanHandler;
import org.cyclos.impl.BigDecimalScaleHandler;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.utils.RichTextHandler;
import org.cyclos.impl.utils.WrappedObject;
import org.cyclos.impl.utils.conversion.BeanConverter;
import org.cyclos.impl.utils.conversion.ConversionHandlerInternal;
import org.cyclos.impl.utils.formatting.FormatterImpl;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.model.Bean;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.ListProperty;
import org.cyclos.model.MapProperty;
import org.cyclos.model.PageProperty;
import org.cyclos.model.Property;
import org.cyclos.model.SetProperty;
import org.cyclos.model.TextMode;
import org.cyclos.model.banking.accounts.AccountOwner;
import org.cyclos.model.banking.accounts.ExternalAccountOwner;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.banking.accounts.SingletonAccountOwner;
import org.cyclos.model.banking.accounts.SystemAccountOwner;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.utils.DecimalRangeDTO;
import org.cyclos.server.utils.FieldHelper;
import org.cyclos.server.utils.PropertyHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.DateTime;
import org.cyclos.utils.IDate;
import org.cyclos.utils.Page;
import org.cyclos.utils.PageImpl;
import org.cyclos.utils.coercion.CoercionException;
import org.cyclos.utils.coercion.CoercionHelper;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.InvalidPropertyException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class ConversionHandlerImpl
extends BaseNetworkedHandlerImpl
implements ConversionHandlerInternal {
    private static final Method EMPTY_METHOD;
    private static final String ENTITY_PACKAGE_PREFIX;
    @Autowired
    private BeanHandler beanHandler;
    @Autowired
    private RawEntityManagerHandler rawEntityManagerHandler;
    @Autowired
    private BigDecimalScaleHandler bigDecimalScaleHandler;
    private Map<String, Method> cachedSetters = new HashMap<String, Method>();
    private Map<Class<?>, BeanConverter<?>> beanConverters;
    @Autowired
    @Lazy
    private RichTextHandler richTextHandler;

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static <T, C extends T> Class<C> concreteClass(Class<T> clazz) {
        void var1_9;
        if (clazz == null) {
            throw new NullPointerException("Class cannot be null");
        }
        Object var1_1 = null;
        int n = clazz.getModifiers();
        if (Modifier.isAbstract(n) || Modifier.isInterface(n) || Collection.class.isAssignableFrom(clazz)) {
            if (Calendar.class.isAssignableFrom(clazz)) {
                return var1_9;
            }
            if (SortedSet.class.isAssignableFrom(clazz)) {
                return var1_9;
            }
            if (Set.class.isAssignableFrom(clazz)) {
                return var1_9;
            }
            if (Iterable.class.isAssignableFrom(clazz)) {
                return var1_9;
            }
            if (SortedMap.class.isAssignableFrom(clazz)) {
                return var1_9;
            }
            if (!Map.class.isAssignableFrom(clazz)) throw new IllegalArgumentException("Unknown concrete class for " + clazz.getName());
            return var1_9;
        }
        Class<T> clazz2 = clazz;
        return var1_9;
    }

    public <E extends SimpleEntity, R> R cachedEntityFromId(Class<E> clazz, Class<R> clazz2, Long l, boolean bl) {
        if (l == null) {
            return null;
        }
        ConvertedEntityCacheKey convertedEntityCacheKey = new ConvertedEntityCacheKey(clazz, clazz2, l, bl);
        return (R)InvocationContext.ensure().getAttribute((Object)convertedEntityCacheKey, () -> {
            SimpleEntity simpleEntity = (SimpleEntity)(bl ? this.rawEntityManagerHandler : this.entityManagerHandler).find(clazz, l);
            return this.conversionHandler.convert(clazz2, (Object)simpleEntity);
        });
    }

    public <T> T clone(T t) {
        if (t == null) {
            return null;
        }
        Object object = this.beanHandler.instantiate(t.getClass());
        this.fill(t, object);
        return (T)object;
    }

    public <T> T convert(Class<T> clazz, Object object) {
        return this.convert(clazz, object, null, InvocationContext.getConversionContext());
    }

    @Override
    public <T> T convert(Class<T> clazz, Object object, Object[] objectArray, InvocationContext.ConversionContext conversionContext) {
        Object object2;
        if (clazz == null) {
            return (T)object;
        }
        if (object == null) {
            if (clazz.isPrimitive()) {
                return (T)CoercionHelper.coerce(clazz, null);
            }
            return null;
        }
        if (object instanceof WrappedObject) {
            object = ((WrappedObject)object).unwrap(this.getApplicationContext());
        }
        if (clazz.isInstance(object)) {
            return (T)object;
        }
        if (CoercionHelper.understands(clazz)) {
            return (T)CoercionHelper.coerce(clazz, (Object)object);
        }
        if (objectArray == null) {
            objectArray = ArrayUtils.EMPTY_OBJECT_ARRAY;
        }
        if ((object2 = conversionContext.getProcessed(object, clazz, objectArray)) != null) {
            return (T)object2;
        }
        BeanConverter<T> beanConverter = this.findConverter(clazz);
        return beanConverter.convert(clazz, object, objectArray, conversionContext);
    }

    public <T> T convertExcluding(Class<T> clazz, Object object, Object ... objectArray) {
        return this.convert(clazz, object, objectArray, InvocationContext.getConversionContext());
    }

    public <T> Function<Object, T> convertingFunction(Class<T> clazz, Object ... objectArray) {
        if (CollectionHelper.isEmpty((Object[])objectArray)) {
            return object -> this.convert(clazz, object);
        }
        return object -> this.convertExcluding(clazz, object, objectArray);
    }

    public <T> CloseableIterator<T> convertIterator(final Class<T> clazz, final CloseableIterator<?> closeableIterator) {
        if (closeableIterator == null) {
            return null;
        }
        final InvocationContext.ConversionContext conversionContext = InvocationContext.getConversionContext();
        return new CloseableIterator<T>(){

            public void close() {
                closeableIterator.close();
            }

            public boolean hasNext() {
                return closeableIterator.hasNext();
            }

            public T next() {
                return ConversionHandlerImpl.this.convert(clazz, closeableIterator.next(), null, conversionContext);
            }

            public void remove() {
                closeableIterator.remove();
            }
        };
    }

    public <T> Iterator<T> convertIterator(final Class<T> clazz, final Iterator<?> iterator) {
        if (iterator == null) {
            return null;
        }
        final InvocationContext.ConversionContext conversionContext = InvocationContext.getConversionContext();
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public T next() {
                return ConversionHandlerImpl.this.convert(clazz, iterator.next(), null, conversionContext);
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
    }

    public <T> List<T> convertList(Class<T> clazz, Iterable<?> iterable) {
        return this.convertList(this.singleMapping(clazz), iterable, null, InvocationContext.getConversionContext());
    }

    public <T> List<T> convertList(Class<T> clazz, Iterable<?> iterable, Map<?, ?> map) {
        return this.convertList(this.singleMapping(clazz), iterable, map, InvocationContext.getConversionContext());
    }

    public <T> List<T> convertList(Map<Class<?>, Class<?>> map, Iterable<?> iterable) {
        return this.convertList(map, iterable, null, InvocationContext.getConversionContext());
    }

    public <T> List<T> convertList(Map<Class<?>, Class<?>> map, Iterable<?> iterable, Map<?, ?> map2) {
        return this.convertList(map, iterable, map2, InvocationContext.getConversionContext());
    }

    @Override
    public <T> List<T> convertList(Map<Class<?>, Class<?>> map, Iterable<?> iterable, Map<?, ?> map2, InvocationContext.ConversionContext conversionContext) {
        return (List)this.convertCollection(List.class, map, iterable, map2, conversionContext);
    }

    public <K, V> Map<K, V> convertMap(Class<K> clazz, Class<V> clazz2, Map<?, ?> map) {
        return this.convertMap(clazz, clazz2, map, InvocationContext.getConversionContext());
    }

    @Override
    public <K, V> Map<K, V> convertMap(Class<K> clazz, Class<V> clazz2, Map<?, ?> map, InvocationContext.ConversionContext conversionContext) {
        return this.convertMap(LinkedHashMap.class, clazz, clazz2, map, conversionContext);
    }

    public <T> Page<T> convertPage(Class<T> clazz, Iterable<?> iterable) {
        return this.convertPage(this.singleMapping(clazz), iterable);
    }

    public <T> Page<T> convertPage(Map<Class<?>, Class<?>> map, Iterable<?> iterable) {
        int n;
        int n2;
        Integer n3;
        ArrayList arrayList;
        if (iterable == null) {
            return null;
        }
        boolean bl = false;
        if (iterable instanceof Page) {
            Page page = (Page)iterable;
            arrayList = page.getPageItems();
            n3 = page.getTotalCount();
            n2 = page.getPageSize();
            n = page.getCurrentPage();
            bl = page.isHasNextPage();
        } else {
            if (iterable instanceof Collection) {
                Collection collection = (Collection)iterable;
                arrayList = collection;
                n2 = collection.size();
                n3 = n2;
            } else {
                ArrayList arrayList2 = new ArrayList();
                for (Object obj : iterable) {
                    arrayList2.add(obj);
                }
                arrayList = arrayList2;
                n2 = arrayList2.size();
                n3 = n2;
            }
            n = 0;
        }
        return new PageImpl(this.convertList(map, arrayList), n2, n, n3, bl);
    }

    public <T> Set<T> convertSet(Class<T> clazz, Iterable<?> iterable) {
        return this.convertSet(this.singleMapping(clazz), iterable, null, InvocationContext.getConversionContext());
    }

    public <T> Set<T> convertSet(Class<T> clazz, Iterable<?> iterable, Map<?, ?> map) {
        return this.convertSet(this.singleMapping(clazz), iterable, map, InvocationContext.getConversionContext());
    }

    public <T> Set<T> convertSet(Map<Class<?>, Class<?>> map, Iterable<?> iterable) {
        return this.convertSet(map, iterable, null, InvocationContext.getConversionContext());
    }

    public <T> Set<T> convertSet(Map<Class<?>, Class<?>> map, Iterable<?> iterable, Map<?, ?> map2) {
        return this.convertSet(map, iterable, map2, InvocationContext.getConversionContext());
    }

    @Override
    public <T> Set<T> convertSet(Map<Class<?>, Class<?>> map, Iterable<?> iterable, Map<?, ?> map2, InvocationContext.ConversionContext conversionContext) {
        return (Set)this.convertCollection(Set.class, map, iterable, map2, conversionContext);
    }

    public void fill(Object object, Object object2) {
        this.fill(object, object2, null, InvocationContext.getConversionContext());
    }

    @Override
    public void fill(Object object, Object object2, Object[] objectArray, InvocationContext.ConversionContext conversionContext) {
        if (object2 == null) {
            return;
        }
        boolean bl = this.isEntity(object);
        boolean bl2 = this.isEntity(object2);
        conversionContext.registerProcessed(object, object2, objectArray);
        boolean bl3 = false;
        if (object instanceof Map) {
            bl3 = true;
        }
        boolean bl4 = false;
        if (object instanceof Bean) {
            bl4 = true;
        }
        boolean bl5 = false;
        if (object2 instanceof Bean) {
            bl5 = true;
        }
        Class<?> clazz = object2.getClass();
        BeanWrapper beanWrapper = bl3 || bl4 ? null : conversionContext.wrap(object);
        Language language = null;
        if (!bl2 && object instanceof BaseEntity && !(object2 instanceof EntityDTO) && ((BaseEntity)object).getDataTranslationType() != null) {
            language = conversionContext.getSessionData().getConfiguration().getLanguage();
        }
        Class<?> clazz2 = clazz;
        for (Object obj : this.getProperties(object2, conversionContext)) {
            Object object3;
            Object object4;
            String string;
            Object object5;
            List<Object> list;
            Class<?> clazz3;
            boolean bl6;
            Object object6;
            String string2;
            block50: {
                ReadOnlyFromDTO readOnlyFromDTO;
                string2 = PropertyHelper.getPropertyName(obj);
                if (PropertyHelper.contains((Object)string2, (Object[])objectArray) || beanWrapper != null && !beanWrapper.isReadableProperty(string2)) continue;
                if (bl2 && object instanceof EntityDTO && (readOnlyFromDTO = (ReadOnlyFromDTO)FieldHelper.getAnnotation(object2.getClass(), (String)string2, ReadOnlyFromDTO.class)) != null) {
                    object6 = (EntityDTO)object;
                    if (readOnlyFromDTO.onInsert() && object6.isTransient() || readOnlyFromDTO.onUpdate() && object6.isPersistent()) continue;
                }
                bl6 = false;
                object6 = null;
                clazz3 = Object.class;
                list = Collections.emptyList();
                if (obj instanceof Property) {
                    object5 = (Property)obj;
                    bl6 = true;
                    clazz3 = object5.getType();
                    if (object5 instanceof ListProperty) {
                        list = Collections.singletonList(((ListProperty)object5).getElementType());
                    } else if (object5 instanceof SetProperty) {
                        list = Collections.singletonList(((SetProperty)object5).getElementType());
                    } else if (object5 instanceof PageProperty) {
                        list = Collections.singletonList(((PageProperty)object5).getElementType());
                    } else if (object5 instanceof MapProperty) {
                        string = (MapProperty)object5;
                        list = new ArrayList();
                        list.add(string.getKeyType());
                        list.add(string.getValueType());
                    }
                } else if (obj instanceof PropertyDescriptor) {
                    try {
                        object5 = (PropertyDescriptor)obj;
                        object6 = object5.getWriteMethod();
                        if (object6 == null) {
                            object6 = this.findSetter(clazz2, string2);
                        }
                        bl6 = object6 != null;
                        clazz3 = object5.getPropertyType();
                        String string3 = string = bl6 ? (Type)CollectionHelper.first((Object[])((Method)object6).getGenericParameterTypes()) : null;
                        if (!(string instanceof ParameterizedType)) break block50;
                        try {
                            object4 = (ParameterizedType)((Object)string);
                            object3 = object4.getActualTypeArguments();
                            list = new ArrayList(((Type[])object3).length);
                            for (Bean bean : object3) {
                                list.add((Class)bean);
                            }
                        }
                        catch (Exception exception) {
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            try {
                Bean bean;
                if (!bl6) continue;
                String string4 = string = language == null ? null : this.dataTranslationHandler.getValue(language, (BaseEntity)object, string2, false);
                if (string != null) {
                    object5 = string;
                } else if (bl3) {
                    object5 = ((Map)object).get(string2);
                } else if (bl4) {
                    object4 = (Bean)object;
                    object3 = (Property)object4.propertyMap().get(string2);
                    if (object3 == null) continue;
                    object5 = object4.get((Property)object3);
                } else {
                    object5 = beanWrapper.getPropertyValue(string2);
                }
                if (Iterable.class.isAssignableFrom(clazz3)) {
                    object3 = (Bean)CollectionHelper.first(list);
                    bean = this.findMappedBy(clazz2, string2);
                    Map<String, Object> map = null;
                    if (bean != null) {
                        map = Collections.singletonMap(bean, object2);
                    }
                    object4 = this.convertCollection(clazz3, this.singleMapping((Class<?>)object3), (Iterable)object5, map, conversionContext);
                    if (clazz3.isArray()) {
                        Collection collection = (Collection)object4;
                        object4 = collection.toArray((Object[])Array.newInstance(clazz3, collection.size()));
                    }
                } else if (Map.class.isAssignableFrom(clazz3)) {
                    object3 = (Class)list.get(0);
                    bean = (Class)list.get(1);
                    object4 = this.convertMap(clazz3, (Class)object3, (Class)bean, (Map)object5, conversionContext);
                } else if (AccountOwner.class.equals(clazz3) || InternalAccountOwner.class.equals(clazz3)) {
                    object4 = object2 instanceof Bean ? this.toAccountOwnerVO(object5) : this.toAccountOwnerEntity(object5);
                } else {
                    object4 = this.convert(clazz3, object5, null, conversionContext);
                    if (object4 instanceof BigDecimal) {
                        if (bl && !bl2) {
                            object3 = (BigDecimal)object4;
                            object4 = this.bigDecimalScaleHandler.adjustScale(object, (Object)string2, (BigDecimal)object3);
                        }
                    } else if (object5 instanceof DecimalRange && object4 instanceof DecimalRangeDTO) {
                        object3 = (DecimalRange)object5;
                        bean = (DecimalRangeDTO)object4;
                        bean.setMin(this.bigDecimalScaleHandler.adjustScale(object, (Object)string2, object3.getMin()));
                        bean.setMax(this.bigDecimalScaleHandler.adjustScale(object, (Object)string2, object3.getMax()));
                    }
                }
                if (object6 != null) {
                    ((Method)object6).invoke(object2, object4);
                    continue;
                }
                if (!bl5) continue;
                object3 = (Bean)object2;
                bean = (Property)obj;
                if (object4 instanceof String && object instanceof HasContentScript && obj instanceof Property && ((Property)obj).getTextMode() == TextMode.DYNAMIC) {
                    object4 = this.richTextHandler.newContentAccessor((HasContentScript)object).setConversionContext(object3, (Property)bean).process((String)object4);
                }
                object3.set((Property)bean, object4);
            }
            catch (CoercionException coercionException) {
            }
            catch (InvalidPropertyException invalidPropertyException) {
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalStateException(illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new IllegalStateException(invocationTargetException.getTargetException());
            }
            catch (Exception exception) {
                throw new IllegalStateException(exception);
            }
        }
    }

    public void fillExcluding(Object object, Object object2, Object ... objectArray) {
        this.fill(object, object2, objectArray, InvocationContext.getConversionContext());
    }

    @Override
    public FormatterImpl getFormatter() {
        return super.getFormatter();
    }

    @PostConstruct
    public void initialize() {
        this.beanConverters = new HashMap();
        Map map = this.getApplicationContext().getBeansOfType(BeanConverter.class);
        for (BeanConverter beanConverter : map.values()) {
            BeanConverter beanConverter2 = this.beanConverters.put(beanConverter.getBeanType(), beanConverter);
            if (beanConverter2 == null) continue;
            throw new IllegalStateException("There was already a BeanConverter registered for " + String.valueOf(beanConverter.getBeanType()));
        }
    }

    public Date toDate(IDate iDate) {
        return iDate == null ? null : this.convert(Date.class, iDate);
    }

    @Override
    public DateTime toDateTime(Date date) {
        return date == null ? null : this.convert(DateTime.class, date);
    }

    private Collection<Object> convertCollection(Class<? extends Collection> clazz, Map map, Iterable<?> iterable, Map<?, ?> map2, InvocationContext.ConversionContext conversionContext) {
        Collection collection = (Collection)this.beanHandler.instantiate(ConversionHandlerImpl.concreteClass(clazz));
        if (iterable != null) {
            Class<?> clazz2 = null;
            Class<?> clazz3 = null;
            for (Object obj : iterable) {
                Class<?> clazz4;
                if (obj == null) continue;
                Class<?> clazz5 = obj.getClass();
                if (clazz2 != null && clazz5.equals(clazz2)) {
                    clazz4 = clazz3;
                } else {
                    clazz4 = this.findType(map, clazz5);
                    clazz2 = clazz5;
                    clazz3 = clazz4;
                }
                Object obj2 = this.convert(clazz4, obj, null, conversionContext);
                if (obj2 != null && CollectionHelper.isNotEmpty(map2)) {
                    BeanWrapper beanWrapper = conversionContext.wrap(obj2);
                    for (Map.Entry<?, ?> entry : map2.entrySet()) {
                        String string = PropertyHelper.getPropertyName(entry.getKey());
                        beanWrapper.setPropertyValue(string, entry.getValue());
                    }
                }
                if (obj2 == null) continue;
                collection.add(obj2);
            }
        }
        return collection;
    }

    private <T extends Map<?, ?>, K, V> Map<K, V> convertMap(Class<T> clazz, Class<K> clazz2, Class<V> clazz3, Map<?, ?> map, InvocationContext.ConversionContext conversionContext) {
        LinkedHashMap<K, V> linkedHashMap = new LinkedHashMap<K, V>();
        if (CollectionHelper.isNotEmpty(map)) {
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                K k = this.convert(clazz2, entry.getKey(), null, conversionContext);
                V v = this.convert(clazz3, entry.getValue(), null, conversionContext);
                if (k == null) continue;
                linkedHashMap.put(k, v);
            }
        }
        return linkedHashMap;
    }

    private <T> BeanConverter<T> findConverter(Class<T> clazz) {
        for (Class<T> clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            BeanConverter<?> beanConverter = this.beanConverters.get(clazz2);
            if (beanConverter == null) continue;
            return beanConverter;
        }
        throw new IllegalStateException("No BeanConverter found for " + String.valueOf(clazz));
    }

    private String findMappedBy(Class<?> clazz, String string) {
        try {
            Field field = clazz.getDeclaredField(string);
            OneToMany oneToMany = field.getAnnotation(OneToMany.class);
            return oneToMany == null ? null : oneToMany.mappedBy();
        }
        catch (NoSuchFieldException noSuchFieldException) {
            Class<?> clazz2 = clazz.getSuperclass();
            if (clazz2 == null || clazz2 == SimpleEntity.class || clazz2 == Object.class) {
                return null;
            }
            return this.findMappedBy(clazz2, string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Method findSetter(Class<?> clazz, String string) {
        String string2 = clazz.getName() + "." + string;
        Method method = this.cachedSetters.get(string2);
        if (method == null) {
            String string3 = "set" + Character.toUpperCase(string.charAt(0)) + (string.length() == 0 ? "" : string.substring(1));
            for (Method method2 : clazz.getMethods()) {
                if (!method2.getName().equals(string3)) continue;
                method = method2;
                break;
            }
            if (method == null) {
                this.cachedSetters.put(string2, EMPTY_METHOD);
            } else {
                this.cachedSetters.put(string2, method);
            }
        }
        return method == EMPTY_METHOD ? null : method;
    }

    private Class<?> findType(Map<Class<?>, Class<?>> map, Class<?> clazz) {
        if (map != null) {
            for (Map.Entry<Class<?>, Class<?>> entry : map.entrySet()) {
                if (!entry.getKey().isAssignableFrom(clazz)) continue;
                return entry.getValue();
            }
        }
        return null;
    }

    private List<?> getProperties(Object object, InvocationContext.ConversionContext conversionContext) {
        if (object instanceof Bean) {
            return ((Bean)object).properties();
        }
        if (object instanceof BeanWrapper) {
            PropertyDescriptor[] propertyDescriptorArray = ((BeanWrapper)object).getPropertyDescriptors();
            return Arrays.asList(propertyDescriptorArray);
        }
        return this.getProperties(conversionContext.wrap(object), conversionContext);
    }

    private boolean isEntity(Object object) {
        Package package_ = object == null ? null : object.getClass().getPackage();
        return package_ != null && package_.getName().startsWith(ENTITY_PACKAGE_PREFIX);
    }

    private Map<Class<?>, Class<?>> singleMapping(Class<?> clazz) {
        return Collections.singletonMap(Object.class, clazz);
    }

    private AccountOwner toAccountOwnerEntity(Object object) {
        SingletonAccountOwner singletonAccountOwner = this.toSingletonAccountOwner(object);
        if (singletonAccountOwner != null) {
            return singletonAccountOwner;
        }
        return (AccountOwner)this.convert(User.class, object);
    }

    private AccountOwner toAccountOwnerVO(Object object) {
        AccountOwner accountOwner = this.toAccountOwnerEntity(object);
        if (accountOwner instanceof User) {
            return (AccountOwner)this.convert(UserVO.class, accountOwner);
        }
        return accountOwner;
    }

    private SingletonAccountOwner toSingletonAccountOwner(Object object) {
        if (object instanceof SingletonAccountOwner) {
            return (SingletonAccountOwner)object;
        }
        if (object instanceof CharSequence) {
            CharSequence charSequence = (CharSequence)object;
            if (StringUtils.equalsAnyIgnoreCase((CharSequence)"SYSTEM", (CharSequence[])new CharSequence[]{charSequence})) {
                return SystemAccountOwner.instance();
            }
            if (StringUtils.equalsAnyIgnoreCase((CharSequence)"EXTERNAL", (CharSequence[])new CharSequence[]{charSequence})) {
                return ExternalAccountOwner.instance();
            }
        }
        return null;
    }

    static {
        Method method = null;
        try {
            method = Object.class.getMethod("equals", Object.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        EMPTY_METHOD = method;
        ENTITY_PACKAGE_PREFIX = SimpleEntity.class.getPackage().getName();
    }

    private static class ConvertedEntityCacheKey {
        private final Class<? extends SimpleEntity> entityType;
        private final Class<?> resultType;
        private final Long id;
        private final boolean foundByRawHandler;

        public ConvertedEntityCacheKey(Class<? extends SimpleEntity> clazz, Class<?> clazz2, Long l, boolean bl) {
            this.entityType = clazz;
            this.resultType = clazz2;
            this.id = l;
            this.foundByRawHandler = bl;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            ConvertedEntityCacheKey convertedEntityCacheKey = (ConvertedEntityCacheKey)object;
            return this.id.equals(convertedEntityCacheKey.id) && this.entityType == convertedEntityCacheKey.entityType && this.resultType == convertedEntityCacheKey.resultType;
        }

        public int hashCode() {
            return 173 * this.entityType.hashCode() * this.resultType.hashCode() * this.id.hashCode();
        }
    }
}

