/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.formatting;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.cyclos.impl.utils.formatting.FormatterImpl;
import org.cyclos.impl.utils.formatting.ValueFormatter;
import org.cyclos.utils.BigDecimalHelper;
import org.cyclos.utils.coercion.CoercionHelper;

public class NumberValueFormatter
implements ValueFormatter {
    private static final List<NumberValueFormatter> INSTANCES = new ArrayList<NumberValueFormatter>();
    private final int scale;

    public static NumberValueFormatter instance(int n) {
        n = Math.max(n, -1);
        n = Math.min(n, BigDecimalHelper.MAX_SCALE);
        return INSTANCES.get(n + 1);
    }

    private NumberValueFormatter(int n) {
        this.scale = n;
    }

    @Override
    public String format(Object object, Object object2, FormatterImpl formatterImpl) {
        BigDecimal bigDecimal = (BigDecimal)CoercionHelper.coerce(BigDecimal.class, (Object)object2);
        if (this.scale >= 0) {
            bigDecimal = BigDecimalHelper.round((BigDecimal)bigDecimal, (int)this.scale);
        }
        return formatterImpl.format(bigDecimal, this.scale);
    }

    static {
        for (int i = 0; i < BigDecimalHelper.MAX_SCALE + 1; ++i) {
            INSTANCES.add(new NumberValueFormatter(i - 1));
        }
    }
}

