/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.jackson;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;

public class EntityDeserializer<E extends SimpleEntity>
extends StdDeserializer<E> {
    private static final long serialVersionUID = 1L;
    private final Class<E> entityClass;
    private final RawEntityManagerHandler rawEntityManagerHandler;

    public EntityDeserializer(Class<E> clazz, RawEntityManagerHandler rawEntityManagerHandler) {
        super(clazz);
        this.entityClass = clazz;
        this.rawEntityManagerHandler = rawEntityManagerHandler;
    }

    public E deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        if (jsonParser.getCurrentToken() == JsonToken.VALUE_NUMBER_INT || jsonParser.getCurrentToken() == JsonToken.VALUE_NUMBER_FLOAT || jsonParser.getCurrentToken() == JsonToken.VALUE_STRING) {
            long l = jsonParser.getValueAsLong();
            return (E)((SimpleEntity)this.rawEntityManagerHandler.find(this.entityClass, Long.valueOf(l)));
        }
        throw new JsonParseException(jsonParser, "Cannot read an " + this.entityClass.getSimpleName() + " from " + String.valueOf(jsonParser.getCurrentToken()));
    }

    public boolean isCachable() {
        return true;
    }
}

